/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.ParseUtil;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

public class AlterDatabaseQuotaStmt
extends DdlStmt {
    private String dbName;
    private QuotaType quotaType;
    private String quotaValue;
    private long quota;

    public AlterDatabaseQuotaStmt(String dbName, QuotaType quotaType, String quotaValue) {
        this.dbName = dbName;
        this.quotaType = quotaType;
        this.quotaValue = quotaValue;
    }

    public String getDbName() {
        return this.dbName;
    }

    public long getQuota() {
        return this.quota;
    }

    public QuotaType getQuotaType() {
        return this.quotaType;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.ADMIN)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_DBACCESS_DENIED_ERROR, analyzer.getQualifiedUser(), this.dbName);
        }
        if (Strings.isNullOrEmpty((String)this.dbName)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
        }
        this.dbName = ClusterNamespace.getFullName(this.getClusterName(), this.dbName);
        if (this.quotaType == QuotaType.DATA) {
            this.quota = ParseUtil.analyzeDataVolumn(this.quotaValue);
        } else if (this.quotaType == QuotaType.REPLICA) {
            this.quota = ParseUtil.analyzeReplicaNumber(this.quotaValue);
        }
    }

    @Override
    public String toSql() {
        return "ALTER DATABASE " + this.dbName + " SET " + (this.quotaType == QuotaType.DATA ? "DATA" : "REPLICA") + " QUOTA " + this.quotaValue;
    }

    public static enum QuotaType {
        NONE,
        DATA,
        REPLICA;

    }
}

