/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.TableName;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

public class AlterColumnStatsStmt
extends DdlStmt {
    private static final ImmutableSet<String> CONFIGURABLE_PROPERTIES_SET = new ImmutableSet.Builder().add((Object)"ndv").add((Object)"avg_size").add((Object)"max_size").add((Object)"num_nulls").add((Object)"min_value").add((Object)"max_value").build();
    private TableName tableName;
    private String columnName;
    private Map<String, String> properties;

    public AlterColumnStatsStmt(TableName tableName, String columnName, Map<String, String> properties) {
        this.tableName = tableName;
        this.columnName = columnName;
        this.properties = properties;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        this.tableName.analyze(analyzer);
        Optional<String> optional = this.properties.keySet().stream().filter(entity -> !CONFIGURABLE_PROPERTIES_SET.contains((Object)entity.toLowerCase())).findFirst();
        if (optional.isPresent()) {
            throw new AnalysisException(optional.get() + " is invalid statistic");
        }
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), this.tableName.getDb(), this.tableName.getTbl(), PrivPredicate.ALTER)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, "ALTER COLUMN STATS", ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), this.tableName.getDb() + ": " + this.tableName.getTbl());
        }
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

