/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import java.util.Map;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.CreateClusterStmt;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

@Deprecated
public class AlterClusterStmt
extends DdlStmt {
    private Map<String, String> properties;
    private String alterClusterName;
    private String clusterName;
    private int instanceNum;

    public AlterClusterStmt(String clusterName, Map<String, String> properties) {
        this.alterClusterName = clusterName;
        this.properties = properties;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (Config.disable_cluster_feature) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_INVALID_OPERATION, "ALTER CLUSTER");
        }
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.OPERATOR)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_CLUSTER_NO_AUTHORITY, "NODE");
        }
        if (this.properties == null || this.properties.size() == 0 || !this.properties.containsKey(CreateClusterStmt.CLUSTER_INSTANCE_NUM)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_CLUSTER_NO_PARAMETER, new Object[0]);
        }
        try {
            this.instanceNum = Integer.valueOf(this.properties.get(CreateClusterStmt.CLUSTER_INSTANCE_NUM));
        }
        catch (NumberFormatException e) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_CLUSTER_NO_PARAMETER, new Object[0]);
        }
        if (this.instanceNum < 0) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_CLUSTER_CREATE_ISTANCE_NUM_ERROR, new Object[0]);
        }
    }

    @Override
    public String toSql() {
        return "ALTER CLUSTER " + this.alterClusterName + " PROPERTIES(\"instance_num\"=\"" + this.instanceNum + "\")";
    }

    public int getInstanceNum() {
        return this.instanceNum;
    }

    public String getAlterClusterName() {
        return this.alterClusterName;
    }

    public void setAlterClusterName(String alterClusterName) {
        this.alterClusterName = alterClusterName;
    }

    @Override
    public String getClusterName() {
        return this.clusterName;
    }

    public void setInstanceNum(int instanceNum) {
        this.instanceNum = instanceNum;
    }
}

