/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.AggregateInfoBase;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ExprSubstitutionMap;
import org.apache.doris.analysis.FunctionCallExpr;
import org.apache.doris.analysis.IsNullPredicate;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.SlotId;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.util.VectorizedUtil;
import org.apache.doris.planner.DataPartition;
import org.apache.doris.thrift.TPartitionType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class AggregateInfo
extends AggregateInfoBase {
    private static final Logger LOG = LogManager.getLogger(AggregateInfo.class);
    private AggregateInfo mergeAggInfo_;
    private AggregateInfo secondPhaseDistinctAggInfo_;
    private final AggPhase aggPhase_;
    protected ExprSubstitutionMap intermediateTupleSmap_ = new ExprSubstitutionMap();
    protected ExprSubstitutionMap outputTupleSmap_ = new ExprSubstitutionMap();
    protected ExprSubstitutionMap outputToIntermediateTupleSmap_ = new ExprSubstitutionMap();
    private List<Expr> partitionExprs_;
    private ArrayList<Integer> materializedAggregateSlots_ = Lists.newArrayList();
    private boolean isDistinctAgg = false;
    private boolean isMultiDistinct_;
    private ArrayList<Integer> firstIdx_ = Lists.newArrayList();
    private ArrayList<Integer> lastIdx_ = Lists.newArrayList();

    private AggregateInfo(ArrayList<Expr> groupingExprs, ArrayList<FunctionCallExpr> aggExprs, AggPhase aggPhase) {
        this(groupingExprs, aggExprs, aggPhase, false);
    }

    private AggregateInfo(ArrayList<Expr> groupingExprs, ArrayList<FunctionCallExpr> aggExprs, AggPhase aggPhase, boolean isMultiDistinct) {
        super(groupingExprs, aggExprs);
        this.aggPhase_ = aggPhase;
        this.isMultiDistinct_ = isMultiDistinct;
    }

    private AggregateInfo(AggregateInfo other) {
        super(other);
        if (other.mergeAggInfo_ != null) {
            this.mergeAggInfo_ = other.mergeAggInfo_.clone();
        }
        if (other.secondPhaseDistinctAggInfo_ != null) {
            this.secondPhaseDistinctAggInfo_ = other.secondPhaseDistinctAggInfo_.clone();
        }
        this.aggPhase_ = other.aggPhase_;
        this.outputTupleSmap_ = other.outputTupleSmap_.clone();
        if (other.requiresIntermediateTuple()) {
            this.intermediateTupleSmap_ = other.intermediateTupleSmap_.clone();
        } else {
            Preconditions.checkState((other.intermediateTupleDesc_ == other.outputTupleDesc_ ? 1 : 0) != 0);
            this.intermediateTupleSmap_ = this.outputTupleSmap_;
        }
        this.partitionExprs_ = other.partitionExprs_ != null ? Expr.cloneList(other.partitionExprs_) : null;
    }

    public List<Expr> getPartitionExprs() {
        return this.partitionExprs_;
    }

    public void setPartitionExprs(List<Expr> exprs) {
        this.partitionExprs_ = exprs;
    }

    public static AggregateInfo create(ArrayList<Expr> groupingExprs, ArrayList<FunctionCallExpr> aggExprs, TupleDescriptor tupleDesc, Analyzer analyzer) throws AnalysisException {
        Preconditions.checkState((groupingExprs != null && !groupingExprs.isEmpty() || aggExprs != null && !aggExprs.isEmpty() ? 1 : 0) != 0);
        AggregateInfo result = new AggregateInfo(groupingExprs, aggExprs, AggPhase.FIRST);
        ArrayList distinctAggExprs = Lists.newArrayList();
        if (aggExprs != null) {
            for (FunctionCallExpr aggExpr : aggExprs) {
                if (!aggExpr.isDistinct()) continue;
                distinctAggExprs.add(aggExpr);
            }
        }
        boolean isMultiDistinct = AggregateInfo.estimateIfContainsMultiDistinct(distinctAggExprs);
        if (distinctAggExprs.isEmpty() || isMultiDistinct) {
            result.setIsMultiDistinct(isMultiDistinct);
            if (tupleDesc == null) {
                result.createTupleDescs(analyzer);
                result.createSmaps(analyzer);
            } else {
                Preconditions.checkState((aggExprs == null ? 1 : 0) != 0);
                result.outputTupleDesc_ = tupleDesc;
                result.intermediateTupleDesc_ = tupleDesc;
            }
            result.createMergeAggInfo(analyzer);
        } else {
            Preconditions.checkState((tupleDesc == null ? 1 : 0) != 0);
            result.createDistinctAggInfo(groupingExprs, distinctAggExprs, analyzer);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("agg info:\n{}", (Object)result.debugString());
        }
        return result;
    }

    public static boolean estimateIfContainsMultiDistinct(List<FunctionCallExpr> distinctAggExprs) throws AnalysisException {
        if (distinctAggExprs == null || distinctAggExprs.size() <= 0) {
            return false;
        }
        ArrayList expr0Children = Lists.newArrayList();
        if (distinctAggExprs.get(0).getFnName().getFunction().equalsIgnoreCase("group_concat")) {
            expr0Children.add(((Expr)distinctAggExprs.get(0).getChild(0)).ignoreImplicitCast());
        } else {
            for (Expr expr : distinctAggExprs.get(0).getChildren()) {
                expr0Children.add(expr.ignoreImplicitCast());
            }
        }
        boolean hasMultiDistinct = false;
        for (int i = 1; i < distinctAggExprs.size(); ++i) {
            ArrayList exprIChildren = Lists.newArrayList();
            if (distinctAggExprs.get(i).getFnName().getFunction().equalsIgnoreCase("group_concat")) {
                exprIChildren.add(((Expr)distinctAggExprs.get(i).getChild(0)).ignoreImplicitCast());
            } else {
                for (Expr expr : distinctAggExprs.get(i).getChildren()) {
                    exprIChildren.add(expr.ignoreImplicitCast());
                }
            }
            if (Expr.equalLists(expr0Children, exprIChildren)) continue;
            if (exprIChildren.size() > 1 || expr0Children.size() > 1) {
                throw new AnalysisException("The query contains multi count distinct or sum distinct, each can't have multi columns.");
            }
            hasMultiDistinct = true;
        }
        return hasMultiDistinct;
    }

    private void createDistinctAggInfo(ArrayList<Expr> origGroupingExprs, ArrayList<FunctionCallExpr> distinctAggExprs, Analyzer analyzer) throws AnalysisException {
        Preconditions.checkState((!distinctAggExprs.isEmpty() ? 1 : 0) != 0);
        ArrayList expr0Children = Lists.newArrayList();
        if (distinctAggExprs.get(0).getFnName().getFunction().equalsIgnoreCase("group_concat")) {
            expr0Children.add(((Expr)distinctAggExprs.get(0).getChild(0)).ignoreImplicitCast());
        } else {
            for (Expr expr : distinctAggExprs.get(0).getChildren()) {
                expr0Children.add(expr.ignoreImplicitCast());
            }
        }
        this.isMultiDistinct_ = AggregateInfo.estimateIfContainsMultiDistinct(distinctAggExprs);
        this.isDistinctAgg = true;
        if (!this.isMultiDistinct_) {
            this.groupingExprs_.addAll(expr0Children);
        }
        this.aggregateExprs_.removeAll(distinctAggExprs);
        this.createTupleDescs(analyzer);
        this.createSmaps(analyzer);
        this.createMergeAggInfo(analyzer);
        this.createSecondPhaseAggInfo(origGroupingExprs, distinctAggExprs, analyzer);
    }

    public ArrayList<FunctionCallExpr> getMaterializedAggregateExprs() {
        ArrayList result = Lists.newArrayList();
        for (Integer i : this.materializedSlots_) {
            result.add((FunctionCallExpr)this.aggregateExprs_.get(i));
        }
        return result;
    }

    public ArrayList<Boolean> getMaterializedAggregateExprChangedFlags() {
        ArrayList result = Lists.newArrayList();
        for (Integer i : this.materializedSlots_) {
            if (this.mergeAggInfo_ != null) {
                result.add(((FunctionCallExpr)this.aggregateExprs_.get(i)).isNullable() != ((FunctionCallExpr)this.mergeAggInfo_.aggregateExprs_.get(i)).isNullable());
                continue;
            }
            result.add(false);
        }
        return result;
    }

    public AggregateInfo getMergeAggInfo() {
        return this.mergeAggInfo_;
    }

    public boolean isMerge() {
        return this.aggPhase_.isMerge();
    }

    public boolean isDistinctAgg() {
        return this.secondPhaseDistinctAggInfo_ != null;
    }

    public ExprSubstitutionMap getIntermediateSmap() {
        return this.intermediateTupleSmap_;
    }

    public ExprSubstitutionMap getOutputSmap() {
        return this.outputTupleSmap_;
    }

    public ExprSubstitutionMap getOutputToIntermediateSmap() {
        return this.outputToIntermediateTupleSmap_;
    }

    public boolean hasAggregateExprs() {
        return !this.aggregateExprs_.isEmpty() || this.secondPhaseDistinctAggInfo_ != null && !this.secondPhaseDistinctAggInfo_.getAggregateExprs().isEmpty();
    }

    public void setIsMultiDistinct(boolean value) {
        this.isMultiDistinct_ = value;
    }

    public boolean isMultiDistinct() {
        return this.isMultiDistinct_;
    }

    public AggregateInfo getSecondPhaseDistinctAggInfo() {
        return this.secondPhaseDistinctAggInfo_;
    }

    public TupleId getResultTupleId() {
        if (this.isDistinctAgg()) {
            return this.secondPhaseDistinctAggInfo_.getOutputTupleId();
        }
        return this.getOutputTupleId();
    }

    public void getRefdSlots(List<SlotId> ids) {
        Preconditions.checkState((this.outputTupleDesc_ != null ? 1 : 0) != 0);
        if (this.groupingExprs_ != null) {
            Expr.getIds(this.groupingExprs_, null, ids);
        }
        Expr.getIds(this.aggregateExprs_, null, ids);
        for (int i = 0; i < this.outputTupleDesc_.getSlots().size(); ++i) {
            ids.add(this.outputTupleDesc_.getSlots().get(i).getId());
        }
    }

    public void substitute(ExprSubstitutionMap smap, Analyzer analyzer) {
        this.groupingExprs_ = Expr.substituteList(this.groupingExprs_, smap, analyzer, true);
        if (LOG.isTraceEnabled()) {
            LOG.trace("AggInfo: grouping_exprs=" + Expr.debugString(this.groupingExprs_));
        }
        ArrayList<Expr> substitutedAggs = Expr.substituteList(this.aggregateExprs_, smap, analyzer, false);
        this.aggregateExprs_.clear();
        for (Expr substitutedAgg : substitutedAggs) {
            this.aggregateExprs_.add((FunctionCallExpr)substitutedAgg);
        }
        this.outputTupleSmap_.substituteLhs(smap, analyzer);
        this.intermediateTupleSmap_.substituteLhs(smap, analyzer);
        if (this.secondPhaseDistinctAggInfo_ != null) {
            this.secondPhaseDistinctAggInfo_.substitute(smap, analyzer);
        }
    }

    private void createMergeAggInfo(Analyzer analyzer) {
        Preconditions.checkState((this.mergeAggInfo_ == null ? 1 : 0) != 0);
        TupleDescriptor inputDesc = this.intermediateTupleDesc_;
        ArrayList groupingExprs = Lists.newArrayList();
        for (int i = 0; i < this.getGroupingExprs().size(); ++i) {
            groupingExprs.add(new SlotRef(inputDesc.getSlots().get(i)));
        }
        ArrayList aggExprs = Lists.newArrayList();
        for (int i = 0; i < this.getAggregateExprs().size(); ++i) {
            FunctionCallExpr inputExpr = this.getAggregateExprs().get(i);
            Preconditions.checkState((boolean)inputExpr.isAggregateFunction());
            ArrayList<Expr> paramExprs = new ArrayList<Expr>();
            if ((inputExpr.fn.functionName().equals("max_by") || inputExpr.fn.functionName().equals("min_by")) && VectorizedUtil.isVectorized()) {
                paramExprs.addAll(inputExpr.getFnParams().exprs());
            } else {
                paramExprs.add(new SlotRef(inputDesc.getSlots().get(i + this.getGroupingExprs().size())));
            }
            FunctionCallExpr aggExpr = FunctionCallExpr.createMergeAggCall(inputExpr, paramExprs);
            aggExpr.analyzeNoThrow(analyzer);
            aggExprs.add(aggExpr);
        }
        AggPhase aggPhase = this.aggPhase_ == AggPhase.FIRST ? AggPhase.FIRST_MERGE : AggPhase.SECOND_MERGE;
        this.mergeAggInfo_ = new AggregateInfo(groupingExprs, aggExprs, aggPhase, this.isMultiDistinct_);
        this.mergeAggInfo_.intermediateTupleDesc_ = this.intermediateTupleDesc_;
        this.mergeAggInfo_.outputTupleDesc_ = this.outputTupleDesc_;
        this.mergeAggInfo_.intermediateTupleSmap_ = this.intermediateTupleSmap_;
        this.mergeAggInfo_.outputTupleSmap_ = this.outputTupleSmap_;
        this.mergeAggInfo_.materializedSlots_ = this.materializedSlots_;
    }

    private Expr createCountDistinctAggExprParam(int firstIdx, int lastIdx, ArrayList<SlotDescriptor> slots) {
        if (firstIdx > lastIdx) {
            return null;
        }
        Expr elseExpr = new SlotRef(slots.get(lastIdx));
        if (firstIdx == lastIdx) {
            return elseExpr;
        }
        for (int i = lastIdx - 1; i >= firstIdx; --i) {
            ArrayList ifArgs = Lists.newArrayList();
            SlotRef slotRef = new SlotRef(slots.get(i));
            IsNullPredicate isNullPred = new IsNullPredicate(slotRef, false);
            ifArgs.add(isNullPred);
            ifArgs.add(new NullLiteral());
            ifArgs.add(elseExpr);
            elseExpr = new FunctionCallExpr("if", (List<Expr>)ifArgs);
        }
        return elseExpr;
    }

    private void createSecondPhaseAggInfo(ArrayList<Expr> origGroupingExprs, ArrayList<FunctionCallExpr> distinctAggExprs, Analyzer analyzer) throws AnalysisException {
        Preconditions.checkState((this.secondPhaseDistinctAggInfo_ == null ? 1 : 0) != 0);
        Preconditions.checkState((!distinctAggExprs.isEmpty() ? 1 : 0) != 0);
        TupleDescriptor inputDesc = this.intermediateTupleDesc_;
        ArrayList secondPhaseAggExprs = Lists.newArrayList();
        boolean distinctExprPos = false;
        for (FunctionCallExpr inputExpr : distinctAggExprs) {
            Preconditions.checkState((boolean)inputExpr.isAggregateFunction());
            FunctionCallExpr aggExpr = null;
            if (!this.isMultiDistinct_) {
                if (inputExpr.getFnName().getFunction().equalsIgnoreCase("count")) {
                    Expr ifExpr = this.createCountDistinctAggExprParam(origGroupingExprs.size(), origGroupingExprs.size() + inputExpr.getChildren().size() - 1, inputDesc.getSlots());
                    Preconditions.checkNotNull((Object)ifExpr);
                    ifExpr.analyzeNoThrow(analyzer);
                    aggExpr = new FunctionCallExpr("count", (List<Expr>)Lists.newArrayList((Object[])new Expr[]{ifExpr}));
                } else if (inputExpr.getFnName().getFunction().equals("group_concat")) {
                    ArrayList exprList = Lists.newArrayList();
                    exprList.add(new SlotRef(inputDesc.getSlots().get(origGroupingExprs.size())));
                    if (inputExpr.getChildren().size() == 2) {
                        exprList.add((Expr)inputExpr.getChild(1));
                    }
                    aggExpr = new FunctionCallExpr(inputExpr.getFnName(), (List<Expr>)exprList);
                } else {
                    SlotRef aggExprParam = new SlotRef(inputDesc.getSlots().get(origGroupingExprs.size()));
                    aggExpr = new FunctionCallExpr(inputExpr.getFnName(), (List<Expr>)Lists.newArrayList((Object[])new Expr[]{aggExprParam}));
                }
            } else {
                Preconditions.checkState((boolean)false);
            }
            secondPhaseAggExprs.add(aggExpr);
        }
        for (int i = 0; i < this.aggregateExprs_.size(); ++i) {
            FunctionCallExpr inputExpr;
            inputExpr = (FunctionCallExpr)this.aggregateExprs_.get(i);
            Preconditions.checkState((boolean)inputExpr.isAggregateFunction());
            SlotRef aggExprParam = new SlotRef(inputDesc.getSlots().get(i + this.getGroupingExprs().size()));
            FunctionCallExpr aggExpr = FunctionCallExpr.createMergeAggCall(inputExpr, Lists.newArrayList((Object[])new Expr[]{aggExprParam}));
            secondPhaseAggExprs.add(aggExpr);
        }
        Preconditions.checkState((secondPhaseAggExprs.size() == this.aggregateExprs_.size() + distinctAggExprs.size() ? 1 : 0) != 0);
        for (FunctionCallExpr aggExpr : secondPhaseAggExprs) {
            aggExpr.analyzeNoThrow(analyzer);
            Preconditions.checkState((boolean)aggExpr.isAggregateFunction());
        }
        ArrayList<Expr> substGroupingExprs = Expr.substituteList(origGroupingExprs, this.intermediateTupleSmap_, analyzer, false);
        this.secondPhaseDistinctAggInfo_ = new AggregateInfo(substGroupingExprs, secondPhaseAggExprs, AggPhase.SECOND, this.isMultiDistinct_);
        this.secondPhaseDistinctAggInfo_.createTupleDescs(analyzer);
        this.secondPhaseDistinctAggInfo_.createSecondPhaseAggSMap(this, distinctAggExprs);
        this.secondPhaseDistinctAggInfo_.createMergeAggInfo(analyzer);
    }

    private void createSecondPhaseAggSMap(AggregateInfo inputAggInfo, ArrayList<FunctionCallExpr> distinctAggExprs) {
        Expr aggExpr;
        this.outputTupleSmap_.clear();
        int slotIdx = 0;
        ArrayList<SlotDescriptor> slotDescs = this.outputTupleDesc_.getSlots();
        int numDistinctParams = 0;
        if (!this.isMultiDistinct_) {
            numDistinctParams = distinctAggExprs.get(0).getChildren().size();
            if (distinctAggExprs.get(0).getFnName().getFunction().equalsIgnoreCase("group_concat") && numDistinctParams == 2) {
                --numDistinctParams;
            }
        } else {
            for (int i = 0; i < distinctAggExprs.size(); ++i) {
                numDistinctParams += distinctAggExprs.get(i).getChildren().size();
            }
        }
        int numOrigGroupingExprs = inputAggInfo.getGroupingExprs().size() - numDistinctParams;
        Preconditions.checkState((slotDescs.size() == numOrigGroupingExprs + distinctAggExprs.size() + inputAggInfo.getAggregateExprs().size() ? 1 : 0) != 0);
        int i = 0;
        while (i < numOrigGroupingExprs) {
            Expr groupingExpr = inputAggInfo.getGroupingExprs().get(i);
            this.outputTupleSmap_.put(groupingExpr.clone(), new SlotRef(slotDescs.get(slotIdx)));
            ++i;
            ++slotIdx;
        }
        i = 0;
        while (i < distinctAggExprs.size()) {
            aggExpr = distinctAggExprs.get(i);
            this.outputTupleSmap_.put(aggExpr.clone(), new SlotRef(slotDescs.get(slotIdx)));
            ++i;
            ++slotIdx;
        }
        i = 0;
        while (i < inputAggInfo.getAggregateExprs().size()) {
            aggExpr = inputAggInfo.getAggregateExprs().get(i);
            this.outputTupleSmap_.put(aggExpr.clone(), new SlotRef(slotDescs.get(slotIdx)));
            ++i;
            ++slotIdx;
        }
    }

    public void createSmaps(Analyzer analyzer) {
        Preconditions.checkNotNull((Object)this.outputTupleDesc_);
        Preconditions.checkNotNull((Object)this.intermediateTupleDesc_);
        ArrayList exprs = Lists.newArrayListWithCapacity((int)(this.groupingExprs_.size() + this.aggregateExprs_.size()));
        exprs.addAll(this.groupingExprs_);
        exprs.addAll(this.aggregateExprs_);
        for (int i = 0; i < exprs.size(); ++i) {
            Expr expr = (Expr)exprs.get(i);
            if (expr.isImplicitCast()) {
                this.outputTupleSmap_.put(((Expr)expr.getChild(0)).clone(), new SlotRef(this.outputTupleDesc_.getSlots().get(i)));
            } else {
                this.outputTupleSmap_.put(expr.clone(), new SlotRef(this.outputTupleDesc_.getSlots().get(i)));
            }
            if (!this.requiresIntermediateTuple()) continue;
            this.intermediateTupleSmap_.put(expr.clone(), new SlotRef(this.intermediateTupleDesc_.getSlots().get(i)));
            this.outputToIntermediateTupleSmap_.put(new SlotRef(this.outputTupleDesc_.getSlots().get(i)), new SlotRef(this.intermediateTupleDesc_.getSlots().get(i)));
            if (i >= this.groupingExprs_.size()) continue;
            analyzer.createAuxEquivPredicate(new SlotRef(this.outputTupleDesc_.getSlots().get(i)), new SlotRef(this.intermediateTupleDesc_.getSlots().get(i)));
        }
        if (!this.requiresIntermediateTuple()) {
            this.intermediateTupleSmap_ = this.outputTupleSmap_;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("output smap=" + this.outputTupleSmap_.debugString());
            LOG.trace("intermediate smap=" + this.intermediateTupleSmap_.debugString());
        }
    }

    public void updateTypeOfAggregateExprs() {
        for (FunctionCallExpr functionCallExpr : this.aggregateExprs_) {
            SlotRef slotRef;
            if (!functionCallExpr.getFnName().getFunction().equalsIgnoreCase("sum")) continue;
            ArrayList slots = new ArrayList();
            functionCallExpr.collect(SlotRef.class, slots);
            if (slots.size() != 1 || (slotRef = (SlotRef)slots.get(0)).getDesc() == null || slotRef.getType() == slotRef.getDesc().getType()) continue;
            slotRef.setType(slotRef.getDesc().getType());
        }
    }

    @Override
    public void materializeRequiredSlots(Analyzer analyzer, ExprSubstitutionMap smap) {
        for (int i = 0; i < this.groupingExprs_.size(); ++i) {
            this.outputTupleDesc_.getSlots().get(i).setIsMaterialized(true);
            this.intermediateTupleDesc_.getSlots().get(i).setIsMaterialized(true);
        }
        this.materializedSlots_.clear();
        ArrayList exprs = Lists.newArrayList();
        exprs.addAll(this.groupingExprs_);
        int aggregateExprsSize = this.aggregateExprs_.size();
        int groupExprsSize = this.groupingExprs_.size();
        boolean isDistinctAgg = this.isDistinctAgg();
        for (int i = 0; i < aggregateExprsSize; ++i) {
            FunctionCallExpr functionCallExpr = (FunctionCallExpr)this.aggregateExprs_.get(i);
            SlotDescriptor slotDesc = this.outputTupleDesc_.getSlots().get(groupExprsSize + i);
            SlotDescriptor intermediateSlotDesc = this.intermediateTupleDesc_.getSlots().get(groupExprsSize + i);
            if (isDistinctAgg || this.isMultiDistinct_) {
                slotDesc.setIsMaterialized(true);
                intermediateSlotDesc.setIsMaterialized(true);
            }
            if (!slotDesc.isMaterialized()) continue;
            intermediateSlotDesc.setIsMaterialized(true);
            exprs.add(functionCallExpr);
            this.materializedSlots_.add(i);
        }
        ArrayList<Expr> resolvedExprs = Expr.substituteList(exprs, smap, analyzer, false);
        analyzer.materializeSlots(resolvedExprs);
        if (this.isDistinctAgg()) {
            this.secondPhaseDistinctAggInfo_.materializeRequiredSlots(analyzer, null);
        }
    }

    public DataPartition getPartition() {
        if (this.groupingExprs_.isEmpty()) {
            return DataPartition.UNPARTITIONED;
        }
        return new DataPartition(TPartitionType.HASH_PARTITIONED, this.groupingExprs_);
    }

    @Override
    public String debugString() {
        StringBuilder out = new StringBuilder(super.debugString());
        out.append(MoreObjects.toStringHelper((Object)this).add("phase", (Object)this.aggPhase_).add("intermediate_smap", (Object)this.intermediateTupleSmap_.debugString()).add("output_smap", (Object)this.outputTupleSmap_.debugString()).toString());
        if (this.mergeAggInfo_ != this && this.mergeAggInfo_ != null) {
            out.append("\nmergeAggInfo:\n" + this.mergeAggInfo_.debugString());
        }
        if (this.secondPhaseDistinctAggInfo_ != null) {
            out.append("\nsecondPhaseDistinctAggInfo:\n" + this.secondPhaseDistinctAggInfo_.debugString());
        }
        return out.toString();
    }

    @Override
    protected String tupleDebugName() {
        return "agg-tuple";
    }

    public AggregateInfo clone() {
        return new AggregateInfo(this);
    }

    public List<Expr> getInputPartitionExprs() {
        return this.partitionExprs_ != null ? this.partitionExprs_ : this.groupingExprs_;
    }

    public static enum AggPhase {
        FIRST,
        FIRST_MERGE,
        SECOND,
        SECOND_MERGE;


        public boolean isMerge() {
            return this == FIRST_MERGE || this == SECOND_MERGE;
        }
    }
}

