/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.ShowResultSetMetaData;

public class AdminShowTabletStorageFormatStmt
extends ShowStmt {
    private boolean verbose;

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    public AdminShowTabletStorageFormatStmt(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.ADMIN)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_ACCESS_DENIED_ERROR, this.toSql(), ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), "ADMIN Privilege needed.");
        }
        super.analyze(analyzer);
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder("ADMIN SHOW TABLET STORAGE TYPE");
        if (this.verbose) {
            sb.append(" VERBOSE");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        ShowResultSetMetaData.Builder builder = ShowResultSetMetaData.builder();
        if (this.verbose) {
            builder.addColumn(new Column("BackendId", ScalarType.createVarchar(30))).addColumn(new Column("TabletId", ScalarType.createVarchar(30))).addColumn(new Column("StorageFormat", ScalarType.createVarchar(30)));
        } else {
            builder.addColumn(new Column("BackendId", ScalarType.createVarchar(30))).addColumn(new Column("V1Count", ScalarType.createVarchar(30))).addColumn(new Column("V2Count", ScalarType.createVarchar(30)));
        }
        return builder.build();
    }
}

