/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.collect.ImmutableList;
import org.apache.doris.analysis.AdminSetConfigStmt;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.ShowResultSetMetaData;

public class AdminShowConfigStmt
extends ShowStmt {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"Key").add((Object)"Value").add((Object)"Type").add((Object)"IsMutable").add((Object)"MasterOnly").add((Object)"Comment").build();
    private AdminSetConfigStmt.ConfigType type;
    private String pattern;

    public AdminShowConfigStmt(AdminSetConfigStmt.ConfigType type, String pattern) {
        this.type = type;
        this.pattern = pattern;
    }

    public AdminSetConfigStmt.ConfigType getType() {
        return this.type;
    }

    public String getPattern() {
        return this.pattern;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        super.analyze(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.ADMIN)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "ADMIN");
        }
        if (this.type != AdminSetConfigStmt.ConfigType.FRONTEND) {
            throw new AnalysisException("Only support setting Frontend configs now");
        }
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        ShowResultSetMetaData.Builder builder = ShowResultSetMetaData.builder();
        for (String title : TITLE_NAMES) {
            builder.addColumn(new Column(title, ScalarType.createVarchar(30)));
        }
        return builder.build();
    }

    @Override
    public RedirectStatus getRedirectStatus() {
        if (ConnectContext.get().getSessionVariable().getForwardToMaster()) {
            return RedirectStatus.FORWARD_NO_SYNC;
        }
        return RedirectStatus.NO_FORWARD;
    }
}

