/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import java.util.Map;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Replica;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

public class AdminSetReplicaStatusStmt
extends DdlStmt {
    public static final String TABLET_ID = "tablet_id";
    public static final String BACKEND_ID = "backend_id";
    public static final String STATUS = "status";
    private Map<String, String> properties;
    private long tabletId = -1L;
    private long backendId = -1L;
    private Replica.ReplicaStatus status;

    public AdminSetReplicaStatusStmt(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        super.analyze(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.ADMIN)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "ADMIN");
        }
        this.checkProperties();
    }

    private void checkProperties() throws AnalysisException {
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            if (key.equalsIgnoreCase(TABLET_ID)) {
                try {
                    this.tabletId = Long.valueOf(val);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new AnalysisException("Invalid tablet id format: " + val);
                }
            }
            if (key.equalsIgnoreCase(BACKEND_ID)) {
                try {
                    this.backendId = Long.valueOf(val);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new AnalysisException("Invalid backend id format: " + val);
                }
            }
            if (key.equalsIgnoreCase(STATUS)) {
                this.status = Replica.ReplicaStatus.valueOf(val.toUpperCase());
                if (this.status == Replica.ReplicaStatus.BAD || this.status == Replica.ReplicaStatus.OK) continue;
                throw new AnalysisException("Do not support setting replica status as " + val);
            }
            throw new AnalysisException("Unknown property: " + key);
        }
        if (this.tabletId == -1L || this.backendId == -1L || this.status == null) {
            throw new AnalysisException("Should add following properties: TABLET_ID, BACKEND_ID and STATUS");
        }
    }

    public long getTabletId() {
        return this.tabletId;
    }

    public long getBackendId() {
        return this.backendId;
    }

    public Replica.ReplicaStatus getStatus() {
        return this.status;
    }

    @Override
    public RedirectStatus getRedirectStatus() {
        return RedirectStatus.FORWARD_WITH_SYNC;
    }
}

