/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ConfigBase;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

public class AdminSetConfigStmt
extends DdlStmt {
    private ConfigType type;
    private Map<String, String> configs;
    private RedirectStatus redirectStatus = RedirectStatus.NO_FORWARD;

    public AdminSetConfigStmt(ConfigType type, Map<String, String> configs) {
        this.type = type;
        this.configs = configs;
        if (this.configs == null) {
            this.configs = Maps.newHashMap();
        }
        for (String key : this.configs.keySet()) {
            if (!ConfigBase.checkIsMasterOnly(key)) continue;
            this.redirectStatus = RedirectStatus.FORWARD_NO_SYNC;
        }
    }

    public ConfigType getType() {
        return this.type;
    }

    public Map<String, String> getConfigs() {
        return this.configs;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        super.analyze(analyzer);
        if (this.configs.size() != 1) {
            throw new AnalysisException("config parameter size is not equal to 1");
        }
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.ADMIN)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "ADMIN");
        }
        if (this.type != ConfigType.FRONTEND) {
            throw new AnalysisException("Only support setting Frontend configs now");
        }
    }

    @Override
    public RedirectStatus getRedirectStatus() {
        return this.redirectStatus;
    }

    public static enum ConfigType {
        FRONTEND,
        BACKEND;

    }
}

