/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.PartitionNames;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

public class AdminCompactTableStmt
extends DdlStmt {
    private TableRef tblRef;
    private Expr where;
    private List<String> partitions = Lists.newArrayList();
    private CompactionType typeFilter;
    private BinaryPredicate.Operator op;

    public AdminCompactTableStmt(TableRef tblRef, Expr where) {
        this.tblRef = tblRef;
        this.where = where;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.ADMIN)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "ADMIN");
        }
        String dbName = null;
        if (Strings.isNullOrEmpty((String)this.tblRef.getName().getDb())) {
            dbName = analyzer.getDefaultDb();
            if (Strings.isNullOrEmpty((String)dbName)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
            }
        } else {
            dbName = ClusterNamespace.getFullName(this.getClusterName(), this.tblRef.getName().getDb());
        }
        this.tblRef.getName().setDb(dbName);
        PartitionNames partitionNames = this.tblRef.getPartitionNames();
        if (partitionNames != null) {
            if (partitionNames.getPartitionNames().size() != 1) {
                throw new AnalysisException("Only support single partition for compaction");
            }
        } else {
            throw new AnalysisException("No partition selected for compaction");
        }
        this.partitions.addAll(partitionNames.getPartitionNames());
        if (this.where == null) {
            throw new AnalysisException("Compaction type must be specified in Where clause like: type = 'BASE/CUMULATIVE'");
        }
        if (!this.analyzeWhere()) {
            throw new AnalysisException("Where clause should looks like: type = 'BASE/CUMULATIVE'");
        }
    }

    private boolean analyzeWhere() throws AnalysisException {
        if (!(this.where instanceof BinaryPredicate)) {
            return false;
        }
        BinaryPredicate binaryPredicate = (BinaryPredicate)this.where;
        this.op = binaryPredicate.getOp();
        if (this.op != BinaryPredicate.Operator.EQ) {
            return false;
        }
        Expr leftChild = (Expr)binaryPredicate.getChild(0);
        if (!(leftChild instanceof SlotRef)) {
            return false;
        }
        String leftKey = ((SlotRef)leftChild).getColumnName();
        if (!leftKey.equalsIgnoreCase("type")) {
            return false;
        }
        Expr rightChild = (Expr)binaryPredicate.getChild(1);
        if (!(rightChild instanceof StringLiteral)) {
            return false;
        }
        try {
            this.typeFilter = CompactionType.valueOf(((StringLiteral)rightChild).getStringValue().toUpperCase());
        }
        catch (Exception e) {
            return false;
        }
        return this.typeFilter != null && (this.typeFilter == CompactionType.CUMULATIVE || this.typeFilter == CompactionType.BASE);
    }

    public String getDbName() {
        return this.tblRef.getName().getDb();
    }

    public String getTblName() {
        return this.tblRef.getName().getTbl();
    }

    public List<String> getPartitions() {
        return this.partitions;
    }

    public String getCompactionType() {
        if (this.typeFilter == CompactionType.CUMULATIVE) {
            return "cumulative";
        }
        return "base";
    }

    public static enum CompactionType {
        CUMULATIVE,
        BASE;

    }
}

