/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.system.Backend;

public class AdminCleanTrashStmt
extends DdlStmt {
    private List<Backend> backends = Lists.newArrayList();

    public AdminCleanTrashStmt(List<String> backends) {
        ImmutableMap<Long, Backend> backendsInfo = Catalog.getCurrentSystemInfo().getIdToBackend();
        HashMap<String, Long> backendsID = new HashMap<String, Long>();
        for (Backend backend : backendsInfo.values()) {
            backendsID.put(String.valueOf(backend.getHost()) + ":" + String.valueOf(backend.getHeartbeatPort()), backend.getId());
        }
        if (backends == null) {
            for (Backend backend : backendsInfo.values()) {
                this.backends.add(backend);
            }
        } else {
            for (String string : backends) {
                if (backendsID.get(string) == null) continue;
                this.backends.add((Backend)backendsInfo.get(backendsID.get(string)));
                backendsID.remove(string);
            }
        }
    }

    public List<Backend> getBackends() {
        return this.backends;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.ADMIN)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "ADMIN");
        }
    }

    @Override
    public RedirectStatus getRedirectStatus() {
        return RedirectStatus.NO_FORWARD;
    }
}

