/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.PropertyAnalyzer;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

public class AdminCheckTabletsStmt
extends DdlStmt {
    private List<Long> tabletIds;
    private Map<String, String> properties;
    private CheckType type;

    public AdminCheckTabletsStmt(List<Long> tabletIds, Map<String, String> properties) {
        this.tabletIds = tabletIds;
        this.properties = properties;
    }

    public List<Long> getTabletIds() {
        return this.tabletIds;
    }

    public CheckType getType() {
        return this.type;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        super.analyze(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.ADMIN)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "ADMIN");
        }
        if (CollectionUtils.isEmpty(this.tabletIds)) {
            throw new AnalysisException("Tablet id list is empty");
        }
        String typeStr = PropertyAnalyzer.analyzeType(this.properties);
        if (typeStr == null) {
            throw new AnalysisException("Should specify 'type' property");
        }
        this.type = CheckType.getTypeFromString(typeStr);
        if (this.properties != null && !this.properties.isEmpty()) {
            throw new AnalysisException("Unknown properties: " + this.properties.keySet());
        }
    }

    @Override
    public RedirectStatus getRedirectStatus() {
        return RedirectStatus.FORWARD_NO_SYNC;
    }

    public static enum CheckType {
        CONSISTENCY;


        public static CheckType getTypeFromString(String str) throws AnalysisException {
            try {
                return CheckType.valueOf(str.toUpperCase());
            }
            catch (Exception e) {
                throw new AnalysisException("Unknown check type: " + str);
            }
        }
    }
}

