/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.PartitionNames;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

public class AdminCancelRepairTableStmt
extends DdlStmt {
    private TableRef tblRef;
    private List<String> partitions = Lists.newArrayList();

    public AdminCancelRepairTableStmt(TableRef tblRef) {
        this.tblRef = tblRef;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.ADMIN)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "ADMIN");
        }
        String dbName = null;
        if (Strings.isNullOrEmpty((String)this.tblRef.getName().getDb())) {
            dbName = analyzer.getDefaultDb();
            if (Strings.isNullOrEmpty((String)dbName)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
            }
        } else {
            dbName = ClusterNamespace.getFullName(this.getClusterName(), this.tblRef.getName().getDb());
        }
        this.tblRef.getName().setDb(dbName);
        PartitionNames partitionNames = this.tblRef.getPartitionNames();
        if (partitionNames != null) {
            if (partitionNames.isTemp()) {
                throw new AnalysisException("Do not support (cancel)repair temporary partitions");
            }
            this.partitions.addAll(partitionNames.getPartitionNames());
        }
    }

    public String getDbName() {
        return this.tblRef.getName().getDb();
    }

    public String getTblName() {
        return this.tblRef.getName().getTbl();
    }

    public List<String> getPartitions() {
        return this.partitions;
    }
}

