/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.doris.alter.AlterOpType;
import org.apache.doris.analysis.AlterTableClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.FeNameFormat;

public class AddRollupClause
extends AlterTableClause {
    private String rollupName;
    private List<String> columnNames;
    private String baseRollupName;
    private List<String> dupKeys;
    private Map<String, String> properties;

    public String getRollupName() {
        return this.rollupName;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public List<String> getDupKeys() {
        return this.dupKeys;
    }

    public String getBaseRollupName() {
        return this.baseRollupName;
    }

    public AddRollupClause(String rollupName, List<String> columnNames, List<String> dupKeys, String baseRollupName, Map<String, String> properties) {
        super(AlterOpType.ADD_ROLLUP);
        this.rollupName = rollupName;
        this.columnNames = columnNames;
        this.dupKeys = dupKeys;
        this.baseRollupName = baseRollupName;
        this.properties = properties;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        FeNameFormat.checkTableName(this.rollupName);
        if (this.columnNames == null || this.columnNames.isEmpty()) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLE_MUST_HAVE_COLUMNS, new Object[0]);
        }
        HashSet colSet = Sets.newHashSet();
        for (String col : this.columnNames) {
            if (Strings.isNullOrEmpty((String)col)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_WRONG_COLUMN_NAME, col);
            }
            if (colSet.add(col)) continue;
            ErrorReport.reportAnalysisException(ErrorCode.ERR_DUP_FIELDNAME, col);
        }
        this.baseRollupName = Strings.emptyToNull((String)this.baseRollupName);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String toSql() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ADD ROLLUP `").append(this.rollupName).append("` (");
        int idx = 0;
        for (String column : this.columnNames) {
            if (idx != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("`").append(column).append("`");
            ++idx;
        }
        stringBuilder.append(")");
        if (this.baseRollupName != null) {
            stringBuilder.append(" FROM `").append(this.baseRollupName).append("`");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

