/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import java.util.Map;
import org.apache.doris.alter.AlterOpType;
import org.apache.doris.analysis.AlterTableClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DistributionDesc;
import org.apache.doris.analysis.SinglePartitionDesc;
import org.apache.doris.common.AnalysisException;

public class AddPartitionClause
extends AlterTableClause {
    private SinglePartitionDesc partitionDesc;
    private DistributionDesc distributionDesc;
    private Map<String, String> properties;
    private boolean isTempPartition;

    public SinglePartitionDesc getSingeRangePartitionDesc() {
        return this.partitionDesc;
    }

    public DistributionDesc getDistributionDesc() {
        return this.distributionDesc;
    }

    public boolean isTempPartition() {
        return this.isTempPartition;
    }

    public AddPartitionClause(SinglePartitionDesc partitionDesc, DistributionDesc distributionDesc, Map<String, String> properties, boolean isTempPartition) {
        super(AlterOpType.ADD_PARTITION);
        this.partitionDesc = partitionDesc;
        this.distributionDesc = distributionDesc;
        this.properties = properties;
        this.isTempPartition = isTempPartition;
        this.needTableStable = false;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("ADD ");
        sb.append(this.partitionDesc.toSql() + "\n");
        if (this.distributionDesc != null) {
            sb.append(this.distributionDesc.toSql());
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

