/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.doris.alter.AlterOpType;
import org.apache.doris.analysis.AlterTableClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ColumnDef;
import org.apache.doris.catalog.Column;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;

public class AddColumnsClause
extends AlterTableClause {
    private List<ColumnDef> columnDefs;
    private String rollupName;
    private Map<String, String> properties;
    private List<Column> columns;

    public List<Column> getColumns() {
        return this.columns;
    }

    public String getRollupName() {
        return this.rollupName;
    }

    public AddColumnsClause(List<ColumnDef> columnDefs, String rollupName, Map<String, String> properties) {
        super(AlterOpType.SCHEMA_CHANGE);
        this.columnDefs = columnDefs;
        this.rollupName = rollupName;
        this.properties = properties;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.columnDefs == null || this.columnDefs.isEmpty()) {
            throw new AnalysisException("Columns is empty in add columns clause.");
        }
        for (ColumnDef colDef : this.columnDefs) {
            colDef.analyze(true);
            if (colDef.isAllowNull() || colDef.getDefaultValue() != null) continue;
            ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DEFAULT_FOR_FIELD, colDef.getName());
        }
        this.rollupName = Strings.emptyToNull((String)this.rollupName);
        this.columns = Lists.newArrayList();
        for (ColumnDef columnDef : this.columnDefs) {
            Column col = columnDef.toColumn();
            this.columns.add(col);
        }
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("ADD COLUMN (");
        int idx = 0;
        for (ColumnDef columnDef : this.columnDefs) {
            if (idx != 0) {
                sb.append(", ");
            }
            sb.append(columnDef.toSql());
            ++idx;
        }
        sb.append(")");
        if (this.rollupName != null) {
            sb.append(" IN `").append(this.rollupName).append("`");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

