/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BackendClause;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.util.PropertyAnalyzer;
import org.apache.doris.resource.Tag;

public class AddBackendClause
extends BackendClause {
    protected boolean isFree;
    protected String destCluster;
    protected Map<String, String> properties = Maps.newHashMap();
    private Tag tag;

    public AddBackendClause(List<String> hostPorts) {
        super(hostPorts);
        this.isFree = true;
        this.destCluster = "";
    }

    public AddBackendClause(List<String> hostPorts, boolean isFree, Map<String, String> properties) {
        super(hostPorts);
        this.isFree = isFree;
        this.destCluster = "";
        this.properties = properties;
        if (this.properties == null) {
            this.properties = Maps.newHashMap();
        }
    }

    public AddBackendClause(List<String> hostPorts, String destCluster) {
        super(hostPorts);
        this.isFree = false;
        this.destCluster = destCluster;
    }

    public Tag getTag() {
        return this.tag;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        this.tag = PropertyAnalyzer.analyzeBackendTagProperties(this.properties, Tag.DEFAULT_BACKEND_TAG);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("ADD ");
        if (this.isFree) {
            sb.append("FREE ");
        }
        sb.append("BACKEND ");
        if (!Strings.isNullOrEmpty((String)this.destCluster)) {
            sb.append("to").append(this.destCluster);
        }
        for (int i = 0; i < this.hostPorts.size(); ++i) {
            sb.append("\"").append((String)this.hostPorts.get(i)).append("\"");
            if (i == this.hostPorts.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public boolean isFree() {
        return this.isFree;
    }

    public String getDestCluster() {
        return this.destCluster;
    }
}

