/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ParseNode;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.UserException;
import org.apache.doris.qe.GlobalVariable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AbstractBackupTableRefClause
implements ParseNode {
    private static final Logger LOG = LogManager.getLogger(AbstractBackupTableRefClause.class);
    private boolean isExclude;
    private List<TableRef> tableRefList;

    public AbstractBackupTableRefClause(boolean isExclude, List<TableRef> tableRefList) {
        this.isExclude = isExclude;
        this.tableRefList = tableRefList;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        TreeMap tblPartsMap = GlobalVariable.lowerCaseTableNames == 0 ? Maps.newTreeMap() : Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        for (TableRef tblRef : this.tableRefList) {
            String tblName = tblRef.getName().getTbl();
            if (!tblPartsMap.containsKey(tblName)) {
                tblPartsMap.put(tblName, tblRef);
                continue;
            }
            throw new AnalysisException("Duplicated table: " + tblName);
        }
        this.tableRefList.clear();
        for (TableRef tableRef : tblPartsMap.values()) {
            this.tableRefList.add(tableRef);
        }
        LOG.debug("table refs after normalization: {}", (Object)Joiner.on((String)",").join(this.tableRefList));
    }

    public boolean isExclude() {
        return this.isExclude;
    }

    public List<TableRef> getTableRefList() {
        return this.tableRefList;
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        if (this.isExclude) {
            sb.append("EXCLUDE ");
        } else {
            sb.append("ON ");
        }
        sb.append("\n(");
        sb.append(Joiner.on((String)",\n").join(this.tableRefList));
        sb.append("\n)");
        return sb.toString();
    }
}

