/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.doris.analysis.AbstractBackupTableRefClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.LabelName;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AbstractBackupStmt
extends DdlStmt {
    private static final Logger LOG = LogManager.getLogger(AbstractBackupStmt.class);
    private static final String PROP_TIMEOUT = "timeout";
    private static final long MIN_TIMEOUT_MS = 600000L;
    protected LabelName labelName;
    protected String repoName;
    protected AbstractBackupTableRefClause abstractBackupTableRefClause;
    protected Map<String, String> properties;
    protected long timeoutMs;

    public AbstractBackupStmt(LabelName labelName, String repoName, AbstractBackupTableRefClause abstractBackupTableRefClause, Map<String, String> properties) {
        this.labelName = labelName;
        this.repoName = repoName;
        this.abstractBackupTableRefClause = abstractBackupTableRefClause;
        this.properties = properties == null ? Maps.newHashMap() : properties;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        this.labelName.analyze(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkDbPriv(ConnectContext.get(), this.labelName.getDbName(), PrivPredicate.LOAD)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "LOAD");
        }
        this.analyzeTableRefClause();
        this.analyzeProperties();
    }

    private void analyzeTableRefClause() throws UserException {
        if (this.abstractBackupTableRefClause == null) {
            return;
        }
        this.checkTableRefWithoutDatabase();
        this.abstractBackupTableRefClause.analyze(this.analyzer);
        this.customAnalyzeTableRefClause();
    }

    private void checkTableRefWithoutDatabase() throws AnalysisException {
        for (TableRef tblRef : this.abstractBackupTableRefClause.getTableRefList()) {
            if (!Strings.isNullOrEmpty((String)tblRef.getName().getDb())) {
                throw new AnalysisException("Cannot specify database name on backup objects: " + tblRef.getName().getTbl() + ". Specify database name before label");
            }
            tblRef.getName().setDb(this.labelName.getDbName());
        }
    }

    protected void customAnalyzeTableRefClause() throws AnalysisException {
    }

    protected void analyzeProperties() throws AnalysisException {
        if (this.properties.containsKey(PROP_TIMEOUT)) {
            try {
                this.timeoutMs = Long.valueOf(this.properties.get(PROP_TIMEOUT));
            }
            catch (NumberFormatException e) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_COMMON_ERROR, "Invalid timeout format: " + this.properties.get(PROP_TIMEOUT));
            }
            if (this.timeoutMs * 1000L < 600000L) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_COMMON_ERROR, "timeout must be at least 10 min");
            }
            this.timeoutMs *= 1000L;
            this.properties.remove(PROP_TIMEOUT);
        } else {
            this.timeoutMs = Config.backup_job_default_timeout_ms;
        }
    }

    public String getDbName() {
        return this.labelName.getDbName();
    }

    public String getLabel() {
        return this.labelName.getLabelName();
    }

    public LabelName getLabelName() {
        return this.labelName;
    }

    public String getRepoName() {
        return this.repoName;
    }

    public AbstractBackupTableRefClause getAbstractBackupTableRefClause() {
        return this.abstractBackupTableRefClause;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public long getTimeoutMs() {
        return this.timeoutMs;
    }
}

