/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.alter;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.NotImplementedException;
import org.apache.doris.alter.AlterHandler;
import org.apache.doris.analysis.AddBackendClause;
import org.apache.doris.analysis.AddFollowerClause;
import org.apache.doris.analysis.AddObserverClause;
import org.apache.doris.analysis.AlterClause;
import org.apache.doris.analysis.AlterLoadErrorUrlClause;
import org.apache.doris.analysis.CancelAlterSystemStmt;
import org.apache.doris.analysis.CancelStmt;
import org.apache.doris.analysis.DecommissionBackendClause;
import org.apache.doris.analysis.DropBackendClause;
import org.apache.doris.analysis.DropFollowerClause;
import org.apache.doris.analysis.DropObserverClause;
import org.apache.doris.analysis.ModifyBackendClause;
import org.apache.doris.analysis.ModifyBrokerClause;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.TabletInvertedIndex;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.Pair;
import org.apache.doris.common.UserException;
import org.apache.doris.ha.FrontendNodeType;
import org.apache.doris.system.Backend;
import org.apache.doris.system.SystemInfoService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SystemHandler
extends AlterHandler {
    private static final Logger LOG = LogManager.getLogger(SystemHandler.class);

    public SystemHandler() {
        super("cluster");
    }

    @Override
    protected void runAfterCatalogReady() {
        super.runAfterCatalogReady();
        this.runAlterJobV2();
    }

    private void runAlterJobV2() {
        SystemInfoService systemInfoService = Catalog.getCurrentSystemInfo();
        TabletInvertedIndex invertedIndex = Catalog.getCurrentInvertedIndex();
        for (Long beId : systemInfoService.getBackendIds(false)) {
            Backend backend = systemInfoService.getBackend(beId);
            if (backend == null || !backend.isDecommissioned()) continue;
            List<Long> backendTabletIds = invertedIndex.getTabletIdsByBackendId(beId);
            if (backendTabletIds.isEmpty() && Config.drop_backend_after_decommission) {
                try {
                    systemInfoService.dropBackend(beId);
                    LOG.info("no tablet on decommission backend {}, drop it", (Object)beId);
                }
                catch (DdlException e) {
                    LOG.info("backend {} is dropped failed after decommission {}", (Object)beId, (Object)e.getMessage());
                }
                continue;
            }
            LOG.info("backend {} lefts {} replicas to decommission: {}", (Object)beId, (Object)backendTabletIds.size(), backendTabletIds.size() <= 20 ? backendTabletIds : "too many");
        }
    }

    @Override
    public List<List<Comparable>> getAlterJobInfosByDb(Database db) {
        throw new NotImplementedException();
    }

    @Override
    public synchronized void process(List<AlterClause> alterClauses, String clusterName, Database dummyDb, OlapTable dummyTbl) throws UserException {
        Preconditions.checkArgument((alterClauses.size() == 1 ? 1 : 0) != 0);
        AlterClause alterClause = alterClauses.get(0);
        if (alterClause instanceof AddBackendClause) {
            AddBackendClause addBackendClause = (AddBackendClause)alterClause;
            String destClusterName = addBackendClause.getDestCluster();
            if ((!Strings.isNullOrEmpty((String)destClusterName) || addBackendClause.isFree()) && Config.disable_cluster_feature) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_INVALID_OPERATION, "ADD BACKEND TO CLUSTER");
            }
            if (!Strings.isNullOrEmpty((String)destClusterName) && Catalog.getCurrentCatalog().getCluster(destClusterName) == null) {
                throw new DdlException("Cluster: " + destClusterName + " does not exist.");
            }
            Catalog.getCurrentSystemInfo().addBackends(addBackendClause.getHostPortPairs(), addBackendClause.isFree(), addBackendClause.getDestCluster(), addBackendClause.getTag());
        } else if (alterClause instanceof DropBackendClause) {
            DropBackendClause dropBackendClause = (DropBackendClause)alterClause;
            if (!dropBackendClause.isForce()) {
                throw new DdlException("It is highly NOT RECOMMENDED to use DROP BACKEND stmt.It is not safe to directly drop a backend. All data on this backend will be discarded permanently. If you insist, use DROPP BACKEND stmt (double P).");
            }
            Catalog.getCurrentSystemInfo().dropBackends(dropBackendClause.getHostPortPairs());
        } else if (alterClause instanceof DecommissionBackendClause) {
            DecommissionBackendClause decommissionBackendClause = (DecommissionBackendClause)alterClause;
            List<Backend> decommissionBackends = this.checkDecommission(decommissionBackendClause);
            for (Backend backend : decommissionBackends) {
                backend.setDecommissioned(true);
                Catalog.getCurrentCatalog().getEditLog().logBackendStateChange(backend);
                LOG.info("set backend {} to decommission", (Object)backend.getId());
            }
        } else if (alterClause instanceof AddObserverClause) {
            AddObserverClause clause = (AddObserverClause)alterClause;
            Catalog.getCurrentCatalog().addFrontend(FrontendNodeType.OBSERVER, clause.getHost(), clause.getPort());
        } else if (alterClause instanceof DropObserverClause) {
            DropObserverClause clause = (DropObserverClause)alterClause;
            Catalog.getCurrentCatalog().dropFrontend(FrontendNodeType.OBSERVER, clause.getHost(), clause.getPort());
        } else if (alterClause instanceof AddFollowerClause) {
            AddFollowerClause clause = (AddFollowerClause)alterClause;
            Catalog.getCurrentCatalog().addFrontend(FrontendNodeType.FOLLOWER, clause.getHost(), clause.getPort());
        } else if (alterClause instanceof DropFollowerClause) {
            DropFollowerClause clause = (DropFollowerClause)alterClause;
            Catalog.getCurrentCatalog().dropFrontend(FrontendNodeType.FOLLOWER, clause.getHost(), clause.getPort());
        } else if (alterClause instanceof ModifyBrokerClause) {
            ModifyBrokerClause clause = (ModifyBrokerClause)alterClause;
            Catalog.getCurrentCatalog().getBrokerMgr().execute(clause);
        } else if (alterClause instanceof AlterLoadErrorUrlClause) {
            AlterLoadErrorUrlClause clause = (AlterLoadErrorUrlClause)alterClause;
            Catalog.getCurrentCatalog().getLoadInstance().setLoadErrorHubInfo(clause.getProperties());
        } else if (alterClause instanceof ModifyBackendClause) {
            Catalog.getCurrentSystemInfo().modifyBackends((ModifyBackendClause)alterClause);
        } else {
            Preconditions.checkState((boolean)false, alterClause.getClass());
        }
    }

    private List<Backend> checkDecommission(DecommissionBackendClause decommissionBackendClause) throws DdlException {
        return SystemHandler.checkDecommission(decommissionBackendClause.getHostPortPairs());
    }

    public static List<Backend> checkDecommission(List<Pair<String, Integer>> hostPortPairs) throws DdlException {
        SystemInfoService infoService = Catalog.getCurrentSystemInfo();
        ArrayList decommissionBackends = Lists.newArrayList();
        for (Pair<String, Integer> pair : hostPortPairs) {
            Backend backend = infoService.getBackendWithHeartbeatPort((String)pair.first, (Integer)pair.second);
            if (backend == null) {
                throw new DdlException("Backend does not exist[" + (String)pair.first + ":" + pair.second + "]");
            }
            if (backend.isDecommissioned()) continue;
            decommissionBackends.add(backend);
        }
        return decommissionBackends;
    }

    @Override
    public synchronized void cancel(CancelStmt stmt) throws DdlException {
        CancelAlterSystemStmt cancelAlterSystemStmt = (CancelAlterSystemStmt)stmt;
        cancelAlterSystemStmt.getHostPortPairs();
        SystemInfoService infoService = Catalog.getCurrentSystemInfo();
        ArrayList backends = Lists.newArrayList();
        List<Pair<String, Integer>> hostPortPairs = cancelAlterSystemStmt.getHostPortPairs();
        for (Pair<String, Integer> pair : hostPortPairs) {
            Backend backend = infoService.getBackendWithHeartbeatPort((String)pair.first, (Integer)pair.second);
            if (backend == null) {
                throw new DdlException("Backend does not exists[" + (String)pair.first + "]");
            }
            if (!backend.isDecommissioned()) {
                LOG.info("backend is not decommissioned[{}]", pair.first);
                continue;
            }
            backends.add(backend);
        }
        for (Backend backend : backends) {
            if (backend.setDecommissioned(false)) {
                Catalog.getCurrentCatalog().getEditLog().logBackendStateChange(backend);
                continue;
            }
            LOG.info("backend is not decommissioned[{}]", (Object)backend.getHost());
        }
    }
}

