/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.alter;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.gson.annotations.SerializedName;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.doris.alter.AlterCancelException;
import org.apache.doris.alter.AlterJobV2;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.Index;
import org.apache.doris.catalog.KeysType;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.catalog.TabletInvertedIndex;
import org.apache.doris.catalog.TabletMeta;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.MarkedCountDownLatch;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.SchemaVersionAndHash;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.doris.task.AgentBatchTask;
import org.apache.doris.task.AgentTask;
import org.apache.doris.task.AgentTaskExecutor;
import org.apache.doris.task.AgentTaskQueue;
import org.apache.doris.task.AlterReplicaTask;
import org.apache.doris.task.CreateReplicaTask;
import org.apache.doris.thrift.TStorageFormat;
import org.apache.doris.thrift.TStorageMedium;
import org.apache.doris.thrift.TStorageType;
import org.apache.doris.thrift.TTaskType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SchemaChangeJobV2
extends AlterJobV2 {
    private static final Logger LOG = LogManager.getLogger(SchemaChangeJobV2.class);
    @SerializedName(value="partitionIndexTabletMap")
    private Table<Long, Long, Map<Long, Long>> partitionIndexTabletMap = HashBasedTable.create();
    @SerializedName(value="partitionIndexMap")
    private Table<Long, Long, MaterializedIndex> partitionIndexMap = HashBasedTable.create();
    @SerializedName(value="indexIdMap")
    private Map<Long, Long> indexIdMap = Maps.newHashMap();
    @SerializedName(value="indexIdToName")
    private Map<Long, String> indexIdToName = Maps.newHashMap();
    @SerializedName(value="indexSchemaMap")
    private Map<Long, List<Column>> indexSchemaMap = Maps.newHashMap();
    @SerializedName(value="indexSchemaVersionAndHashMap")
    private Map<Long, SchemaVersionAndHash> indexSchemaVersionAndHashMap = Maps.newHashMap();
    @SerializedName(value="indexShortKeyMap")
    private Map<Long, Short> indexShortKeyMap = Maps.newHashMap();
    @SerializedName(value="hasBfChange")
    private boolean hasBfChange;
    @SerializedName(value="bfColumns")
    private Set<String> bfColumns = null;
    @SerializedName(value="bfFpp")
    private double bfFpp = 0.0;
    @SerializedName(value="indexChange")
    private boolean indexChange = false;
    @SerializedName(value="indexes")
    private List<Index> indexes = null;
    @SerializedName(value="watershedTxnId")
    protected long watershedTxnId = -1L;
    @SerializedName(value="storageFormat")
    private TStorageFormat storageFormat = TStorageFormat.DEFAULT;
    private AgentBatchTask schemaChangeBatchTask = new AgentBatchTask();

    public SchemaChangeJobV2(long jobId, long dbId, long tableId, String tableName, long timeoutMs) {
        super(jobId, AlterJobV2.JobType.SCHEMA_CHANGE, dbId, tableId, tableName, timeoutMs);
    }

    private SchemaChangeJobV2() {
        super(AlterJobV2.JobType.SCHEMA_CHANGE);
    }

    public void addTabletIdMap(long partitionId, long shadowIdxId, long shadowTabletId, long originTabletId) {
        Map tabletMap = (Map)this.partitionIndexTabletMap.get((Object)partitionId, (Object)shadowIdxId);
        if (tabletMap == null) {
            tabletMap = Maps.newHashMap();
            this.partitionIndexTabletMap.put((Object)partitionId, (Object)shadowIdxId, (Object)tabletMap);
        }
        tabletMap.put(shadowTabletId, originTabletId);
    }

    public void addPartitionShadowIndex(long partitionId, long shadowIdxId, MaterializedIndex shadowIdx) {
        this.partitionIndexMap.put((Object)partitionId, (Object)shadowIdxId, (Object)shadowIdx);
    }

    public void addIndexSchema(long shadowIdxId, long originIdxId, String shadowIndexName, int shadowSchemaVersion, int shadowSchemaHash, short shadowIdxShortKeyCount, List<Column> shadowIdxSchema) {
        this.indexIdMap.put(shadowIdxId, originIdxId);
        this.indexIdToName.put(shadowIdxId, shadowIndexName);
        this.indexSchemaVersionAndHashMap.put(shadowIdxId, new SchemaVersionAndHash(shadowSchemaVersion, shadowSchemaHash));
        this.indexShortKeyMap.put(shadowIdxId, shadowIdxShortKeyCount);
        this.indexSchemaMap.put(shadowIdxId, shadowIdxSchema);
    }

    public void setBloomFilterInfo(boolean hasBfChange, Set<String> bfColumns, double bfFpp) {
        this.hasBfChange = hasBfChange;
        this.bfColumns = bfColumns;
        this.bfFpp = bfFpp;
    }

    public void setAlterIndexInfo(boolean indexChange, List<Index> indexes) {
        this.indexChange = indexChange;
        this.indexes = indexes;
    }

    public void setStorageFormat(TStorageFormat storageFormat) {
        this.storageFormat = storageFormat;
    }

    private void pruneMeta() {
        this.partitionIndexTabletMap.clear();
        this.partitionIndexMap.clear();
        this.indexSchemaMap.clear();
        this.indexShortKeyMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runPendingJob() throws AlterCancelException {
        OlapTable tbl;
        Preconditions.checkState((this.jobState == AlterJobV2.JobState.PENDING ? 1 : 0) != 0, (Object)((Object)this.jobState));
        LOG.info("begin to send create replica tasks. job: {}", (Object)this.jobId);
        Database db = Catalog.getCurrentCatalog().getDbOrException(this.dbId, s -> new AlterCancelException("Database " + s + " does not exist"));
        if (!this.checkTableStable(db)) {
            return;
        }
        AgentBatchTask batchTask = new AgentBatchTask();
        int totalReplicaNum = 0;
        for (MaterializedIndex shadowIdx : this.partitionIndexMap.values()) {
            for (Tablet tablet : shadowIdx.getTablets()) {
                totalReplicaNum += tablet.getReplicas().size();
            }
        }
        MarkedCountDownLatch<Long, Long> countDownLatch = new MarkedCountDownLatch<Long, Long>(totalReplicaNum);
        try {
            tbl = (OlapTable)db.getTableOrMetaException(this.tableId, Table.TableType.OLAP);
        }
        catch (MetaNotFoundException e) {
            throw new AlterCancelException(e.getMessage());
        }
        tbl.readLock();
        try {
            Preconditions.checkState((tbl.getState() == OlapTable.OlapTableState.SCHEMA_CHANGE ? 1 : 0) != 0);
            Iterator e = this.partitionIndexMap.rowKeySet().iterator();
            while (e.hasNext()) {
                long partitionId = (Long)e.next();
                Partition partition = tbl.getPartition(partitionId);
                if (partition == null) continue;
                TStorageMedium storageMedium = tbl.getPartitionInfo().getDataProperty(partitionId).getStorageMedium();
                Map shadowIndexMap = this.partitionIndexMap.row((Object)partitionId);
                for (Map.Entry entry : shadowIndexMap.entrySet()) {
                    long shadowIdxId = (Long)entry.getKey();
                    MaterializedIndex shadowIdx = (MaterializedIndex)entry.getValue();
                    short shadowShortKeyColumnCount = this.indexShortKeyMap.get(shadowIdxId);
                    List<Column> shadowSchema = this.indexSchemaMap.get(shadowIdxId);
                    int shadowSchemaHash = this.indexSchemaVersionAndHashMap.get((Object)Long.valueOf((long)shadowIdxId)).schemaHash;
                    long originIndexId = this.indexIdMap.get(shadowIdxId);
                    int originSchemaHash = tbl.getSchemaHashByIndexId(originIndexId);
                    KeysType originKeysType = tbl.getKeysTypeByIndexId(originIndexId);
                    for (Tablet shadowTablet : shadowIdx.getTablets()) {
                        long shadowTabletId = shadowTablet.getId();
                        List<Replica> shadowReplicas = shadowTablet.getReplicas();
                        for (Replica shadowReplica : shadowReplicas) {
                            long backendId = shadowReplica.getBackendId();
                            countDownLatch.addMark(backendId, shadowTabletId);
                            CreateReplicaTask createReplicaTask = new CreateReplicaTask(backendId, this.dbId, this.tableId, partitionId, shadowIdxId, shadowTabletId, shadowShortKeyColumnCount, shadowSchemaHash, 1L, originKeysType, TStorageType.COLUMN, storageMedium, shadowSchema, this.bfColumns, this.bfFpp, countDownLatch, this.indexes, tbl.isInMemory(), tbl.getPartitionInfo().getTabletType(partitionId), tbl.getCompressionType());
                            createReplicaTask.setBaseTablet((Long)((Map)this.partitionIndexTabletMap.get((Object)partitionId, (Object)shadowIdxId)).get(shadowTabletId), originSchemaHash);
                            if (this.storageFormat != null) {
                                createReplicaTask.setStorageFormat(this.storageFormat);
                            }
                            batchTask.addTask(createReplicaTask);
                        }
                    }
                }
            }
        }
        finally {
            tbl.readUnlock();
        }
        if (!FeConstants.runningUnitTest) {
            AgentTaskQueue.addBatchTask(batchTask);
            AgentTaskExecutor.submit(batchTask);
            long timeout = Math.min((long)Config.tablet_create_timeout_second * 1000L * (long)totalReplicaNum, (long)Config.max_create_table_timeout_second * 1000L);
            boolean ok = false;
            try {
                ok = countDownLatch.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOG.warn("InterruptedException: ", (Throwable)e);
                ok = false;
            }
            if (!ok) {
                AgentTaskQueue.removeBatchTask(batchTask, TTaskType.CREATE);
                String errMsg = null;
                if (!countDownLatch.getStatus().ok()) {
                    errMsg = countDownLatch.getStatus().getErrorMsg();
                } else {
                    List unfinishedMarks = countDownLatch.getLeftMarks();
                    List subList = unfinishedMarks.subList(0, Math.min(unfinishedMarks.size(), 3));
                    errMsg = "Error replicas:" + Joiner.on((String)", ").join(subList);
                }
                LOG.warn("failed to create replicas for job: {}, {}", (Object)this.jobId, (Object)errMsg);
                throw new AlterCancelException("Create replicas failed. Error: " + errMsg);
            }
        }
        tbl.writeLockOrAlterCancelException();
        try {
            Preconditions.checkState((tbl.getState() == OlapTable.OlapTableState.SCHEMA_CHANGE ? 1 : 0) != 0);
            this.addShadowIndexToCatalog(tbl);
        }
        finally {
            tbl.writeUnlock();
        }
        this.watershedTxnId = Catalog.getCurrentGlobalTransactionMgr().getTransactionIDGenerator().getNextTransactionId();
        this.jobState = AlterJobV2.JobState.WAITING_TXN;
        Catalog.getCurrentCatalog().getEditLog().logAlterJob(this);
        LOG.info("transfer schema change job {} state to {}, watershed txn id: {}", (Object)this.jobId, (Object)this.jobState, (Object)this.watershedTxnId);
    }

    private void addShadowIndexToCatalog(OlapTable tbl) {
        Iterator<Object> iterator = this.partitionIndexMap.rowKeySet().iterator();
        while (iterator.hasNext()) {
            long partitionId = (Long)iterator.next();
            Partition partition = tbl.getPartition(partitionId);
            if (partition == null) continue;
            Map shadowIndexMap = this.partitionIndexMap.row((Object)partitionId);
            for (MaterializedIndex shadowIndex : shadowIndexMap.values()) {
                Preconditions.checkState((shadowIndex.getState() == MaterializedIndex.IndexState.SHADOW ? 1 : 0) != 0, (Object)((Object)shadowIndex.getState()));
                partition.createRollupIndex(shadowIndex);
            }
        }
        iterator = this.indexIdMap.keySet().iterator();
        while (iterator.hasNext()) {
            long shadowIdxId = (Long)iterator.next();
            tbl.setIndexMeta(shadowIdxId, this.indexIdToName.get(shadowIdxId), this.indexSchemaMap.get(shadowIdxId), this.indexSchemaVersionAndHashMap.get((Object)Long.valueOf((long)shadowIdxId)).schemaVersion, this.indexSchemaVersionAndHashMap.get((Object)Long.valueOf((long)shadowIdxId)).schemaHash, this.indexShortKeyMap.get(shadowIdxId), TStorageType.COLUMN, tbl.getKeysTypeByIndexId(this.indexIdMap.get(shadowIdxId)));
        }
        tbl.rebuildFullSchema();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runWaitingTxnJob() throws AlterCancelException {
        OlapTable tbl;
        Preconditions.checkState((this.jobState == AlterJobV2.JobState.WAITING_TXN ? 1 : 0) != 0, (Object)((Object)this.jobState));
        try {
            if (!this.isPreviousLoadFinished()) {
                LOG.info("wait transactions before {} to be finished, schema change job: {}", (Object)this.watershedTxnId, (Object)this.jobId);
                return;
            }
        }
        catch (AnalysisException e) {
            throw new AlterCancelException(e.getMessage());
        }
        LOG.info("previous transactions are all finished, begin to send schema change tasks. job: {}", (Object)this.jobId);
        Database db = Catalog.getCurrentCatalog().getDbOrException(this.dbId, s -> new AlterCancelException("Database " + s + " does not exist"));
        try {
            tbl = (OlapTable)db.getTableOrMetaException(this.tableId, Table.TableType.OLAP);
        }
        catch (MetaNotFoundException e) {
            throw new AlterCancelException(e.getMessage());
        }
        tbl.readLock();
        try {
            Preconditions.checkState((tbl.getState() == OlapTable.OlapTableState.SCHEMA_CHANGE ? 1 : 0) != 0);
            Iterator iterator = this.partitionIndexMap.rowKeySet().iterator();
            while (iterator.hasNext()) {
                long partitionId = (Long)iterator.next();
                Partition partition = tbl.getPartition(partitionId);
                Preconditions.checkNotNull((Object)partition, (Object)partitionId);
                long visibleVersion = partition.getVisibleVersion();
                Map shadowIndexMap = this.partitionIndexMap.row((Object)partitionId);
                for (Map.Entry entry : shadowIndexMap.entrySet()) {
                    long shadowIdxId = (Long)entry.getKey();
                    MaterializedIndex shadowIdx = (MaterializedIndex)entry.getValue();
                    long originIdxId = this.indexIdMap.get(shadowIdxId);
                    int shadowSchemaHash = this.indexSchemaVersionAndHashMap.get((Object)Long.valueOf((long)shadowIdxId)).schemaHash;
                    int originSchemaHash = tbl.getSchemaHashByIndexId(this.indexIdMap.get(shadowIdxId));
                    for (Tablet shadowTablet : shadowIdx.getTablets()) {
                        long shadowTabletId = shadowTablet.getId();
                        long originTabletId = (Long)((Map)this.partitionIndexTabletMap.get((Object)partitionId, (Object)shadowIdxId)).get(shadowTabletId);
                        List<Replica> shadowReplicas = shadowTablet.getReplicas();
                        for (Replica shadowReplica : shadowReplicas) {
                            AlterReplicaTask rollupTask = new AlterReplicaTask(shadowReplica.getBackendId(), this.dbId, this.tableId, partitionId, shadowIdxId, originIdxId, shadowTabletId, originTabletId, shadowReplica.getId(), shadowSchemaHash, originSchemaHash, visibleVersion, this.jobId, AlterJobV2.JobType.SCHEMA_CHANGE);
                            this.schemaChangeBatchTask.addTask(rollupTask);
                        }
                    }
                }
            }
        }
        finally {
            tbl.readUnlock();
        }
        AgentTaskQueue.addBatchTask(this.schemaChangeBatchTask);
        AgentTaskExecutor.submit(this.schemaChangeBatchTask);
        this.jobState = AlterJobV2.JobState.RUNNING;
        LOG.info("transfer schema change job {} state to {}", (Object)this.jobId, (Object)this.jobState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runRunningJob() throws AlterCancelException {
        OlapTable tbl;
        Preconditions.checkState((this.jobState == AlterJobV2.JobState.RUNNING ? 1 : 0) != 0, (Object)((Object)this.jobState));
        Database db = Catalog.getCurrentCatalog().getDbOrException(this.dbId, s -> new AlterCancelException("Database " + s + " does not exist"));
        try {
            tbl = (OlapTable)db.getTableOrMetaException(this.tableId, Table.TableType.OLAP);
        }
        catch (MetaNotFoundException e) {
            throw new AlterCancelException(e.getMessage());
        }
        if (!this.schemaChangeBatchTask.isFinished()) {
            LOG.info("schema change tasks not finished. job: {}", (Object)this.jobId);
            List<AgentTask> tasks = this.schemaChangeBatchTask.getUnfinishedTasks(2000);
            for (AgentTask task : tasks) {
                if (task.getFailedTimes() < 3) continue;
                throw new AlterCancelException("schema change task failed after try three times: " + task.getErrorMsg());
            }
            return;
        }
        tbl.writeLockOrAlterCancelException();
        try {
            Preconditions.checkState((tbl.getState() == OlapTable.OlapTableState.SCHEMA_CHANGE ? 1 : 0) != 0);
            Iterator iterator = this.partitionIndexMap.rowKeySet().iterator();
            while (iterator.hasNext()) {
                long partitionId = (Long)iterator.next();
                Partition partition = tbl.getPartition(partitionId);
                Preconditions.checkNotNull((Object)partition, (Object)partitionId);
                long visiableVersion = partition.getVisibleVersion();
                short expectReplicationNum = tbl.getPartitionInfo().getReplicaAllocation(partition.getId()).getTotalReplicaNum();
                Map shadowIndexMap = this.partitionIndexMap.row((Object)partitionId);
                for (Map.Entry entry : shadowIndexMap.entrySet()) {
                    MaterializedIndex shadowIdx = (MaterializedIndex)entry.getValue();
                    for (Tablet shadowTablet : shadowIdx.getTablets()) {
                        List<Replica> replicas = shadowTablet.getReplicas();
                        int healthyReplicaNum = 0;
                        for (Replica replica : replicas) {
                            if (replica.getLastFailedVersion() >= 0L || !replica.checkVersionCatchUp(visiableVersion, false)) continue;
                            ++healthyReplicaNum;
                        }
                        if (healthyReplicaNum >= expectReplicationNum / 2 + 1) continue;
                        LOG.warn("shadow tablet {} has few healthy replicas: {}, schema change job: {}", (Object)shadowTablet.getId(), replicas, (Object)this.jobId);
                        throw new AlterCancelException("shadow tablet " + shadowTablet.getId() + " has few healthy replicas");
                    }
                }
            }
            this.onFinished(tbl);
        }
        finally {
            tbl.writeUnlock();
        }
        this.pruneMeta();
        this.jobState = AlterJobV2.JobState.FINISHED;
        this.finishedTimeMs = System.currentTimeMillis();
        Catalog.getCurrentCatalog().getEditLog().logAlterJob(this);
        LOG.info("schema change job finished: {}", (Object)this.jobId);
    }

    private void onFinished(OlapTable tbl) {
        for (Partition partition : tbl.getPartitions()) {
            for (Map.Entry<Long, Long> entry : this.indexIdMap.entrySet()) {
                long shadowIdxId = entry.getKey();
                long originIdxId = entry.getValue();
                MaterializedIndex shadowIdx = partition.getIndex(shadowIdxId);
                Preconditions.checkNotNull((Object)shadowIdx, (Object)shadowIdxId);
                MaterializedIndex droppedIdx = null;
                droppedIdx = originIdxId == partition.getBaseIndex().getId() ? partition.getBaseIndex() : partition.deleteRollupIndex(originIdxId);
                Preconditions.checkNotNull((Object)droppedIdx, (Object)(originIdxId + " vs. " + shadowIdxId));
                for (Tablet tablet : shadowIdx.getTablets()) {
                    for (Replica replica : tablet.getReplicas()) {
                        replica.setState(Replica.ReplicaState.NORMAL);
                    }
                }
                partition.visualiseShadowIndex(shadowIdxId, originIdxId == partition.getBaseIndex().getId());
                for (Tablet originTablet : droppedIdx.getTablets()) {
                    Catalog.getCurrentInvertedIndex().deleteTablet(originTablet.getId());
                }
            }
        }
        for (Map.Entry entry : this.indexIdMap.entrySet()) {
            long shadowIdxId = (Long)entry.getKey();
            long originIdxId = (Long)entry.getValue();
            String shadowIdxName = tbl.getIndexNameById(shadowIdxId);
            String originIdxName = tbl.getIndexNameById(originIdxId);
            tbl.deleteIndexInfo(originIdxName);
            tbl.renameIndexForSchemaChange(shadowIdxName, originIdxName);
            tbl.renameColumnNamePrefix(shadowIdxId);
            if (originIdxId != tbl.getBaseIndexId()) continue;
            tbl.setBaseIndexId(shadowIdxId);
        }
        tbl.rebuildFullSchema();
        if (this.hasBfChange) {
            tbl.setBloomFilterInfo(this.bfColumns, this.bfFpp);
        }
        if (this.indexChange) {
            tbl.setIndexes(this.indexes);
        }
        if (this.storageFormat == TStorageFormat.V2) {
            tbl.setStorageFormat(this.storageFormat);
        }
        tbl.setState(OlapTable.OlapTableState.NORMAL);
    }

    @Override
    protected synchronized boolean cancelImpl(String errMsg) {
        if (this.jobState.isFinalState()) {
            return false;
        }
        this.cancelInternal();
        this.pruneMeta();
        this.errMsg = errMsg;
        this.finishedTimeMs = System.currentTimeMillis();
        LOG.info("cancel {} job {}, err: {}", (Object)this.type, (Object)this.jobId, (Object)errMsg);
        Catalog.getCurrentCatalog().getEditLog().logAlterJob(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelInternal() {
        OlapTable tbl;
        AgentTaskQueue.removeBatchTask(this.schemaChangeBatchTask, TTaskType.ALTER);
        TabletInvertedIndex invertedIndex = Catalog.getCurrentInvertedIndex();
        Database db = Catalog.getCurrentCatalog().getDbNullable(this.dbId);
        if (db != null && (tbl = (OlapTable)db.getTableNullable(this.tableId)) != null) {
            tbl.writeLock();
            try {
                Iterator<Object> iterator = this.partitionIndexMap.rowKeySet().iterator();
                while (iterator.hasNext()) {
                    long partitionId = (Long)iterator.next();
                    Partition partition = tbl.getPartition(partitionId);
                    Preconditions.checkNotNull((Object)partition, (Object)partitionId);
                    Map shadowIndexMap = this.partitionIndexMap.row((Object)partitionId);
                    for (Map.Entry entry : shadowIndexMap.entrySet()) {
                        MaterializedIndex shadowIdx = (MaterializedIndex)entry.getValue();
                        for (Tablet shadowTablet : shadowIdx.getTablets()) {
                            invertedIndex.deleteTablet(shadowTablet.getId());
                        }
                        partition.deleteRollupIndex(shadowIdx.getId());
                    }
                }
                for (String shadowIndexName : this.indexIdToName.values()) {
                    tbl.deleteIndexInfo(shadowIndexName);
                }
                tbl.setState(OlapTable.OlapTableState.NORMAL);
            }
            finally {
                tbl.writeUnlock();
            }
        }
        this.jobState = AlterJobV2.JobState.CANCELLED;
    }

    protected boolean isPreviousLoadFinished() throws AnalysisException {
        return Catalog.getCurrentGlobalTransactionMgr().isPreviousTransactionsFinished(this.watershedTxnId, this.dbId, Lists.newArrayList((Object[])new Long[]{this.tableId}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replayCreateJob(SchemaChangeJobV2 replayedJob) throws MetaNotFoundException {
        Database db = Catalog.getCurrentCatalog().getDbOrMetaException(this.dbId);
        OlapTable olapTable = (OlapTable)db.getTableOrMetaException(this.tableId, Table.TableType.OLAP);
        olapTable.writeLock();
        try {
            TabletInvertedIndex invertedIndex = Catalog.getCurrentInvertedIndex();
            for (Table.Cell cell : this.partitionIndexMap.cellSet()) {
                long partitionId = (Long)cell.getRowKey();
                long shadowIndexId = (Long)cell.getColumnKey();
                MaterializedIndex shadowIndex = (MaterializedIndex)cell.getValue();
                TStorageMedium medium = olapTable.getPartitionInfo().getDataProperty(partitionId).getStorageMedium();
                TabletMeta shadowTabletMeta = new TabletMeta(this.dbId, this.tableId, partitionId, shadowIndexId, this.indexSchemaVersionAndHashMap.get((Object)Long.valueOf((long)shadowIndexId)).schemaHash, medium);
                for (Tablet shadownTablet : shadowIndex.getTablets()) {
                    invertedIndex.addTablet(shadownTablet.getId(), shadowTabletMeta);
                    for (Replica shadowReplica : shadownTablet.getReplicas()) {
                        invertedIndex.addReplica(shadownTablet.getId(), shadowReplica);
                    }
                }
            }
            olapTable.setState(OlapTable.OlapTableState.SCHEMA_CHANGE);
        }
        finally {
            olapTable.writeUnlock();
        }
        this.watershedTxnId = replayedJob.watershedTxnId;
        this.jobState = AlterJobV2.JobState.WAITING_TXN;
        LOG.info("replay pending schema change job: {}, table id: {}", (Object)this.jobId, (Object)this.tableId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replayPendingJob(SchemaChangeJobV2 replayedJob) throws MetaNotFoundException {
        Database db = Catalog.getCurrentCatalog().getDbOrMetaException(this.dbId);
        OlapTable olapTable = (OlapTable)db.getTableOrMetaException(this.tableId, Table.TableType.OLAP);
        olapTable.writeLock();
        try {
            this.addShadowIndexToCatalog(olapTable);
        }
        finally {
            olapTable.writeUnlock();
        }
        this.jobState = AlterJobV2.JobState.WAITING_TXN;
        this.watershedTxnId = replayedJob.watershedTxnId;
        LOG.info("replay waiting txn schema change job: {} table id: {}", (Object)this.jobId, (Object)this.tableId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replayRunningJob(SchemaChangeJobV2 replayedJob) {
        OlapTable tbl;
        Database db = Catalog.getCurrentCatalog().getDbNullable(this.dbId);
        if (db != null && (tbl = (OlapTable)db.getTableNullable(this.tableId)) != null) {
            tbl.writeLock();
            try {
                this.onFinished(tbl);
            }
            finally {
                tbl.writeUnlock();
            }
        }
        this.jobState = AlterJobV2.JobState.FINISHED;
        this.finishedTimeMs = replayedJob.finishedTimeMs;
        LOG.info("replay finished schema change job: {}", (Object)this.jobId);
    }

    private void replayCancelled(SchemaChangeJobV2 replayedJob) {
        this.cancelInternal();
        this.jobState = AlterJobV2.JobState.CANCELLED;
        this.finishedTimeMs = replayedJob.finishedTimeMs;
        this.errMsg = replayedJob.errMsg;
        LOG.info("replay cancelled schema change job: {}", (Object)this.jobId);
    }

    @Override
    public void replay(AlterJobV2 replayedJob) {
        try {
            SchemaChangeJobV2 replayedSchemaChangeJob = (SchemaChangeJobV2)replayedJob;
            switch (replayedJob.jobState) {
                case PENDING: {
                    this.replayCreateJob(replayedSchemaChangeJob);
                    break;
                }
                case WAITING_TXN: {
                    this.replayPendingJob(replayedSchemaChangeJob);
                    break;
                }
                case FINISHED: {
                    this.replayRunningJob(replayedSchemaChangeJob);
                    break;
                }
                case CANCELLED: {
                    this.replayCancelled(replayedSchemaChangeJob);
                    break;
                }
            }
        }
        catch (MetaNotFoundException e) {
            LOG.warn("[INCONSISTENT META] replay schema change job failed {}", (Object)replayedJob.getJobId(), (Object)e);
        }
    }

    @Override
    protected void getInfo(List<List<Comparable>> infos) {
        String progress = FeConstants.null_string;
        if (this.jobState == AlterJobV2.JobState.RUNNING && this.schemaChangeBatchTask.getTaskNum() > 0) {
            progress = this.schemaChangeBatchTask.getFinishedTaskNum() + "/" + this.schemaChangeBatchTask.getTaskNum();
        }
        for (Map.Entry<Long, Long> entry : this.indexIdMap.entrySet()) {
            long shadowIndexId = entry.getKey();
            ArrayList info = Lists.newArrayList();
            info.add(this.jobId);
            info.add(this.tableName);
            info.add(TimeUtils.longToTimeString(this.createTimeMs));
            info.add(TimeUtils.longToTimeString(this.finishedTimeMs));
            info.add(this.indexIdToName.get(shadowIndexId).substring("__doris_shadow_".length()));
            info.add(shadowIndexId);
            info.add((Comparable)entry.getValue());
            info.add(this.indexSchemaVersionAndHashMap.get(shadowIndexId).toString());
            info.add(this.watershedTxnId);
            info.add(this.jobState.name());
            info.add(this.errMsg);
            info.add(progress);
            info.add(this.timeoutMs / 1000L);
            infos.add(info);
        }
    }

    public List<List<String>> getUnfinishedTasks(int limit) {
        ArrayList taskInfos = Lists.newArrayList();
        if (this.jobState == AlterJobV2.JobState.RUNNING) {
            List<AgentTask> tasks = this.schemaChangeBatchTask.getUnfinishedTasks(limit);
            for (AgentTask agentTask : tasks) {
                AlterReplicaTask alterTask = (AlterReplicaTask)agentTask;
                ArrayList info = Lists.newArrayList();
                info.add(String.valueOf(alterTask.getBackendId()));
                info.add(String.valueOf(alterTask.getBaseTabletId()));
                info.add(String.valueOf(alterTask.getSignature()));
                taskInfos.add(info);
            }
        }
        return taskInfos;
    }

    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson((Object)this, AlterJobV2.class);
        Text.writeString((DataOutput)out, (String)json);
    }
}

