/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.alter;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.doris.alter.AlterHandler;
import org.apache.doris.alter.AlterJobV2;
import org.apache.doris.alter.SchemaChangeJobV2;
import org.apache.doris.analysis.AddColumnClause;
import org.apache.doris.analysis.AddColumnsClause;
import org.apache.doris.analysis.AlterClause;
import org.apache.doris.analysis.CancelAlterTableStmt;
import org.apache.doris.analysis.CancelStmt;
import org.apache.doris.analysis.ColumnPosition;
import org.apache.doris.analysis.CreateIndexClause;
import org.apache.doris.analysis.DropColumnClause;
import org.apache.doris.analysis.DropIndexClause;
import org.apache.doris.analysis.IndexDef;
import org.apache.doris.analysis.ModifyColumnClause;
import org.apache.doris.analysis.ModifyTablePropertiesClause;
import org.apache.doris.analysis.ReorderColumnsClause;
import org.apache.doris.catalog.AggregateType;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.DistributionInfo;
import org.apache.doris.catalog.HashDistributionInfo;
import org.apache.doris.catalog.Index;
import org.apache.doris.catalog.KeysType;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.MaterializedIndexMeta;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.PartitionInfo;
import org.apache.doris.catalog.PartitionType;
import org.apache.doris.catalog.RandomDistributionInfo;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.ReplicaAllocation;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.catalog.TabletMeta;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.MarkedCountDownLatch;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.ThreadPoolManager;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.DynamicPartitionUtil;
import org.apache.doris.common.util.ListComparator;
import org.apache.doris.common.util.PropertyAnalyzer;
import org.apache.doris.common.util.Util;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.persist.RemoveAlterJobV2OperationLog;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.task.AgentBatchTask;
import org.apache.doris.task.AgentTaskExecutor;
import org.apache.doris.task.AgentTaskQueue;
import org.apache.doris.task.ClearAlterTask;
import org.apache.doris.task.UpdateTabletMetaInfoTask;
import org.apache.doris.thrift.TStorageFormat;
import org.apache.doris.thrift.TStorageMedium;
import org.apache.doris.thrift.TTaskType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SchemaChangeHandler
extends AlterHandler {
    private static final Logger LOG = LogManager.getLogger(SchemaChangeHandler.class);
    public static final String SHADOW_NAME_PRFIX = "__doris_shadow_";
    public static final int MAX_ACTIVE_SCHEMA_CHANGE_JOB_V2_SIZE = 10;
    public static final int CYCLE_COUNT_TO_CHECK_EXPIRE_SCHEMA_CHANGE_JOB = 20;
    public final ThreadPoolExecutor schemaChangeThreadPool = ThreadPoolManager.newDaemonCacheThreadPool(10, "schema-change-pool", true);
    public final Map<Long, AlterJobV2> activeSchemaChangeJobsV2 = Maps.newConcurrentMap();
    public final Map<Long, AlterJobV2> runnableSchemaChangeJobV2 = Maps.newConcurrentMap();
    public int cycleCount = 0;

    public SchemaChangeHandler() {
        super("schema change", Config.default_schema_change_scheduler_interval_millisecond);
    }

    private void processAddColumn(AddColumnClause alterClause, OlapTable olapTable, Map<Long, LinkedList<Column>> indexSchemaMap) throws DdlException {
        Column column = alterClause.getColumn();
        ColumnPosition columnPos = alterClause.getColPos();
        String targetIndexName = alterClause.getRollupName();
        this.checkIndexExists(olapTable, targetIndexName);
        String baseIndexName = olapTable.getName();
        this.checkAssignedTargetIndexName(baseIndexName, targetIndexName);
        long baseIndexId = olapTable.getBaseIndexId();
        long targetIndexId = -1L;
        if (targetIndexName != null) {
            targetIndexId = olapTable.getIndexIdByName(targetIndexName);
        }
        HashSet newColNameSet = Sets.newHashSet((Object[])new String[]{column.getName()});
        this.addColumnInternal(olapTable, column, columnPos, targetIndexId, baseIndexId, indexSchemaMap, newColNameSet);
    }

    private void processAddColumn(AddColumnClause alterClause, Table externalTable, List<Column> newSchema) throws DdlException {
        Column column = alterClause.getColumn();
        ColumnPosition columnPos = alterClause.getColPos();
        HashSet newColNameSet = Sets.newHashSet((Object[])new String[]{column.getName()});
        this.addColumnInternal(column, columnPos, newSchema, newColNameSet);
    }

    private void processAddColumns(AddColumnsClause alterClause, Table externalTable, List<Column> newSchema) throws DdlException {
        List<Column> columns = alterClause.getColumns();
        HashSet newColNameSet = Sets.newHashSet();
        for (Column column : alterClause.getColumns()) {
            newColNameSet.add(column.getName());
        }
        for (Column newColumn : columns) {
            this.addColumnInternal(newColumn, null, newSchema, newColNameSet);
        }
    }

    private void processAddColumns(AddColumnsClause alterClause, OlapTable olapTable, Map<Long, LinkedList<Column>> indexSchemaMap) throws DdlException {
        List<Column> columns = alterClause.getColumns();
        String targetIndexName = alterClause.getRollupName();
        this.checkIndexExists(olapTable, targetIndexName);
        HashSet newColNameSet = Sets.newHashSet();
        for (Column column : columns) {
            newColNameSet.add(column.getName());
        }
        String baseIndexName = olapTable.getName();
        this.checkAssignedTargetIndexName(baseIndexName, targetIndexName);
        long baseIndexId = olapTable.getBaseIndexId();
        long targetIndexId = -1L;
        if (targetIndexName != null) {
            targetIndexId = olapTable.getIndexIdByName(targetIndexName);
        }
        for (Column column : columns) {
            this.addColumnInternal(olapTable, column, null, targetIndexId, baseIndexId, indexSchemaMap, newColNameSet);
        }
    }

    private void processDropColumn(DropColumnClause alterClause, Table externalTable, List<Column> newSchema) throws DdlException {
        String dropColName = alterClause.getColName();
        boolean found = false;
        Iterator<Column> baseIter = newSchema.iterator();
        while (baseIter.hasNext()) {
            Column column = baseIter.next();
            if (!column.getName().equalsIgnoreCase(dropColName)) continue;
            if (newSchema.size() > 1) {
                baseIter.remove();
                found = true;
                break;
            }
            throw new DdlException("Do not allow remove last column of table: " + externalTable.getName() + " column: " + dropColName);
        }
        if (!found) {
            throw new DdlException("Column does not exists: " + dropColName);
        }
    }

    private void processDropColumn(DropColumnClause alterClause, OlapTable olapTable, Map<Long, LinkedList<Column>> indexSchemaMap, List<Index> indexes) throws DdlException {
        boolean isKey;
        List baseSchema;
        long baseIndexId;
        String dropColName = alterClause.getColName();
        String targetIndexName = alterClause.getRollupName();
        this.checkIndexExists(olapTable, targetIndexName);
        String baseIndexName = olapTable.getName();
        this.checkAssignedTargetIndexName(baseIndexName, targetIndexName);
        if (KeysType.UNIQUE_KEYS == olapTable.getKeysType()) {
            baseIndexId = olapTable.getBaseIndexId();
            baseSchema = indexSchemaMap.get(baseIndexId);
            isKey = false;
            for (Object column : baseSchema) {
                if (!((Column)column).isKey() || !((Column)column).getName().equalsIgnoreCase(dropColName)) continue;
                isKey = true;
                break;
            }
            if (isKey) {
                throw new DdlException("Can not drop key column in Unique data model table");
            }
        } else if (KeysType.AGG_KEYS == olapTable.getKeysType()) {
            if (null == targetIndexName) {
                baseIndexId = olapTable.getBaseIndexId();
                baseSchema = indexSchemaMap.get(baseIndexId);
                isKey = false;
                boolean hasReplaceColumn = false;
                for (Column column : baseSchema) {
                    if (column.isKey() && column.getName().equalsIgnoreCase(dropColName)) {
                        isKey = true;
                        continue;
                    }
                    if (AggregateType.REPLACE != column.getAggregationType() && AggregateType.REPLACE_IF_NOT_NULL != column.getAggregationType()) continue;
                    hasReplaceColumn = true;
                }
                if (isKey && hasReplaceColumn) {
                    throw new DdlException("Can not drop key column when table has value column with REPLACE aggregation method");
                }
            } else {
                long targetIndexId = olapTable.getIndexIdByName(targetIndexName);
                List targetIndexSchema = indexSchemaMap.get(targetIndexId);
                isKey = false;
                boolean hasReplaceColumn = false;
                for (Column column : targetIndexSchema) {
                    if (column.isKey() && column.getName().equalsIgnoreCase(dropColName)) {
                        isKey = true;
                        continue;
                    }
                    if (AggregateType.REPLACE != column.getAggregationType() && AggregateType.REPLACE_IF_NOT_NULL != column.getAggregationType()) continue;
                    hasReplaceColumn = true;
                }
                if (isKey && hasReplaceColumn) {
                    throw new DdlException("Can not drop key column when rollup has value column with REPLACE aggregation metho");
                }
            }
        }
        Iterator<Index> it = indexes.iterator();
        block3: while (it.hasNext()) {
            Index index = it.next();
            for (String indexCol : index.getColumns()) {
                if (!dropColName.equalsIgnoreCase(indexCol)) continue;
                it.remove();
                continue block3;
            }
        }
        long baseIndexId2 = olapTable.getBaseIndexId();
        if (targetIndexName == null) {
            ArrayList<Long> indexIds = new ArrayList<Long>();
            indexIds.add(baseIndexId2);
            indexIds.addAll(olapTable.getIndexIdListExceptBaseIndex());
            List baseSchema2 = indexSchemaMap.get(baseIndexId2);
            boolean found = false;
            Iterator baseIter = baseSchema2.iterator();
            while (baseIter.hasNext()) {
                Column column = (Column)baseIter.next();
                if (!column.getName().equalsIgnoreCase(dropColName)) continue;
                baseIter.remove();
                found = true;
                break;
            }
            if (!found) {
                throw new DdlException("Column does not exists: " + dropColName);
            }
            block6: for (int i = 1; i < indexIds.size(); ++i) {
                List rollupSchema = indexSchemaMap.get(indexIds.get(i));
                Iterator iter = rollupSchema.iterator();
                while (iter.hasNext()) {
                    Column column = (Column)iter.next();
                    if (!column.getName().equalsIgnoreCase(dropColName)) continue;
                    iter.remove();
                    continue block6;
                }
            }
        } else {
            long targetIndexId = olapTable.getIndexIdByName(targetIndexName);
            List targetIndexSchema = indexSchemaMap.get(targetIndexId);
            boolean found = false;
            Iterator iter = targetIndexSchema.iterator();
            while (iter.hasNext()) {
                Column column = (Column)iter.next();
                if (!column.getName().equalsIgnoreCase(dropColName)) continue;
                iter.remove();
                found = true;
                break;
            }
            if (!found) {
                throw new DdlException("Column does not exists: " + dropColName);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processModifyColumn(ModifyColumnClause alterClause, Table externalTable, List<Column> newSchema) throws DdlException {
        Column modColumn = alterClause.getColumn();
        ColumnPosition columnPos = alterClause.getColPos();
        String newColName = modColumn.getName();
        boolean hasColPos = columnPos != null && !columnPos.isFirst();
        boolean found = false;
        boolean typeChanged = false;
        int modColIndex = -1;
        int lastColIndex = -1;
        for (int i = 0; i < newSchema.size(); ++i) {
            Column col = newSchema.get(i);
            if (col.getName().equalsIgnoreCase(newColName)) {
                modColIndex = i;
                found = true;
                if (!col.equals(modColumn)) {
                    typeChanged = true;
                }
            }
            if (hasColPos) {
                if (!col.getName().equalsIgnoreCase(columnPos.getLastCol())) continue;
                lastColIndex = i;
                continue;
            }
            if (!col.isKey()) continue;
            lastColIndex = i;
        }
        if (!found) {
            throw new DdlException("Column[" + newColName + "] does not exists");
        }
        if (hasColPos && lastColIndex == -1) {
            throw new DdlException("Column[" + columnPos.getLastCol() + "] does not exists");
        }
        if (columnPos != null && columnPos.isFirst()) {
            lastColIndex = -1;
            hasColPos = true;
        }
        Column oriColumn = newSchema.get(modColIndex);
        modColumn.setName(oriColumn.getName());
        if (hasColPos) {
            if (lastColIndex > modColIndex) {
                newSchema.add(lastColIndex + 1, modColumn);
                newSchema.remove(modColIndex);
                return;
            } else {
                if (lastColIndex >= modColIndex) throw new DdlException("Column[" + columnPos.getLastCol() + "] modify position is invalid");
                newSchema.remove(modColIndex);
                newSchema.add(lastColIndex + 1, modColumn);
            }
            return;
        } else {
            newSchema.set(modColIndex, modColumn);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processModifyColumn(ModifyColumnClause alterClause, OlapTable olapTable, Map<Long, LinkedList<Column>> indexSchemaMap) throws DdlException {
        Column modColumn = alterClause.getColumn();
        if (KeysType.AGG_KEYS == olapTable.getKeysType()) {
            if (modColumn.isKey() && null != modColumn.getAggregationType()) {
                throw new DdlException("Can not assign aggregation method on key column: " + modColumn.getName());
            }
            if (null == modColumn.getAggregationType()) {
                modColumn.setIsKey(true);
            }
        } else if (KeysType.UNIQUE_KEYS == olapTable.getKeysType()) {
            if (null != modColumn.getAggregationType()) {
                throw new DdlException("Can not assign aggregation method on column in Unique data model table: " + modColumn.getName());
            }
            if (!modColumn.isKey()) {
                modColumn.setAggregationType(AggregateType.REPLACE, true);
            }
        } else {
            if (null != modColumn.getAggregationType()) {
                throw new DdlException("Can not assign aggregation method on column in Duplicate data model table: " + modColumn.getName());
            }
            if (!modColumn.isKey()) {
                modColumn.setAggregationType(AggregateType.NONE, true);
            }
        }
        ColumnPosition columnPos = alterClause.getColPos();
        String targetIndexName = alterClause.getRollupName();
        this.checkIndexExists(olapTable, targetIndexName);
        String baseIndexName = olapTable.getName();
        this.checkAssignedTargetIndexName(baseIndexName, targetIndexName);
        if (targetIndexName != null && columnPos == null) {
            throw new DdlException("Do not need to specify index name when just modifying column type");
        }
        String indexNameForFindingColumn = targetIndexName;
        if (indexNameForFindingColumn == null) {
            indexNameForFindingColumn = baseIndexName;
        }
        long indexIdForFindingColumn = olapTable.getIndexIdByName(indexNameForFindingColumn);
        List schemaForFinding = indexSchemaMap.get(indexIdForFindingColumn);
        String newColName = modColumn.getName();
        boolean hasColPos = columnPos != null && !columnPos.isFirst();
        boolean found = false;
        boolean typeChanged = false;
        int modColIndex = -1;
        int lastColIndex = -1;
        for (int i = 0; i < schemaForFinding.size(); ++i) {
            Column col = (Column)schemaForFinding.get(i);
            if (col.getName().equalsIgnoreCase(newColName)) {
                modColIndex = i;
                found = true;
                if (!col.equals(modColumn)) {
                    typeChanged = true;
                }
            }
            if (hasColPos) {
                if (!col.getName().equalsIgnoreCase(columnPos.getLastCol())) continue;
                lastColIndex = i;
                continue;
            }
            if (!col.isKey()) continue;
            lastColIndex = i;
        }
        if (!found) {
            throw new DdlException("Column[" + newColName + "] does not exists");
        }
        if (hasColPos && lastColIndex == -1) {
            throw new DdlException("Column[" + columnPos.getLastCol() + "] does not exists");
        }
        if (columnPos != null && columnPos.isFirst()) {
            lastColIndex = -1;
            hasColPos = true;
        }
        Column oriColumn = (Column)schemaForFinding.get(modColIndex);
        modColumn.setName(oriColumn.getName());
        if (hasColPos) {
            if (lastColIndex > modColIndex) {
                schemaForFinding.add(lastColIndex + 1, modColumn);
                schemaForFinding.remove(modColIndex);
            } else {
                if (lastColIndex >= modColIndex) throw new DdlException("Column[" + columnPos.getLastCol() + "] modify position is invalid");
                schemaForFinding.remove(modColIndex);
                schemaForFinding.add(lastColIndex + 1, modColumn);
            }
        } else {
            schemaForFinding.set(modColIndex, modColumn);
        }
        if (!modColumn.equals(oriColumn)) {
            List otherIndexSchema;
            ArrayList<Long> otherIndexIds = new ArrayList<Long>();
            block1: for (Map.Entry<Long, List<Column>> entry : olapTable.getIndexIdToSchema().entrySet()) {
                if (entry.getKey() == indexIdForFindingColumn) continue;
                List<Column> schema = entry.getValue();
                for (Column column : schema) {
                    if (!column.getName().equalsIgnoreCase(modColumn.getName())) continue;
                    otherIndexIds.add(entry.getKey());
                    continue block1;
                }
            }
            if (KeysType.AGG_KEYS == olapTable.getKeysType() || KeysType.UNIQUE_KEYS == olapTable.getKeysType()) {
                for (Long otherIndexId : otherIndexIds) {
                    otherIndexSchema = indexSchemaMap.get(otherIndexId);
                    modColIndex = -1;
                    for (int i = 0; i < otherIndexSchema.size(); ++i) {
                        if (!((Column)otherIndexSchema.get(i)).getName().equalsIgnoreCase(modColumn.getName())) continue;
                        modColIndex = i;
                        break;
                    }
                    Preconditions.checkState((modColIndex != -1 ? 1 : 0) != 0);
                    otherIndexSchema.set(modColIndex, modColumn);
                }
            } else {
                for (Long otherIndexId : otherIndexIds) {
                    otherIndexSchema = indexSchemaMap.get(otherIndexId);
                    modColIndex = -1;
                    for (int i = 0; i < otherIndexSchema.size(); ++i) {
                        if (!((Column)otherIndexSchema.get(i)).getName().equalsIgnoreCase(modColumn.getName())) continue;
                        modColIndex = i;
                        break;
                    }
                    Preconditions.checkState((modColIndex != -1 ? 1 : 0) != 0);
                    Column oldCol = (Column)otherIndexSchema.get(modColIndex);
                    Column otherCol = new Column(modColumn);
                    otherCol.setIsKey(oldCol.isKey());
                    if (null != oldCol.getAggregationType()) {
                        otherCol.setAggregationType(oldCol.getAggregationType(), oldCol.isAggregationTypeImplicit());
                    } else {
                        otherCol.setAggregationType(null, oldCol.isAggregationTypeImplicit());
                    }
                    otherIndexSchema.set(modColIndex, otherCol);
                }
            }
        }
        if (!typeChanged) return;
        modColumn.setName(SHADOW_NAME_PRFIX + modColumn.getName());
    }

    private void processReorderColumn(ReorderColumnsClause alterClause, Table externalTable, List<Column> newSchema) throws DdlException {
        List<String> orderedColNames = alterClause.getColumnsByPos();
        newSchema.clear();
        List<Column> targetIndexSchema = externalTable.getBaseSchema();
        TreeSet colNameSet = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
        for (String colName : orderedColNames) {
            Column oneCol = null;
            for (Column column : targetIndexSchema) {
                if (!column.getName().equalsIgnoreCase(colName) || !column.isVisible()) continue;
                oneCol = column;
                break;
            }
            if (oneCol == null) {
                throw new DdlException("Column[" + colName + "] not exists");
            }
            newSchema.add(oneCol);
            if (colNameSet.contains(colName)) {
                throw new DdlException("Reduplicative column[" + colName + "]");
            }
            colNameSet.add(colName);
        }
        if (newSchema.size() != targetIndexSchema.size()) {
            throw new DdlException("Reorder stmt should contains all columns");
        }
    }

    private void processReorderColumn(ReorderColumnsClause alterClause, OlapTable olapTable, Map<Long, LinkedList<Column>> indexSchemaMap) throws DdlException {
        List<String> orderedColNames = alterClause.getColumnsByPos();
        String targetIndexName = alterClause.getRollupName();
        this.checkIndexExists(olapTable, targetIndexName);
        String baseIndexName = olapTable.getName();
        this.checkAssignedTargetIndexName(baseIndexName, targetIndexName);
        if (targetIndexName == null) {
            targetIndexName = baseIndexName;
        }
        long targetIndexId = olapTable.getIndexIdByName(targetIndexName);
        LinkedList<Column> newSchema = new LinkedList<Column>();
        LinkedList<Column> targetIndexSchema = indexSchemaMap.get(targetIndexId);
        TreeSet colNameSet = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
        for (String colName : orderedColNames) {
            Column oneCol = null;
            for (Column column : targetIndexSchema) {
                if (!column.getName().equalsIgnoreCase(colName) || !column.isVisible()) continue;
                oneCol = column;
                break;
            }
            if (oneCol == null) {
                throw new DdlException("Column[" + colName + "] not exists");
            }
            newSchema.add(oneCol);
            if (colNameSet.contains(colName)) {
                throw new DdlException("Reduplicative column[" + colName + "]");
            }
            colNameSet.add(colName);
        }
        if (olapTable.getKeysType() == KeysType.UNIQUE_KEYS) {
            for (Column column : targetIndexSchema) {
                if (column.isVisible()) continue;
                newSchema.add(column);
            }
        }
        if (newSchema.size() != targetIndexSchema.size()) {
            throw new DdlException("Reorder stmt should contains all columns");
        }
        indexSchemaMap.put(targetIndexId, newSchema);
    }

    private void addColumnInternal(Column newColumn, ColumnPosition columnPos, List<Column> modIndexSchema, Set<String> newColNameSet) throws DdlException {
        String newColName = newColumn.getName();
        int posIndex = -1;
        boolean hasPos = columnPos != null && !columnPos.isFirst();
        for (int i = 0; i < modIndexSchema.size(); ++i) {
            Column col = modIndexSchema.get(i);
            if (col.getName().equalsIgnoreCase(newColName)) {
                if (!newColNameSet.contains(newColName)) {
                    throw new DdlException("Repeatedly add column: " + newColName);
                }
                if (!col.equals(newColumn)) {
                    throw new DdlException("Repeatedly add same column with different definition: " + newColName);
                }
                return;
            }
            if (!hasPos || !col.getName().equalsIgnoreCase(columnPos.getLastCol())) continue;
            posIndex = i;
        }
        if (hasPos && posIndex == -1) {
            throw new DdlException("Column[" + columnPos.getLastCol() + "] does not found");
        }
        if (columnPos != null && columnPos.isFirst()) {
            posIndex = -1;
            hasPos = true;
        }
        if (hasPos) {
            modIndexSchema.add(posIndex + 1, newColumn);
        } else {
            modIndexSchema.add(newColumn);
        }
    }

    private void addColumnInternal(OlapTable olapTable, Column newColumn, ColumnPosition columnPos, long targetIndexId, long baseIndexId, Map<Long, LinkedList<Column>> indexSchemaMap, Set<String> newColNameSet) throws DdlException {
        List modIndexSchema;
        String newColName = newColumn.getName();
        if (KeysType.AGG_KEYS == olapTable.getKeysType()) {
            if (newColumn.isKey() && newColumn.getAggregationType() != null) {
                throw new DdlException("Can not assign aggregation method on key column: " + newColName);
            }
            if (null == newColumn.getAggregationType()) {
                newColumn.setIsKey(true);
            } else {
                if (newColumn.getAggregationType() == AggregateType.SUM && newColumn.getDefaultValue() != null && !newColumn.getDefaultValue().equals("0")) {
                    throw new DdlException("The default value of '" + newColName + "' with SUM aggregation function must be zero");
                }
                if (olapTable.getDefaultDistributionInfo() instanceof RandomDistributionInfo && (newColumn.getAggregationType() == AggregateType.REPLACE || newColumn.getAggregationType() == AggregateType.REPLACE_IF_NOT_NULL)) {
                    throw new DdlException("Can not add value column with aggregation type " + (Object)((Object)newColumn.getAggregationType()) + " for olap table with random distribution : " + newColName);
                }
            }
        } else if (KeysType.UNIQUE_KEYS == olapTable.getKeysType()) {
            if (newColumn.getAggregationType() != null) {
                throw new DdlException("Can not assign aggregation method on column in Unique data model table: " + newColName);
            }
            if (!newColumn.isKey()) {
                newColumn.setAggregationType(AggregateType.REPLACE, true);
            }
        } else {
            if (newColumn.getAggregationType() != null) {
                throw new DdlException("Can not assign aggregation method on column in Duplicate data model table: " + newColName);
            }
            if (!newColumn.isKey()) {
                if (targetIndexId != -1L && olapTable.getIndexMetaByIndexId(targetIndexId).getKeysType() == KeysType.AGG_KEYS) {
                    throw new DdlException("Please add non-key column on base table directly");
                }
                newColumn.setAggregationType(AggregateType.NONE, true);
            }
        }
        if (newColumn.getType().isHllType() && KeysType.AGG_KEYS != olapTable.getKeysType()) {
            throw new DdlException("HLL type column can only be in Aggregation data model table: " + newColName);
        }
        if (newColumn.getAggregationType() == AggregateType.BITMAP_UNION && KeysType.AGG_KEYS != olapTable.getKeysType()) {
            throw new DdlException("BITMAP_UNION must be used in AGG_KEYS");
        }
        List<Column> baseSchema = olapTable.getBaseSchema(true);
        boolean found = false;
        for (Column column : baseSchema) {
            if (!column.getName().equalsIgnoreCase(newColName)) continue;
            found = true;
            break;
        }
        if (found) {
            if (newColName.equalsIgnoreCase("__DORIS_DELETE_SIGN__")) {
                throw new DdlException("Can not enable batch delete support, already supported batch delete.");
            }
            if (newColName.equalsIgnoreCase("__DORIS_SEQUENCE_COL__")) {
                throw new DdlException("Can not enable sequence column support, already supported sequence column.");
            }
            throw new DdlException("Can not add column which already exists in base table: " + newColName);
        }
        if (KeysType.UNIQUE_KEYS == olapTable.getKeysType()) {
            if (newColumn.isKey()) {
                for (Map.Entry<Long, LinkedList<Column>> entry : indexSchemaMap.entrySet()) {
                    modIndexSchema = entry.getValue();
                    boolean isBaseIdex = entry.getKey() == baseIndexId;
                    this.checkAndAddColumn(modIndexSchema, newColumn, columnPos, newColNameSet, isBaseIdex);
                }
            } else {
                modIndexSchema = indexSchemaMap.get(baseIndexId);
                this.checkAndAddColumn(modIndexSchema, newColumn, columnPos, newColNameSet, true);
                if (targetIndexId == -1L) {
                    return;
                }
                modIndexSchema = indexSchemaMap.get(targetIndexId);
                this.checkAndAddColumn(modIndexSchema, newColumn, columnPos, newColNameSet, false);
            }
        } else if (KeysType.DUP_KEYS == olapTable.getKeysType()) {
            if (targetIndexId == -1L) {
                modIndexSchema = indexSchemaMap.get(baseIndexId);
                this.checkAndAddColumn(modIndexSchema, newColumn, columnPos, newColNameSet, true);
                return;
            }
            modIndexSchema = indexSchemaMap.get(targetIndexId);
            this.checkAndAddColumn(modIndexSchema, newColumn, columnPos, newColNameSet, false);
            if (newColumn.isKey()) {
                modIndexSchema = indexSchemaMap.get(baseIndexId);
                this.checkAndAddColumn(modIndexSchema, newColumn, null, newColNameSet, true);
            } else {
                modIndexSchema = indexSchemaMap.get(baseIndexId);
                this.checkAndAddColumn(modIndexSchema, newColumn, columnPos, newColNameSet, true);
            }
        } else {
            modIndexSchema = indexSchemaMap.get(baseIndexId);
            this.checkAndAddColumn(modIndexSchema, newColumn, columnPos, newColNameSet, true);
            if (targetIndexId == -1L) {
                return;
            }
            modIndexSchema = indexSchemaMap.get(targetIndexId);
            this.checkAndAddColumn(modIndexSchema, newColumn, columnPos, newColNameSet, false);
        }
    }

    private void checkAndAddColumn(List<Column> modIndexSchema, Column newColumn, ColumnPosition columnPos, Set<String> newColNameSet, boolean isBaseIndex) throws DdlException {
        int posIndex = -1;
        int lastVisibleIdx = -1;
        String newColName = newColumn.getName();
        boolean hasPos = columnPos != null && !columnPos.isFirst();
        for (int i = 0; i < modIndexSchema.size(); ++i) {
            Column col = modIndexSchema.get(i);
            if (col.getName().equalsIgnoreCase(newColName)) {
                if (!isBaseIndex || !newColNameSet.contains(newColName)) {
                    throw new DdlException("Repeatedly add column: " + newColName);
                }
                if (!col.equals(newColumn)) {
                    throw new DdlException("Repeatedly add same column with different definition: " + newColName);
                }
                return;
            }
            if (col.isVisible()) {
                lastVisibleIdx = i;
            }
            if (hasPos) {
                if (!col.getName().equalsIgnoreCase(columnPos.getLastCol())) continue;
                posIndex = i;
                continue;
            }
            if (!col.isKey()) continue;
            posIndex = i;
        }
        if (hasPos && posIndex == -1) {
            throw new DdlException("Column[" + columnPos.getLastCol() + "] does not found");
        }
        if (columnPos != null && columnPos.isFirst()) {
            posIndex = -1;
            hasPos = true;
        }
        if (hasPos) {
            modIndexSchema.add(posIndex + 1, newColumn);
        } else if (newColumn.isKey()) {
            modIndexSchema.add(posIndex + 1, newColumn);
        } else if (lastVisibleIdx != -1 && lastVisibleIdx < modIndexSchema.size() - 1) {
            modIndexSchema.add(lastVisibleIdx + 1, newColumn);
        } else {
            modIndexSchema.add(newColumn);
        }
    }

    private void checkIndexExists(OlapTable olapTable, String targetIndexName) throws DdlException {
        if (targetIndexName != null && !olapTable.hasMaterializedIndex(targetIndexName)) {
            throw new DdlException("Index[" + targetIndexName + "] does not exist in table[" + olapTable.getName() + "]");
        }
    }

    private void checkAssignedTargetIndexName(String baseIndexName, String targetIndexName) throws DdlException {
        if (targetIndexName != null && targetIndexName.equals(baseIndexName)) {
            throw new DdlException("Do not need to assign base index[" + baseIndexName + "] to do schema change");
        }
    }

    private void createJob(long dbId, OlapTable olapTable, Map<Long, LinkedList<Column>> indexSchemaMap, Map<String, String> propertyMap, List<Index> indexes) throws UserException {
        if (olapTable.getState() == OlapTable.OlapTableState.ROLLUP) {
            throw new DdlException("Table[" + olapTable.getName() + "]'s is doing ROLLUP job");
        }
        Preconditions.checkState((olapTable.getState() == OlapTable.OlapTableState.NORMAL ? 1 : 0) != 0, (Object)olapTable.getState().name());
        HashMap indexIdToProperties = new HashMap();
        if (propertyMap.size() > 0) {
            for (String key : propertyMap.keySet()) {
                if (!key.endsWith("short_key")) continue;
                String[] keyArray = key.split("#");
                if (keyArray.length != 2 || keyArray[0].isEmpty() || !keyArray[1].equals("short_key")) {
                    throw new DdlException("Invalid alter table property: " + key);
                }
                HashMap<String, String> prop = new HashMap<String, String>();
                if (!olapTable.hasMaterializedIndex(keyArray[0])) {
                    throw new DdlException("Index[" + keyArray[0] + "] does not exist");
                }
                prop.put("short_key", propertyMap.get(key));
                indexIdToProperties.put(olapTable.getIndexIdByName(keyArray[0]), prop);
            }
        }
        boolean hasIndexChange = false;
        HashSet<Index> newSet = new HashSet<Index>(indexes);
        HashSet<Index> oriSet = new HashSet<Index>(olapTable.getIndexes());
        if (!newSet.equals(oriSet)) {
            hasIndexChange = true;
        }
        Set<String> bfColumns = null;
        double bfFpp = 0.0;
        try {
            bfColumns = PropertyAnalyzer.analyzeBloomFilterColumns(propertyMap, (List<Column>)indexSchemaMap.get(olapTable.getBaseIndexId()), olapTable.getKeysType());
            bfFpp = PropertyAnalyzer.analyzeBloomFilterFpp(propertyMap);
        }
        catch (AnalysisException e) {
            throw new DdlException(e.getMessage());
        }
        boolean hasBfChange = false;
        Set<String> oriBfColumns = olapTable.getCopiedBfColumns();
        double oriBfFpp = olapTable.getBfFpp();
        if (bfColumns != null) {
            if (bfFpp == 0.0) {
                if (bfColumns.equals(oriBfColumns)) {
                    throw new DdlException("Bloom filter index has no change");
                }
                bfFpp = oriBfColumns == null ? FeConstants.default_bloom_filter_fpp : oriBfFpp;
            } else if (bfColumns.equals(oriBfColumns) && bfFpp == oriBfFpp) {
                throw new DdlException("Bloom filter index has no change");
            }
            hasBfChange = true;
        } else {
            if (bfFpp == 0.0) {
                bfFpp = oriBfFpp;
            } else {
                if (bfFpp == oriBfFpp) {
                    throw new DdlException("Bloom filter index has no change");
                }
                if (oriBfColumns == null) {
                    throw new DdlException("Bloom filter index has no change");
                }
                hasBfChange = true;
            }
            bfColumns = oriBfColumns;
        }
        if (bfColumns != null && bfColumns.isEmpty()) {
            bfColumns = null;
        }
        if (bfColumns == null) {
            bfFpp = 0.0;
        }
        long timeoutSecond = PropertyAnalyzer.analyzeTimeout(propertyMap, Config.alter_table_timeout_second);
        TStorageFormat storageFormat = PropertyAnalyzer.analyzeStorageFormat(propertyMap);
        Catalog catalog = Catalog.getCurrentCatalog();
        long jobId = catalog.getNextId();
        SchemaChangeJobV2 schemaChangeJob = new SchemaChangeJobV2(jobId, dbId, olapTable.getId(), olapTable.getName(), timeoutSecond * 1000L);
        schemaChangeJob.setBloomFilterInfo(hasBfChange, bfColumns, bfFpp);
        schemaChangeJob.setAlterIndexInfo(hasIndexChange, indexes);
        if (hasIndexChange) {
            storageFormat = TStorageFormat.V2;
        }
        schemaChangeJob.setStorageFormat(storageFormat);
        long tableId = olapTable.getId();
        HashMap indexIdToShortKeyColumnCount = Maps.newHashMap();
        HashMap changedIndexIdToSchema = Maps.newHashMap();
        for (Long l : indexSchemaMap.keySet()) {
            DistributionInfo distributionInfo;
            List<Column> originSchema = olapTable.getSchemaByIndexId(l, true);
            List alterSchema = indexSchemaMap.get(l);
            HashSet needAlterColumns = Sets.newHashSet();
            boolean hasColumnChange = false;
            if (alterSchema.size() != originSchema.size()) {
                hasColumnChange = true;
            } else {
                for (int i = 0; i < alterSchema.size(); ++i) {
                    Column alterColumn = (Column)alterSchema.get(i);
                    if (alterColumn.equals(originSchema.get(i))) continue;
                    needAlterColumns.add(alterColumn);
                    hasColumnChange = true;
                }
            }
            boolean needAlter = false;
            if (hasColumnChange) {
                needAlter = true;
            } else if (hasBfChange) {
                for (Column alterColumn : alterSchema) {
                    Iterator columnName = alterColumn.getName();
                    boolean isOldBfColumn = false;
                    if (oriBfColumns != null && oriBfColumns.contains(columnName)) {
                        isOldBfColumn = true;
                    }
                    boolean isNewBfColumn = false;
                    if (bfColumns != null && bfColumns.contains(columnName)) {
                        isNewBfColumn = true;
                    }
                    if (isOldBfColumn != isNewBfColumn) {
                        needAlter = true;
                    } else if (isOldBfColumn && isNewBfColumn && oriBfFpp != bfFpp) {
                        needAlter = true;
                    }
                    if (!needAlter) continue;
                    break;
                }
            } else if (hasIndexChange) {
                needAlter = true;
            } else if (storageFormat == TStorageFormat.V2 && olapTable.getStorageFormat() != TStorageFormat.V2) {
                needAlter = true;
            }
            if (!needAlter) {
                LOG.debug("index[{}] is not changed. ignore", (Object)l);
                continue;
            }
            LOG.debug("index[{}] is changed. start checking...", (Object)l);
            boolean meetValue = false;
            boolean hasKey = false;
            for (Column column : alterSchema) {
                if (column.isKey() && meetValue) {
                    throw new DdlException("Invalid column order. value should be after key. index[" + olapTable.getIndexNameById(l) + "]");
                }
                if (!column.isKey()) {
                    meetValue = true;
                    continue;
                }
                hasKey = true;
            }
            if (!hasKey) {
                throw new DdlException("No key column left. index[" + olapTable.getIndexNameById(l) + "]");
            }
            for (Column alterColumn : alterSchema) {
                for (Column oriColumn : originSchema) {
                    if (!alterColumn.nameEquals(oriColumn.getName(), true) || alterColumn.equals(oriColumn)) continue;
                    oriColumn.checkSchemaChangeAllowed(alterColumn);
                }
            }
            PartitionInfo partitionInfo = olapTable.getPartitionInfo();
            if (partitionInfo.getType() == PartitionType.RANGE || partitionInfo.getType() == PartitionType.LIST) {
                List<Column> partitionColumns = partitionInfo.getPartitionColumns();
                for (Column partitionCol : partitionColumns) {
                    boolean found = false;
                    for (Object alterColumn : alterSchema) {
                        if (!((Column)alterColumn).nameEquals(partitionCol.getName(), true)) continue;
                        if (needAlterColumns.contains(alterColumn) && !((Column)alterColumn).equals(partitionCol)) {
                            throw new DdlException("Can not modify partition column[" + partitionCol.getName() + "]. index[" + olapTable.getIndexNameById(l) + "]");
                        }
                        found = true;
                        break;
                    }
                    if (found || l.longValue() != olapTable.getBaseIndexId()) continue;
                    throw new DdlException("Partition column[" + partitionCol.getName() + "] cannot be dropped. index[" + olapTable.getIndexNameById(l) + "]");
                }
            }
            if ((distributionInfo = olapTable.getDefaultDistributionInfo()).getType() == DistributionInfo.DistributionInfoType.HASH) {
                List<Column> distributionColumns = ((HashDistributionInfo)distributionInfo).getDistributionColumns();
                for (Column distributionCol : distributionColumns) {
                    Object alterColumn;
                    boolean found = false;
                    alterColumn = alterSchema.iterator();
                    while (alterColumn.hasNext()) {
                        Column alterColumn2 = (Column)alterColumn.next();
                        if (!alterColumn2.nameEquals(distributionCol.getName(), true)) continue;
                        if (needAlterColumns.contains(alterColumn2) && !alterColumn2.equals(distributionCol)) {
                            throw new DdlException("Can not modify distribution column[" + distributionCol.getName() + "]. index[" + olapTable.getIndexNameById(l) + "]");
                        }
                        found = true;
                        break;
                    }
                    if (found || l.longValue() != olapTable.getBaseIndexId()) continue;
                    throw new DdlException("Distribution column[" + distributionCol.getName() + "] cannot be dropped. index[" + olapTable.getIndexNameById(l) + "]");
                }
            }
            short newShortKeyColumnCount = Catalog.calcShortKeyColumnCount(alterSchema, (Map)indexIdToProperties.get(l));
            LOG.debug("alter index[{}] short key column count: {}", (Object)l, (Object)newShortKeyColumnCount);
            indexIdToShortKeyColumnCount.put(l, newShortKeyColumnCount);
            changedIndexIdToSchema.put(l, alterSchema);
            LOG.debug("schema change[{}-{}-{}] check pass.", (Object)dbId, (Object)tableId, (Object)l);
        }
        if (changedIndexIdToSchema.isEmpty() && !hasIndexChange) {
            throw new DdlException("Nothing is changed. please check your alter stmt.");
        }
        for (Map.Entry entry : changedIndexIdToSchema.entrySet()) {
            long originIndexId = (Long)entry.getKey();
            MaterializedIndexMeta currentIndexMeta = olapTable.getIndexMetaByIndexId(originIndexId);
            int currentSchemaVersion = currentIndexMeta.getSchemaVersion();
            int newSchemaVersion = currentSchemaVersion + 1;
            int currentSchemaHash = currentIndexMeta.getSchemaHash();
            int newSchemaHash = Util.generateSchemaHash();
            while (currentSchemaHash == newSchemaHash) {
                newSchemaHash = Util.generateSchemaHash();
            }
            String newIndexName = SHADOW_NAME_PRFIX + olapTable.getIndexNameById(originIndexId);
            short newShortKeyColumnCount = (Short)indexIdToShortKeyColumnCount.get(originIndexId);
            long shadowIndexId = catalog.getNextId();
            ArrayList addedTablets = Lists.newArrayList();
            for (Partition partition : olapTable.getPartitions()) {
                long partitionId = partition.getId();
                TStorageMedium medium = olapTable.getPartitionInfo().getDataProperty(partitionId).getStorageMedium();
                MaterializedIndex shadowIndex = new MaterializedIndex(shadowIndexId, MaterializedIndex.IndexState.SHADOW);
                MaterializedIndex originIndex = partition.getIndex(originIndexId);
                TabletMeta shadowTabletMeta = new TabletMeta(dbId, tableId, partitionId, shadowIndexId, newSchemaHash, medium);
                ReplicaAllocation replicaAlloc = olapTable.getPartitionInfo().getReplicaAllocation(partitionId);
                Short totalReplicaNum = replicaAlloc.getTotalReplicaNum();
                for (Tablet originTablet : originIndex.getTablets()) {
                    long originTabletId = originTablet.getId();
                    long shadowTabletId = catalog.getNextId();
                    Tablet shadowTablet = new Tablet(shadowTabletId);
                    shadowIndex.addTablet(shadowTablet, shadowTabletMeta);
                    addedTablets.add(shadowTablet);
                    schemaChangeJob.addTabletIdMap(partitionId, shadowIndexId, shadowTabletId, originTabletId);
                    List<Replica> originReplicas = originTablet.getReplicas();
                    int healthyReplicaNum = 0;
                    for (Replica originReplica : originReplicas) {
                        long shadowReplicaId = catalog.getNextId();
                        long backendId = originReplica.getBackendId();
                        if (originReplica.getState() == Replica.ReplicaState.CLONE || originReplica.getState() == Replica.ReplicaState.DECOMMISSION || originReplica.getLastFailedVersion() > 0L) {
                            LOG.info("origin replica {} of tablet {} state is {}, and last failed version is {}, skip creating shadow replica", (Object)originReplica.getId(), (Object)originReplica, (Object)originReplica.getState(), (Object)originReplica.getLastFailedVersion());
                            continue;
                        }
                        Preconditions.checkState((originReplica.getState() == Replica.ReplicaState.NORMAL ? 1 : 0) != 0, (Object)((Object)originReplica.getState()));
                        Replica shadowReplica = new Replica(shadowReplicaId, backendId, Replica.ReplicaState.ALTER, 1L, newSchemaHash);
                        shadowTablet.addReplica(shadowReplica);
                        ++healthyReplicaNum;
                    }
                    if (healthyReplicaNum >= totalReplicaNum / 2 + 1) continue;
                    for (Tablet tablet : addedTablets) {
                        Catalog.getCurrentInvertedIndex().deleteTablet(tablet.getId());
                    }
                    throw new DdlException("tablet " + originTabletId + " has few healthy replica: " + healthyReplicaNum);
                }
                schemaChangeJob.addPartitionShadowIndex(partitionId, shadowIndexId, shadowIndex);
            }
            schemaChangeJob.addIndexSchema(shadowIndexId, originIndexId, newIndexName, newSchemaVersion, newSchemaHash, newShortKeyColumnCount, (List)entry.getValue());
        }
        olapTable.setState(OlapTable.OlapTableState.SCHEMA_CHANGE);
        this.addAlterJobV2(schemaChangeJob);
        Catalog.getCurrentCatalog().getEditLog().logAlterJob(schemaChangeJob);
        LOG.info("finished to create schema change job: {}", (Object)schemaChangeJob.getJobId());
    }

    @Override
    protected void runAfterCatalogReady() {
        if (this.cycleCount >= 20) {
            this.clearFinishedOrCancelledSchemaChangeJobV2();
            super.runAfterCatalogReady();
            this.cycleCount = 0;
        }
        this.runAlterJobV2();
        ++this.cycleCount;
    }

    private void runAlterJobV2() {
        this.runnableSchemaChangeJobV2.values().forEach(alterJobsV2 -> {
            if (!alterJobsV2.isDone() && !this.activeSchemaChangeJobsV2.containsKey(alterJobsV2.getJobId()) && this.activeSchemaChangeJobsV2.size() < 10) {
                if (FeConstants.runningUnitTest) {
                    alterJobsV2.run();
                } else {
                    this.schemaChangeThreadPool.submit(() -> {
                        if (this.activeSchemaChangeJobsV2.putIfAbsent(alterJobsV2.getJobId(), (AlterJobV2)alterJobsV2) == null) {
                            try {
                                alterJobsV2.run();
                            }
                            finally {
                                this.activeSchemaChangeJobsV2.remove(alterJobsV2.getJobId());
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    public List<List<Comparable>> getAlterJobInfosByDb(Database db) {
        LinkedList<List<Comparable>> schemaChangeJobInfos = new LinkedList<List<Comparable>>();
        this.getAlterJobV2Infos(db, schemaChangeJobInfos);
        ListComparator comparator = new ListComparator(0, 1, 2, 3, 4, 5);
        schemaChangeJobInfos.sort(comparator);
        return schemaChangeJobInfos;
    }

    private void getAlterJobV2Infos(Database db, List<AlterJobV2> alterJobsV2, List<List<Comparable>> schemaChangeJobInfos) {
        ConnectContext ctx = ConnectContext.get();
        for (AlterJobV2 alterJob : alterJobsV2) {
            if (alterJob.getDbId() != db.getId() || ctx != null && !Catalog.getCurrentCatalog().getAuth().checkTblPriv(ctx, db.getFullName(), alterJob.getTableName(), PrivPredicate.ALTER)) continue;
            alterJob.getInfo(schemaChangeJobInfos);
        }
    }

    private void getAlterJobV2Infos(Database db, List<List<Comparable>> schemaChangeJobInfos) {
        this.getAlterJobV2Infos(db, (List<AlterJobV2>)ImmutableList.copyOf(this.alterJobsV2.values()), schemaChangeJobInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(List<AlterClause> alterClauses, String clusterName, Database db, OlapTable olapTable) throws UserException {
        olapTable.writeLockOrDdlException();
        try {
            HashMap<Long, LinkedList<Column>> indexSchemaMap = new HashMap<Long, LinkedList<Column>>();
            for (Map.Entry<Long, List<Column>> entry : olapTable.getIndexIdToSchema(true).entrySet()) {
                indexSchemaMap.put(entry.getKey(), new LinkedList(entry.getValue()));
            }
            List<Index> newIndexes = olapTable.getCopiedIndexes();
            HashMap<String, String> propertyMap = new HashMap<String, String>();
            for (AlterClause alterClause : alterClauses) {
                Map<String, String> properties = alterClause.getProperties();
                if (properties != null) {
                    if (!propertyMap.isEmpty()) {
                        throw new DdlException("reduplicated PROPERTIES");
                    }
                    propertyMap.putAll(properties);
                    if (properties.containsKey("colocate_with")) {
                        String colocateGroup = properties.get("colocate_with");
                        Catalog.getCurrentCatalog().modifyTableColocate(db, olapTable, colocateGroup, false, null);
                        return;
                    }
                    if (properties.containsKey("distribution_type")) {
                        String distributionType = properties.get("distribution_type");
                        if (!distributionType.equalsIgnoreCase("random")) {
                            throw new DdlException("Only support modifying distribution type of table from hash to random");
                        }
                        Catalog.getCurrentCatalog().convertDistributionType(db, olapTable);
                        return;
                    }
                    if (properties.containsKey("send_clear_alter_tasks")) {
                        this.sendClearAlterTask(db, olapTable);
                        return;
                    }
                    if (DynamicPartitionUtil.checkDynamicPartitionPropertiesExist(properties)) {
                        if (!olapTable.dynamicPartitionExists()) {
                            try {
                                DynamicPartitionUtil.checkInputDynamicPartitionProperties(properties, olapTable.getPartitionInfo());
                            }
                            catch (DdlException e) {
                                throw new DdlException("Table " + db.getFullName() + "." + olapTable.getName() + " is not a dynamic partition table. Use command `HELP ALTER TABLE` to see how to change a normal table to a dynamic partition table.");
                            }
                        }
                        Catalog.getCurrentCatalog().modifyTableDynamicPartition(db, olapTable, properties);
                        return;
                    }
                    if (properties.containsKey("default.replication_allocation")) {
                        Preconditions.checkNotNull((Object)properties.get("default.replication_allocation"));
                        Catalog.getCurrentCatalog().modifyTableDefaultReplicaAllocation(db, olapTable, properties);
                        return;
                    }
                    if (properties.containsKey("replication_allocation")) {
                        Catalog.getCurrentCatalog().modifyTableReplicaAllocation(db, olapTable, properties);
                        return;
                    }
                }
                if (olapTable.existTempPartitions()) {
                    throw new DdlException("Can not alter table when there are temp partitions in table");
                }
                if (alterClause instanceof AddColumnClause) {
                    this.processAddColumn((AddColumnClause)alterClause, olapTable, indexSchemaMap);
                    continue;
                }
                if (alterClause instanceof AddColumnsClause) {
                    this.processAddColumns((AddColumnsClause)alterClause, olapTable, indexSchemaMap);
                    continue;
                }
                if (alterClause instanceof DropColumnClause) {
                    this.processDropColumn((DropColumnClause)alterClause, olapTable, indexSchemaMap, newIndexes);
                    continue;
                }
                if (alterClause instanceof ModifyColumnClause) {
                    this.processModifyColumn((ModifyColumnClause)alterClause, olapTable, indexSchemaMap);
                    continue;
                }
                if (alterClause instanceof ReorderColumnsClause) {
                    this.processReorderColumn((ReorderColumnsClause)alterClause, olapTable, indexSchemaMap);
                    continue;
                }
                if (alterClause instanceof ModifyTablePropertiesClause) continue;
                if (alterClause instanceof CreateIndexClause) {
                    if (!this.processAddIndex((CreateIndexClause)alterClause, olapTable, newIndexes)) continue;
                    return;
                }
                if (alterClause instanceof DropIndexClause) {
                    if (!this.processDropIndex((DropIndexClause)alterClause, olapTable, newIndexes)) continue;
                    return;
                }
                Preconditions.checkState((boolean)false);
            }
            this.createJob(db.getId(), olapTable, indexSchemaMap, propertyMap, newIndexes);
        }
        finally {
            olapTable.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processExternalTable(List<AlterClause> alterClauses, Database db, Table externalTable) throws UserException {
        externalTable.writeLockOrDdlException();
        try {
            ArrayList newSchema = Lists.newArrayList();
            newSchema.addAll(externalTable.getBaseSchema(true));
            for (AlterClause alterClause : alterClauses) {
                if (alterClause instanceof AddColumnClause) {
                    this.processAddColumn((AddColumnClause)alterClause, externalTable, newSchema);
                    continue;
                }
                if (alterClause instanceof AddColumnsClause) {
                    this.processAddColumns((AddColumnsClause)alterClause, externalTable, newSchema);
                    continue;
                }
                if (alterClause instanceof DropColumnClause) {
                    this.processDropColumn((DropColumnClause)alterClause, externalTable, newSchema);
                    continue;
                }
                if (alterClause instanceof ModifyColumnClause) {
                    this.processModifyColumn((ModifyColumnClause)alterClause, externalTable, newSchema);
                    continue;
                }
                if (alterClause instanceof ReorderColumnsClause) {
                    this.processReorderColumn((ReorderColumnsClause)alterClause, externalTable, newSchema);
                    continue;
                }
                Preconditions.checkState((boolean)false);
            }
            externalTable.setNewFullSchema(newSchema);
            Catalog.getCurrentCatalog().refreshExternalTableSchema(db, externalTable, newSchema);
        }
        finally {
            externalTable.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendClearAlterTask(Database db, OlapTable olapTable) {
        AgentBatchTask batchTask = new AgentBatchTask();
        olapTable.readLock();
        try {
            for (Partition partition : olapTable.getPartitions()) {
                for (MaterializedIndex index : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.VISIBLE)) {
                    int schemaHash = olapTable.getSchemaHashByIndexId(index.getId());
                    for (Tablet tablet : index.getTablets()) {
                        for (Replica replica : tablet.getReplicas()) {
                            ClearAlterTask alterTask = new ClearAlterTask(replica.getBackendId(), db.getId(), olapTable.getId(), partition.getId(), index.getId(), tablet.getId(), schemaHash);
                            batchTask.addTask(alterTask);
                        }
                    }
                }
            }
        }
        finally {
            olapTable.readUnlock();
        }
        AgentTaskExecutor.submit(batchTask);
        LOG.info("send clear alter task for table {}, number: {}", (Object)olapTable.getName(), (Object)batchTask.getTaskNum());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTableInMemoryMeta(Database db, String tableName, Map<String, String> properties) throws UserException {
        ArrayList partitions = Lists.newArrayList();
        OlapTable olapTable = (OlapTable)db.getTableOrMetaException(tableName, Table.TableType.OLAP);
        olapTable.readLock();
        try {
            partitions.addAll(olapTable.getPartitions());
        }
        finally {
            olapTable.readUnlock();
        }
        boolean isInMemory = Boolean.parseBoolean(properties.get("in_memory"));
        if (isInMemory == olapTable.isInMemory()) {
            return;
        }
        for (Partition partition : partitions) {
            this.updatePartitionInMemoryMeta(db, olapTable.getName(), partition.getName(), isInMemory);
        }
        olapTable.writeLockOrDdlException();
        try {
            Catalog.getCurrentCatalog().modifyTableInMemoryMeta(db, olapTable, properties);
        }
        finally {
            olapTable.writeUnlock();
        }
    }

    public void updatePartitionsInMemoryMeta(Database db, String tableName, List<String> partitionNames, Map<String, String> properties) throws DdlException, MetaNotFoundException {
        OlapTable olapTable = (OlapTable)db.getTableOrMetaException(tableName, Table.TableType.OLAP);
        boolean isInMemory = Boolean.parseBoolean(properties.get("in_memory"));
        if (isInMemory == olapTable.isInMemory()) {
            return;
        }
        for (String partitionName : partitionNames) {
            try {
                this.updatePartitionInMemoryMeta(db, olapTable.getName(), partitionName, isInMemory);
            }
            catch (Exception e) {
                String errMsg = "Failed to update partition[" + partitionName + "]'s 'in_memory' property. The reason is [" + e.getMessage() + "]";
                throw new DdlException(errMsg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePartitionInMemoryMeta(Database db, String tableName, String partitionName, boolean isInMemory) throws UserException {
        HashMap beIdToTabletIdWithHash = Maps.newHashMap();
        OlapTable olapTable = (OlapTable)db.getTableOrMetaException(tableName, Table.TableType.OLAP);
        olapTable.readLock();
        try {
            Partition partition = olapTable.getPartition(partitionName);
            if (partition == null) {
                throw new DdlException("Partition[" + partitionName + "] does not exist in table[" + olapTable.getName() + "]");
            }
            for (MaterializedIndex index : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.VISIBLE)) {
                int schemaHash = olapTable.getSchemaHashByIndexId(index.getId());
                for (Tablet tablet : index.getTablets()) {
                    for (Replica replica : tablet.getReplicas()) {
                        Set tabletIdWithHash = beIdToTabletIdWithHash.computeIfAbsent(replica.getBackendId(), k -> Sets.newHashSet());
                        tabletIdWithHash.add(new Pair<Long, Integer>(tablet.getId(), schemaHash));
                    }
                }
            }
        }
        finally {
            olapTable.readUnlock();
        }
        int totalTaskNum = beIdToTabletIdWithHash.keySet().size();
        MarkedCountDownLatch<Long, Set<Pair<Long, Integer>>> countDownLatch = new MarkedCountDownLatch<Long, Set<Pair<Long, Integer>>>(totalTaskNum);
        AgentBatchTask batchTask = new AgentBatchTask();
        for (Map.Entry kv : beIdToTabletIdWithHash.entrySet()) {
            countDownLatch.addMark((Long)kv.getKey(), (Set)kv.getValue());
            UpdateTabletMetaInfoTask task = new UpdateTabletMetaInfoTask((Long)kv.getKey(), (Set)kv.getValue(), isInMemory, countDownLatch);
            batchTask.addTask(task);
        }
        if (!FeConstants.runningUnitTest) {
            AgentTaskQueue.addBatchTask(batchTask);
            AgentTaskExecutor.submit(batchTask);
            LOG.info("send update tablet meta task for table {}, partitions {}, number: {}", (Object)tableName, (Object)partitionName, (Object)batchTask.getTaskNum());
            long timeout = (long)Config.tablet_create_timeout_second * 1000L * (long)totalTaskNum;
            timeout = Math.min(timeout, (long)(Config.max_create_table_timeout_second * 1000));
            boolean ok = false;
            try {
                ok = countDownLatch.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOG.warn("InterruptedException: ", (Throwable)e);
            }
            if (!ok || !countDownLatch.getStatus().ok()) {
                String errMsg = "Failed to update partition[" + partitionName + "]. tablet meta.";
                AgentTaskQueue.removeBatchTask(batchTask, TTaskType.UPDATE_TABLET_META_INFO);
                if (!countDownLatch.getStatus().ok()) {
                    errMsg = errMsg + " Error: " + countDownLatch.getStatus().getErrorMsg();
                } else {
                    List<Map.Entry<Long, Set<Pair<Long, Integer>>>> unfinishedMarks = countDownLatch.getLeftMarks();
                    List<Map.Entry<Long, Set<Pair<Long, Integer>>>> subList = unfinishedMarks.subList(0, Math.min(unfinishedMarks.size(), 3));
                    if (!subList.isEmpty()) {
                        errMsg = errMsg + " Unfinished mark: " + Joiner.on((String)", ").join(subList);
                    }
                }
                errMsg = errMsg + ". This operation maybe partial successfully, You should retry until success.";
                LOG.warn(errMsg);
                throw new DdlException(errMsg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(CancelStmt stmt) throws DdlException {
        CancelAlterTableStmt cancelAlterTableStmt = (CancelAlterTableStmt)stmt;
        String dbName = cancelAlterTableStmt.getDbName();
        String tableName = cancelAlterTableStmt.getTableName();
        Preconditions.checkState((!Strings.isNullOrEmpty((String)dbName) ? 1 : 0) != 0);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)tableName) ? 1 : 0) != 0);
        Database db = Catalog.getCurrentCatalog().getDbOrDdlException(dbName);
        AlterJobV2 schemaChangeJobV2 = null;
        OlapTable olapTable = db.getOlapTableOrDdlException(tableName);
        olapTable.writeLockOrDdlException();
        try {
            if (olapTable.getState() != OlapTable.OlapTableState.SCHEMA_CHANGE && olapTable.getState() != OlapTable.OlapTableState.WAITING_STABLE) {
                throw new DdlException("Table[" + tableName + "] is not under SCHEMA_CHANGE.");
            }
            List<AlterJobV2> schemaChangeJobV2List = this.getUnfinishedAlterJobV2ByTableId(olapTable.getId());
            AlterJobV2 alterJobV2 = schemaChangeJobV2 = schemaChangeJobV2List.size() == 0 ? null : (AlterJobV2)Iterables.getOnlyElement(schemaChangeJobV2List);
            if (schemaChangeJobV2 == null) {
                throw new DdlException("Table[" + tableName + "] is under schema change state but could not find related job");
            }
        }
        finally {
            olapTable.writeUnlock();
        }
        if (schemaChangeJobV2 != null) {
            if (!schemaChangeJobV2.cancel("user cancelled")) {
                throw new DdlException("Job can not be cancelled. State: " + (Object)((Object)schemaChangeJobV2.getJobState()));
            }
            return;
        }
    }

    private boolean processAddIndex(CreateIndexClause alterClause, OlapTable olapTable, List<Index> newIndexes) throws UserException {
        if (alterClause.getIndex() == null) {
            return false;
        }
        List<Index> existedIndexes = olapTable.getIndexes();
        IndexDef indexDef = alterClause.getIndexDef();
        TreeSet newColset = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
        newColset.addAll(indexDef.getColumns());
        for (Index existedIdx : existedIndexes) {
            if (existedIdx.getIndexName().equalsIgnoreCase(indexDef.getIndexName())) {
                if (indexDef.isSetIfNotExists()) {
                    LOG.info("create index[{}] which already exists on table[{}]", (Object)indexDef.getIndexName(), (Object)olapTable.getName());
                    return true;
                }
                throw new DdlException("index `" + indexDef.getIndexName() + "` already exist.");
            }
            TreeSet existedIdxColSet = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
            existedIdxColSet.addAll(existedIdx.getColumns());
            if (!newColset.equals(existedIdxColSet)) continue;
            throw new DdlException("index for columns (" + String.join((CharSequence)",", indexDef.getColumns()) + " ) already exist.");
        }
        for (String col : indexDef.getColumns()) {
            Column column = olapTable.getColumn(col);
            if (column != null) {
                indexDef.checkColumn(column, olapTable.getKeysType());
                continue;
            }
            throw new DdlException("BITMAP column does not exist in table. invalid column: " + col);
        }
        newIndexes.add(alterClause.getIndex());
        return false;
    }

    private boolean processDropIndex(DropIndexClause alterClause, OlapTable olapTable, List<Index> indexes) throws DdlException {
        String indexName = alterClause.getIndexName();
        List<Index> existedIndexes = olapTable.getIndexes();
        Index found = null;
        for (Index existedIdx : existedIndexes) {
            if (!existedIdx.getIndexName().equalsIgnoreCase(indexName)) continue;
            found = existedIdx;
            break;
        }
        if (found == null) {
            if (alterClause.isSetIfExists()) {
                LOG.info("drop index[{}] which does not exist on table[{}]", (Object)indexName, (Object)olapTable.getName());
                return true;
            }
            throw new DdlException("index " + indexName + " does not exist");
        }
        Iterator<Index> itr = indexes.iterator();
        while (itr.hasNext()) {
            Index idx = itr.next();
            if (!idx.getIndexName().equalsIgnoreCase(alterClause.getIndexName())) continue;
            itr.remove();
            break;
        }
        return false;
    }

    @Override
    public void addAlterJobV2(AlterJobV2 alterJob) {
        super.addAlterJobV2(alterJob);
        this.runnableSchemaChangeJobV2.put(alterJob.getJobId(), alterJob);
    }

    private void clearFinishedOrCancelledSchemaChangeJobV2() {
        Iterator<Map.Entry<Long, AlterJobV2>> iterator = this.runnableSchemaChangeJobV2.entrySet().iterator();
        while (iterator.hasNext()) {
            AlterJobV2 alterJobV2 = iterator.next().getValue();
            if (!alterJobV2.isDone()) continue;
            iterator.remove();
        }
    }

    @Override
    public void replayRemoveAlterJobV2(RemoveAlterJobV2OperationLog log) {
        if (this.runnableSchemaChangeJobV2.containsKey(log.getJobId())) {
            this.runnableSchemaChangeJobV2.remove(log.getJobId());
        }
        super.replayRemoveAlterJobV2(log);
    }

    @Override
    public void replayAlterJobV2(AlterJobV2 alterJob) {
        if (!alterJob.isDone() && !this.runnableSchemaChangeJobV2.containsKey(alterJob.getJobId())) {
            this.runnableSchemaChangeJobV2.put(alterJob.getJobId(), alterJob);
        }
        super.replayAlterJobV2(alterJob);
    }
}

