/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.alter;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.io.DataOutput;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.doris.alter.AlterCancelException;
import org.apache.doris.alter.AlterJobV2;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.CreateMaterializedViewStmt;
import org.apache.doris.analysis.MVColumnItem;
import org.apache.doris.analysis.SqlParser;
import org.apache.doris.analysis.SqlScanner;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.KeysType;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.catalog.TabletInvertedIndex;
import org.apache.doris.catalog.TabletMeta;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.MarkedCountDownLatch;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.util.SqlParserUtils;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.persist.gson.GsonPostProcessable;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.OriginStatement;
import org.apache.doris.task.AgentBatchTask;
import org.apache.doris.task.AgentTask;
import org.apache.doris.task.AgentTaskExecutor;
import org.apache.doris.task.AgentTaskQueue;
import org.apache.doris.task.AlterReplicaTask;
import org.apache.doris.task.CreateReplicaTask;
import org.apache.doris.thrift.TStorageFormat;
import org.apache.doris.thrift.TStorageMedium;
import org.apache.doris.thrift.TStorageType;
import org.apache.doris.thrift.TTabletType;
import org.apache.doris.thrift.TTaskType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RollupJobV2
extends AlterJobV2
implements GsonPostProcessable {
    private static final Logger LOG = LogManager.getLogger(RollupJobV2.class);
    @SerializedName(value="partitionIdToBaseRollupTabletIdMap")
    private Map<Long, Map<Long, Long>> partitionIdToBaseRollupTabletIdMap = Maps.newHashMap();
    @SerializedName(value="partitionIdToRollupIndex")
    private Map<Long, MaterializedIndex> partitionIdToRollupIndex = Maps.newHashMap();
    @SerializedName(value="baseIndexId")
    private long baseIndexId;
    @SerializedName(value="rollupIndexId")
    private long rollupIndexId;
    @SerializedName(value="baseIndexName")
    private String baseIndexName;
    @SerializedName(value="rollupIndexName")
    private String rollupIndexName;
    @SerializedName(value="rollupSchema")
    private List<Column> rollupSchema = Lists.newArrayList();
    @SerializedName(value="baseSchemaHash")
    private int baseSchemaHash;
    @SerializedName(value="rollupSchemaHash")
    private int rollupSchemaHash;
    @SerializedName(value="rollupKeysType")
    private KeysType rollupKeysType;
    @SerializedName(value="rollupShortKeyColumnCount")
    private short rollupShortKeyColumnCount;
    @SerializedName(value="origStmt")
    private OriginStatement origStmt;
    @SerializedName(value="storageFormat")
    private TStorageFormat storageFormat = TStorageFormat.DEFAULT;
    @SerializedName(value="watershedTxnId")
    protected long watershedTxnId = -1L;
    private AgentBatchTask rollupBatchTask = new AgentBatchTask();

    public RollupJobV2(long jobId, long dbId, long tableId, String tableName, long timeoutMs, long baseIndexId, long rollupIndexId, String baseIndexName, String rollupIndexName, List<Column> rollupSchema, int baseSchemaHash, int rollupSchemaHash, KeysType rollupKeysType, short rollupShortKeyColumnCount, OriginStatement origStmt) {
        super(jobId, AlterJobV2.JobType.ROLLUP, dbId, tableId, tableName, timeoutMs);
        this.baseIndexId = baseIndexId;
        this.rollupIndexId = rollupIndexId;
        this.baseIndexName = baseIndexName;
        this.rollupIndexName = rollupIndexName;
        this.rollupSchema = rollupSchema;
        this.baseSchemaHash = baseSchemaHash;
        this.rollupSchemaHash = rollupSchemaHash;
        this.rollupKeysType = rollupKeysType;
        this.rollupShortKeyColumnCount = rollupShortKeyColumnCount;
        this.origStmt = origStmt;
    }

    private RollupJobV2() {
        super(AlterJobV2.JobType.ROLLUP);
    }

    public void addTabletIdMap(long partitionId, long rollupTabletId, long baseTabletId) {
        Map tabletIdMap = this.partitionIdToBaseRollupTabletIdMap.computeIfAbsent(partitionId, k -> Maps.newHashMap());
        tabletIdMap.put(rollupTabletId, baseTabletId);
    }

    public void addMVIndex(long partitionId, MaterializedIndex mvIndex) {
        this.partitionIdToRollupIndex.put(partitionId, mvIndex);
    }

    public void setStorageFormat(TStorageFormat storageFormat) {
        this.storageFormat = storageFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runPendingJob() throws AlterCancelException {
        OlapTable tbl;
        Preconditions.checkState((this.jobState == AlterJobV2.JobState.PENDING ? 1 : 0) != 0, (Object)((Object)this.jobState));
        LOG.info("begin to send create rollup replica tasks. job: {}", (Object)this.jobId);
        Database db = Catalog.getCurrentCatalog().getDbOrException(this.dbId, s -> new AlterCancelException("Database " + s + " does not exist"));
        if (!this.checkTableStable(db)) {
            return;
        }
        AgentBatchTask batchTask = new AgentBatchTask();
        int totalReplicaNum = 0;
        for (MaterializedIndex rollupIdx : this.partitionIdToRollupIndex.values()) {
            for (Tablet tablet : rollupIdx.getTablets()) {
                totalReplicaNum += tablet.getReplicas().size();
            }
        }
        MarkedCountDownLatch<Long, Long> countDownLatch = new MarkedCountDownLatch<Long, Long>(totalReplicaNum);
        try {
            tbl = (OlapTable)db.getTableOrMetaException(this.tableId, Table.TableType.OLAP);
        }
        catch (MetaNotFoundException e) {
            throw new AlterCancelException(e.getMessage());
        }
        tbl.readLock();
        try {
            Preconditions.checkState((tbl.getState() == OlapTable.OlapTableState.ROLLUP ? 1 : 0) != 0);
            for (Map.Entry<Long, MaterializedIndex> entry : this.partitionIdToRollupIndex.entrySet()) {
                long partitionId = entry.getKey();
                Partition partition = tbl.getPartition(partitionId);
                if (partition == null) continue;
                TStorageMedium storageMedium = tbl.getPartitionInfo().getDataProperty(partitionId).getStorageMedium();
                TTabletType tabletType = tbl.getPartitionInfo().getTabletType(partitionId);
                MaterializedIndex rollupIndex = entry.getValue();
                Map<Long, Long> tabletIdMap = this.partitionIdToBaseRollupTabletIdMap.get(partitionId);
                for (Tablet rollupTablet : rollupIndex.getTablets()) {
                    long rollupTabletId = rollupTablet.getId();
                    List<Replica> rollupReplicas = rollupTablet.getReplicas();
                    for (Replica rollupReplica : rollupReplicas) {
                        long backendId = rollupReplica.getBackendId();
                        Preconditions.checkNotNull((Object)tabletIdMap.get(rollupTabletId));
                        countDownLatch.addMark(backendId, rollupTabletId);
                        CreateReplicaTask createReplicaTask = new CreateReplicaTask(backendId, this.dbId, this.tableId, partitionId, this.rollupIndexId, rollupTabletId, this.rollupShortKeyColumnCount, this.rollupSchemaHash, 1L, this.rollupKeysType, TStorageType.COLUMN, storageMedium, this.rollupSchema, tbl.getCopiedBfColumns(), tbl.getBfFpp(), countDownLatch, tbl.getCopiedIndexes(), tbl.isInMemory(), tabletType, tbl.getCompressionType());
                        createReplicaTask.setBaseTablet(tabletIdMap.get(rollupTabletId), this.baseSchemaHash);
                        if (this.storageFormat != null) {
                            createReplicaTask.setStorageFormat(this.storageFormat);
                        }
                        batchTask.addTask(createReplicaTask);
                    }
                }
            }
        }
        finally {
            tbl.readUnlock();
        }
        if (!FeConstants.runningUnitTest) {
            AgentTaskQueue.addBatchTask(batchTask);
            AgentTaskExecutor.submit(batchTask);
            long timeout = Math.min((long)Config.tablet_create_timeout_second * 1000L * (long)totalReplicaNum, (long)Config.max_create_table_timeout_second * 1000L);
            boolean ok = false;
            try {
                ok = countDownLatch.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOG.warn("InterruptedException: ", (Throwable)e);
                ok = false;
            }
            if (!ok || !countDownLatch.getStatus().ok()) {
                AgentTaskQueue.removeBatchTask(batchTask, TTaskType.CREATE);
                String errMsg = null;
                if (!countDownLatch.getStatus().ok()) {
                    errMsg = countDownLatch.getStatus().getErrorMsg();
                } else {
                    List unfinishedMarks = countDownLatch.getLeftMarks();
                    List subList = unfinishedMarks.subList(0, Math.min(unfinishedMarks.size(), 3));
                    errMsg = "Error replicas:" + Joiner.on((String)", ").join(subList);
                }
                LOG.warn("failed to create rollup replicas for job: {}, {}", (Object)this.jobId, (Object)errMsg);
                throw new AlterCancelException("Create rollup replicas failed. Error: " + errMsg);
            }
        }
        tbl.writeLockOrAlterCancelException();
        try {
            Preconditions.checkState((tbl.getState() == OlapTable.OlapTableState.ROLLUP ? 1 : 0) != 0);
            this.addRollupIndexToCatalog(tbl);
        }
        finally {
            tbl.writeUnlock();
        }
        this.watershedTxnId = Catalog.getCurrentGlobalTransactionMgr().getTransactionIDGenerator().getNextTransactionId();
        this.jobState = AlterJobV2.JobState.WAITING_TXN;
        Catalog.getCurrentCatalog().getEditLog().logAlterJob(this);
        LOG.info("transfer rollup job {} state to {}, watershed txn id: {}", (Object)this.jobId, (Object)this.jobState, (Object)this.watershedTxnId);
    }

    private void addRollupIndexToCatalog(OlapTable tbl) {
        for (Partition partition : tbl.getPartitions()) {
            long partitionId = partition.getId();
            MaterializedIndex rollupIndex = this.partitionIdToRollupIndex.get(partitionId);
            Preconditions.checkNotNull((Object)rollupIndex);
            Preconditions.checkState((rollupIndex.getState() == MaterializedIndex.IndexState.SHADOW ? 1 : 0) != 0, (Object)((Object)rollupIndex.getState()));
            partition.createRollupIndex(rollupIndex);
        }
        tbl.setIndexMeta(this.rollupIndexId, this.rollupIndexName, this.rollupSchema, 0, this.rollupSchemaHash, this.rollupShortKeyColumnCount, TStorageType.COLUMN, this.rollupKeysType, this.origStmt);
        tbl.rebuildFullSchema();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runWaitingTxnJob() throws AlterCancelException {
        OlapTable tbl;
        Preconditions.checkState((this.jobState == AlterJobV2.JobState.WAITING_TXN ? 1 : 0) != 0, (Object)((Object)this.jobState));
        try {
            if (!this.isPreviousLoadFinished()) {
                LOG.info("wait transactions before {} to be finished, rollup job: {}", (Object)this.watershedTxnId, (Object)this.jobId);
                return;
            }
        }
        catch (AnalysisException e) {
            throw new AlterCancelException(e.getMessage());
        }
        LOG.info("previous transactions are all finished, begin to send rollup tasks. job: {}", (Object)this.jobId);
        Database db = Catalog.getCurrentCatalog().getDbOrException(this.dbId, s -> new AlterCancelException("Databasee " + s + " does not exist"));
        try {
            tbl = (OlapTable)db.getTableOrMetaException(this.tableId, Table.TableType.OLAP);
        }
        catch (MetaNotFoundException e) {
            throw new AlterCancelException(e.getMessage());
        }
        tbl.readLock();
        try {
            Preconditions.checkState((tbl.getState() == OlapTable.OlapTableState.ROLLUP ? 1 : 0) != 0);
            for (Map.Entry<Long, MaterializedIndex> entry : this.partitionIdToRollupIndex.entrySet()) {
                long partitionId = entry.getKey();
                Partition partition = tbl.getPartition(partitionId);
                Preconditions.checkNotNull((Object)partition, (Object)partitionId);
                long visibleVersion = partition.getVisibleVersion();
                MaterializedIndex rollupIndex = entry.getValue();
                Map<Long, Long> tabletIdMap = this.partitionIdToBaseRollupTabletIdMap.get(partitionId);
                for (Tablet rollupTablet : rollupIndex.getTablets()) {
                    long rollupTabletId = rollupTablet.getId();
                    long baseTabletId = tabletIdMap.get(rollupTabletId);
                    HashMap defineExprs = Maps.newHashMap();
                    for (Column column : this.rollupSchema) {
                        if (column.getDefineExpr() == null) continue;
                        defineExprs.put(column.getName(), column.getDefineExpr());
                    }
                    List<Replica> rollupReplicas = rollupTablet.getReplicas();
                    for (Replica rollupReplica : rollupReplicas) {
                        AlterReplicaTask rollupTask = new AlterReplicaTask(rollupReplica.getBackendId(), this.dbId, this.tableId, partitionId, this.rollupIndexId, this.baseIndexId, rollupTabletId, baseTabletId, rollupReplica.getId(), this.rollupSchemaHash, this.baseSchemaHash, visibleVersion, this.jobId, AlterJobV2.JobType.ROLLUP, defineExprs);
                        this.rollupBatchTask.addTask(rollupTask);
                    }
                }
            }
        }
        finally {
            tbl.readUnlock();
        }
        AgentTaskQueue.addBatchTask(this.rollupBatchTask);
        AgentTaskExecutor.submit(this.rollupBatchTask);
        this.jobState = AlterJobV2.JobState.RUNNING;
        LOG.info("transfer rollup job {} state to {}", (Object)this.jobId, (Object)this.jobState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runRunningJob() throws AlterCancelException {
        OlapTable tbl;
        Preconditions.checkState((this.jobState == AlterJobV2.JobState.RUNNING ? 1 : 0) != 0, (Object)((Object)this.jobState));
        Database db = Catalog.getCurrentCatalog().getDbOrException(this.dbId, s -> new AlterCancelException("Databasee " + s + " does not exist"));
        try {
            tbl = (OlapTable)db.getTableOrMetaException(this.tableId, Table.TableType.OLAP);
        }
        catch (MetaNotFoundException e) {
            throw new AlterCancelException(e.getMessage());
        }
        if (!this.rollupBatchTask.isFinished()) {
            LOG.info("rollup tasks not finished. job: {}", (Object)this.jobId);
            List<AgentTask> tasks = this.rollupBatchTask.getUnfinishedTasks(2000);
            for (AgentTask task : tasks) {
                if (task.getFailedTimes() < 3) continue;
                throw new AlterCancelException("rollup task failed after try three times: " + task.getErrorMsg());
            }
            return;
        }
        tbl.writeLockOrAlterCancelException();
        try {
            Preconditions.checkState((tbl.getState() == OlapTable.OlapTableState.ROLLUP ? 1 : 0) != 0);
            for (Map.Entry<Long, MaterializedIndex> entry : this.partitionIdToRollupIndex.entrySet()) {
                long partitionId = entry.getKey();
                Partition partition = tbl.getPartition(partitionId);
                if (partition == null) continue;
                long visiableVersion = partition.getVisibleVersion();
                short expectReplicationNum = tbl.getPartitionInfo().getReplicaAllocation(partitionId).getTotalReplicaNum();
                MaterializedIndex rollupIndex = entry.getValue();
                for (Tablet rollupTablet : rollupIndex.getTablets()) {
                    List<Replica> replicas = rollupTablet.getReplicas();
                    int healthyReplicaNum = 0;
                    for (Replica replica : replicas) {
                        if (replica.getLastFailedVersion() >= 0L || !replica.checkVersionCatchUp(visiableVersion, false)) continue;
                        ++healthyReplicaNum;
                    }
                    if (healthyReplicaNum >= expectReplicationNum / 2 + 1) continue;
                    LOG.warn("rollup tablet {} has few healthy replicas: {}, rollup job: {}", (Object)rollupTablet.getId(), replicas, (Object)this.jobId);
                    throw new AlterCancelException("rollup tablet " + rollupTablet.getId() + " has few healthy replicas");
                }
            }
            this.onFinished(tbl);
        }
        finally {
            tbl.writeUnlock();
        }
        this.jobState = AlterJobV2.JobState.FINISHED;
        this.finishedTimeMs = System.currentTimeMillis();
        Catalog.getCurrentCatalog().getEditLog().logAlterJob(this);
        LOG.info("rollup job finished: {}", (Object)this.jobId);
    }

    private void onFinished(OlapTable tbl) {
        for (Partition partition : tbl.getPartitions()) {
            MaterializedIndex rollupIndex = partition.getIndex(this.rollupIndexId);
            Preconditions.checkNotNull((Object)rollupIndex, (Object)this.rollupIndexId);
            for (Tablet tablet : rollupIndex.getTablets()) {
                for (Replica replica : tablet.getReplicas()) {
                    replica.setState(Replica.ReplicaState.NORMAL);
                }
            }
            partition.visualiseShadowIndex(this.rollupIndexId, false);
        }
        tbl.rebuildFullSchema();
    }

    @Override
    protected boolean cancelImpl(String errMsg) {
        if (this.jobState.isFinalState()) {
            return false;
        }
        this.cancelInternal();
        this.jobState = AlterJobV2.JobState.CANCELLED;
        this.errMsg = errMsg;
        this.finishedTimeMs = System.currentTimeMillis();
        LOG.info("cancel {} job {}, err: {}", (Object)this.type, (Object)this.jobId, (Object)errMsg);
        Catalog.getCurrentCatalog().getEditLog().logAlterJob(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelInternal() {
        OlapTable tbl;
        AgentTaskQueue.removeBatchTask(this.rollupBatchTask, TTaskType.ALTER);
        TabletInvertedIndex invertedIndex = Catalog.getCurrentInvertedIndex();
        Database db = Catalog.getCurrentCatalog().getDbNullable(this.dbId);
        if (db != null && (tbl = (OlapTable)db.getTableNullable(this.tableId)) != null) {
            tbl.writeLock();
            try {
                for (Long partitionId : this.partitionIdToRollupIndex.keySet()) {
                    MaterializedIndex rollupIndex = this.partitionIdToRollupIndex.get(partitionId);
                    for (Tablet rollupTablet : rollupIndex.getTablets()) {
                        invertedIndex.deleteTablet(rollupTablet.getId());
                    }
                    Partition partition = tbl.getPartition(partitionId);
                    partition.deleteRollupIndex(this.rollupIndexId);
                }
                tbl.deleteIndexInfo(this.rollupIndexName);
            }
            finally {
                tbl.writeUnlock();
            }
        }
    }

    protected boolean isPreviousLoadFinished() throws AnalysisException {
        return Catalog.getCurrentGlobalTransactionMgr().isPreviousTransactionsFinished(this.watershedTxnId, this.dbId, Lists.newArrayList((Object[])new Long[]{this.tableId}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replayCreateJob(RollupJobV2 replayedJob) throws MetaNotFoundException {
        Database db = Catalog.getCurrentCatalog().getDbOrMetaException(this.dbId);
        OlapTable olapTable = (OlapTable)db.getTableOrMetaException(this.tableId, Table.TableType.OLAP);
        olapTable.writeLock();
        try {
            this.addTabletToInvertedIndex(olapTable);
        }
        finally {
            olapTable.writeUnlock();
        }
        this.jobState = AlterJobV2.JobState.PENDING;
        this.watershedTxnId = replayedJob.watershedTxnId;
        LOG.info("replay pending rollup job: {}", (Object)this.jobId);
    }

    private void addTabletToInvertedIndex(OlapTable tbl) {
        TabletInvertedIndex invertedIndex = Catalog.getCurrentInvertedIndex();
        for (Long partitionId : this.partitionIdToRollupIndex.keySet()) {
            MaterializedIndex rollupIndex = this.partitionIdToRollupIndex.get(partitionId);
            TStorageMedium medium = tbl.getPartitionInfo().getDataProperty(partitionId).getStorageMedium();
            TabletMeta rollupTabletMeta = new TabletMeta(this.dbId, this.tableId, partitionId, this.rollupIndexId, this.rollupSchemaHash, medium);
            for (Tablet rollupTablet : rollupIndex.getTablets()) {
                invertedIndex.addTablet(rollupTablet.getId(), rollupTabletMeta);
                for (Replica rollupReplica : rollupTablet.getReplicas()) {
                    invertedIndex.addReplica(rollupTablet.getId(), rollupReplica);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replayPendingJob(RollupJobV2 replayedJob) throws MetaNotFoundException {
        Database db = Catalog.getCurrentCatalog().getDbOrMetaException(this.dbId);
        OlapTable olapTable = (OlapTable)db.getTableOrMetaException(this.tableId, Table.TableType.OLAP);
        olapTable.writeLock();
        try {
            this.addRollupIndexToCatalog(olapTable);
        }
        finally {
            olapTable.writeUnlock();
        }
        this.jobState = AlterJobV2.JobState.WAITING_TXN;
        this.watershedTxnId = replayedJob.watershedTxnId;
        LOG.info("replay waiting txn rollup job: {}", (Object)this.jobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replayRunningJob(RollupJobV2 replayedJob) {
        OlapTable tbl;
        Database db = Catalog.getCurrentCatalog().getDbNullable(this.dbId);
        if (db != null && (tbl = (OlapTable)db.getTableNullable(this.tableId)) != null) {
            tbl.writeLock();
            try {
                Preconditions.checkState((tbl.getState() == OlapTable.OlapTableState.ROLLUP ? 1 : 0) != 0);
                this.onFinished(tbl);
            }
            finally {
                tbl.writeUnlock();
            }
        }
        this.jobState = AlterJobV2.JobState.FINISHED;
        this.finishedTimeMs = replayedJob.finishedTimeMs;
        LOG.info("replay finished rollup job: {}", (Object)this.jobId);
    }

    private void replayCancelled(RollupJobV2 replayedJob) {
        this.cancelInternal();
        this.jobState = AlterJobV2.JobState.CANCELLED;
        this.finishedTimeMs = replayedJob.finishedTimeMs;
        this.errMsg = replayedJob.errMsg;
        LOG.info("replay cancelled rollup job: {}", (Object)this.jobId);
    }

    @Override
    public void replay(AlterJobV2 replayedJob) {
        try {
            RollupJobV2 replayedRollupJob = (RollupJobV2)replayedJob;
            switch (replayedJob.jobState) {
                case PENDING: {
                    this.replayCreateJob(replayedRollupJob);
                    break;
                }
                case WAITING_TXN: {
                    this.replayPendingJob(replayedRollupJob);
                    break;
                }
                case FINISHED: {
                    this.replayRunningJob(replayedRollupJob);
                    break;
                }
                case CANCELLED: {
                    this.replayCancelled(replayedRollupJob);
                    break;
                }
            }
        }
        catch (MetaNotFoundException e) {
            LOG.warn("[INCONSISTENT META] replay rollup job failed {}", (Object)replayedJob.getJobId(), (Object)e);
        }
    }

    @Override
    protected void getInfo(List<List<Comparable>> infos) {
        ArrayList info = Lists.newArrayList();
        info.add(this.jobId);
        info.add(this.tableName);
        info.add(TimeUtils.longToTimeString(this.createTimeMs));
        info.add(TimeUtils.longToTimeString(this.finishedTimeMs));
        info.add(this.baseIndexName);
        info.add(this.rollupIndexName);
        info.add(this.rollupIndexId);
        info.add(this.watershedTxnId);
        info.add(this.jobState.name());
        info.add(this.errMsg);
        if (this.jobState == AlterJobV2.JobState.RUNNING && this.rollupBatchTask.getTaskNum() > 0) {
            info.add(this.rollupBatchTask.getFinishedTaskNum() + "/" + this.rollupBatchTask.getTaskNum());
        } else {
            info.add(FeConstants.null_string);
        }
        info.add(this.timeoutMs / 1000L);
        infos.add(info);
    }

    public List<List<String>> getUnfinishedTasks(int limit) {
        ArrayList taskInfos = Lists.newArrayList();
        if (this.jobState == AlterJobV2.JobState.RUNNING) {
            List<AgentTask> tasks = this.rollupBatchTask.getUnfinishedTasks(limit);
            for (AgentTask agentTask : tasks) {
                AlterReplicaTask rollupTask = (AlterReplicaTask)agentTask;
                ArrayList info = Lists.newArrayList();
                info.add(String.valueOf(rollupTask.getBackendId()));
                info.add(String.valueOf(rollupTask.getBaseTabletId()));
                info.add(String.valueOf(rollupTask.getSignature()));
                taskInfos.add(info);
            }
        }
        return taskInfos;
    }

    public Map<Long, MaterializedIndex> getPartitionIdToRollupIndex() {
        return this.partitionIdToRollupIndex;
    }

    public void setJobState(AlterJobV2.JobState jobState) {
        this.jobState = jobState;
    }

    private void setColumnsDefineExpr(List<MVColumnItem> mvColumnItemList) {
        block0: for (MVColumnItem mvColumnItem : mvColumnItemList) {
            for (Column column : this.rollupSchema) {
                if (!column.getName().equals(mvColumnItem.getName())) continue;
                column.setDefineExpr(mvColumnItem.getDefineExpr());
                continue block0;
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson((Object)this, AlterJobV2.class);
        Text.writeString((DataOutput)out, (String)json);
    }

    @Override
    public void gsonPostProcess() throws IOException {
        Database db;
        if (this.origStmt == null) {
            return;
        }
        if (this.jobState != AlterJobV2.JobState.PENDING) {
            return;
        }
        SqlParser parser = new SqlParser(new SqlScanner(new StringReader(this.origStmt.originStmt), (Long)0L));
        ConnectContext connectContext = new ConnectContext();
        try {
            db = Catalog.getCurrentCatalog().getDbOrMetaException(this.dbId);
        }
        catch (MetaNotFoundException e) {
            throw new IOException("error happens when parsing create materialized view stmt: " + this.origStmt, e);
        }
        String clusterName = db.getClusterName();
        if (clusterName == null || clusterName.length() == 0) {
            clusterName = "default_cluster";
        }
        connectContext.setCluster(clusterName);
        connectContext.setDatabase(db.getFullName());
        Analyzer analyzer = new Analyzer(Catalog.getCurrentCatalog(), connectContext);
        CreateMaterializedViewStmt stmt = null;
        try {
            stmt = (CreateMaterializedViewStmt)SqlParserUtils.getStmt(parser, this.origStmt.idx);
            stmt.setIsReplay(true);
            stmt.analyze(analyzer);
        }
        catch (Exception e) {
            throw new IOException("error happens when parsing create materialized view stmt: " + stmt, e);
        }
        this.setColumnsDefineExpr(stmt.getMVColumnItemList());
    }
}

