/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.alter;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.doris.alter.AlterHandler;
import org.apache.doris.alter.AlterJobV2;
import org.apache.doris.alter.BatchAlterJobPersistInfo;
import org.apache.doris.alter.RollupJobV2;
import org.apache.doris.analysis.AddRollupClause;
import org.apache.doris.analysis.AlterClause;
import org.apache.doris.analysis.CancelAlterTableStmt;
import org.apache.doris.analysis.CancelStmt;
import org.apache.doris.analysis.CreateMaterializedViewStmt;
import org.apache.doris.analysis.DropMaterializedViewStmt;
import org.apache.doris.analysis.DropRollupClause;
import org.apache.doris.analysis.MVColumnItem;
import org.apache.doris.catalog.AggregateType;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.KeysType;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.catalog.TabletInvertedIndex;
import org.apache.doris.catalog.TabletMeta;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.util.ListComparator;
import org.apache.doris.common.util.PropertyAnalyzer;
import org.apache.doris.common.util.Util;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.persist.BatchDropInfo;
import org.apache.doris.persist.DropInfo;
import org.apache.doris.persist.EditLog;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.OriginStatement;
import org.apache.doris.thrift.TStorageFormat;
import org.apache.doris.thrift.TStorageMedium;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MaterializedViewHandler
extends AlterHandler {
    private static final Logger LOG = LogManager.getLogger(MaterializedViewHandler.class);
    public static final String NEW_STORAGE_FORMAT_INDEX_NAME_PREFIX = "__v2_";
    private Map<Long, Set<Long>> tableNotFinalStateJobMap = new ConcurrentHashMap<Long, Set<Long>>();
    private Map<Long, Set<Long>> tableRunningJobMap = new ConcurrentHashMap<Long, Set<Long>>();

    public MaterializedViewHandler() {
        super("materialized view");
    }

    @Override
    public void addAlterJobV2(AlterJobV2 alterJob) {
        super.addAlterJobV2(alterJob);
        this.addAlterJobV2ToTableNotFinalStateJobMap(alterJob);
    }

    protected void batchAddAlterJobV2(List<AlterJobV2> alterJobV2List) {
        for (AlterJobV2 alterJobV2 : alterJobV2List) {
            this.addAlterJobV2(alterJobV2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addAlterJobV2ToTableNotFinalStateJobMap(AlterJobV2 alterJobV2) {
        if (alterJobV2.isDone()) {
            LOG.warn("try to add a final job({}) to a unfinal set. db: {}, tbl: {}", (Object)alterJobV2.getJobId(), (Object)alterJobV2.getDbId(), (Object)alterJobV2.getTableId());
            return false;
        }
        Long tableId = alterJobV2.getTableId();
        Long jobId = alterJobV2.getJobId();
        Map<Long, Set<Long>> map = this.tableNotFinalStateJobMap;
        synchronized (map) {
            Set<Long> tableNotFinalStateJobIdSet = this.tableNotFinalStateJobMap.get(tableId);
            if (tableNotFinalStateJobIdSet == null) {
                tableNotFinalStateJobIdSet = new HashSet<Long>();
                this.tableNotFinalStateJobMap.put(tableId, tableNotFinalStateJobIdSet);
            }
            return tableNotFinalStateJobIdSet.add(jobId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeAlterJobV2FromTableNotFinalStateJobMap(AlterJobV2 alterJobV2) {
        Long tableId = alterJobV2.getTableId();
        Long jobId = alterJobV2.getJobId();
        Map<Long, Set<Long>> map = this.tableNotFinalStateJobMap;
        synchronized (map) {
            Set<Long> tableNotFinalStateJobIdset = this.tableNotFinalStateJobMap.get(tableId);
            if (tableNotFinalStateJobIdset == null) {
                return false;
            }
            tableNotFinalStateJobIdset.remove(jobId);
            if (tableNotFinalStateJobIdset.size() == 0) {
                this.tableNotFinalStateJobMap.remove(tableId);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCreateMaterializedView(CreateMaterializedViewStmt addMVClause, Database db, OlapTable olapTable) throws DdlException, AnalysisException {
        olapTable.writeLockOrDdlException();
        try {
            olapTable.checkStableAndNormal(db.getClusterName());
            if (olapTable.existTempPartitions()) {
                throw new DdlException("Can not alter table when there are temp partitions in table");
            }
            if (!addMVClause.getBaseIndexName().equals(olapTable.getName())) {
                throw new DdlException("The name of table in from clause must be same as the name of alter table");
            }
            String baseIndexName = addMVClause.getBaseIndexName();
            String mvIndexName = addMVClause.getMVName();
            LOG.info("process add materialized view[{}] based on [{}]", (Object)mvIndexName, (Object)baseIndexName);
            Preconditions.checkState((olapTable.getState() == OlapTable.OlapTableState.NORMAL ? 1 : 0) != 0);
            long baseIndexId = this.checkAndGetBaseIndex(baseIndexName, olapTable);
            List<Column> mvColumns = this.checkAndPrepareMaterializedView(addMVClause, olapTable);
            RollupJobV2 rollupJobV2 = this.createMaterializedViewJob(mvIndexName, baseIndexName, mvColumns, addMVClause.getProperties(), olapTable, db, baseIndexId, addMVClause.getMVKeysType(), addMVClause.getOrigStmt());
            this.addAlterJobV2(rollupJobV2);
            olapTable.setState(OlapTable.OlapTableState.ROLLUP);
            Catalog.getCurrentCatalog().getEditLog().logAlterJob(rollupJobV2);
            LOG.info("finished to create materialized view job: {}", (Object)rollupJobV2.getJobId());
        }
        finally {
            olapTable.writeUnlock();
        }
    }

    public void processBatchAddRollup(List<AlterClause> alterClauses, Database db, OlapTable olapTable) throws DdlException, AnalysisException {
        LinkedHashMap<String, RollupJobV2> rollupNameJobMap = new LinkedHashMap<String, RollupJobV2>();
        HashSet<Long> logJobIdSet = new HashSet<Long>();
        olapTable.writeLockOrDdlException();
        try {
            if (olapTable.existTempPartitions()) {
                throw new DdlException("Can not alter table when there are temp partitions in table");
            }
            for (AlterClause alterClause : alterClauses) {
                String baseIndexName;
                AddRollupClause addRollupClause = (AddRollupClause)alterClause;
                String rollupIndexName = addRollupClause.getRollupName();
                boolean changeStorageFormat = false;
                if (rollupIndexName.equalsIgnoreCase(olapTable.getName())) {
                    Map<String, String> properties = addRollupClause.getProperties();
                    if (properties == null || !properties.containsKey("storage_format") || !properties.get("storage_format").equalsIgnoreCase("v2")) {
                        throw new DdlException("Table[" + olapTable.getName() + "] can not add segment v2 rollup index without setting storage format to v2.");
                    }
                    rollupIndexName = NEW_STORAGE_FORMAT_INDEX_NAME_PREFIX + olapTable.getName();
                    changeStorageFormat = true;
                }
                if ((baseIndexName = addRollupClause.getBaseRollupName()) == null) {
                    baseIndexName = olapTable.getName();
                }
                long baseIndexId = this.checkAndGetBaseIndex(baseIndexName, olapTable);
                List<Column> rollupSchema = this.checkAndPrepareMaterializedView(addRollupClause, olapTable, baseIndexId, changeStorageFormat);
                RollupJobV2 alterJobV2 = this.createMaterializedViewJob(rollupIndexName, baseIndexName, rollupSchema, addRollupClause.getProperties(), olapTable, db, baseIndexId, olapTable.getKeysType(), null);
                rollupNameJobMap.put(addRollupClause.getRollupName(), alterJobV2);
                logJobIdSet.add(alterJobV2.getJobId());
            }
            olapTable.setState(OlapTable.OlapTableState.ROLLUP);
            ArrayList<AlterJobV2> rollupJobV2List = new ArrayList<AlterJobV2>(rollupNameJobMap.values());
            this.batchAddAlterJobV2(rollupJobV2List);
            BatchAlterJobPersistInfo batchAlterJobV2 = new BatchAlterJobPersistInfo(rollupJobV2List);
            Catalog.getCurrentCatalog().getEditLog().logBatchAlterJob(batchAlterJobV2);
            LOG.info("finished to create materialized view job: {}", logJobIdSet);
        }
        catch (Exception e) {
            TabletInvertedIndex tabletInvertedIndex = Catalog.getCurrentInvertedIndex();
            for (RollupJobV2 rollupJobV2 : rollupNameJobMap.values()) {
                for (MaterializedIndex index : rollupJobV2.getPartitionIdToRollupIndex().values()) {
                    for (Tablet tablet : index.getTablets()) {
                        tabletInvertedIndex.deleteTablet(tablet.getId());
                    }
                }
            }
            throw e;
        }
        finally {
            olapTable.writeUnlock();
        }
    }

    private RollupJobV2 createMaterializedViewJob(String mvName, String baseIndexName, List<Column> mvColumns, Map<String, String> properties, OlapTable olapTable, Database db, long baseIndexId, KeysType mvKeysType, OriginStatement origStmt) throws DdlException, AnalysisException {
        if (mvKeysType == null) {
            mvKeysType = olapTable.getKeysType();
        }
        int mvSchemaHash = Util.generateSchemaHash();
        short mvShortKeyColumnCount = Catalog.calcShortKeyColumnCount(mvColumns, properties);
        long timeoutMs = PropertyAnalyzer.analyzeTimeout(properties, Config.alter_table_timeout_second) * 1000L;
        long dbId = db.getId();
        long tableId = olapTable.getId();
        int baseSchemaHash = olapTable.getSchemaHashByIndexId(baseIndexId);
        Catalog catalog = Catalog.getCurrentCatalog();
        long jobId = catalog.getNextId();
        long mvIndexId = catalog.getNextId();
        RollupJobV2 mvJob = new RollupJobV2(jobId, dbId, tableId, olapTable.getName(), timeoutMs, baseIndexId, mvIndexId, baseIndexName, mvName, mvColumns, baseSchemaHash, mvSchemaHash, mvKeysType, mvShortKeyColumnCount, origStmt);
        String newStorageFormatIndexName = NEW_STORAGE_FORMAT_INDEX_NAME_PREFIX + olapTable.getName();
        if (mvName.equals(newStorageFormatIndexName)) {
            mvJob.setStorageFormat(TStorageFormat.V2);
        } else {
            mvJob.setStorageFormat(olapTable.getStorageFormat());
        }
        ArrayList addedTablets = Lists.newArrayList();
        for (Partition partition : olapTable.getPartitions()) {
            long partitionId = partition.getId();
            TStorageMedium medium = olapTable.getPartitionInfo().getDataProperty(partitionId).getStorageMedium();
            MaterializedIndex mvIndex = new MaterializedIndex(mvIndexId, MaterializedIndex.IndexState.SHADOW);
            MaterializedIndex baseIndex = partition.getIndex(baseIndexId);
            TabletMeta mvTabletMeta = new TabletMeta(dbId, tableId, partitionId, mvIndexId, mvSchemaHash, medium);
            short replicationNum = olapTable.getPartitionInfo().getReplicaAllocation(partitionId).getTotalReplicaNum();
            for (Tablet baseTablet : baseIndex.getTablets()) {
                long baseTabletId = baseTablet.getId();
                long mvTabletId = catalog.getNextId();
                Tablet newTablet = new Tablet(mvTabletId);
                mvIndex.addTablet(newTablet, mvTabletMeta);
                addedTablets.add(newTablet);
                mvJob.addTabletIdMap(partitionId, mvTabletId, baseTabletId);
                List<Replica> baseReplicas = baseTablet.getReplicas();
                int healthyReplicaNum = 0;
                for (Replica baseReplica : baseReplicas) {
                    long mvReplicaId = catalog.getNextId();
                    long backendId = baseReplica.getBackendId();
                    if (baseReplica.getState() == Replica.ReplicaState.CLONE || baseReplica.getState() == Replica.ReplicaState.DECOMMISSION || baseReplica.getLastFailedVersion() > 0L) {
                        LOG.info("base replica {} of tablet {} state is {}, and last failed version is {}, skip creating rollup replica", (Object)baseReplica.getId(), (Object)baseTabletId, (Object)baseReplica.getState(), (Object)baseReplica.getLastFailedVersion());
                        continue;
                    }
                    Preconditions.checkState((baseReplica.getState() == Replica.ReplicaState.NORMAL ? 1 : 0) != 0, (Object)((Object)baseReplica.getState()));
                    Replica mvReplica = new Replica(mvReplicaId, backendId, Replica.ReplicaState.ALTER, 1L, mvSchemaHash);
                    newTablet.addReplica(mvReplica);
                    ++healthyReplicaNum;
                }
                if (healthyReplicaNum >= replicationNum / 2 + 1) continue;
                for (Tablet tablet : addedTablets) {
                    Catalog.getCurrentInvertedIndex().deleteTablet(tablet.getId());
                }
                throw new DdlException("tablet " + baseTabletId + " has few healthy replica: " + healthyReplicaNum);
            }
            mvJob.addMVIndex(partitionId, mvIndex);
            LOG.debug("create materialized view index {} based on index {} in partition {}", (Object)mvIndexId, (Object)baseIndexId, (Object)partitionId);
        }
        LOG.info("finished to create materialized view job: {}", (Object)mvJob.getJobId());
        return mvJob;
    }

    private List<Column> checkAndPrepareMaterializedView(CreateMaterializedViewStmt addMVClause, OlapTable olapTable) throws DdlException {
        if (olapTable.hasMaterializedIndex(addMVClause.getMVName())) {
            throw new DdlException("Materialized view[" + addMVClause.getMVName() + "] already exists");
        }
        List<MVColumnItem> mvColumnItemList = addMVClause.getMVColumnItemList();
        ArrayList newMVColumns = Lists.newArrayList();
        int numOfKeys = 0;
        if (olapTable.getKeysType().isAggregationFamily()) {
            if (addMVClause.getMVKeysType() != KeysType.AGG_KEYS) {
                throw new DdlException("The materialized view of aggregation or unique table must has grouping columns");
            }
            for (MVColumnItem mvColumnItem : mvColumnItemList) {
                String mvColumnName = mvColumnItem.getName();
                Column baseColumn = olapTable.getColumn(mvColumnName);
                if (mvColumnItem.isKey()) {
                    ++numOfKeys;
                }
                if (baseColumn == null) {
                    throw new DdlException("The mv column of agg or uniq table cannot be transformed from original column[" + mvColumnItem.getBaseColumnName() + "]");
                }
                Preconditions.checkNotNull((Object)baseColumn, (Object)("Column[" + mvColumnName + "] does not exist"));
                AggregateType baseAggregationType = baseColumn.getAggregationType();
                AggregateType mvAggregationType = mvColumnItem.getAggregationType();
                if (baseColumn.isKey() && !mvColumnItem.isKey()) {
                    throw new DdlException("The column[" + mvColumnName + "] must be the key of materialized view");
                }
                if (baseAggregationType != mvAggregationType) {
                    throw new DdlException("The aggregation type of column[" + mvColumnName + "] must be same as the aggregate type of base column in aggregate table");
                }
                if (baseAggregationType != null && baseAggregationType.isReplaceFamily() && olapTable.getKeysNum() != numOfKeys) {
                    throw new DdlException("The materialized view should contain all keys of base table if there is a REPLACE value");
                }
                newMVColumns.add(mvColumnItem.toMVColumn(olapTable));
            }
        } else {
            Set<String> partitionOrDistributedColumnName = olapTable.getPartitionColumnNames();
            partitionOrDistributedColumnName.addAll(olapTable.getDistributionColumnNames());
            for (MVColumnItem mvColumnItem : mvColumnItemList) {
                if (partitionOrDistributedColumnName.contains(mvColumnItem.getBaseColumnName().toLowerCase()) && mvColumnItem.getAggregationType() != null) {
                    throw new DdlException("The partition and distributed columns " + mvColumnItem.getBaseColumnName() + " must be key column in mv");
                }
                newMVColumns.add(mvColumnItem.toMVColumn(olapTable));
            }
        }
        if (KeysType.UNIQUE_KEYS == olapTable.getKeysType() && olapTable.hasDeleteSign()) {
            newMVColumns.add(new Column(olapTable.getDeleteSignColumn()));
        }
        if (KeysType.UNIQUE_KEYS == olapTable.getKeysType() && olapTable.hasSequenceCol().booleanValue()) {
            newMVColumns.add(new Column(olapTable.getSequenceCol()));
        }
        return newMVColumns;
    }

    /*
     * WARNING - void declaration
     */
    public List<Column> checkAndPrepareMaterializedView(AddRollupClause addRollupClause, OlapTable olapTable, long baseIndexId, boolean changeStorageFormat) throws DdlException {
        ArrayList<Column> rollupSchema;
        block35: {
            HashMap baseColumnNameToColumn;
            KeysType keysType;
            boolean hasKey;
            boolean meetValue;
            List<String> rollupColumnNames;
            block34: {
                String rollupIndexName = addRollupClause.getRollupName();
                rollupColumnNames = addRollupClause.getColumnNames();
                if (changeStorageFormat) {
                    String newStorageFormatIndexName;
                    rollupIndexName = newStorageFormatIndexName = NEW_STORAGE_FORMAT_INDEX_NAME_PREFIX + olapTable.getName();
                    List<Column> columns = olapTable.getSchemaByIndexId(baseIndexId, true);
                    rollupColumnNames.clear();
                    for (Column column : columns) {
                        rollupColumnNames.add(column.getName());
                    }
                }
                if (olapTable.hasMaterializedIndex(rollupIndexName)) {
                    throw new DdlException("Rollup index[" + rollupIndexName + "] already exists");
                }
                rollupSchema = new ArrayList<Column>();
                meetValue = false;
                hasKey = false;
                boolean meetReplaceValue = false;
                keysType = olapTable.getKeysType();
                baseColumnNameToColumn = Maps.newHashMap();
                for (Column column : olapTable.getSchemaByIndexId(baseIndexId, true)) {
                    baseColumnNameToColumn.put(column.getName(), column);
                }
                if (!keysType.isAggregationFamily()) break block34;
                int keysNumOfRollup = 0;
                for (String columnName : rollupColumnNames) {
                    Column oneColumn = (Column)baseColumnNameToColumn.get(columnName);
                    if (oneColumn == null) {
                        throw new DdlException("Column[" + columnName + "] does not exist");
                    }
                    if (oneColumn.isKey() && meetValue) {
                        throw new DdlException("Invalid column order. value should be after key");
                    }
                    if (oneColumn.isKey()) {
                        ++keysNumOfRollup;
                        hasKey = true;
                    } else {
                        meetValue = true;
                        if (oneColumn.getAggregationType().isReplaceFamily()) {
                            meetReplaceValue = true;
                        }
                    }
                    rollupSchema.add(oneColumn);
                }
                if (!hasKey) {
                    throw new DdlException("No key column is found");
                }
                if (KeysType.UNIQUE_KEYS != keysType && !meetReplaceValue) break block35;
                if (keysNumOfRollup != olapTable.getKeysNum()) {
                    if (KeysType.UNIQUE_KEYS == keysType) {
                        throw new DdlException("Rollup should contains all unique keys in basetable");
                    }
                    throw new DdlException("Rollup should contains all keys if there is a REPLACE value");
                }
                if (KeysType.UNIQUE_KEYS == olapTable.getKeysType() && olapTable.hasDeleteSign()) {
                    rollupSchema.add(new Column(olapTable.getDeleteSignColumn()));
                }
                if (KeysType.UNIQUE_KEYS == olapTable.getKeysType() && olapTable.hasSequenceCol().booleanValue()) {
                    rollupSchema.add(new Column(olapTable.getSequenceCol()));
                }
                break block35;
            }
            if (KeysType.DUP_KEYS == keysType) {
                if (addRollupClause.getDupKeys() == null || addRollupClause.getDupKeys().isEmpty()) {
                    int theBeginIndexOfValue;
                    for (int i = 0; i < rollupColumnNames.size(); ++i) {
                        String string = rollupColumnNames.get(i);
                        Column baseColumn = (Column)baseColumnNameToColumn.get(string);
                        if (baseColumn == null) {
                            throw new DdlException("Column[" + string + "] does not exist in base index");
                        }
                        Column rollupColumn = new Column(baseColumn);
                        rollupSchema.add(rollupColumn);
                    }
                    if (changeStorageFormat) {
                        return rollupSchema;
                    }
                    boolean bl = false;
                    for (theBeginIndexOfValue = 0; theBeginIndexOfValue < rollupSchema.size(); ++theBeginIndexOfValue) {
                        Column column = (Column)rollupSchema.get(theBeginIndexOfValue);
                        if (theBeginIndexOfValue + 1 > FeConstants.shortkey_max_column_count || (var15_24 += column.getType().getIndexSize()) > FeConstants.shortkey_maxsize_bytes) {
                            if (theBeginIndexOfValue != 0 || !column.getType().getPrimitiveType().isCharFamily()) break;
                            column.setIsKey(true);
                            ++theBeginIndexOfValue;
                            break;
                        }
                        if (column.getType().isFloatingPointType()) break;
                        if (column.getType().getPrimitiveType() == PrimitiveType.VARCHAR) {
                            column.setIsKey(true);
                            ++theBeginIndexOfValue;
                            break;
                        }
                        column.setIsKey(true);
                    }
                    if (theBeginIndexOfValue == 0) {
                        throw new DdlException("The first column could not be float or double");
                    }
                    while (theBeginIndexOfValue < rollupSchema.size()) {
                        Column rollupColumn = (Column)rollupSchema.get(theBeginIndexOfValue);
                        rollupColumn.setIsKey(false);
                        rollupColumn.setAggregationType(AggregateType.NONE, true);
                        ++theBeginIndexOfValue;
                    }
                } else {
                    void var15_26;
                    List<String> dupKeys = addRollupClause.getDupKeys();
                    if (dupKeys.size() > rollupColumnNames.size()) {
                        throw new DdlException("Num of duplicate keys should less than or equal to num of rollup columns.");
                    }
                    boolean bl = false;
                    while (var15_26 < rollupColumnNames.size()) {
                        Column baseColumn;
                        String rollupColName = rollupColumnNames.get((int)var15_26);
                        boolean isKey = false;
                        if (var15_26 < dupKeys.size()) {
                            String dupKeyName = dupKeys.get((int)var15_26);
                            if (!rollupColName.equalsIgnoreCase(dupKeyName)) {
                                throw new DdlException("Duplicate keys should be the prefix of rollup columns");
                            }
                            isKey = true;
                        }
                        if ((baseColumn = (Column)baseColumnNameToColumn.get(rollupColName)) == null) {
                            throw new DdlException("Column[" + rollupColName + "] does not exist");
                        }
                        if (isKey && meetValue) {
                            throw new DdlException("Invalid column order. key should before all values: " + rollupColName);
                        }
                        Column oneColumn = new Column(baseColumn);
                        if (isKey) {
                            hasKey = true;
                            oneColumn.setIsKey(true);
                            oneColumn.setAggregationType(null, false);
                        } else {
                            meetValue = true;
                            oneColumn.setIsKey(false);
                            oneColumn.setAggregationType(AggregateType.NONE, true);
                        }
                        rollupSchema.add(oneColumn);
                        ++var15_26;
                    }
                }
            }
        }
        return rollupSchema;
    }

    private long checkAndGetBaseIndex(String baseIndexName, OlapTable olapTable) throws DdlException {
        Preconditions.checkState((olapTable.getState() == OlapTable.OlapTableState.NORMAL ? 1 : 0) != 0, (Object)olapTable.getState().name());
        Long baseIndexId = olapTable.getIndexIdByName(baseIndexName);
        if (baseIndexId == null) {
            throw new DdlException("Base index[" + baseIndexName + "] does not exist");
        }
        for (Partition partition : olapTable.getPartitions()) {
            MaterializedIndex baseIndex = partition.getIndex(baseIndexId);
            Preconditions.checkState((baseIndex.getState() == MaterializedIndex.IndexState.NORMAL ? 1 : 0) != 0, (Object)baseIndex.getState().name());
        }
        return baseIndexId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processBatchDropRollup(List<AlterClause> dropRollupClauses, Database db, OlapTable olapTable) throws DdlException, MetaNotFoundException {
        olapTable.writeLockOrDdlException();
        try {
            if (olapTable.existTempPartitions()) {
                throw new DdlException("Can not alter table when there are temp partitions in table");
            }
            for (AlterClause alterClause : dropRollupClauses) {
                DropRollupClause dropRollupClause = (DropRollupClause)alterClause;
                this.checkDropMaterializedView(dropRollupClause.getRollupName(), olapTable);
            }
            HashSet<Long> indexIdSet = new HashSet<Long>();
            HashSet<String> rollupNameSet = new HashSet<String>();
            for (AlterClause alterClause : dropRollupClauses) {
                DropRollupClause dropRollupClause = (DropRollupClause)alterClause;
                String rollupIndexName = dropRollupClause.getRollupName();
                long rollupIndexId = this.dropMaterializedView(rollupIndexName, olapTable);
                indexIdSet.add(rollupIndexId);
                rollupNameSet.add(rollupIndexName);
            }
            EditLog editLog = Catalog.getCurrentCatalog().getEditLog();
            long dbId = db.getId();
            long tableId = olapTable.getId();
            editLog.logBatchDropRollup(new BatchDropInfo(dbId, tableId, indexIdSet));
            LOG.info("finished drop rollup index[{}] in table[{}]", (Object)String.join((CharSequence)"", rollupNameSet), (Object)olapTable.getName());
        }
        finally {
            olapTable.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDropMaterializedView(DropMaterializedViewStmt dropMaterializedViewStmt, Database db, OlapTable olapTable) throws DdlException, MetaNotFoundException {
        block7: {
            olapTable.writeLockOrDdlException();
            try {
                if (olapTable.getState() != OlapTable.OlapTableState.NORMAL) {
                    throw new DdlException("Table[" + olapTable.getName() + "]'s state is not NORMAL. Do not allow doing DROP ops");
                }
                String mvName = dropMaterializedViewStmt.getMvName();
                this.checkDropMaterializedView(mvName, olapTable);
                long mvIndexId = this.dropMaterializedView(mvName, olapTable);
                EditLog editLog = Catalog.getCurrentCatalog().getEditLog();
                editLog.logDropRollup(new DropInfo(db.getId(), olapTable.getId(), mvIndexId, false));
                LOG.info("finished drop materialized view [{}] in table [{}]", (Object)mvName, (Object)olapTable.getName());
            }
            catch (MetaNotFoundException e) {
                if (dropMaterializedViewStmt.isIfExists()) {
                    LOG.info(e.getMessage());
                    break block7;
                }
                throw e;
            }
            finally {
                olapTable.writeUnlock();
            }
        }
    }

    private void checkDropMaterializedView(String mvName, OlapTable olapTable) throws DdlException, MetaNotFoundException {
        Preconditions.checkState((olapTable.getState() == OlapTable.OlapTableState.NORMAL ? 1 : 0) != 0, (Object)olapTable.getState().name());
        if (mvName.equals(olapTable.getName())) {
            throw new DdlException("Cannot drop base index by using DROP ROLLUP or DROP MATERIALIZED VIEW.");
        }
        if (!olapTable.hasMaterializedIndex(mvName)) {
            throw new MetaNotFoundException("Materialized view [" + mvName + "] does not exist in table [" + olapTable.getName() + "]");
        }
        long mvIndexId = olapTable.getIndexIdByName(mvName);
        int mvSchemaHash = olapTable.getSchemaHashByIndexId(mvIndexId);
        Preconditions.checkState((mvSchemaHash != -1 ? 1 : 0) != 0);
        for (Partition partition : olapTable.getPartitions()) {
            MaterializedIndex materializedIndex = partition.getIndex(mvIndexId);
            Preconditions.checkNotNull((Object)materializedIndex);
        }
    }

    private long dropMaterializedView(String mvName, OlapTable olapTable) {
        long mvIndexId = olapTable.getIndexIdByName(mvName);
        TabletInvertedIndex invertedIndex = Catalog.getCurrentInvertedIndex();
        for (Partition partition : olapTable.getPartitions()) {
            MaterializedIndex rollupIndex = partition.getIndex(mvIndexId);
            partition.deleteRollupIndex(mvIndexId);
            for (Tablet tablet : rollupIndex.getTablets()) {
                long tabletId = tablet.getId();
                invertedIndex.deleteTablet(tabletId);
            }
        }
        olapTable.deleteIndexInfo(mvName);
        return mvIndexId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayDropRollup(DropInfo dropInfo, Catalog catalog) throws MetaNotFoundException {
        long dbId = dropInfo.getDbId();
        long tableId = dropInfo.getTableId();
        long rollupIndexId = dropInfo.getIndexId();
        TabletInvertedIndex invertedIndex = Catalog.getCurrentInvertedIndex();
        Database db = catalog.getDbOrMetaException(dbId);
        OlapTable olapTable = (OlapTable)db.getTableOrMetaException(tableId, Table.TableType.OLAP);
        olapTable.writeLock();
        try {
            for (Partition partition : olapTable.getPartitions()) {
                MaterializedIndex rollupIndex = partition.deleteRollupIndex(rollupIndexId);
                if (Catalog.isCheckpointThread()) continue;
                for (Tablet tablet : rollupIndex.getTablets()) {
                    invertedIndex.deleteTablet(tablet.getId());
                }
            }
            String rollupIndexName = olapTable.getIndexNameById(rollupIndexId);
            olapTable.deleteIndexInfo(rollupIndexName);
        }
        finally {
            olapTable.writeUnlock();
        }
        LOG.info("replay drop rollup {}", (Object)dropInfo.getIndexId());
    }

    @Override
    protected void runAfterCatalogReady() {
        super.runAfterCatalogReady();
        this.runAlterJobV2();
    }

    private Map<Long, AlterJobV2> getAlterJobsCopy() {
        return new HashMap<Long, AlterJobV2>(this.alterJobsV2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeJobFromRunningQueue(AlterJobV2 alterJob) {
        Map<Long, Set<Long>> map = this.tableRunningJobMap;
        synchronized (map) {
            Set<Long> runningJobIdSet = this.tableRunningJobMap.get(alterJob.getTableId());
            if (runningJobIdSet != null) {
                runningJobIdSet.remove(alterJob.getJobId());
                if (runningJobIdSet.size() == 0) {
                    this.tableRunningJobMap.remove(alterJob.getTableId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeTableStatus(long dbId, long tableId, OlapTable.OlapTableState olapTableState) {
        try {
            Database db = Catalog.getCurrentCatalog().getDbOrMetaException(dbId);
            OlapTable olapTable = (OlapTable)db.getTableOrMetaException(tableId, Table.TableType.OLAP);
            olapTable.writeLockOrMetaException();
            try {
                if (olapTable.getState() == olapTableState) {
                    return;
                }
                olapTable.setState(olapTableState);
            }
            finally {
                olapTable.writeUnlock();
            }
        }
        catch (MetaNotFoundException e) {
            LOG.warn("[INCONSISTENT META] changing table status failed after rollup job done", (Throwable)e);
        }
    }

    @Override
    public void replayAlterJobV2(AlterJobV2 alterJob) {
        super.replayAlterJobV2(alterJob);
        if (!alterJob.isDone()) {
            this.addAlterJobV2ToTableNotFinalStateJobMap(alterJob);
            this.changeTableStatus(alterJob.getDbId(), alterJob.getTableId(), OlapTable.OlapTableState.ROLLUP);
        } else if (this.removeAlterJobV2FromTableNotFinalStateJobMap(alterJob)) {
            this.changeTableStatus(alterJob.getDbId(), alterJob.getTableId(), OlapTable.OlapTableState.NORMAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAlterJobWithConcurrencyLimit(RollupJobV2 rollupJobV2) {
        if (rollupJobV2.isDone()) {
            return;
        }
        if (rollupJobV2.isTimeout()) {
            rollupJobV2.run();
            return;
        }
        long tblId = rollupJobV2.getTableId();
        long jobId = rollupJobV2.getJobId();
        boolean shouldJobRun = false;
        Map<Long, Set<Long>> map = this.tableRunningJobMap;
        synchronized (map) {
            Set<Long> tableRunningJobSet = this.tableRunningJobMap.get(tblId);
            if (tableRunningJobSet == null) {
                tableRunningJobSet = new HashSet<Long>();
                this.tableRunningJobMap.put(tblId, tableRunningJobSet);
            }
            if (tableRunningJobSet.contains(jobId)) {
                shouldJobRun = true;
            } else if (tableRunningJobSet.size() < Config.max_running_rollup_job_num_per_table) {
                tableRunningJobSet.add(jobId);
                shouldJobRun = true;
            } else {
                LOG.debug("number of running alter job {} in table {} exceed limit {}. job {} is suspended", (Object)tableRunningJobSet.size(), (Object)rollupJobV2.getTableId(), (Object)Config.max_running_rollup_job_num_per_table, (Object)rollupJobV2.getJobId());
                shouldJobRun = false;
            }
        }
        if (shouldJobRun) {
            rollupJobV2.run();
        }
    }

    private void runAlterJobV2() {
        for (Map.Entry<Long, AlterJobV2> entry : this.getAlterJobsCopy().entrySet()) {
            RollupJobV2 alterJob = (RollupJobV2)entry.getValue();
            this.runAlterJobWithConcurrencyLimit(alterJob);
            if (!alterJob.isDone()) continue;
            this.onJobDone(alterJob);
        }
    }

    private void onJobDone(AlterJobV2 alterJob) {
        this.removeJobFromRunningQueue(alterJob);
        if (this.removeAlterJobV2FromTableNotFinalStateJobMap(alterJob)) {
            this.changeTableStatus(alterJob.getDbId(), alterJob.getTableId(), OlapTable.OlapTableState.NORMAL);
        }
    }

    @Override
    public List<List<Comparable>> getAlterJobInfosByDb(Database db) {
        LinkedList<List<Comparable>> rollupJobInfos = new LinkedList<List<Comparable>>();
        this.getAlterJobV2Infos(db, rollupJobInfos);
        ListComparator comparator = new ListComparator(0, 1, 2, 3, 4, 5);
        Collections.sort(rollupJobInfos, comparator);
        return rollupJobInfos;
    }

    private void getAlterJobV2Infos(Database db, List<List<Comparable>> rollupJobInfos) {
        ConnectContext ctx = ConnectContext.get();
        for (AlterJobV2 alterJob : this.alterJobsV2.values()) {
            if (alterJob.getDbId() != db.getId() || ctx != null && !Catalog.getCurrentCatalog().getAuth().checkTblPriv(ctx, db.getFullName(), alterJob.getTableName(), PrivPredicate.ALTER)) continue;
            alterJob.getInfo(rollupJobInfos);
        }
    }

    @Override
    public void process(List<AlterClause> alterClauses, String clusterName, Database db, OlapTable olapTable) throws DdlException, AnalysisException, MetaNotFoundException {
        Optional alterClauseOptional = alterClauses.stream().findAny();
        if (alterClauseOptional.isPresent()) {
            if (alterClauseOptional.get() instanceof AddRollupClause) {
                this.processBatchAddRollup(alterClauses, db, olapTable);
            } else if (alterClauseOptional.get() instanceof DropRollupClause) {
                this.processBatchDropRollup(alterClauses, db, olapTable);
            } else {
                Preconditions.checkState((boolean)false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(CancelStmt stmt) throws DdlException {
        OlapTable olapTable;
        CancelAlterTableStmt cancelAlterTableStmt = (CancelAlterTableStmt)stmt;
        String dbName = cancelAlterTableStmt.getDbName();
        String tableName = cancelAlterTableStmt.getTableName();
        Preconditions.checkState((!Strings.isNullOrEmpty((String)dbName) ? 1 : 0) != 0);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)tableName) ? 1 : 0) != 0);
        Database db = Catalog.getCurrentCatalog().getDbOrDdlException(dbName);
        List<Object> rollupJobV2List = new ArrayList();
        try {
            olapTable = (OlapTable)db.getTableOrMetaException(tableName, Table.TableType.OLAP);
        }
        catch (MetaNotFoundException e) {
            throw new DdlException(e.getMessage());
        }
        olapTable.writeLock();
        try {
            if (olapTable.getState() != OlapTable.OlapTableState.ROLLUP && olapTable.getState() != OlapTable.OlapTableState.WAITING_STABLE) {
                throw new DdlException("Table[" + tableName + "] is not under ROLLUP. Use 'ALTER TABLE DROP ROLLUP' if you want to.");
            }
            if (cancelAlterTableStmt.getAlterJobIdList() != null) {
                for (Long l : cancelAlterTableStmt.getAlterJobIdList()) {
                    AlterJobV2 alterJobV2 = this.getUnfinishedAlterJobV2ByJobId(l);
                    if (alterJobV2 == null) continue;
                    rollupJobV2List.add(this.getUnfinishedAlterJobV2ByJobId(l));
                }
            } else {
                rollupJobV2List = this.getUnfinishedAlterJobV2ByTableId(olapTable.getId());
            }
            if (rollupJobV2List.size() == 0) {
                throw new DdlException("Table[" + tableName + "] is not under ROLLUP. Maybe it has old alter job");
            }
        }
        finally {
            olapTable.writeUnlock();
        }
        if (rollupJobV2List.size() != 0) {
            for (AlterJobV2 alterJobV2 : rollupJobV2List) {
                alterJobV2.cancel("user cancelled");
                if (!alterJobV2.isDone()) continue;
                this.onJobDone(alterJobV2);
            }
            return;
        }
    }

    public Map<Long, Set<Long>> getTableRunningJobMap() {
        return this.tableRunningJobMap;
    }
}

