/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.alter;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.apache.doris.alter.AlterOpType;
import org.apache.doris.analysis.AlterClause;
import org.apache.doris.common.DdlException;

public class AlterOperations {
    private Set<AlterOpType> currentOps = Sets.newHashSet();

    public Set<AlterOpType> getCurrentOps() {
        return this.currentOps;
    }

    public void checkConflict(List<AlterClause> alterClauses) throws DdlException {
        for (AlterClause alterClause : alterClauses) {
            this.checkOp(alterClause.getOpType());
        }
    }

    public boolean needCheckCapacity() {
        for (AlterOpType currentOp : this.currentOps) {
            if (!currentOp.needCheckCapacity()) continue;
            return true;
        }
        return false;
    }

    public boolean hasPartitionOp() {
        return this.currentOps.contains((Object)AlterOpType.ADD_PARTITION) || this.currentOps.contains((Object)AlterOpType.DROP_PARTITION) || this.currentOps.contains((Object)AlterOpType.REPLACE_PARTITION) || this.currentOps.contains((Object)AlterOpType.MODIFY_PARTITION);
    }

    public boolean hasSchemaChangeOp() {
        return this.currentOps.contains((Object)AlterOpType.SCHEMA_CHANGE) || this.currentOps.contains((Object)AlterOpType.MODIFY_TABLE_PROPERTY);
    }

    public boolean hasRollupOp() {
        return this.currentOps.contains((Object)AlterOpType.ADD_ROLLUP) || this.currentOps.contains((Object)AlterOpType.DROP_ROLLUP);
    }

    public boolean hasRenameOp() {
        return this.currentOps.contains((Object)AlterOpType.RENAME);
    }

    public boolean hasReplaceTableOp() {
        return this.currentOps.contains((Object)AlterOpType.REPLACE_TABLE);
    }

    public boolean hasModifyBucketNumOp() {
        return this.currentOps.contains((Object)AlterOpType.MODIFY_DISTRIBUTION);
    }

    public boolean contains(AlterOpType op) {
        return this.currentOps.contains((Object)op);
    }

    private void checkOp(AlterOpType opType) throws DdlException {
        if (this.currentOps.isEmpty()) {
            this.currentOps.add(opType);
            return;
        }
        for (AlterOpType currentOp : this.currentOps) {
            if (AlterOpType.COMPATIBILITY_MATRIX[currentOp.ordinal()][opType.ordinal()].booleanValue()) continue;
            throw new DdlException("Alter operation " + (Object)((Object)opType) + " conflicts with operation " + (Object)((Object)currentOp));
        }
        this.currentOps.add(opType);
    }

    public boolean hasEnableFeatureOP() {
        return this.currentOps.contains((Object)AlterOpType.ENABLE_FEATURE);
    }

    public String toString() {
        return Joiner.on((String)", ").join(this.currentOps);
    }
}

