/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.alter;

public enum AlterOpType {
    ADD_ROLLUP,
    DROP_ROLLUP,
    SCHEMA_CHANGE,
    ADD_PARTITION,
    DROP_PARTITION,
    REPLACE_PARTITION,
    MODIFY_PARTITION,
    RENAME,
    MODIFY_TABLE_PROPERTY,
    MODIFY_TABLE_PROPERTY_SYNC,
    ALTER_OTHER,
    ENABLE_FEATURE,
    REPLACE_TABLE,
    MODIFY_DISTRIBUTION,
    MODIFY_TABLE_COMMENT,
    MODIFY_COLUMN_COMMENT,
    MODIFY_ENGINE,
    INVALID_OP;

    public static Boolean[][] COMPATIBILITY_MATRIX;

    public boolean needCheckCapacity() {
        return this == ADD_ROLLUP || this == SCHEMA_CHANGE || this == ADD_PARTITION || this == ENABLE_FEATURE;
    }

    static {
        COMPATIBILITY_MATRIX = new Boolean[INVALID_OP.ordinal() + 1][INVALID_OP.ordinal() + 1];
        for (int i = 0; i < INVALID_OP.ordinal(); ++i) {
            for (int j = 0; j < INVALID_OP.ordinal(); ++j) {
                AlterOpType.COMPATIBILITY_MATRIX[i][j] = false;
            }
        }
        AlterOpType.COMPATIBILITY_MATRIX[AlterOpType.ADD_ROLLUP.ordinal()][AlterOpType.ADD_ROLLUP.ordinal()] = true;
        AlterOpType.COMPATIBILITY_MATRIX[AlterOpType.DROP_ROLLUP.ordinal()][AlterOpType.DROP_ROLLUP.ordinal()] = true;
        AlterOpType.COMPATIBILITY_MATRIX[AlterOpType.SCHEMA_CHANGE.ordinal()][AlterOpType.SCHEMA_CHANGE.ordinal()] = true;
        AlterOpType.COMPATIBILITY_MATRIX[AlterOpType.MODIFY_COLUMN_COMMENT.ordinal()][AlterOpType.MODIFY_COLUMN_COMMENT.ordinal()] = true;
    }
}

