/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.alter;

import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.IOException;
import java.util.List;
import org.apache.doris.alter.AlterCancelException;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.Config;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AlterJobV2
implements Writable {
    private static final Logger LOG = LogManager.getLogger(AlterJobV2.class);
    @SerializedName(value="type")
    protected JobType type;
    @SerializedName(value="jobId")
    protected long jobId;
    @SerializedName(value="jobState")
    protected JobState jobState;
    @SerializedName(value="dbId")
    protected long dbId;
    @SerializedName(value="tableId")
    protected long tableId;
    @SerializedName(value="tableName")
    protected String tableName;
    @SerializedName(value="errMsg")
    protected String errMsg = "";
    @SerializedName(value="createTimeMs")
    protected long createTimeMs = -1L;
    @SerializedName(value="finishedTimeMs")
    protected long finishedTimeMs = -1L;
    @SerializedName(value="timeoutMs")
    protected long timeoutMs = -1L;

    public AlterJobV2(long jobId, JobType jobType, long dbId, long tableId, String tableName, long timeoutMs) {
        this.jobId = jobId;
        this.type = jobType;
        this.dbId = dbId;
        this.tableId = tableId;
        this.tableName = tableName;
        this.timeoutMs = timeoutMs;
        this.createTimeMs = System.currentTimeMillis();
        this.jobState = JobState.PENDING;
    }

    protected AlterJobV2(JobType type) {
        this.type = type;
    }

    public long getJobId() {
        return this.jobId;
    }

    public JobState getJobState() {
        return this.jobState;
    }

    public JobType getType() {
        return this.type;
    }

    public long getDbId() {
        return this.dbId;
    }

    public long getTableId() {
        return this.tableId;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isTimeout() {
        return System.currentTimeMillis() - this.createTimeMs > this.timeoutMs;
    }

    public boolean isExpire() {
        return this.isDone() && (System.currentTimeMillis() - this.finishedTimeMs) / 1000L > (long)Config.history_job_keep_max_second;
    }

    public boolean isDone() {
        return this.jobState.isFinalState();
    }

    public long getFinishedTimeMs() {
        return this.finishedTimeMs;
    }

    public synchronized void run() {
        if (this.isTimeout()) {
            this.cancelImpl("Timeout");
            return;
        }
        try {
            switch (this.jobState) {
                case PENDING: {
                    this.runPendingJob();
                    break;
                }
                case WAITING_TXN: {
                    this.runWaitingTxnJob();
                    break;
                }
                case RUNNING: {
                    this.runRunningJob();
                    break;
                }
            }
        }
        catch (AlterCancelException e) {
            this.cancelImpl(e.getMessage());
        }
    }

    public final synchronized boolean cancel(String errMsg) {
        return this.cancelImpl(errMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkTableStable(Database db) throws AlterCancelException {
        OlapTable tbl;
        try {
            tbl = (OlapTable)db.getTableOrMetaException(this.tableId, Table.TableType.OLAP);
        }
        catch (MetaNotFoundException e) {
            throw new AlterCancelException(e.getMessage());
        }
        tbl.writeLockOrAlterCancelException();
        try {
            boolean isStable = tbl.isStable(Catalog.getCurrentSystemInfo(), Catalog.getCurrentCatalog().getTabletScheduler(), db.getClusterName());
            if (!isStable) {
                this.errMsg = "table is unstable";
                LOG.warn("wait table {} to be stable before doing {} job", (Object)this.tableId, (Object)this.type);
                tbl.setState(OlapTable.OlapTableState.WAITING_STABLE);
                boolean bl = false;
                return bl;
            }
            LOG.info("table {} is stable, start {} job {}", (Object)this.tableId, (Object)this.type, (Object)this.jobId);
            tbl.setState(this.type == JobType.ROLLUP ? OlapTable.OlapTableState.ROLLUP : OlapTable.OlapTableState.SCHEMA_CHANGE);
            this.errMsg = "";
            boolean bl = true;
            return bl;
        }
        finally {
            tbl.writeUnlock();
        }
    }

    protected abstract void runPendingJob() throws AlterCancelException;

    protected abstract void runWaitingTxnJob() throws AlterCancelException;

    protected abstract void runRunningJob() throws AlterCancelException;

    protected abstract boolean cancelImpl(String var1);

    protected abstract void getInfo(List<List<Comparable>> var1);

    public abstract void replay(AlterJobV2 var1);

    public static AlterJobV2 read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (AlterJobV2)GsonUtils.GSON.fromJson(json, AlterJobV2.class);
    }

    public static enum JobType {
        ROLLUP,
        SCHEMA_CHANGE,
        DECOMMISSION_BACKEND;

    }

    public static enum JobState {
        PENDING,
        WAITING_TXN,
        RUNNING,
        FINISHED,
        CANCELLED;


        public boolean isFinalState() {
            return this == FINISHED || this == CANCELLED;
        }
    }
}

