/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.alter;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.doris.alter.AlterJobV2;
import org.apache.doris.analysis.AlterClause;
import org.apache.doris.analysis.CancelStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.MasterDaemon;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.persist.RemoveAlterJobV2OperationLog;
import org.apache.doris.persist.ReplicaPersistInfo;
import org.apache.doris.task.AlterReplicaTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AlterHandler
extends MasterDaemon {
    private static final Logger LOG = LogManager.getLogger(AlterHandler.class);
    protected ConcurrentMap<Long, AlterJobV2> alterJobsV2 = Maps.newConcurrentMap();
    protected ReentrantLock lock = new ReentrantLock();

    protected void lock() {
        this.lock.lock();
    }

    protected void unlock() {
        this.lock.unlock();
    }

    public AlterHandler(String name) {
        this(name, FeConstants.default_scheduler_interval_millisecond);
    }

    public AlterHandler(String name, int scheduler_interval_millisecond) {
        super(name, scheduler_interval_millisecond);
    }

    protected void addAlterJobV2(AlterJobV2 alterJob) {
        this.alterJobsV2.put(alterJob.getJobId(), alterJob);
        LOG.info("add {} job {}", (Object)alterJob.getType(), (Object)alterJob.getJobId());
    }

    public List<AlterJobV2> getUnfinishedAlterJobV2ByTableId(long tblId) {
        ArrayList<AlterJobV2> unfinishedAlterJobList = new ArrayList<AlterJobV2>();
        for (AlterJobV2 alterJob : this.alterJobsV2.values()) {
            if (alterJob.getTableId() != tblId || alterJob.getJobState() == AlterJobV2.JobState.FINISHED || alterJob.getJobState() == AlterJobV2.JobState.CANCELLED) continue;
            unfinishedAlterJobList.add(alterJob);
        }
        return unfinishedAlterJobList;
    }

    public AlterJobV2 getUnfinishedAlterJobV2ByJobId(long jobId) {
        for (AlterJobV2 alterJob : this.alterJobsV2.values()) {
            if (alterJob.getJobId() != jobId || alterJob.isDone()) continue;
            return alterJob;
        }
        return null;
    }

    public Map<Long, AlterJobV2> getAlterJobsV2() {
        return this.alterJobsV2;
    }

    private void clearExpireFinishedOrCancelledAlterJobsV2() {
        Iterator iterator = this.alterJobsV2.entrySet().iterator();
        while (iterator.hasNext()) {
            AlterJobV2 alterJobV2 = (AlterJobV2)iterator.next().getValue();
            if (!alterJobV2.isExpire()) continue;
            iterator.remove();
            RemoveAlterJobV2OperationLog log = new RemoveAlterJobV2OperationLog(alterJobV2.getJobId(), alterJobV2.getType());
            Catalog.getCurrentCatalog().getEditLog().logRemoveExpiredAlterJobV2(log);
            LOG.info("remove expired {} job {}. finish at {}", (Object)alterJobV2.getType(), (Object)alterJobV2.getJobId(), (Object)TimeUtils.longToTimeString(alterJobV2.getFinishedTimeMs()));
        }
    }

    public void replayRemoveAlterJobV2(RemoveAlterJobV2OperationLog log) {
        if (this.alterJobsV2.remove(log.getJobId()) != null) {
            LOG.info("replay removing expired {} job {}.", (Object)log.getType(), (Object)log.getJobId());
        } else {
            LOG.warn("failed to find {} job {} when replay removing expired job.", (Object)log.getType(), (Object)log.getJobId());
        }
    }

    public Long getAlterJobV2Num(AlterJobV2.JobState state, long dbId) {
        return this.alterJobsV2.values().stream().filter(e -> e.getJobState() == state && e.getDbId() == dbId).count();
    }

    public Long getAlterJobV2Num(AlterJobV2.JobState state) {
        return this.alterJobsV2.values().stream().filter(e -> e.getJobState() == state).count();
    }

    @Override
    protected void runAfterCatalogReady() {
        this.clearExpireFinishedOrCancelledAlterJobsV2();
    }

    @Override
    public void start() {
        super.start();
    }

    public abstract List<List<Comparable>> getAlterJobInfosByDb(Database var1);

    public abstract void process(List<AlterClause> var1, String var2, Database var3, OlapTable var4) throws UserException;

    public void processExternalTable(List<AlterClause> alterClauses, Database db, Table externalTable) throws UserException {
    }

    public abstract void cancel(CancelStmt var1) throws DdlException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFinishAlterTask(AlterReplicaTask task) throws MetaNotFoundException {
        Database db = Catalog.getCurrentCatalog().getDbOrMetaException(task.getDbId());
        OlapTable tbl = (OlapTable)db.getTableOrMetaException(task.getTableId(), Table.TableType.OLAP);
        tbl.writeLockOrMetaException();
        try {
            Partition partition = tbl.getPartition(task.getPartitionId());
            if (partition == null) {
                throw new MetaNotFoundException("partition " + task.getPartitionId() + " does not exist");
            }
            MaterializedIndex index = partition.getIndex(task.getIndexId());
            if (index == null) {
                throw new MetaNotFoundException("index " + task.getIndexId() + " does not exist");
            }
            Tablet tablet = index.getTablet(task.getTabletId());
            Preconditions.checkNotNull((Object)tablet, (Object)task.getTabletId());
            Replica replica = tablet.getReplicaById(task.getNewReplicaId());
            if (replica == null) {
                throw new MetaNotFoundException("replica " + task.getNewReplicaId() + " does not exist");
            }
            LOG.info("before handle alter task tablet {}, replica: {}, task version: {}", (Object)task.getSignature(), (Object)replica, (Object)task.getVersion());
            boolean versionChanged = false;
            if (replica.getVersion() < task.getVersion()) {
                replica.updateVersionInfo(task.getVersion(), replica.getDataSize(), replica.getRowCount());
                versionChanged = true;
            }
            if (versionChanged) {
                ReplicaPersistInfo info = ReplicaPersistInfo.createForClone(task.getDbId(), task.getTableId(), task.getPartitionId(), task.getIndexId(), task.getTabletId(), task.getBackendId(), replica.getId(), replica.getVersion(), -1, replica.getDataSize(), replica.getRowCount(), replica.getLastFailedVersion(), replica.getLastSuccessVersion());
                Catalog.getCurrentCatalog().getEditLog().logUpdateReplica(info);
            }
            LOG.info("after handle alter task tablet: {}, replica: {}", (Object)task.getSignature(), (Object)replica);
        }
        finally {
            tbl.writeUnlock();
        }
    }

    public void replayAlterJobV2(AlterJobV2 alterJob) {
        AlterJobV2 existingJob = (AlterJobV2)this.alterJobsV2.get(alterJob.getJobId());
        if (existingJob == null) {
            alterJob.replay(alterJob);
            this.alterJobsV2.put(alterJob.getJobId(), alterJob);
        } else {
            existingJob.replay(alterJob);
        }
    }
}

