/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.alter;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.doris.alter.AlterHandler;
import org.apache.doris.alter.AlterOpType;
import org.apache.doris.alter.AlterOperations;
import org.apache.doris.alter.MaterializedViewHandler;
import org.apache.doris.alter.SchemaChangeHandler;
import org.apache.doris.alter.SystemHandler;
import org.apache.doris.analysis.AddPartitionClause;
import org.apache.doris.analysis.AlterClause;
import org.apache.doris.analysis.AlterSystemStmt;
import org.apache.doris.analysis.AlterTableStmt;
import org.apache.doris.analysis.AlterViewStmt;
import org.apache.doris.analysis.ColumnRenameClause;
import org.apache.doris.analysis.CreateMaterializedViewStmt;
import org.apache.doris.analysis.DropMaterializedViewStmt;
import org.apache.doris.analysis.DropPartitionClause;
import org.apache.doris.analysis.ModifyColumnCommentClause;
import org.apache.doris.analysis.ModifyDistributionClause;
import org.apache.doris.analysis.ModifyEngineClause;
import org.apache.doris.analysis.ModifyPartitionClause;
import org.apache.doris.analysis.ModifyTableCommentClause;
import org.apache.doris.analysis.ModifyTablePropertiesClause;
import org.apache.doris.analysis.PartitionRenameClause;
import org.apache.doris.analysis.ReplacePartitionClause;
import org.apache.doris.analysis.ReplaceTableClause;
import org.apache.doris.analysis.RollupRenameClause;
import org.apache.doris.analysis.TableName;
import org.apache.doris.analysis.TableRenameClause;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.DataProperty;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.MysqlTable;
import org.apache.doris.catalog.OdbcTable;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.PartitionInfo;
import org.apache.doris.catalog.ReplicaAllocation;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.View;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.DynamicPartitionUtil;
import org.apache.doris.common.util.MetaLockUtils;
import org.apache.doris.common.util.PropertyAnalyzer;
import org.apache.doris.persist.AlterViewInfo;
import org.apache.doris.persist.BatchModifyPartitionsInfo;
import org.apache.doris.persist.ModifyCommentOperationLog;
import org.apache.doris.persist.ModifyPartitionInfo;
import org.apache.doris.persist.ModifyTableEngineOperationLog;
import org.apache.doris.persist.ReplaceTableOperationLog;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.thrift.TOdbcTableType;
import org.apache.doris.thrift.TSortType;
import org.apache.doris.thrift.TTabletType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Alter {
    private static final Logger LOG = LogManager.getLogger(Alter.class);
    private AlterHandler schemaChangeHandler = new SchemaChangeHandler();
    private AlterHandler materializedViewHandler = new MaterializedViewHandler();
    private SystemHandler clusterHandler = new SystemHandler();

    public void start() {
        this.schemaChangeHandler.start();
        this.materializedViewHandler.start();
        this.clusterHandler.start();
    }

    public void processCreateMaterializedView(CreateMaterializedViewStmt stmt) throws DdlException, AnalysisException, MetaNotFoundException {
        String tableName = stmt.getBaseIndexName();
        String dbName = stmt.getDBName();
        Database db = Catalog.getCurrentCatalog().getDbOrDdlException(dbName);
        Catalog.getCurrentSystemInfo().checkClusterCapacity(stmt.getClusterName());
        db.checkQuota();
        OlapTable olapTable = (OlapTable)db.getTableOrMetaException(tableName, Table.TableType.OLAP);
        ((MaterializedViewHandler)this.materializedViewHandler).processCreateMaterializedView(stmt, db, olapTable);
    }

    public void processDropMaterializedView(DropMaterializedViewStmt stmt) throws DdlException, MetaNotFoundException {
        String dbName = stmt.getTableName().getDb();
        Database db = Catalog.getCurrentCatalog().getDbOrDdlException(dbName);
        String tableName = stmt.getTableName().getTbl();
        OlapTable olapTable = (OlapTable)db.getTableOrMetaException(tableName, Table.TableType.OLAP);
        ((MaterializedViewHandler)this.materializedViewHandler).processDropMaterializedView(stmt, db, olapTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processAlterOlapTable(AlterTableStmt stmt, OlapTable olapTable, List<AlterClause> alterClauses, String clusterName, Database db) throws UserException {
        if (olapTable.getDataSortInfo() != null && olapTable.getDataSortInfo().getSortType() == TSortType.ZORDER) {
            throw new UserException("z-order table can not support schema change!");
        }
        stmt.rewriteAlterClause(olapTable);
        alterClauses.addAll(stmt.getOps());
        AlterOperations currentAlterOps = new AlterOperations();
        currentAlterOps.checkConflict(alterClauses);
        if (currentAlterOps.needCheckCapacity()) {
            Catalog.getCurrentSystemInfo().checkClusterCapacity(clusterName);
            db.checkQuota();
        }
        if (olapTable.getState() != OlapTable.OlapTableState.NORMAL) {
            throw new DdlException("Table[" + olapTable.getName() + "]'s state is not NORMAL. Do not allow doing ALTER ops");
        }
        boolean needProcessOutsideTableLock = false;
        if (currentAlterOps.hasSchemaChangeOp()) {
            this.schemaChangeHandler.process(alterClauses, clusterName, db, olapTable);
        } else if (currentAlterOps.hasRollupOp()) {
            this.materializedViewHandler.process(alterClauses, clusterName, db, olapTable);
        } else if (currentAlterOps.hasPartitionOp()) {
            Preconditions.checkState((alterClauses.size() == 1 ? 1 : 0) != 0);
            AlterClause alterClause = alterClauses.get(0);
            olapTable.writeLockOrDdlException();
            try {
                if (alterClause instanceof DropPartitionClause) {
                    if (!((DropPartitionClause)alterClause).isTempPartition()) {
                        DynamicPartitionUtil.checkAlterAllowed(olapTable);
                    }
                    Catalog.getCurrentCatalog().dropPartition(db, olapTable, (DropPartitionClause)alterClause);
                }
                if (alterClause instanceof ReplacePartitionClause) {
                    Catalog.getCurrentCatalog().replaceTempPartition(db, olapTable, (ReplacePartitionClause)alterClause);
                }
                if (alterClause instanceof ModifyPartitionClause) {
                    Map<String, String> properties;
                    ModifyPartitionClause clause = (ModifyPartitionClause)alterClause;
                    if (clause.isNeedExpand()) {
                        List<String> partitionNames = clause.getPartitionNames();
                        partitionNames.clear();
                        for (Partition partition : olapTable.getPartitions()) {
                            partitionNames.add(partition.getName());
                        }
                    }
                    if ((properties = clause.getProperties()).containsKey("in_memory")) {
                        needProcessOutsideTableLock = true;
                    }
                    List<String> partitionNames = clause.getPartitionNames();
                    this.modifyPartitionsProperty(db, olapTable, partitionNames, properties);
                }
                if (alterClause instanceof AddPartitionClause) {
                    needProcessOutsideTableLock = true;
                }
                throw new DdlException("Invalid alter operation: " + (Object)((Object)alterClause.getOpType()));
            }
            finally {
                olapTable.writeUnlock();
            }
        } else if (currentAlterOps.hasRenameOp()) {
            this.processRename(db, olapTable, alterClauses);
        } else if (currentAlterOps.hasReplaceTableOp()) {
            this.processReplaceTable(db, olapTable, alterClauses);
        } else if (currentAlterOps.contains(AlterOpType.MODIFY_TABLE_PROPERTY_SYNC)) {
            needProcessOutsideTableLock = true;
        } else if (currentAlterOps.contains(AlterOpType.MODIFY_DISTRIBUTION)) {
            Preconditions.checkState((alterClauses.size() == 1 ? 1 : 0) != 0);
            AlterClause alterClause = alterClauses.get(0);
            Catalog.getCurrentCatalog().modifyDefaultDistributionBucketNum(db, olapTable, (ModifyDistributionClause)alterClause);
        } else if (currentAlterOps.contains(AlterOpType.MODIFY_COLUMN_COMMENT)) {
            this.processModifyColumnComment(db, olapTable, alterClauses);
        } else if (currentAlterOps.contains(AlterOpType.MODIFY_TABLE_COMMENT)) {
            Preconditions.checkState((alterClauses.size() == 1 ? 1 : 0) != 0);
            AlterClause alterClause = alterClauses.get(0);
            this.processModifyTableComment(db, olapTable, alterClause);
        } else {
            throw new DdlException("Invalid alter operations: " + currentAlterOps);
        }
        return needProcessOutsideTableLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processModifyTableComment(Database db, OlapTable tbl, AlterClause alterClause) throws DdlException {
        tbl.writeLockOrDdlException();
        try {
            ModifyTableCommentClause clause = (ModifyTableCommentClause)alterClause;
            tbl.setComment(clause.getComment());
            ModifyCommentOperationLog op = ModifyCommentOperationLog.forTable(db.getId(), tbl.getId(), clause.getComment());
            Catalog.getCurrentCatalog().getEditLog().logModifyComment(op);
        }
        finally {
            tbl.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processModifyColumnComment(Database db, OlapTable tbl, List<AlterClause> alterClauses) throws DdlException {
        tbl.writeLockOrDdlException();
        try {
            HashMap colToComment = Maps.newHashMap();
            for (AlterClause alterClause : alterClauses) {
                Preconditions.checkState((boolean)(alterClause instanceof ModifyColumnCommentClause));
                ModifyColumnCommentClause clause = (ModifyColumnCommentClause)alterClause;
                String colName = clause.getColName();
                if (tbl.getColumn(colName) == null) {
                    throw new DdlException("Unknown column: " + colName);
                }
                if (colToComment.containsKey(colName)) {
                    throw new DdlException("Duplicate column: " + colName);
                }
                colToComment.put(colName, clause.getComment());
            }
            for (Map.Entry entry : colToComment.entrySet()) {
                Column col = tbl.getColumn((String)entry.getKey());
                col.setComment((String)entry.getValue());
            }
            ModifyCommentOperationLog op = ModifyCommentOperationLog.forColumn(db.getId(), tbl.getId(), colToComment);
            Catalog.getCurrentCatalog().getEditLog().logModifyComment(op);
        }
        finally {
            tbl.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void replayModifyComment(ModifyCommentOperationLog operation) throws MetaNotFoundException {
        long dbId = operation.getDbId();
        long tblId = operation.getTblId();
        Database db = Catalog.getCurrentCatalog().getDbOrMetaException(dbId);
        Table tbl = db.getTableOrMetaException(tblId);
        tbl.writeLock();
        try {
            ModifyCommentOperationLog.Type type = operation.getType();
            switch (type) {
                case TABLE: {
                    tbl.setComment(operation.getTblComment());
                    return;
                }
                case COLUMN: {
                    Iterator<Map.Entry<String, String>> iterator = operation.getColToComment().entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, String> entry = iterator.next();
                        tbl.getColumn(entry.getKey()).setComment(entry.getValue());
                    }
                    return;
                }
            }
            return;
        }
        finally {
            tbl.writeUnlock();
        }
    }

    private void processAlterExternalTable(AlterTableStmt stmt, Table externalTable, Database db) throws UserException {
        stmt.checkExternalTableOperationAllow(externalTable);
        List<AlterClause> alterClauses = stmt.getOps();
        AlterOperations currentAlterOps = new AlterOperations();
        currentAlterOps.checkConflict(alterClauses);
        if (currentAlterOps.hasRenameOp()) {
            this.processRename(db, externalTable, alterClauses);
        } else if (currentAlterOps.hasSchemaChangeOp()) {
            this.schemaChangeHandler.processExternalTable(alterClauses, db, externalTable);
        } else if (currentAlterOps.contains(AlterOpType.MODIFY_ENGINE)) {
            ModifyEngineClause modifyEngineClause = (ModifyEngineClause)alterClauses.get(0);
            this.processModifyEngine(db, externalTable, modifyEngineClause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processModifyEngine(Database db, Table externalTable, ModifyEngineClause clause) throws DdlException {
        externalTable.writeLockOrDdlException();
        try {
            if (externalTable.getType() != Table.TableType.MYSQL) {
                throw new DdlException("Only support modify table engine from MySQL to ODBC");
            }
            this.processModifyEngineInternal(db, externalTable, clause.getProperties(), false);
        }
        finally {
            externalTable.writeUnlock();
        }
        LOG.info("modify table {}'s engine from MySQL to ODBC", (Object)externalTable.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayProcessModifyEngine(ModifyTableEngineOperationLog log) {
        Database db = Catalog.getCurrentCatalog().getDbNullable(log.getDbId());
        if (db == null) {
            return;
        }
        MysqlTable mysqlTable = (MysqlTable)db.getTableNullable(log.getTableId());
        if (mysqlTable == null) {
            return;
        }
        mysqlTable.writeLock();
        try {
            this.processModifyEngineInternal(db, mysqlTable, log.getProperties(), true);
        }
        finally {
            mysqlTable.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processModifyEngineInternal(Database db, Table externalTable, Map<String, String> prop, boolean isReplay) {
        MysqlTable mysqlTable = (MysqlTable)externalTable;
        HashMap newProp = Maps.newHashMap(prop);
        newProp.put("host", mysqlTable.getHost());
        newProp.put("port", mysqlTable.getPort());
        newProp.put("user", mysqlTable.getUserName());
        newProp.put("password", mysqlTable.getPasswd());
        newProp.put("database", mysqlTable.getMysqlDatabaseName());
        newProp.put("table", mysqlTable.getMysqlTableName());
        newProp.put("odbc_type", TOdbcTableType.MYSQL.name());
        OdbcTable odbcTable = null;
        try {
            odbcTable = new OdbcTable(mysqlTable.getId(), mysqlTable.getName(), mysqlTable.getBaseSchema(), newProp);
        }
        catch (DdlException e) {
            LOG.warn("Should not happen", (Throwable)e);
            return;
        }
        odbcTable.writeLock();
        try {
            db.dropTable(mysqlTable.getName());
            db.createTable(odbcTable);
            if (!isReplay) {
                ModifyTableEngineOperationLog log = new ModifyTableEngineOperationLog(db.getId(), externalTable.getId(), prop);
                Catalog.getCurrentCatalog().getEditLog().logModifyTableEngine(log);
            }
        }
        finally {
            odbcTable.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAlterTable(AlterTableStmt stmt) throws UserException {
        TableName dbTableName = stmt.getTbl();
        String dbName = dbTableName.getDb();
        String tableName = dbTableName.getTbl();
        String clusterName = stmt.getClusterName();
        Database db = Catalog.getCurrentCatalog().getDbOrDdlException(dbName);
        Table table = db.getTableOrDdlException(tableName);
        ArrayList alterClauses = Lists.newArrayList();
        boolean needProcessOutsideTableLock = false;
        switch (table.getType()) {
            case OLAP: {
                OlapTable olapTable = (OlapTable)table;
                needProcessOutsideTableLock = this.processAlterOlapTable(stmt, olapTable, alterClauses, clusterName, db);
                break;
            }
            case ODBC: 
            case MYSQL: 
            case ELASTICSEARCH: {
                this.processAlterExternalTable(stmt, table, db);
                return;
            }
            default: {
                throw new DdlException("Do not support alter " + table.getType().toString() + " table[" + tableName + "]");
            }
        }
        if (needProcessOutsideTableLock) {
            Preconditions.checkState((alterClauses.size() == 1 ? 1 : 0) != 0);
            AlterClause alterClause = (AlterClause)alterClauses.get(0);
            if (alterClause instanceof AddPartitionClause) {
                if (!((AddPartitionClause)alterClause).isTempPartition()) {
                    DynamicPartitionUtil.checkAlterAllowed((OlapTable)db.getTableOrMetaException(tableName, Table.TableType.OLAP));
                }
                Catalog.getCurrentCatalog().addPartition(db, tableName, (AddPartitionClause)alterClause);
            } else if (alterClause instanceof ModifyPartitionClause) {
                ModifyPartitionClause clause = (ModifyPartitionClause)alterClause;
                Map<String, String> properties = clause.getProperties();
                List<String> partitionNames = clause.getPartitionNames();
                Preconditions.checkState((boolean)properties.containsKey("in_memory"));
                ((SchemaChangeHandler)this.schemaChangeHandler).updatePartitionsInMemoryMeta(db, tableName, partitionNames, properties);
                OlapTable olapTable = (OlapTable)table;
                olapTable.writeLockOrDdlException();
                try {
                    this.modifyPartitionsProperty(db, olapTable, partitionNames, properties);
                }
                finally {
                    olapTable.writeUnlock();
                }
            } else if (alterClause instanceof ModifyTablePropertiesClause) {
                Map<String, String> properties = alterClause.getProperties();
                Preconditions.checkState((boolean)properties.containsKey("in_memory"));
                ((SchemaChangeHandler)this.schemaChangeHandler).updateTableInMemoryMeta(db, tableName, properties);
            } else {
                throw new DdlException("Invalid alter operation: " + (Object)((Object)alterClause.getOpType()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processReplaceTable(Database db, OlapTable origTable, List<AlterClause> alterClauses) throws UserException {
        ReplaceTableClause clause = (ReplaceTableClause)alterClauses.get(0);
        String newTblName = clause.getTblName();
        boolean swapTable = clause.isSwapTable();
        db.writeLockOrDdlException();
        try {
            Object newTbl = db.getTableOrMetaException(newTblName, Table.TableType.OLAP);
            OlapTable olapNewTbl = (OlapTable)newTbl;
            ArrayList tableList = Lists.newArrayList((Object[])new Table[]{origTable, newTbl});
            tableList.sort(Comparator.comparing(Table::getId));
            MetaLockUtils.writeLockTablesOrMetaException(tableList);
            try {
                String oldTblName = origTable.getName();
                olapNewTbl.checkAndSetName(oldTblName, true);
                if (swapTable) {
                    origTable.checkAndSetName(newTblName, true);
                }
                this.replaceTableInternal(db, origTable, olapNewTbl, swapTable, false);
                ReplaceTableOperationLog log = new ReplaceTableOperationLog(db.getId(), origTable.getId(), olapNewTbl.getId(), swapTable);
                Catalog.getCurrentCatalog().getEditLog().logReplaceTable(log);
                LOG.info("finish replacing table {} with table {}, is swap: {}", (Object)oldTblName, (Object)newTblName, (Object)swapTable);
            }
            finally {
                MetaLockUtils.writeUnlockTables(tableList);
            }
        }
        finally {
            db.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayReplaceTable(ReplaceTableOperationLog log) throws MetaNotFoundException {
        long dbId = log.getDbId();
        long origTblId = log.getOrigTblId();
        long newTblId = log.getNewTblId();
        Database db = Catalog.getCurrentCatalog().getDbOrMetaException(dbId);
        OlapTable origTable = (OlapTable)db.getTableOrMetaException(origTblId, Table.TableType.OLAP);
        OlapTable newTbl = (OlapTable)db.getTableOrMetaException(newTblId, Table.TableType.OLAP);
        ArrayList tableList = Lists.newArrayList((Object[])new Table[]{origTable, newTbl});
        tableList.sort(Comparator.comparing(Table::getId));
        MetaLockUtils.writeLockTablesOrMetaException(tableList);
        try {
            this.replaceTableInternal(db, origTable, newTbl, log.isSwapTable(), true);
        }
        catch (DdlException e) {
            LOG.warn("should not happen", (Throwable)e);
        }
        finally {
            MetaLockUtils.writeUnlockTables(tableList);
        }
        LOG.info("finish replay replacing table {} with table {}, is swap: {}", (Object)origTblId, (Object)newTblId, (Object)log.isSwapTable());
    }

    private void replaceTableInternal(Database db, OlapTable origTable, OlapTable newTbl, boolean swapTable, boolean isReplay) throws DdlException {
        String oldTblName = origTable.getName();
        String newTblName = newTbl.getName();
        db.dropTable(oldTblName);
        db.dropTable(newTblName);
        newTbl.checkAndSetName(oldTblName, false);
        db.createTable(newTbl);
        if (swapTable) {
            origTable.checkAndSetName(newTblName, false);
            db.createTable(origTable);
        } else {
            Catalog.getCurrentCatalog().onEraseOlapTable(origTable, isReplay);
        }
    }

    public void processAlterView(AlterViewStmt stmt, ConnectContext ctx) throws UserException {
        TableName dbTableName = stmt.getTbl();
        String dbName = dbTableName.getDb();
        Database db = Catalog.getCurrentCatalog().getDbOrDdlException(dbName);
        String tableName = dbTableName.getTbl();
        View view = (View)db.getTableOrMetaException(tableName, Table.TableType.VIEW);
        this.modifyViewDef(db, view, stmt.getInlineViewDef(), ctx.getSessionVariable().getSqlMode(), stmt.getColumns());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyViewDef(Database db, View view, String inlineViewDef, long sqlMode, List<Column> newFullSchema) throws DdlException {
        db.writeLockOrDdlException();
        try {
            view.writeLockOrDdlException();
            try {
                view.setInlineViewDefWithSqlMode(inlineViewDef, sqlMode);
                try {
                    view.init();
                }
                catch (UserException e) {
                    throw new DdlException("failed to init view stmt", e);
                }
                view.setNewFullSchema(newFullSchema);
                String viewName = view.getName();
                db.dropTable(viewName);
                db.createTable(view);
                AlterViewInfo alterViewInfo = new AlterViewInfo(db.getId(), view.getId(), inlineViewDef, newFullSchema, sqlMode);
                Catalog.getCurrentCatalog().getEditLog().logModifyViewDef(alterViewInfo);
                LOG.info("modify view[{}] definition to {}", (Object)viewName, (Object)inlineViewDef);
            }
            finally {
                view.writeUnlock();
            }
        }
        finally {
            db.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayModifyViewDef(AlterViewInfo alterViewInfo) throws MetaNotFoundException, DdlException {
        long dbId = alterViewInfo.getDbId();
        long tableId = alterViewInfo.getTableId();
        String inlineViewDef = alterViewInfo.getInlineViewDef();
        List<Column> newFullSchema = alterViewInfo.getNewFullSchema();
        Database db = Catalog.getCurrentCatalog().getDbOrMetaException(dbId);
        View view = (View)db.getTableOrMetaException(tableId, Table.TableType.VIEW);
        db.writeLock();
        view.writeLock();
        try {
            String viewName = view.getName();
            view.setInlineViewDefWithSqlMode(inlineViewDef, alterViewInfo.getSqlMode());
            try {
                view.init();
            }
            catch (UserException e) {
                throw new DdlException("failed to init view stmt", e);
            }
            view.setNewFullSchema(newFullSchema);
            db.dropTable(viewName);
            db.createTable(view);
            LOG.info("replay modify view[{}] definition to {}", (Object)viewName, (Object)inlineViewDef);
        }
        finally {
            view.writeUnlock();
            db.writeUnlock();
        }
    }

    public void processAlterCluster(AlterSystemStmt stmt) throws UserException {
        this.clusterHandler.process(Arrays.asList(stmt.getAlterClause()), stmt.getClusterName(), null, null);
    }

    private void processRename(Database db, OlapTable table, List<AlterClause> alterClauses) throws DdlException {
        for (AlterClause alterClause : alterClauses) {
            if (alterClause instanceof TableRenameClause) {
                Catalog.getCurrentCatalog().renameTable(db, table, (TableRenameClause)alterClause);
                break;
            }
            if (alterClause instanceof RollupRenameClause) {
                Catalog.getCurrentCatalog().renameRollup(db, table, (RollupRenameClause)alterClause);
                break;
            }
            if (alterClause instanceof PartitionRenameClause) {
                Catalog.getCurrentCatalog().renamePartition(db, table, (PartitionRenameClause)alterClause);
                break;
            }
            if (alterClause instanceof ColumnRenameClause) {
                Catalog.getCurrentCatalog().renameColumn(db, table, (ColumnRenameClause)alterClause);
                break;
            }
            Preconditions.checkState((boolean)false);
        }
    }

    private void processRename(Database db, Table table, List<AlterClause> alterClauses) throws DdlException {
        for (AlterClause alterClause : alterClauses) {
            if (alterClause instanceof TableRenameClause) {
                Catalog.getCurrentCatalog().renameTable(db, table, (TableRenameClause)alterClause);
                break;
            }
            Preconditions.checkState((boolean)false);
        }
    }

    public void modifyPartitionsProperty(Database db, OlapTable olapTable, List<String> partitionNames, Map<String, String> properties) throws DdlException, AnalysisException {
        Preconditions.checkArgument((boolean)olapTable.isWriteLockHeldByCurrentThread());
        ArrayList modifyPartitionInfos = Lists.newArrayList();
        if (olapTable.getState() != OlapTable.OlapTableState.NORMAL) {
            throw new DdlException("Table[" + olapTable.getName() + "]'s state is not NORMAL");
        }
        for (String partitionName : partitionNames) {
            Partition partition = olapTable.getPartition(partitionName);
            if (partition != null) continue;
            throw new DdlException("Partition[" + partitionName + "] does not exist in table[" + olapTable.getName() + "]");
        }
        boolean hasInMemory = false;
        if (properties.containsKey("in_memory")) {
            hasInMemory = true;
        }
        DataProperty newDataProperty = PropertyAnalyzer.analyzeDataProperty(properties, null);
        ReplicaAllocation replicaAlloc = PropertyAnalyzer.analyzeReplicaAllocation(properties, "");
        Catalog.getCurrentSystemInfo().checkReplicaAllocation(db.getClusterName(), replicaAlloc);
        boolean newInMemory = PropertyAnalyzer.analyzeBooleanProp(properties, "in_memory", false);
        TTabletType tTabletType = PropertyAnalyzer.analyzeTabletType(properties);
        PartitionInfo partitionInfo = olapTable.getPartitionInfo();
        for (String partitionName : partitionNames) {
            Partition partition = olapTable.getPartition(partitionName);
            if (newDataProperty != null) {
                partitionInfo.setDataProperty(partition.getId(), newDataProperty);
            }
            if (!replicaAlloc.isNotSet()) {
                partitionInfo.setReplicaAllocation(partition.getId(), replicaAlloc);
            }
            boolean oldInMemory = partitionInfo.getIsInMemory(partition.getId());
            if (hasInMemory && newInMemory != oldInMemory) {
                partitionInfo.setIsInMemory(partition.getId(), newInMemory);
            }
            if (tTabletType != partitionInfo.getTabletType(partition.getId())) {
                partitionInfo.setTabletType(partition.getId(), tTabletType);
            }
            ModifyPartitionInfo info = new ModifyPartitionInfo(db.getId(), olapTable.getId(), partition.getId(), newDataProperty, replicaAlloc, hasInMemory ? newInMemory : oldInMemory);
            modifyPartitionInfos.add(info);
        }
        BatchModifyPartitionsInfo info = new BatchModifyPartitionsInfo(modifyPartitionInfos);
        Catalog.getCurrentCatalog().getEditLog().logBatchModifyPartition(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayModifyPartition(ModifyPartitionInfo info) throws MetaNotFoundException {
        Database db = Catalog.getCurrentCatalog().getDbOrMetaException(info.getDbId());
        OlapTable olapTable = (OlapTable)db.getTableOrMetaException(info.getTableId(), Table.TableType.OLAP);
        olapTable.writeLock();
        try {
            PartitionInfo partitionInfo = olapTable.getPartitionInfo();
            if (info.getDataProperty() != null) {
                partitionInfo.setDataProperty(info.getPartitionId(), info.getDataProperty());
            }
            if (!info.getReplicaAlloc().isNotSet()) {
                partitionInfo.setReplicaAllocation(info.getPartitionId(), info.getReplicaAlloc());
            }
            partitionInfo.setIsInMemory(info.getPartitionId(), info.isInMemory());
        }
        finally {
            olapTable.writeUnlock();
        }
    }

    public AlterHandler getSchemaChangeHandler() {
        return this.schemaChangeHandler;
    }

    public AlterHandler getMaterializedViewHandler() {
        return this.materializedViewHandler;
    }

    public AlterHandler getClusterHandler() {
        return this.clusterHandler;
    }
}

