/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.Security;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.CommandLineOptions;
import org.apache.doris.common.Config;
import org.apache.doris.common.LdapConfig;
import org.apache.doris.common.Log4jConfig;
import org.apache.doris.common.ThreadPoolManager;
import org.apache.doris.common.util.JdkUtils;
import org.apache.doris.common.util.NetUtils;
import org.apache.doris.httpv2.HttpServer;
import org.apache.doris.journal.bdbje.BDBDebugger;
import org.apache.doris.journal.bdbje.BDBTool;
import org.apache.doris.journal.bdbje.BDBToolOptions;
import org.apache.doris.qe.QeService;
import org.apache.doris.service.ExecuteEnv;
import org.apache.doris.service.FeServer;
import org.apache.doris.service.FrontendOptions;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PaloFe {
    private static final Logger LOG = LogManager.getLogger(PaloFe.class);
    public static final String DORIS_HOME_DIR = System.getenv("DORIS_HOME");
    public static final String PID_DIR = System.getenv("PID_DIR");

    public static void main(String[] args) {
        PaloFe.start(DORIS_HOME_DIR, PID_DIR, args);
    }

    public static void start(String dorisHomeDir, String pidDir, String[] args) {
        if (System.getenv("DORIS_LOG_TO_STDERR") != null) {
            Log4jConfig.foreground = true;
        }
        if (Strings.isNullOrEmpty((String)dorisHomeDir)) {
            System.err.println("env DORIS_HOME is not set.");
            return;
        }
        if (Strings.isNullOrEmpty((String)pidDir)) {
            System.err.println("env PID_DIR is not set.");
            return;
        }
        CommandLineOptions cmdLineOpts = PaloFe.parseArgs(args);
        try {
            if (!PaloFe.createAndLockPidFile(pidDir + "/fe.pid")) {
                throw new IOException("pid file is already locked.");
            }
            Config config = new Config();
            config.init(dorisHomeDir + "/conf/fe.conf");
            config.initCustom(Config.custom_config_dir + "/fe_custom.conf");
            LdapConfig ldapConfig = new LdapConfig();
            if (new File(dorisHomeDir + "/conf/ldap.conf").exists()) {
                ldapConfig.init(dorisHomeDir + "/conf/ldap.conf");
            }
            if (!JdkUtils.checkJavaVersion()) {
                throw new IllegalArgumentException("Java version doesn't match");
            }
            Log4jConfig.initLogging(dorisHomeDir + "/conf/");
            Security.setProperty("networkaddress.cache.ttl", "60");
            PaloFe.checkCommandLineOptions(cmdLineOpts);
            LOG.info("Palo FE starting...");
            FrontendOptions.init();
            PaloFe.checkAllPorts();
            if (Config.enable_bdbje_debug_mode) {
                BDBDebugger.get().startDebugMode(dorisHomeDir);
                return;
            }
            Catalog.getCurrentCatalog().initialize(args);
            Catalog.getCurrentCatalog().waitForReady();
            QeService qeService = new QeService(Config.query_port, Config.mysql_service_nio_enabled, ExecuteEnv.getInstance().getScheduler());
            FeServer feServer = new FeServer(Config.rpc_port);
            feServer.start();
            HttpServer httpServer = new HttpServer();
            httpServer.setPort(Config.http_port);
            httpServer.setMaxHttpPostSize(Config.jetty_server_max_http_post_size);
            httpServer.setAcceptors(Config.jetty_server_acceptors);
            httpServer.setSelectors(Config.jetty_server_selectors);
            httpServer.setWorkers(Config.jetty_server_workers);
            httpServer.start(dorisHomeDir);
            qeService.start();
            ThreadPoolManager.registerAllThreadPoolMetric();
            while (true) {
                Thread.sleep(2000L);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            return;
        }
    }

    private static void checkAllPorts() throws IOException {
        if (!NetUtils.isPortAvailable(FrontendOptions.getLocalHostAddress(), Config.edit_log_port, "Edit log port", "Please change the 'edit_log_port' in fe.conf and try again. But if this is not the first time your start this FE, please DO NOT change it.  You need to find the service that occupies the port and shut it down, and then return the port to Doris.")) {
            throw new IOException("port " + Config.edit_log_port + " already in use");
        }
        if (!NetUtils.isPortAvailable(FrontendOptions.getLocalHostAddress(), Config.http_port, "Http port", "Please change the 'http_port' in fe.conf and try again. But you need to make sure that ALL FEs http_port are same.")) {
            throw new IOException("port " + Config.http_port + " already in use");
        }
        if (!NetUtils.isPortAvailable(FrontendOptions.getLocalHostAddress(), Config.query_port, "Query port", "Please change the 'query_port' in fe.conf and try again.")) {
            throw new IOException("port " + Config.query_port + " already in use");
        }
        if (!NetUtils.isPortAvailable(FrontendOptions.getLocalHostAddress(), Config.rpc_port, "Rpc port", "Please change the 'rpc_port' in fe.conf and try again.")) {
            throw new IOException("port " + Config.rpc_port + " already in use");
        }
    }

    private static CommandLineOptions parseArgs(String[] args) {
        DefaultParser commandLineParser = new DefaultParser();
        Options options = new Options();
        options.addOption("v", "version", false, "Print the version of Palo Frontend");
        options.addOption("h", "helper", true, "Specify the helper node when joining a bdb je replication group");
        options.addOption("b", "bdb", false, "Run bdbje debug tools");
        options.addOption("l", "listdb", false, "List databases in bdbje");
        options.addOption("d", "db", true, "Specify a database in bdbje");
        options.addOption("s", "stat", false, "Print statistic of a database, including count, first key, last key");
        options.addOption("f", "from", true, "Specify the start scan key");
        options.addOption("t", "to", true, "Specify the end scan key");
        options.addOption("m", "metaversion", true, "Specify the meta version to decode log value");
        CommandLine cmd = null;
        try {
            cmd = commandLineParser.parse(options, args);
        }
        catch (ParseException e) {
            e.printStackTrace();
            System.err.println("Failed to parse command line. exit now");
            System.exit(-1);
        }
        if (cmd.hasOption('v') || cmd.hasOption("version")) {
            return new CommandLineOptions(true, "", null);
        }
        if (cmd.hasOption('h') || cmd.hasOption("helper")) {
            String helperNode = cmd.getOptionValue("helper");
            if (Strings.isNullOrEmpty((String)helperNode)) {
                System.err.println("Missing helper node");
                System.exit(-1);
            }
            return new CommandLineOptions(false, helperNode, null);
        }
        if (cmd.hasOption('b') || cmd.hasOption("bdb")) {
            if (cmd.hasOption('l') || cmd.hasOption("listdb")) {
                BDBToolOptions bdbOpts = new BDBToolOptions(true, "", false, "", "", 0);
                return new CommandLineOptions(false, "", bdbOpts);
            }
            if (cmd.hasOption('d') || cmd.hasOption("db")) {
                String dbName = cmd.getOptionValue("db");
                if (Strings.isNullOrEmpty((String)dbName)) {
                    System.err.println("BDBJE database name is missing");
                    System.exit(-1);
                }
                if (cmd.hasOption('s') || cmd.hasOption("stat")) {
                    BDBToolOptions bdbOpts = new BDBToolOptions(false, dbName, true, "", "", 0);
                    return new CommandLineOptions(false, "", bdbOpts);
                }
                String fromKey = "";
                String endKey = "";
                int metaVersion = 0;
                if ((cmd.hasOption('f') || cmd.hasOption("from")) && Strings.isNullOrEmpty((String)(fromKey = cmd.getOptionValue("from")))) {
                    System.err.println("from key is missing");
                    System.exit(-1);
                }
                if ((cmd.hasOption('t') || cmd.hasOption("to")) && Strings.isNullOrEmpty((String)(endKey = cmd.getOptionValue("to")))) {
                    System.err.println("end key is missing");
                    System.exit(-1);
                }
                if (cmd.hasOption('m') || cmd.hasOption("metaversion")) {
                    try {
                        metaVersion = Integer.parseInt(cmd.getOptionValue("metaversion"));
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Invalid meta version format");
                        System.exit(-1);
                    }
                }
                BDBToolOptions bdbOpts = new BDBToolOptions(false, dbName, false, fromKey, endKey, metaVersion);
                return new CommandLineOptions(false, "", bdbOpts);
            }
            System.err.println("Invalid options when running bdb je tools");
            System.exit(-1);
        }
        return new CommandLineOptions(false, null, null);
    }

    private static void checkCommandLineOptions(CommandLineOptions cmdLineOpts) {
        if (cmdLineOpts.isVersion()) {
            System.out.println("Build version: 1.1.0-rc05");
            System.out.println("Build time: Sun, 10 Jul 2022 13:58:03 UTC");
            System.out.println("Build info: root@1264bad10c91");
            System.out.println("Build hash: file:///root/doris@Unknown");
            System.out.println("Java compile version: openjdk full version \"11.0.15+9-LTS\"");
            System.exit(0);
        } else if (cmdLineOpts.runBdbTools()) {
            BDBTool bdbTool = new BDBTool(Catalog.getCurrentCatalog().getBdbDir(), cmdLineOpts.getBdbToolOpts());
            if (bdbTool.run()) {
                System.exit(0);
            } else {
                System.exit(-1);
            }
        }
    }

    private static boolean createAndLockPidFile(String pidFilePath) throws IOException {
        File pid = new File(pidFilePath);
        RandomAccessFile file = new RandomAccessFile(pid, "rws");
        try {
            FileLock lock = file.getChannel().tryLock();
            if (lock == null) {
                return false;
            }
            pid.deleteOnExit();
            String name = ManagementFactory.getRuntimeMXBean().getName();
            file.setLength(0L);
            file.write(name.split("@")[0].getBytes(Charsets.UTF_8));
            return true;
        }
        catch (OverlappingFileLockException e) {
            file.close();
            return false;
        }
        catch (IOException e) {
            file.close();
            throw e;
        }
    }
}

