/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.modules.ObjectReaderModule;
import com.alibaba.fastjson2.reader.ObjectArrayReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBaseModule;
import com.alibaba.fastjson2.reader.ObjectReaderCreator;
import com.alibaba.fastjson2.reader.ObjectReaderCreatorASM;
import com.alibaba.fastjson2.reader.ObjectReaderCreatorLambda;
import com.alibaba.fastjson2.reader.ObjectReaderImplMap;
import com.alibaba.fastjson2.reader.ObjectReaderImplString;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;

public class ObjectReaderProvider {
    public static final boolean SAFE_MODE;
    static final String[] DENYS;
    static final String[] AUTO_TYPE_ACCEPT_LIST;
    static JSONReader.AutoTypeBeforeHandler DEFAULT_AUTO_TYPE_BEFORE_HANDLER;
    static Consumer<Class> DEFAULT_AUTO_TYPE_HANDLER;
    static boolean DEFAULT_AUTO_TYPE_HANDLER_INIT_ERROR;
    final ConcurrentMap<Type, ObjectReader> cache = new ConcurrentHashMap<Type, ObjectReader>();
    final ConcurrentMap<Type, ObjectReader> cacheFieldBased = new ConcurrentHashMap<Type, ObjectReader>();
    final ConcurrentMap<Integer, ConcurrentHashMap<Long, ObjectReader>> tclHashCaches = new ConcurrentHashMap<Integer, ConcurrentHashMap<Long, ObjectReader>>();
    final ConcurrentMap<Long, ObjectReader> hashCache = new ConcurrentHashMap<Long, ObjectReader>();
    final ConcurrentMap<Class, Class> mixInCache = new ConcurrentHashMap<Class, Class>();
    private ConcurrentMap<Type, Map<Type, Function>> typeConverts = new ConcurrentHashMap<Type, Map<Type, Function>>();
    final ObjectReaderCreator creator;
    final List<ObjectReaderModule> modules = new ArrayList<ObjectReaderModule>();
    private final long[] denyHashCodes;
    private long[] acceptHashCodes;
    private JSONReader.AutoTypeBeforeHandler autoTypeBeforeHandler = DEFAULT_AUTO_TYPE_BEFORE_HANDLER;
    private Consumer<Class> autoTypeHandler = DEFAULT_AUTO_TYPE_HANDLER;

    public void registerIfAbsent(long hashCode, ObjectReader objectReader) {
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        if (tcl != null && tcl != JSON.class.getClassLoader()) {
            int tclHash = System.identityHashCode(tcl);
            ConcurrentHashMap tclHashCache = (ConcurrentHashMap)this.tclHashCaches.get(tclHash);
            if (tclHashCache == null) {
                this.tclHashCaches.putIfAbsent(tclHash, new ConcurrentHashMap());
                tclHashCache = (ConcurrentHashMap)this.tclHashCaches.get(tclHash);
            }
            tclHashCache.putIfAbsent(hashCode, objectReader);
        }
        this.hashCache.putIfAbsent(hashCode, objectReader);
    }

    public void addAutoTypeAccept(String name) {
        long hash;
        if (name != null && name.length() != 0 && Arrays.binarySearch(this.acceptHashCodes, hash = Fnv.hashCode64(name)) < 0) {
            long[] hashCodes = new long[this.acceptHashCodes.length + 1];
            hashCodes[hashCodes.length - 1] = hash;
            System.arraycopy(this.acceptHashCodes, 0, hashCodes, 0, this.acceptHashCodes.length);
            Arrays.sort(hashCodes);
            this.acceptHashCodes = hashCodes;
        }
    }

    public Consumer<Class> getAutoTypeHandler() {
        return this.autoTypeHandler;
    }

    public void setAutoTypeHandler(Consumer<Class> autoTypeHandler) {
        this.autoTypeHandler = autoTypeHandler;
    }

    public Class getMixIn(Class target) {
        return (Class)this.mixInCache.get(target);
    }

    public void mixIn(Class target, Class mixinSource) {
        this.mixInCache.put(target, mixinSource);
        this.cache.remove(target);
        this.cacheFieldBased.remove(target);
    }

    public boolean register(Type type, ObjectReader objectReader) {
        return this.cache.put(type, objectReader) == null;
    }

    public boolean register(ObjectReaderModule module) {
        for (int i = this.modules.size() - 1; i >= 0; --i) {
            if (this.modules.get(i) != module) continue;
            return false;
        }
        module.init(this);
        this.modules.add(0, module);
        return true;
    }

    public ObjectReaderCreator getCreator() {
        ObjectReaderCreator contextCreator = JSONFactory.getContextReaderCreator();
        if (contextCreator != null) {
            return contextCreator;
        }
        return this.creator;
    }

    public ObjectReaderProvider() {
        this.denyHashCodes = new long[]{-9164606388214699518L, -8754006975464705441L, -8720046426850100497L, -8649961213709896794L, -8614556368991373401L, -8382625455832334425L, -8165637398350707645L, -8109300701639721088L, -7966123100503199569L, -7921218830998286408L, -7775351613326101303L, -7768608037458185275L, -7766605818834748097L, -6835437086156813536L, -6316154655839304624L, -6179589609550493385L, -6149130139291498841L, -6149093380703242441L, -6088208984980396913L, -6025144546313590215L, -5939269048541779808L, -5885964883385605994L, -5767141746063564198L, -5764804792063216819L, -5472097725414717105L, -5194641081268104286L, -5076846148177416215L, -4837536971810737970L, -4836620931940850535L, -4733542790109620528L, -4703320437989596122L, -4608341446948126581L, -4537258998789938600L, -4438775680185074100L, -4314457471973557243L, -4150995715611818742L, -4082057040235125754L, -3975378478825053783L, -3967588558552655563L, -3935185854875733362L, -3319207949486691020L, -3077205613010077203L, -3053747177772160511L, -2995060141064716555L, -2825378362173150292L, -2533039401923731906L, -2439930098895578154L, -2378990704010641148L, -2364987994247679115L, -2262244760619952081L, -2192804397019347313L, -2095516571388852610L, -1872417015366588117L, -1650485814983027158L, -1589194880214235129L, -965955008570215305L, -905177026366752536L, -831789045734283466L, -803541446955902575L, -731978084025273882L, -666475508176557463L, -582813228520337988L, -254670111376247151L, -219577392946377768L, -190281065685395680L, -26639035867733124L, -9822483067882491L, 4750336058574309L, 33238344207745342L, 156405680656087946L, 218512992947536312L, 313864100207897507L, 386461436234701831L, 744602970950881621L, 823641066473609950L, 1073634739308289776L, 1153291637701043748L, 1203232727967308606L, 1214780596910349029L, 1268707909007641340L, 1459860845934817624L, 1502845958873959152L, 1534439610567445754L, 1698504441317515818L, 1818089308493370394L, 2078113382421334967L, 2164696723069287854L, 2622551729063269307L, 2653453629929770569L, 2660670623866180977L, 2731823439467737506L, 2836431254737891113L, 2930861374593775110L, 3058452313624178956L, 3085473968517218653L, 3089451460101527857L, 3114862868117605599L, 3129395579983849527L, 3256258368248066264L, 3452379460455804429L, 3547627781654598988L, 3637939656440441093L, 3688179072722109200L, 3718352661124136681L, 3730752432285826863L, 3740226159580918099L, 3794316665763266033L, 3977090344859527316L, 4000049462512838776L, 4046190361520671643L, 4147696707147271408L, 4193204392725694463L, 4215053018660518963L, 4241163808635564644L, 4254584350247334433L, 4814658433570175913L, 4841947709850912914L, 4904007817188630457L, 5100336081510080343L, 5120543992130540564L, 5274044858141538265L, 5347909877633654828L, 5450448828334921485L, 5474268165959054640L, 5545425291794704408L, 5596129856135573697L, 5688200883751798389L, 5751393439502795295L, 5916409771425455946L, 5944107969236155580L, 6007332606592876737L, 6090377589998869205L, 6280357960959217660L, 6456855723474196908L, 6511035576063254270L, 6534946468240507089L, 6584624952928234050L, 6734240326434096246L, 6742705432718011780L, 6800727078373023163L, 6854854816081053523L, 7045245923763966215L, 7123326897294507060L, 7164889056054194741L, 7179336928365889465L, 7240293012336844478L, 7347653049056829645L, 7375862386996623731L, 7442624256860549330L, 7617522210483516279L, 7658177784286215602L, 8055461369741094911L, 8064026652676081192L, 8389032537095247355L, 8488266005336625107L, 8537233257283452655L, 8735538376409180149L, 8838294710098435315L, 8861402923078831179L, 9140390920032557669L, 9140416208800006522L, 9144212112462101475L};
        long[] hashCodes = new long[AUTO_TYPE_ACCEPT_LIST.length + 1];
        for (int i = 0; i < AUTO_TYPE_ACCEPT_LIST.length; ++i) {
            hashCodes[i] = Fnv.hashCode64(AUTO_TYPE_ACCEPT_LIST[i]);
        }
        hashCodes[hashCodes.length - 1] = -6293031534589903644L;
        Arrays.sort(hashCodes);
        this.acceptHashCodes = hashCodes;
        this.hashCache.put(ObjectArrayReader.TYPE_HASH_CODE, ObjectArrayReader.INSTANCE);
        this.hashCache.put(Fnv.hashCode64(String.class.getName()), ObjectReaderImplString.INSTANCE);
        this.hashCache.put(Fnv.hashCode64(TypeUtils.getTypeName(HashMap.class)), ObjectReaderImplMap.INSTANCE);
        switch (JSONFactory.CREATOR) {
            case "reflect": {
                this.creator = ObjectReaderCreator.INSTANCE;
                break;
            }
            case "lambda": {
                this.creator = ObjectReaderCreatorLambda.INSTANCE;
                break;
            }
            default: {
                this.creator = ObjectReaderCreatorASM.INSTANCE;
            }
        }
        this.modules.add(new ObjectReaderBaseModule(this));
        this.init();
    }

    public ObjectReaderProvider(ObjectReaderCreator creator) {
        this.denyHashCodes = new long[]{-9164606388214699518L, -8754006975464705441L, -8720046426850100497L, -8649961213709896794L, -8614556368991373401L, -8382625455832334425L, -8165637398350707645L, -8109300701639721088L, -7966123100503199569L, -7921218830998286408L, -7775351613326101303L, -7768608037458185275L, -7766605818834748097L, -6835437086156813536L, -6316154655839304624L, -6179589609550493385L, -6149130139291498841L, -6149093380703242441L, -6088208984980396913L, -6025144546313590215L, -5939269048541779808L, -5885964883385605994L, -5767141746063564198L, -5764804792063216819L, -5472097725414717105L, -5194641081268104286L, -5076846148177416215L, -4837536971810737970L, -4836620931940850535L, -4733542790109620528L, -4703320437989596122L, -4608341446948126581L, -4537258998789938600L, -4438775680185074100L, -4314457471973557243L, -4150995715611818742L, -4082057040235125754L, -3975378478825053783L, -3967588558552655563L, -3935185854875733362L, -3319207949486691020L, -3077205613010077203L, -3053747177772160511L, -2995060141064716555L, -2825378362173150292L, -2533039401923731906L, -2439930098895578154L, -2378990704010641148L, -2364987994247679115L, -2262244760619952081L, -2192804397019347313L, -2095516571388852610L, -1872417015366588117L, -1650485814983027158L, -1589194880214235129L, -965955008570215305L, -905177026366752536L, -831789045734283466L, -803541446955902575L, -731978084025273882L, -666475508176557463L, -582813228520337988L, -254670111376247151L, -219577392946377768L, -190281065685395680L, -26639035867733124L, -9822483067882491L, 4750336058574309L, 33238344207745342L, 156405680656087946L, 218512992947536312L, 313864100207897507L, 386461436234701831L, 744602970950881621L, 823641066473609950L, 1073634739308289776L, 1153291637701043748L, 1203232727967308606L, 1214780596910349029L, 1268707909007641340L, 1459860845934817624L, 1502845958873959152L, 1534439610567445754L, 1698504441317515818L, 1818089308493370394L, 2078113382421334967L, 2164696723069287854L, 2622551729063269307L, 2653453629929770569L, 2660670623866180977L, 2731823439467737506L, 2836431254737891113L, 2930861374593775110L, 3058452313624178956L, 3085473968517218653L, 3089451460101527857L, 3114862868117605599L, 3129395579983849527L, 3256258368248066264L, 3452379460455804429L, 3547627781654598988L, 3637939656440441093L, 3688179072722109200L, 3718352661124136681L, 3730752432285826863L, 3740226159580918099L, 3794316665763266033L, 3977090344859527316L, 4000049462512838776L, 4046190361520671643L, 4147696707147271408L, 4193204392725694463L, 4215053018660518963L, 4241163808635564644L, 4254584350247334433L, 4814658433570175913L, 4841947709850912914L, 4904007817188630457L, 5100336081510080343L, 5120543992130540564L, 5274044858141538265L, 5347909877633654828L, 5450448828334921485L, 5474268165959054640L, 5545425291794704408L, 5596129856135573697L, 5688200883751798389L, 5751393439502795295L, 5916409771425455946L, 5944107969236155580L, 6007332606592876737L, 6090377589998869205L, 6280357960959217660L, 6456855723474196908L, 6511035576063254270L, 6534946468240507089L, 6584624952928234050L, 6734240326434096246L, 6742705432718011780L, 6800727078373023163L, 6854854816081053523L, 7045245923763966215L, 7123326897294507060L, 7164889056054194741L, 7179336928365889465L, 7240293012336844478L, 7347653049056829645L, 7375862386996623731L, 7442624256860549330L, 7617522210483516279L, 7658177784286215602L, 8055461369741094911L, 8064026652676081192L, 8389032537095247355L, 8488266005336625107L, 8537233257283452655L, 8735538376409180149L, 8838294710098435315L, 8861402923078831179L, 9140390920032557669L, 9140416208800006522L, 9144212112462101475L};
        long[] hashCodes = new long[AUTO_TYPE_ACCEPT_LIST.length + 1];
        for (int i = 0; i < AUTO_TYPE_ACCEPT_LIST.length; ++i) {
            hashCodes[i] = Fnv.hashCode64(AUTO_TYPE_ACCEPT_LIST[i]);
        }
        hashCodes[hashCodes.length - 1] = -6293031534589903644L;
        Arrays.sort(hashCodes);
        this.acceptHashCodes = hashCodes;
        this.hashCache.put(ObjectArrayReader.TYPE_HASH_CODE, ObjectArrayReader.INSTANCE);
        this.hashCache.put(Fnv.hashCode64(String.class.getName()), ObjectReaderImplString.INSTANCE);
        this.hashCache.put(Fnv.hashCode64(TypeUtils.getTypeName(HashMap.class)), ObjectReaderImplMap.INSTANCE);
        this.creator = creator;
        this.modules.add(new ObjectReaderBaseModule(this));
        this.init();
    }

    void init() {
        for (ObjectReaderModule module : this.modules) {
            module.init(this);
        }
    }

    public Function getTypeConvert(Type from, Type to) {
        Map map = (Map)this.typeConverts.get(from);
        if (map == null) {
            return null;
        }
        return (Function)map.get(to);
    }

    public Function registerTypeConvert(Type from, Type to, Function typeConvert) {
        Map map = (Map)this.typeConverts.get(from);
        if (map == null) {
            this.typeConverts.putIfAbsent(from, new ConcurrentHashMap());
            map = (Map)this.typeConverts.get(from);
        }
        return map.putIfAbsent(to, typeConvert);
    }

    public ObjectReader getObjectReader(long hashCode) {
        int tclHash;
        ConcurrentHashMap tclHashCache;
        Long hashCodeObj = hashCode;
        ObjectReader objectReader = null;
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        if (tcl != null && tcl != JSON.class.getClassLoader() && (tclHashCache = (ConcurrentHashMap)this.tclHashCaches.get(tclHash = System.identityHashCode(tcl))) != null) {
            objectReader = (ObjectReader)tclHashCache.get(hashCodeObj);
        }
        if (objectReader == null) {
            objectReader = (ObjectReader)this.hashCache.get(hashCodeObj);
        }
        return objectReader;
    }

    public ObjectReader getObjectReader(String typeName, Class<?> expectClass, long features) {
        Class<?> autoTypeClass = this.checkAutoType(typeName, expectClass, features);
        if (autoTypeClass == null) {
            return null;
        }
        boolean fieldBased = (features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = this.getObjectReader(autoTypeClass, fieldBased);
        this.registerIfAbsent(Fnv.hashCode64(typeName), objectReader);
        return objectReader;
    }

    public Class<?> checkAutoType(String typeName, Class<?> expectClass, long features) {
        Class clazz;
        int ch;
        int i;
        long hash;
        Class<?> resolvedClass;
        if (typeName == null || typeName.isEmpty()) {
            return null;
        }
        if (this.autoTypeBeforeHandler != null && (resolvedClass = this.autoTypeBeforeHandler.apply(typeName, expectClass, features)) != null) {
            return resolvedClass;
        }
        if (SAFE_MODE) {
            return null;
        }
        int typeNameLength = typeName.length();
        if (typeNameLength >= 192) {
            throw new JSONException("autoType is not support. " + typeName);
        }
        if (typeName.charAt(0) == '[') {
            String componentTypeName = typeName.substring(1);
            this.checkAutoType(componentTypeName, null, features);
        }
        if (expectClass != null && expectClass.getName().equals(typeName)) {
            if (this.autoTypeHandler != null) {
                this.autoTypeHandler.accept(expectClass);
            }
            return expectClass;
        }
        boolean autoTypeSupport = (features & JSONReader.Feature.SupportAutoType.mask) != 0L;
        long BASIC = -3750763034362895579L;
        long PRIME = 1099511628211L;
        if (autoTypeSupport) {
            hash = -3750763034362895579L;
            for (i = 0; i < typeNameLength; ++i) {
                ch = typeName.charAt(i);
                if (ch == 36) {
                    ch = 46;
                }
                hash ^= (long)ch;
                if (Arrays.binarySearch(this.acceptHashCodes, hash *= 1099511628211L) >= 0 && (clazz = TypeUtils.loadClass(typeName)) != null) {
                    if (this.autoTypeHandler != null) {
                        this.autoTypeHandler.accept(expectClass);
                    }
                    return clazz;
                }
                if (Arrays.binarySearch(this.denyHashCodes, hash) < 0 || TypeUtils.getMapping(typeName) != null) continue;
                throw new JSONException("autoType is not support. " + typeName);
            }
        }
        if (!autoTypeSupport) {
            hash = -3750763034362895579L;
            for (i = 0; i < typeNameLength; ++i) {
                ch = typeName.charAt(i);
                if (ch == 36) {
                    ch = 46;
                }
                hash ^= (long)ch;
                if (Arrays.binarySearch(this.denyHashCodes, hash *= 1099511628211L) >= 0) {
                    throw new JSONException("autoType is not support. " + typeName);
                }
                if (Arrays.binarySearch(this.acceptHashCodes, hash) < 0) continue;
                clazz = TypeUtils.loadClass(typeName);
                if (clazz != null && expectClass != null && expectClass.isAssignableFrom(clazz)) {
                    throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
                }
                return clazz;
            }
        }
        if (!autoTypeSupport) {
            return null;
        }
        clazz = TypeUtils.getMapping(typeName);
        if (clazz != null) {
            if (expectClass != null && expectClass != Object.class && clazz != HashMap.class && !expectClass.isAssignableFrom(clazz)) {
                throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
            }
            if (this.autoTypeHandler != null) {
                this.autoTypeHandler.accept(expectClass);
            }
            return clazz;
        }
        clazz = TypeUtils.loadClass(typeName);
        if (clazz != null) {
            if (ClassLoader.class.isAssignableFrom(clazz) || JDKUtils.isSQLDataSourceOrRowSet(clazz)) {
                throw new JSONException("autoType is not support. " + typeName);
            }
            if (expectClass != null) {
                if (expectClass.isAssignableFrom(clazz)) {
                    if (this.autoTypeHandler != null) {
                        this.autoTypeHandler.accept(expectClass);
                    }
                    return clazz;
                }
                throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
            }
        }
        if (this.autoTypeHandler != null) {
            this.autoTypeHandler.accept(expectClass);
        }
        return clazz;
    }

    public List<ObjectReaderModule> getModules() {
        return this.modules;
    }

    public ObjectReader getObjectReader(Type objectType) {
        return this.getObjectReader(objectType, false);
    }

    public ObjectReader getObjectReader(Type objectType, boolean fieldBased) {
        ObjectReader previous;
        ObjectReader boundObjectReader;
        Type bound;
        Type[] bounds;
        ObjectReader objectReader;
        if (objectType == null) {
            objectType = Object.class;
        }
        ObjectReader objectReader2 = objectReader = fieldBased ? (ObjectReader)this.cacheFieldBased.get(objectType) : (ObjectReader)this.cache.get(objectType);
        if (objectReader != null) {
            return objectReader;
        }
        for (ObjectReaderModule module : this.modules) {
            ObjectReader previous2;
            objectReader = module.getObjectReader(this, (Type)objectType);
            if (objectReader == null) continue;
            ObjectReader objectReader3 = previous2 = fieldBased ? this.cacheFieldBased.putIfAbsent((Type)objectType, objectReader) : this.cache.putIfAbsent((Type)objectType, objectReader);
            if (previous2 != null) {
                objectReader = previous2;
            }
            return objectReader;
        }
        if (objectType instanceof TypeVariable && (bounds = ((TypeVariable)objectType).getBounds()).length > 0 && (bound = bounds[0]) instanceof Class && (boundObjectReader = this.getObjectReader(bound, fieldBased)) != null) {
            ObjectReader previous3 = this.getPreviousObjectReader(fieldBased, (Type)objectType, boundObjectReader);
            if (previous3 != null) {
                boundObjectReader = previous3;
            }
            return boundObjectReader;
        }
        if (objectType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)objectType;
            Type rawType = parameterizedType.getRawType();
            Object typeArguments = parameterizedType.getActualTypeArguments();
            if (rawType instanceof Class) {
                ObjectReader rawClassReader;
                Class rawClass = (Class)rawType;
                boolean generic = false;
                for (Class clazz = rawClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
                    if (clazz.getTypeParameters().length <= 0) continue;
                    generic = true;
                    break;
                }
                if (!(((Object)typeArguments).length != 0 && generic || (rawClassReader = this.getObjectReader(rawClass, fieldBased)) == null)) {
                    ObjectReader previous4 = this.getPreviousObjectReader(fieldBased, (Type)objectType, rawClassReader);
                    if (previous4 != null) {
                        rawClassReader = previous4;
                    }
                    return rawClassReader;
                }
            }
        }
        Class<?> objectClass = TypeUtils.getMapping((Type)objectType);
        String className = objectClass.getName();
        if (objectReader == null && !fieldBased) {
            switch (className) {
                case "com.google.common.collect.ArrayListMultimap": {
                    objectReader = ObjectReaderImplMap.of(null, objectClass, 0L);
                    break;
                }
            }
        }
        if (objectReader == null) {
            ObjectReaderCreator creator = this.getCreator();
            objectReader = creator.createObjectReader(objectClass, (Type)objectType, fieldBased, this.modules);
        }
        if ((previous = this.getPreviousObjectReader(fieldBased, (Type)objectType, objectReader)) != null) {
            objectReader = previous;
        }
        return objectReader;
    }

    private ObjectReader getPreviousObjectReader(boolean fieldBased, Type objectType, ObjectReader boundObjectReader) {
        return fieldBased ? this.cacheFieldBased.putIfAbsent(objectType, boundObjectReader) : this.cache.putIfAbsent(objectType, boundObjectReader);
    }

    public JSONReader.AutoTypeBeforeHandler getAutoTypeBeforeHandler() {
        return this.autoTypeBeforeHandler;
    }

    public void setAutoTypeBeforeHandler(JSONReader.AutoTypeBeforeHandler autoTypeBeforeHandler) {
        this.autoTypeBeforeHandler = autoTypeBeforeHandler;
    }

    static {
        Class handlerClass;
        String property = System.getProperty("fastjson2.parser.deny");
        if (property == null) {
            property = JSONFactory.getProperty("fastjson2.parser.deny");
        }
        DENYS = property != null && property.length() > 0 ? property.split(",") : new String[0];
        property = System.getProperty("fastjson2.autoTypeAccept");
        if (property == null) {
            property = JSONFactory.getProperty("fastjson2.autoTypeAccept");
        }
        AUTO_TYPE_ACCEPT_LIST = property != null && property.length() > 0 ? property.split(",") : new String[0];
        property = System.getProperty("fastjson2.autoTypeBeforeHandler");
        if (property == null || property.isEmpty()) {
            property = JSONFactory.getProperty("fastjson2.autoTypeBeforeHandler");
        }
        if (property != null) {
            property = property.trim();
        }
        if (property != null && !property.isEmpty() && (handlerClass = TypeUtils.loadClass(property)) != null) {
            try {
                DEFAULT_AUTO_TYPE_BEFORE_HANDLER = (JSONReader.AutoTypeBeforeHandler)handlerClass.newInstance();
            }
            catch (Exception ignored) {
                DEFAULT_AUTO_TYPE_HANDLER_INIT_ERROR = true;
            }
        }
        if ((property = System.getProperty("fastjson2.autoTypeHandler")) == null || property.isEmpty()) {
            property = JSONFactory.getProperty("fastjson2.autoTypeHandler");
        }
        if (property != null) {
            property = property.trim();
        }
        if (property != null && !property.isEmpty() && (handlerClass = TypeUtils.loadClass(property)) != null) {
            try {
                DEFAULT_AUTO_TYPE_HANDLER = (Consumer)handlerClass.newInstance();
            }
            catch (Exception ignored) {
                DEFAULT_AUTO_TYPE_HANDLER_INIT_ERROR = true;
            }
        }
        if ((property = System.getProperty("fastjson.parser.safeMode")) == null || property.isEmpty()) {
            property = JSONFactory.getProperty("fastjson.parser.safeMode");
        }
        if (property == null || property.isEmpty()) {
            property = System.getProperty("fastjson2.parser.safeMode");
        }
        if (property == null || property.isEmpty()) {
            property = JSONFactory.getProperty("fastjson2.parser.safeMode");
        }
        if (property != null) {
            property = property.trim();
        }
        SAFE_MODE = "true".equals(property);
    }
}

