/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.ParameterizedTypeImpl;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;

public abstract class TypeReference<T> {
    protected final Type type;
    protected final Class<? super T> rawType;

    public TypeReference() {
        Type superClass = this.getClass().getGenericSuperclass();
        this.type = ((ParameterizedType)superClass).getActualTypeArguments()[0];
        this.rawType = BeanUtils.getRawType(this.type);
    }

    public TypeReference(Type type) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.type = BeanUtils.canonicalize(type);
        this.rawType = BeanUtils.getRawType(type);
    }

    public TypeReference(Type[] actualTypeArguments) {
        if (actualTypeArguments == null || actualTypeArguments.length == 0) {
            throw new NullPointerException();
        }
        Class<?> thisClass = this.getClass();
        Type superClass = thisClass.getGenericSuperclass();
        ParameterizedType argType = (ParameterizedType)((ParameterizedType)superClass).getActualTypeArguments()[0];
        this.type = TypeReference.canonicalize(thisClass, argType, actualTypeArguments, 0);
        this.rawType = BeanUtils.getRawType(this.type);
    }

    public final Type getType() {
        return this.type;
    }

    public final Class<? super T> getRawType() {
        return this.rawType;
    }

    public T parseObject(String text) {
        return JSON.parseObject(text, this.type);
    }

    public T parseObject(byte[] utf8Bytes) {
        return JSON.parseObject(utf8Bytes, this.type);
    }

    public List<T> parseArray(String text, JSONReader.Feature ... features) {
        return JSON.parseArray(text, this.type, features);
    }

    public List<T> parseArray(byte[] utf8Bytes, JSONReader.Feature ... features) {
        return JSON.parseArray(utf8Bytes, this.type, features);
    }

    public T to(JSONArray array) {
        return array.to(this.type);
    }

    public T to(JSONObject object, JSONReader.Feature ... features) {
        return object.to(this.type, features);
    }

    @Deprecated
    public T toJavaObject(JSONArray array) {
        return array.to(this.type);
    }

    @Deprecated
    public T toJavaObject(JSONObject object, JSONReader.Feature ... features) {
        return object.to(this.type, features);
    }

    public static TypeReference<?> get(Type type) {
        return new TypeReference<Object>(type){};
    }

    private static Type canonicalize(Class<?> thisClass, ParameterizedType type, Type[] actualTypeArguments, int actualIndex) {
        Type rawType = type.getRawType();
        Type[] argTypes = type.getActualTypeArguments();
        for (int i = 0; i < argTypes.length; ++i) {
            block8: {
                StringBuilder sb;
                block10: {
                    Class cls;
                    block16: {
                        block15: {
                            block14: {
                                block13: {
                                    block12: {
                                        block11: {
                                            block9: {
                                                if (argTypes[i] instanceof TypeVariable && actualIndex < actualTypeArguments.length) {
                                                    argTypes[i] = actualTypeArguments[actualIndex++];
                                                }
                                                if (!(argTypes[i] instanceof GenericArrayType)) break block8;
                                                Type componentType = argTypes[i];
                                                sb = new StringBuilder();
                                                while (componentType instanceof GenericArrayType) {
                                                    sb.append('[');
                                                    componentType = ((GenericArrayType)componentType).getGenericComponentType();
                                                }
                                                if (!(componentType instanceof Class) || !(cls = (Class)componentType).isPrimitive()) break block8;
                                                if (cls != Integer.TYPE) break block9;
                                                sb.append('I');
                                                break block10;
                                            }
                                            if (cls != Long.TYPE) break block11;
                                            sb.append('J');
                                            break block10;
                                        }
                                        if (cls != Float.TYPE) break block12;
                                        sb.append('F');
                                        break block10;
                                    }
                                    if (cls != Double.TYPE) break block13;
                                    sb.append('D');
                                    break block10;
                                }
                                if (cls != Boolean.TYPE) break block14;
                                sb.append('Z');
                                break block10;
                            }
                            if (cls != Character.TYPE) break block15;
                            sb.append('C');
                            break block10;
                        }
                        if (cls != Byte.TYPE) break block16;
                        sb.append('B');
                        break block10;
                    }
                    if (cls != Short.TYPE) break block8;
                    sb.append('S');
                }
                try {
                    argTypes[i] = Class.forName(sb.toString());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (!(argTypes[i] instanceof ParameterizedType)) continue;
            argTypes[i] = TypeReference.canonicalize(thisClass, (ParameterizedType)argTypes[i], actualTypeArguments, actualIndex);
        }
        return new ParameterizedTypeImpl(argTypes, thisClass, rawType);
    }
}

