/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.thrift;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.doris.thrift.TFileFormatType;
import org.apache.doris.thrift.TFileType;
import org.apache.doris.thrift.THdfsParams;
import org.apache.doris.thrift.TUniqueId;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;

public class TBrokerRangeDesc
implements TBase<TBrokerRangeDesc, _Fields>,
Serializable,
Cloneable,
Comparable<TBrokerRangeDesc> {
    private static final TStruct STRUCT_DESC = new TStruct("TBrokerRangeDesc");
    private static final TField FILE_TYPE_FIELD_DESC = new TField("file_type", 8, 1);
    private static final TField FORMAT_TYPE_FIELD_DESC = new TField("format_type", 8, 2);
    private static final TField SPLITTABLE_FIELD_DESC = new TField("splittable", 2, 3);
    private static final TField PATH_FIELD_DESC = new TField("path", 11, 4);
    private static final TField START_OFFSET_FIELD_DESC = new TField("start_offset", 10, 5);
    private static final TField SIZE_FIELD_DESC = new TField("size", 10, 6);
    private static final TField LOAD_ID_FIELD_DESC = new TField("load_id", 12, 7);
    private static final TField FILE_SIZE_FIELD_DESC = new TField("file_size", 10, 8);
    private static final TField NUM_OF_COLUMNS_FROM_FILE_FIELD_DESC = new TField("num_of_columns_from_file", 8, 9);
    private static final TField COLUMNS_FROM_PATH_FIELD_DESC = new TField("columns_from_path", 15, 10);
    private static final TField STRIP_OUTER_ARRAY_FIELD_DESC = new TField("strip_outer_array", 2, 11);
    private static final TField JSONPATHS_FIELD_DESC = new TField("jsonpaths", 11, 12);
    private static final TField JSON_ROOT_FIELD_DESC = new TField("json_root", 11, 13);
    private static final TField NUM_AS_STRING_FIELD_DESC = new TField("num_as_string", 2, 14);
    private static final TField FUZZY_PARSE_FIELD_DESC = new TField("fuzzy_parse", 2, 15);
    private static final TField HDFS_PARAMS_FIELD_DESC = new TField("hdfs_params", 12, 16);
    private static final TField READ_JSON_BY_LINE_FIELD_DESC = new TField("read_json_by_line", 2, 17);
    private static final TField READ_BY_COLUMN_DEF_FIELD_DESC = new TField("read_by_column_def", 2, 18);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TBrokerRangeDescStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TBrokerRangeDescTupleSchemeFactory();
    @Nullable
    public TFileType file_type;
    @Nullable
    public TFileFormatType format_type;
    public boolean splittable;
    @Nullable
    public String path;
    public long start_offset;
    public long size;
    @Nullable
    public TUniqueId load_id;
    public long file_size;
    public int num_of_columns_from_file;
    @Nullable
    public List<String> columns_from_path;
    public boolean strip_outer_array;
    @Nullable
    public String jsonpaths;
    @Nullable
    public String json_root;
    public boolean num_as_string;
    public boolean fuzzy_parse;
    @Nullable
    public THdfsParams hdfs_params;
    public boolean read_json_by_line;
    public boolean read_by_column_def;
    private static final int __SPLITTABLE_ISSET_ID = 0;
    private static final int __START_OFFSET_ISSET_ID = 1;
    private static final int __SIZE_ISSET_ID = 2;
    private static final int __FILE_SIZE_ISSET_ID = 3;
    private static final int __NUM_OF_COLUMNS_FROM_FILE_ISSET_ID = 4;
    private static final int __STRIP_OUTER_ARRAY_ISSET_ID = 5;
    private static final int __NUM_AS_STRING_ISSET_ID = 6;
    private static final int __FUZZY_PARSE_ISSET_ID = 7;
    private static final int __READ_JSON_BY_LINE_ISSET_ID = 8;
    private static final int __READ_BY_COLUMN_DEF_ISSET_ID = 9;
    private short __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.LOAD_ID, _Fields.FILE_SIZE, _Fields.NUM_OF_COLUMNS_FROM_FILE, _Fields.COLUMNS_FROM_PATH, _Fields.STRIP_OUTER_ARRAY, _Fields.JSONPATHS, _Fields.JSON_ROOT, _Fields.NUM_AS_STRING, _Fields.FUZZY_PARSE, _Fields.HDFS_PARAMS, _Fields.READ_JSON_BY_LINE, _Fields.READ_BY_COLUMN_DEF};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TBrokerRangeDesc() {
    }

    public TBrokerRangeDesc(TFileType file_type, TFileFormatType format_type, boolean splittable, String path, long start_offset, long size) {
        this();
        this.file_type = file_type;
        this.format_type = format_type;
        this.splittable = splittable;
        this.setSplittableIsSet(true);
        this.path = path;
        this.start_offset = start_offset;
        this.setStartOffsetIsSet(true);
        this.size = size;
        this.setSizeIsSet(true);
    }

    public TBrokerRangeDesc(TBrokerRangeDesc other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetFileType()) {
            this.file_type = other.file_type;
        }
        if (other.isSetFormatType()) {
            this.format_type = other.format_type;
        }
        this.splittable = other.splittable;
        if (other.isSetPath()) {
            this.path = other.path;
        }
        this.start_offset = other.start_offset;
        this.size = other.size;
        if (other.isSetLoadId()) {
            this.load_id = new TUniqueId(other.load_id);
        }
        this.file_size = other.file_size;
        this.num_of_columns_from_file = other.num_of_columns_from_file;
        if (other.isSetColumnsFromPath()) {
            ArrayList<String> __this__columns_from_path = new ArrayList<String>(other.columns_from_path);
            this.columns_from_path = __this__columns_from_path;
        }
        this.strip_outer_array = other.strip_outer_array;
        if (other.isSetJsonpaths()) {
            this.jsonpaths = other.jsonpaths;
        }
        if (other.isSetJsonRoot()) {
            this.json_root = other.json_root;
        }
        this.num_as_string = other.num_as_string;
        this.fuzzy_parse = other.fuzzy_parse;
        if (other.isSetHdfsParams()) {
            this.hdfs_params = new THdfsParams(other.hdfs_params);
        }
        this.read_json_by_line = other.read_json_by_line;
        this.read_by_column_def = other.read_by_column_def;
    }

    @Override
    public TBrokerRangeDesc deepCopy() {
        return new TBrokerRangeDesc(this);
    }

    @Override
    public void clear() {
        this.file_type = null;
        this.format_type = null;
        this.setSplittableIsSet(false);
        this.splittable = false;
        this.path = null;
        this.setStartOffsetIsSet(false);
        this.start_offset = 0L;
        this.setSizeIsSet(false);
        this.size = 0L;
        this.load_id = null;
        this.setFileSizeIsSet(false);
        this.file_size = 0L;
        this.setNumOfColumnsFromFileIsSet(false);
        this.num_of_columns_from_file = 0;
        this.columns_from_path = null;
        this.setStripOuterArrayIsSet(false);
        this.strip_outer_array = false;
        this.jsonpaths = null;
        this.json_root = null;
        this.setNumAsStringIsSet(false);
        this.num_as_string = false;
        this.setFuzzyParseIsSet(false);
        this.fuzzy_parse = false;
        this.hdfs_params = null;
        this.setReadJsonByLineIsSet(false);
        this.read_json_by_line = false;
        this.setReadByColumnDefIsSet(false);
        this.read_by_column_def = false;
    }

    @Nullable
    public TFileType getFileType() {
        return this.file_type;
    }

    public TBrokerRangeDesc setFileType(@Nullable TFileType file_type) {
        this.file_type = file_type;
        return this;
    }

    public void unsetFileType() {
        this.file_type = null;
    }

    public boolean isSetFileType() {
        return this.file_type != null;
    }

    public void setFileTypeIsSet(boolean value) {
        if (!value) {
            this.file_type = null;
        }
    }

    @Nullable
    public TFileFormatType getFormatType() {
        return this.format_type;
    }

    public TBrokerRangeDesc setFormatType(@Nullable TFileFormatType format_type) {
        this.format_type = format_type;
        return this;
    }

    public void unsetFormatType() {
        this.format_type = null;
    }

    public boolean isSetFormatType() {
        return this.format_type != null;
    }

    public void setFormatTypeIsSet(boolean value) {
        if (!value) {
            this.format_type = null;
        }
    }

    public boolean isSplittable() {
        return this.splittable;
    }

    public TBrokerRangeDesc setSplittable(boolean splittable) {
        this.splittable = splittable;
        this.setSplittableIsSet(true);
        return this;
    }

    public void unsetSplittable() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 0);
    }

    public boolean isSetSplittable() {
        return EncodingUtils.testBit(this.__isset_bitfield, 0);
    }

    public void setSplittableIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 0, value);
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    public TBrokerRangeDesc setPath(@Nullable String path) {
        this.path = path;
        return this;
    }

    public void unsetPath() {
        this.path = null;
    }

    public boolean isSetPath() {
        return this.path != null;
    }

    public void setPathIsSet(boolean value) {
        if (!value) {
            this.path = null;
        }
    }

    public long getStartOffset() {
        return this.start_offset;
    }

    public TBrokerRangeDesc setStartOffset(long start_offset) {
        this.start_offset = start_offset;
        this.setStartOffsetIsSet(true);
        return this;
    }

    public void unsetStartOffset() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 1);
    }

    public boolean isSetStartOffset() {
        return EncodingUtils.testBit(this.__isset_bitfield, 1);
    }

    public void setStartOffsetIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 1, value);
    }

    public long getSize() {
        return this.size;
    }

    public TBrokerRangeDesc setSize(long size) {
        this.size = size;
        this.setSizeIsSet(true);
        return this;
    }

    public void unsetSize() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 2);
    }

    public boolean isSetSize() {
        return EncodingUtils.testBit(this.__isset_bitfield, 2);
    }

    public void setSizeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 2, value);
    }

    @Nullable
    public TUniqueId getLoadId() {
        return this.load_id;
    }

    public TBrokerRangeDesc setLoadId(@Nullable TUniqueId load_id) {
        this.load_id = load_id;
        return this;
    }

    public void unsetLoadId() {
        this.load_id = null;
    }

    public boolean isSetLoadId() {
        return this.load_id != null;
    }

    public void setLoadIdIsSet(boolean value) {
        if (!value) {
            this.load_id = null;
        }
    }

    public long getFileSize() {
        return this.file_size;
    }

    public TBrokerRangeDesc setFileSize(long file_size) {
        this.file_size = file_size;
        this.setFileSizeIsSet(true);
        return this;
    }

    public void unsetFileSize() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 3);
    }

    public boolean isSetFileSize() {
        return EncodingUtils.testBit(this.__isset_bitfield, 3);
    }

    public void setFileSizeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 3, value);
    }

    public int getNumOfColumnsFromFile() {
        return this.num_of_columns_from_file;
    }

    public TBrokerRangeDesc setNumOfColumnsFromFile(int num_of_columns_from_file) {
        this.num_of_columns_from_file = num_of_columns_from_file;
        this.setNumOfColumnsFromFileIsSet(true);
        return this;
    }

    public void unsetNumOfColumnsFromFile() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 4);
    }

    public boolean isSetNumOfColumnsFromFile() {
        return EncodingUtils.testBit(this.__isset_bitfield, 4);
    }

    public void setNumOfColumnsFromFileIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 4, value);
    }

    public int getColumnsFromPathSize() {
        return this.columns_from_path == null ? 0 : this.columns_from_path.size();
    }

    @Nullable
    public Iterator<String> getColumnsFromPathIterator() {
        return this.columns_from_path == null ? null : this.columns_from_path.iterator();
    }

    public void addToColumnsFromPath(String elem) {
        if (this.columns_from_path == null) {
            this.columns_from_path = new ArrayList<String>();
        }
        this.columns_from_path.add(elem);
    }

    @Nullable
    public List<String> getColumnsFromPath() {
        return this.columns_from_path;
    }

    public TBrokerRangeDesc setColumnsFromPath(@Nullable List<String> columns_from_path) {
        this.columns_from_path = columns_from_path;
        return this;
    }

    public void unsetColumnsFromPath() {
        this.columns_from_path = null;
    }

    public boolean isSetColumnsFromPath() {
        return this.columns_from_path != null;
    }

    public void setColumnsFromPathIsSet(boolean value) {
        if (!value) {
            this.columns_from_path = null;
        }
    }

    public boolean isStripOuterArray() {
        return this.strip_outer_array;
    }

    public TBrokerRangeDesc setStripOuterArray(boolean strip_outer_array) {
        this.strip_outer_array = strip_outer_array;
        this.setStripOuterArrayIsSet(true);
        return this;
    }

    public void unsetStripOuterArray() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 5);
    }

    public boolean isSetStripOuterArray() {
        return EncodingUtils.testBit(this.__isset_bitfield, 5);
    }

    public void setStripOuterArrayIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 5, value);
    }

    @Nullable
    public String getJsonpaths() {
        return this.jsonpaths;
    }

    public TBrokerRangeDesc setJsonpaths(@Nullable String jsonpaths) {
        this.jsonpaths = jsonpaths;
        return this;
    }

    public void unsetJsonpaths() {
        this.jsonpaths = null;
    }

    public boolean isSetJsonpaths() {
        return this.jsonpaths != null;
    }

    public void setJsonpathsIsSet(boolean value) {
        if (!value) {
            this.jsonpaths = null;
        }
    }

    @Nullable
    public String getJsonRoot() {
        return this.json_root;
    }

    public TBrokerRangeDesc setJsonRoot(@Nullable String json_root) {
        this.json_root = json_root;
        return this;
    }

    public void unsetJsonRoot() {
        this.json_root = null;
    }

    public boolean isSetJsonRoot() {
        return this.json_root != null;
    }

    public void setJsonRootIsSet(boolean value) {
        if (!value) {
            this.json_root = null;
        }
    }

    public boolean isNumAsString() {
        return this.num_as_string;
    }

    public TBrokerRangeDesc setNumAsString(boolean num_as_string) {
        this.num_as_string = num_as_string;
        this.setNumAsStringIsSet(true);
        return this;
    }

    public void unsetNumAsString() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 6);
    }

    public boolean isSetNumAsString() {
        return EncodingUtils.testBit(this.__isset_bitfield, 6);
    }

    public void setNumAsStringIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 6, value);
    }

    public boolean isFuzzyParse() {
        return this.fuzzy_parse;
    }

    public TBrokerRangeDesc setFuzzyParse(boolean fuzzy_parse) {
        this.fuzzy_parse = fuzzy_parse;
        this.setFuzzyParseIsSet(true);
        return this;
    }

    public void unsetFuzzyParse() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 7);
    }

    public boolean isSetFuzzyParse() {
        return EncodingUtils.testBit(this.__isset_bitfield, 7);
    }

    public void setFuzzyParseIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 7, value);
    }

    @Nullable
    public THdfsParams getHdfsParams() {
        return this.hdfs_params;
    }

    public TBrokerRangeDesc setHdfsParams(@Nullable THdfsParams hdfs_params) {
        this.hdfs_params = hdfs_params;
        return this;
    }

    public void unsetHdfsParams() {
        this.hdfs_params = null;
    }

    public boolean isSetHdfsParams() {
        return this.hdfs_params != null;
    }

    public void setHdfsParamsIsSet(boolean value) {
        if (!value) {
            this.hdfs_params = null;
        }
    }

    public boolean isReadJsonByLine() {
        return this.read_json_by_line;
    }

    public TBrokerRangeDesc setReadJsonByLine(boolean read_json_by_line) {
        this.read_json_by_line = read_json_by_line;
        this.setReadJsonByLineIsSet(true);
        return this;
    }

    public void unsetReadJsonByLine() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 8);
    }

    public boolean isSetReadJsonByLine() {
        return EncodingUtils.testBit(this.__isset_bitfield, 8);
    }

    public void setReadJsonByLineIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 8, value);
    }

    public boolean isReadByColumnDef() {
        return this.read_by_column_def;
    }

    public TBrokerRangeDesc setReadByColumnDef(boolean read_by_column_def) {
        this.read_by_column_def = read_by_column_def;
        this.setReadByColumnDefIsSet(true);
        return this;
    }

    public void unsetReadByColumnDef() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 9);
    }

    public boolean isSetReadByColumnDef() {
        return EncodingUtils.testBit(this.__isset_bitfield, 9);
    }

    public void setReadByColumnDefIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 9, value);
    }

    @Override
    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case FILE_TYPE: {
                if (value == null) {
                    this.unsetFileType();
                    break;
                }
                this.setFileType((TFileType)value);
                break;
            }
            case FORMAT_TYPE: {
                if (value == null) {
                    this.unsetFormatType();
                    break;
                }
                this.setFormatType((TFileFormatType)value);
                break;
            }
            case SPLITTABLE: {
                if (value == null) {
                    this.unsetSplittable();
                    break;
                }
                this.setSplittable((Boolean)value);
                break;
            }
            case PATH: {
                if (value == null) {
                    this.unsetPath();
                    break;
                }
                this.setPath((String)value);
                break;
            }
            case START_OFFSET: {
                if (value == null) {
                    this.unsetStartOffset();
                    break;
                }
                this.setStartOffset((Long)value);
                break;
            }
            case SIZE: {
                if (value == null) {
                    this.unsetSize();
                    break;
                }
                this.setSize((Long)value);
                break;
            }
            case LOAD_ID: {
                if (value == null) {
                    this.unsetLoadId();
                    break;
                }
                this.setLoadId((TUniqueId)value);
                break;
            }
            case FILE_SIZE: {
                if (value == null) {
                    this.unsetFileSize();
                    break;
                }
                this.setFileSize((Long)value);
                break;
            }
            case NUM_OF_COLUMNS_FROM_FILE: {
                if (value == null) {
                    this.unsetNumOfColumnsFromFile();
                    break;
                }
                this.setNumOfColumnsFromFile((Integer)value);
                break;
            }
            case COLUMNS_FROM_PATH: {
                if (value == null) {
                    this.unsetColumnsFromPath();
                    break;
                }
                this.setColumnsFromPath((List)value);
                break;
            }
            case STRIP_OUTER_ARRAY: {
                if (value == null) {
                    this.unsetStripOuterArray();
                    break;
                }
                this.setStripOuterArray((Boolean)value);
                break;
            }
            case JSONPATHS: {
                if (value == null) {
                    this.unsetJsonpaths();
                    break;
                }
                this.setJsonpaths((String)value);
                break;
            }
            case JSON_ROOT: {
                if (value == null) {
                    this.unsetJsonRoot();
                    break;
                }
                this.setJsonRoot((String)value);
                break;
            }
            case NUM_AS_STRING: {
                if (value == null) {
                    this.unsetNumAsString();
                    break;
                }
                this.setNumAsString((Boolean)value);
                break;
            }
            case FUZZY_PARSE: {
                if (value == null) {
                    this.unsetFuzzyParse();
                    break;
                }
                this.setFuzzyParse((Boolean)value);
                break;
            }
            case HDFS_PARAMS: {
                if (value == null) {
                    this.unsetHdfsParams();
                    break;
                }
                this.setHdfsParams((THdfsParams)value);
                break;
            }
            case READ_JSON_BY_LINE: {
                if (value == null) {
                    this.unsetReadJsonByLine();
                    break;
                }
                this.setReadJsonByLine((Boolean)value);
                break;
            }
            case READ_BY_COLUMN_DEF: {
                if (value == null) {
                    this.unsetReadByColumnDef();
                    break;
                }
                this.setReadByColumnDef((Boolean)value);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case FILE_TYPE: {
                return this.getFileType();
            }
            case FORMAT_TYPE: {
                return this.getFormatType();
            }
            case SPLITTABLE: {
                return this.isSplittable();
            }
            case PATH: {
                return this.getPath();
            }
            case START_OFFSET: {
                return this.getStartOffset();
            }
            case SIZE: {
                return this.getSize();
            }
            case LOAD_ID: {
                return this.getLoadId();
            }
            case FILE_SIZE: {
                return this.getFileSize();
            }
            case NUM_OF_COLUMNS_FROM_FILE: {
                return this.getNumOfColumnsFromFile();
            }
            case COLUMNS_FROM_PATH: {
                return this.getColumnsFromPath();
            }
            case STRIP_OUTER_ARRAY: {
                return this.isStripOuterArray();
            }
            case JSONPATHS: {
                return this.getJsonpaths();
            }
            case JSON_ROOT: {
                return this.getJsonRoot();
            }
            case NUM_AS_STRING: {
                return this.isNumAsString();
            }
            case FUZZY_PARSE: {
                return this.isFuzzyParse();
            }
            case HDFS_PARAMS: {
                return this.getHdfsParams();
            }
            case READ_JSON_BY_LINE: {
                return this.isReadJsonByLine();
            }
            case READ_BY_COLUMN_DEF: {
                return this.isReadByColumnDef();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case FILE_TYPE: {
                return this.isSetFileType();
            }
            case FORMAT_TYPE: {
                return this.isSetFormatType();
            }
            case SPLITTABLE: {
                return this.isSetSplittable();
            }
            case PATH: {
                return this.isSetPath();
            }
            case START_OFFSET: {
                return this.isSetStartOffset();
            }
            case SIZE: {
                return this.isSetSize();
            }
            case LOAD_ID: {
                return this.isSetLoadId();
            }
            case FILE_SIZE: {
                return this.isSetFileSize();
            }
            case NUM_OF_COLUMNS_FROM_FILE: {
                return this.isSetNumOfColumnsFromFile();
            }
            case COLUMNS_FROM_PATH: {
                return this.isSetColumnsFromPath();
            }
            case STRIP_OUTER_ARRAY: {
                return this.isSetStripOuterArray();
            }
            case JSONPATHS: {
                return this.isSetJsonpaths();
            }
            case JSON_ROOT: {
                return this.isSetJsonRoot();
            }
            case NUM_AS_STRING: {
                return this.isSetNumAsString();
            }
            case FUZZY_PARSE: {
                return this.isSetFuzzyParse();
            }
            case HDFS_PARAMS: {
                return this.isSetHdfsParams();
            }
            case READ_JSON_BY_LINE: {
                return this.isSetReadJsonByLine();
            }
            case READ_BY_COLUMN_DEF: {
                return this.isSetReadByColumnDef();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TBrokerRangeDesc) {
            return this.equals((TBrokerRangeDesc)that);
        }
        return false;
    }

    public boolean equals(TBrokerRangeDesc that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_file_type = this.isSetFileType();
        boolean that_present_file_type = that.isSetFileType();
        if (this_present_file_type || that_present_file_type) {
            if (!this_present_file_type || !that_present_file_type) {
                return false;
            }
            if (!this.file_type.equals(that.file_type)) {
                return false;
            }
        }
        boolean this_present_format_type = this.isSetFormatType();
        boolean that_present_format_type = that.isSetFormatType();
        if (this_present_format_type || that_present_format_type) {
            if (!this_present_format_type || !that_present_format_type) {
                return false;
            }
            if (!this.format_type.equals(that.format_type)) {
                return false;
            }
        }
        boolean this_present_splittable = true;
        boolean that_present_splittable = true;
        if (this_present_splittable || that_present_splittable) {
            if (!this_present_splittable || !that_present_splittable) {
                return false;
            }
            if (this.splittable != that.splittable) {
                return false;
            }
        }
        boolean this_present_path = this.isSetPath();
        boolean that_present_path = that.isSetPath();
        if (this_present_path || that_present_path) {
            if (!this_present_path || !that_present_path) {
                return false;
            }
            if (!this.path.equals(that.path)) {
                return false;
            }
        }
        boolean this_present_start_offset = true;
        boolean that_present_start_offset = true;
        if (this_present_start_offset || that_present_start_offset) {
            if (!this_present_start_offset || !that_present_start_offset) {
                return false;
            }
            if (this.start_offset != that.start_offset) {
                return false;
            }
        }
        boolean this_present_size = true;
        boolean that_present_size = true;
        if (this_present_size || that_present_size) {
            if (!this_present_size || !that_present_size) {
                return false;
            }
            if (this.size != that.size) {
                return false;
            }
        }
        boolean this_present_load_id = this.isSetLoadId();
        boolean that_present_load_id = that.isSetLoadId();
        if (this_present_load_id || that_present_load_id) {
            if (!this_present_load_id || !that_present_load_id) {
                return false;
            }
            if (!this.load_id.equals(that.load_id)) {
                return false;
            }
        }
        boolean this_present_file_size = this.isSetFileSize();
        boolean that_present_file_size = that.isSetFileSize();
        if (this_present_file_size || that_present_file_size) {
            if (!this_present_file_size || !that_present_file_size) {
                return false;
            }
            if (this.file_size != that.file_size) {
                return false;
            }
        }
        boolean this_present_num_of_columns_from_file = this.isSetNumOfColumnsFromFile();
        boolean that_present_num_of_columns_from_file = that.isSetNumOfColumnsFromFile();
        if (this_present_num_of_columns_from_file || that_present_num_of_columns_from_file) {
            if (!this_present_num_of_columns_from_file || !that_present_num_of_columns_from_file) {
                return false;
            }
            if (this.num_of_columns_from_file != that.num_of_columns_from_file) {
                return false;
            }
        }
        boolean this_present_columns_from_path = this.isSetColumnsFromPath();
        boolean that_present_columns_from_path = that.isSetColumnsFromPath();
        if (this_present_columns_from_path || that_present_columns_from_path) {
            if (!this_present_columns_from_path || !that_present_columns_from_path) {
                return false;
            }
            if (!this.columns_from_path.equals(that.columns_from_path)) {
                return false;
            }
        }
        boolean this_present_strip_outer_array = this.isSetStripOuterArray();
        boolean that_present_strip_outer_array = that.isSetStripOuterArray();
        if (this_present_strip_outer_array || that_present_strip_outer_array) {
            if (!this_present_strip_outer_array || !that_present_strip_outer_array) {
                return false;
            }
            if (this.strip_outer_array != that.strip_outer_array) {
                return false;
            }
        }
        boolean this_present_jsonpaths = this.isSetJsonpaths();
        boolean that_present_jsonpaths = that.isSetJsonpaths();
        if (this_present_jsonpaths || that_present_jsonpaths) {
            if (!this_present_jsonpaths || !that_present_jsonpaths) {
                return false;
            }
            if (!this.jsonpaths.equals(that.jsonpaths)) {
                return false;
            }
        }
        boolean this_present_json_root = this.isSetJsonRoot();
        boolean that_present_json_root = that.isSetJsonRoot();
        if (this_present_json_root || that_present_json_root) {
            if (!this_present_json_root || !that_present_json_root) {
                return false;
            }
            if (!this.json_root.equals(that.json_root)) {
                return false;
            }
        }
        boolean this_present_num_as_string = this.isSetNumAsString();
        boolean that_present_num_as_string = that.isSetNumAsString();
        if (this_present_num_as_string || that_present_num_as_string) {
            if (!this_present_num_as_string || !that_present_num_as_string) {
                return false;
            }
            if (this.num_as_string != that.num_as_string) {
                return false;
            }
        }
        boolean this_present_fuzzy_parse = this.isSetFuzzyParse();
        boolean that_present_fuzzy_parse = that.isSetFuzzyParse();
        if (this_present_fuzzy_parse || that_present_fuzzy_parse) {
            if (!this_present_fuzzy_parse || !that_present_fuzzy_parse) {
                return false;
            }
            if (this.fuzzy_parse != that.fuzzy_parse) {
                return false;
            }
        }
        boolean this_present_hdfs_params = this.isSetHdfsParams();
        boolean that_present_hdfs_params = that.isSetHdfsParams();
        if (this_present_hdfs_params || that_present_hdfs_params) {
            if (!this_present_hdfs_params || !that_present_hdfs_params) {
                return false;
            }
            if (!this.hdfs_params.equals(that.hdfs_params)) {
                return false;
            }
        }
        boolean this_present_read_json_by_line = this.isSetReadJsonByLine();
        boolean that_present_read_json_by_line = that.isSetReadJsonByLine();
        if (this_present_read_json_by_line || that_present_read_json_by_line) {
            if (!this_present_read_json_by_line || !that_present_read_json_by_line) {
                return false;
            }
            if (this.read_json_by_line != that.read_json_by_line) {
                return false;
            }
        }
        boolean this_present_read_by_column_def = this.isSetReadByColumnDef();
        boolean that_present_read_by_column_def = that.isSetReadByColumnDef();
        if (this_present_read_by_column_def || that_present_read_by_column_def) {
            if (!this_present_read_by_column_def || !that_present_read_by_column_def) {
                return false;
            }
            if (this.read_by_column_def != that.read_by_column_def) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetFileType() ? 131071 : 524287);
        if (this.isSetFileType()) {
            hashCode = hashCode * 8191 + this.file_type.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetFormatType() ? 131071 : 524287);
        if (this.isSetFormatType()) {
            hashCode = hashCode * 8191 + this.format_type.getValue();
        }
        hashCode = hashCode * 8191 + (this.splittable ? 131071 : 524287);
        hashCode = hashCode * 8191 + (this.isSetPath() ? 131071 : 524287);
        if (this.isSetPath()) {
            hashCode = hashCode * 8191 + this.path.hashCode();
        }
        hashCode = hashCode * 8191 + TBaseHelper.hashCode(this.start_offset);
        hashCode = hashCode * 8191 + TBaseHelper.hashCode(this.size);
        hashCode = hashCode * 8191 + (this.isSetLoadId() ? 131071 : 524287);
        if (this.isSetLoadId()) {
            hashCode = hashCode * 8191 + this.load_id.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetFileSize() ? 131071 : 524287);
        if (this.isSetFileSize()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode(this.file_size);
        }
        hashCode = hashCode * 8191 + (this.isSetNumOfColumnsFromFile() ? 131071 : 524287);
        if (this.isSetNumOfColumnsFromFile()) {
            hashCode = hashCode * 8191 + this.num_of_columns_from_file;
        }
        hashCode = hashCode * 8191 + (this.isSetColumnsFromPath() ? 131071 : 524287);
        if (this.isSetColumnsFromPath()) {
            hashCode = hashCode * 8191 + this.columns_from_path.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetStripOuterArray() ? 131071 : 524287);
        if (this.isSetStripOuterArray()) {
            hashCode = hashCode * 8191 + (this.strip_outer_array ? 131071 : 524287);
        }
        hashCode = hashCode * 8191 + (this.isSetJsonpaths() ? 131071 : 524287);
        if (this.isSetJsonpaths()) {
            hashCode = hashCode * 8191 + this.jsonpaths.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetJsonRoot() ? 131071 : 524287);
        if (this.isSetJsonRoot()) {
            hashCode = hashCode * 8191 + this.json_root.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetNumAsString() ? 131071 : 524287);
        if (this.isSetNumAsString()) {
            hashCode = hashCode * 8191 + (this.num_as_string ? 131071 : 524287);
        }
        hashCode = hashCode * 8191 + (this.isSetFuzzyParse() ? 131071 : 524287);
        if (this.isSetFuzzyParse()) {
            hashCode = hashCode * 8191 + (this.fuzzy_parse ? 131071 : 524287);
        }
        hashCode = hashCode * 8191 + (this.isSetHdfsParams() ? 131071 : 524287);
        if (this.isSetHdfsParams()) {
            hashCode = hashCode * 8191 + this.hdfs_params.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetReadJsonByLine() ? 131071 : 524287);
        if (this.isSetReadJsonByLine()) {
            hashCode = hashCode * 8191 + (this.read_json_by_line ? 131071 : 524287);
        }
        hashCode = hashCode * 8191 + (this.isSetReadByColumnDef() ? 131071 : 524287);
        if (this.isSetReadByColumnDef()) {
            hashCode = hashCode * 8191 + (this.read_by_column_def ? 131071 : 524287);
        }
        return hashCode;
    }

    @Override
    public int compareTo(TBrokerRangeDesc other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetFileType()).compareTo(other.isSetFileType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFileType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.file_type), (Comparable)((Object)other.file_type))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetFormatType()).compareTo(other.isSetFormatType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFormatType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.format_type), (Comparable)((Object)other.format_type))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSplittable()).compareTo(other.isSetSplittable());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSplittable() && (lastComparison = TBaseHelper.compareTo(this.splittable, other.splittable)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetPath()).compareTo(other.isSetPath());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPath() && (lastComparison = TBaseHelper.compareTo(this.path, other.path)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetStartOffset()).compareTo(other.isSetStartOffset());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetStartOffset() && (lastComparison = TBaseHelper.compareTo(this.start_offset, other.start_offset)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSize()).compareTo(other.isSetSize());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSize() && (lastComparison = TBaseHelper.compareTo(this.size, other.size)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLoadId()).compareTo(other.isSetLoadId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLoadId() && (lastComparison = TBaseHelper.compareTo(this.load_id, other.load_id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetFileSize()).compareTo(other.isSetFileSize());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFileSize() && (lastComparison = TBaseHelper.compareTo(this.file_size, other.file_size)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetNumOfColumnsFromFile()).compareTo(other.isSetNumOfColumnsFromFile());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNumOfColumnsFromFile() && (lastComparison = TBaseHelper.compareTo(this.num_of_columns_from_file, other.num_of_columns_from_file)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumnsFromPath()).compareTo(other.isSetColumnsFromPath());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumnsFromPath() && (lastComparison = TBaseHelper.compareTo(this.columns_from_path, other.columns_from_path)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetStripOuterArray()).compareTo(other.isSetStripOuterArray());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetStripOuterArray() && (lastComparison = TBaseHelper.compareTo(this.strip_outer_array, other.strip_outer_array)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetJsonpaths()).compareTo(other.isSetJsonpaths());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetJsonpaths() && (lastComparison = TBaseHelper.compareTo(this.jsonpaths, other.jsonpaths)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetJsonRoot()).compareTo(other.isSetJsonRoot());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetJsonRoot() && (lastComparison = TBaseHelper.compareTo(this.json_root, other.json_root)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetNumAsString()).compareTo(other.isSetNumAsString());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNumAsString() && (lastComparison = TBaseHelper.compareTo(this.num_as_string, other.num_as_string)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetFuzzyParse()).compareTo(other.isSetFuzzyParse());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFuzzyParse() && (lastComparison = TBaseHelper.compareTo(this.fuzzy_parse, other.fuzzy_parse)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetHdfsParams()).compareTo(other.isSetHdfsParams());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetHdfsParams() && (lastComparison = TBaseHelper.compareTo(this.hdfs_params, other.hdfs_params)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetReadJsonByLine()).compareTo(other.isSetReadJsonByLine());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetReadJsonByLine() && (lastComparison = TBaseHelper.compareTo(this.read_json_by_line, other.read_json_by_line)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetReadByColumnDef()).compareTo(other.isSetReadByColumnDef());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetReadByColumnDef() && (lastComparison = TBaseHelper.compareTo(this.read_by_column_def, other.read_by_column_def)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        TBrokerRangeDesc.scheme(iprot).read(iprot, (TBrokerRangeDesc)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        TBrokerRangeDesc.scheme(oprot).write(oprot, (TBrokerRangeDesc)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TBrokerRangeDesc(");
        boolean first = true;
        sb.append("file_type:");
        if (this.file_type == null) {
            sb.append("null");
        } else {
            sb.append(this.file_type);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("format_type:");
        if (this.format_type == null) {
            sb.append("null");
        } else {
            sb.append(this.format_type);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("splittable:");
        sb.append(this.splittable);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("path:");
        if (this.path == null) {
            sb.append("null");
        } else {
            sb.append(this.path);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("start_offset:");
        sb.append(this.start_offset);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("size:");
        sb.append(this.size);
        first = false;
        if (this.isSetLoadId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("load_id:");
            if (this.load_id == null) {
                sb.append("null");
            } else {
                sb.append(this.load_id);
            }
            first = false;
        }
        if (this.isSetFileSize()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("file_size:");
            sb.append(this.file_size);
            first = false;
        }
        if (this.isSetNumOfColumnsFromFile()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("num_of_columns_from_file:");
            sb.append(this.num_of_columns_from_file);
            first = false;
        }
        if (this.isSetColumnsFromPath()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("columns_from_path:");
            if (this.columns_from_path == null) {
                sb.append("null");
            } else {
                sb.append(this.columns_from_path);
            }
            first = false;
        }
        if (this.isSetStripOuterArray()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("strip_outer_array:");
            sb.append(this.strip_outer_array);
            first = false;
        }
        if (this.isSetJsonpaths()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("jsonpaths:");
            if (this.jsonpaths == null) {
                sb.append("null");
            } else {
                sb.append(this.jsonpaths);
            }
            first = false;
        }
        if (this.isSetJsonRoot()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("json_root:");
            if (this.json_root == null) {
                sb.append("null");
            } else {
                sb.append(this.json_root);
            }
            first = false;
        }
        if (this.isSetNumAsString()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("num_as_string:");
            sb.append(this.num_as_string);
            first = false;
        }
        if (this.isSetFuzzyParse()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("fuzzy_parse:");
            sb.append(this.fuzzy_parse);
            first = false;
        }
        if (this.isSetHdfsParams()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("hdfs_params:");
            if (this.hdfs_params == null) {
                sb.append("null");
            } else {
                sb.append(this.hdfs_params);
            }
            first = false;
        }
        if (this.isSetReadJsonByLine()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("read_json_by_line:");
            sb.append(this.read_json_by_line);
            first = false;
        }
        if (this.isSetReadByColumnDef()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("read_by_column_def:");
            sb.append(this.read_by_column_def);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.file_type == null) {
            throw new TProtocolException("Required field 'file_type' was not present! Struct: " + this.toString());
        }
        if (this.format_type == null) {
            throw new TProtocolException("Required field 'format_type' was not present! Struct: " + this.toString());
        }
        if (this.path == null) {
            throw new TProtocolException("Required field 'path' was not present! Struct: " + this.toString());
        }
        if (this.load_id != null) {
            this.load_id.validate();
        }
        if (this.hdfs_params != null) {
            this.hdfs_params.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.FILE_TYPE, new FieldMetaData("file_type", 1, new EnumMetaData(16, TFileType.class)));
        tmpMap.put(_Fields.FORMAT_TYPE, new FieldMetaData("format_type", 1, new EnumMetaData(16, TFileFormatType.class)));
        tmpMap.put(_Fields.SPLITTABLE, new FieldMetaData("splittable", 1, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.PATH, new FieldMetaData("path", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.START_OFFSET, new FieldMetaData("start_offset", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.SIZE, new FieldMetaData("size", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.LOAD_ID, new FieldMetaData("load_id", 2, new StructMetaData(12, TUniqueId.class)));
        tmpMap.put(_Fields.FILE_SIZE, new FieldMetaData("file_size", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.NUM_OF_COLUMNS_FROM_FILE, new FieldMetaData("num_of_columns_from_file", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.COLUMNS_FROM_PATH, new FieldMetaData("columns_from_path", 2, new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.STRIP_OUTER_ARRAY, new FieldMetaData("strip_outer_array", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.JSONPATHS, new FieldMetaData("jsonpaths", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.JSON_ROOT, new FieldMetaData("json_root", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.NUM_AS_STRING, new FieldMetaData("num_as_string", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.FUZZY_PARSE, new FieldMetaData("fuzzy_parse", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.HDFS_PARAMS, new FieldMetaData("hdfs_params", 2, new StructMetaData(12, THdfsParams.class)));
        tmpMap.put(_Fields.READ_JSON_BY_LINE, new FieldMetaData("read_json_by_line", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.READ_BY_COLUMN_DEF, new FieldMetaData("read_by_column_def", 2, new FieldValueMetaData(2)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TBrokerRangeDesc.class, metaDataMap);
    }

    private static class TBrokerRangeDescTupleScheme
    extends TupleScheme<TBrokerRangeDesc> {
        private TBrokerRangeDescTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, TBrokerRangeDesc struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.file_type.getValue());
            oprot.writeI32(struct.format_type.getValue());
            oprot.writeBool(struct.splittable);
            oprot.writeString(struct.path);
            oprot.writeI64(struct.start_offset);
            oprot.writeI64(struct.size);
            BitSet optionals = new BitSet();
            if (struct.isSetLoadId()) {
                optionals.set(0);
            }
            if (struct.isSetFileSize()) {
                optionals.set(1);
            }
            if (struct.isSetNumOfColumnsFromFile()) {
                optionals.set(2);
            }
            if (struct.isSetColumnsFromPath()) {
                optionals.set(3);
            }
            if (struct.isSetStripOuterArray()) {
                optionals.set(4);
            }
            if (struct.isSetJsonpaths()) {
                optionals.set(5);
            }
            if (struct.isSetJsonRoot()) {
                optionals.set(6);
            }
            if (struct.isSetNumAsString()) {
                optionals.set(7);
            }
            if (struct.isSetFuzzyParse()) {
                optionals.set(8);
            }
            if (struct.isSetHdfsParams()) {
                optionals.set(9);
            }
            if (struct.isSetReadJsonByLine()) {
                optionals.set(10);
            }
            if (struct.isSetReadByColumnDef()) {
                optionals.set(11);
            }
            oprot.writeBitSet(optionals, 12);
            if (struct.isSetLoadId()) {
                struct.load_id.write(oprot);
            }
            if (struct.isSetFileSize()) {
                oprot.writeI64(struct.file_size);
            }
            if (struct.isSetNumOfColumnsFromFile()) {
                oprot.writeI32(struct.num_of_columns_from_file);
            }
            if (struct.isSetColumnsFromPath()) {
                oprot.writeI32(struct.columns_from_path.size());
                for (String _iter28 : struct.columns_from_path) {
                    oprot.writeString(_iter28);
                }
            }
            if (struct.isSetStripOuterArray()) {
                oprot.writeBool(struct.strip_outer_array);
            }
            if (struct.isSetJsonpaths()) {
                oprot.writeString(struct.jsonpaths);
            }
            if (struct.isSetJsonRoot()) {
                oprot.writeString(struct.json_root);
            }
            if (struct.isSetNumAsString()) {
                oprot.writeBool(struct.num_as_string);
            }
            if (struct.isSetFuzzyParse()) {
                oprot.writeBool(struct.fuzzy_parse);
            }
            if (struct.isSetHdfsParams()) {
                struct.hdfs_params.write(oprot);
            }
            if (struct.isSetReadJsonByLine()) {
                oprot.writeBool(struct.read_json_by_line);
            }
            if (struct.isSetReadByColumnDef()) {
                oprot.writeBool(struct.read_by_column_def);
            }
        }

        @Override
        public void read(TProtocol prot, TBrokerRangeDesc struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.file_type = TFileType.findByValue(iprot.readI32());
            struct.setFileTypeIsSet(true);
            struct.format_type = TFileFormatType.findByValue(iprot.readI32());
            struct.setFormatTypeIsSet(true);
            struct.splittable = iprot.readBool();
            struct.setSplittableIsSet(true);
            struct.path = iprot.readString();
            struct.setPathIsSet(true);
            struct.start_offset = iprot.readI64();
            struct.setStartOffsetIsSet(true);
            struct.size = iprot.readI64();
            struct.setSizeIsSet(true);
            BitSet incoming = iprot.readBitSet(12);
            if (incoming.get(0)) {
                struct.load_id = new TUniqueId();
                struct.load_id.read(iprot);
                struct.setLoadIdIsSet(true);
            }
            if (incoming.get(1)) {
                struct.file_size = iprot.readI64();
                struct.setFileSizeIsSet(true);
            }
            if (incoming.get(2)) {
                struct.num_of_columns_from_file = iprot.readI32();
                struct.setNumOfColumnsFromFileIsSet(true);
            }
            if (incoming.get(3)) {
                TList _list29 = new TList(11, iprot.readI32());
                struct.columns_from_path = new ArrayList<String>(_list29.size);
                for (int _i31 = 0; _i31 < _list29.size; ++_i31) {
                    String _elem30 = iprot.readString();
                    struct.columns_from_path.add(_elem30);
                }
                struct.setColumnsFromPathIsSet(true);
            }
            if (incoming.get(4)) {
                struct.strip_outer_array = iprot.readBool();
                struct.setStripOuterArrayIsSet(true);
            }
            if (incoming.get(5)) {
                struct.jsonpaths = iprot.readString();
                struct.setJsonpathsIsSet(true);
            }
            if (incoming.get(6)) {
                struct.json_root = iprot.readString();
                struct.setJsonRootIsSet(true);
            }
            if (incoming.get(7)) {
                struct.num_as_string = iprot.readBool();
                struct.setNumAsStringIsSet(true);
            }
            if (incoming.get(8)) {
                struct.fuzzy_parse = iprot.readBool();
                struct.setFuzzyParseIsSet(true);
            }
            if (incoming.get(9)) {
                struct.hdfs_params = new THdfsParams();
                struct.hdfs_params.read(iprot);
                struct.setHdfsParamsIsSet(true);
            }
            if (incoming.get(10)) {
                struct.read_json_by_line = iprot.readBool();
                struct.setReadJsonByLineIsSet(true);
            }
            if (incoming.get(11)) {
                struct.read_by_column_def = iprot.readBool();
                struct.setReadByColumnDefIsSet(true);
            }
        }
    }

    private static class TBrokerRangeDescTupleSchemeFactory
    implements SchemeFactory {
        private TBrokerRangeDescTupleSchemeFactory() {
        }

        public TBrokerRangeDescTupleScheme getScheme() {
            return new TBrokerRangeDescTupleScheme();
        }
    }

    private static class TBrokerRangeDescStandardScheme
    extends StandardScheme<TBrokerRangeDesc> {
        private TBrokerRangeDescStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, TBrokerRangeDesc struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 8) {
                            struct.file_type = TFileType.findByValue(iprot.readI32());
                            struct.setFileTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 8) {
                            struct.format_type = TFileFormatType.findByValue(iprot.readI32());
                            struct.setFormatTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 2) {
                            struct.splittable = iprot.readBool();
                            struct.setSplittableIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 11) {
                            struct.path = iprot.readString();
                            struct.setPathIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 10) {
                            struct.start_offset = iprot.readI64();
                            struct.setStartOffsetIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 10) {
                            struct.size = iprot.readI64();
                            struct.setSizeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 12) {
                            struct.load_id = new TUniqueId();
                            struct.load_id.read(iprot);
                            struct.setLoadIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 10) {
                            struct.file_size = iprot.readI64();
                            struct.setFileSizeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 8) {
                            struct.num_of_columns_from_file = iprot.readI32();
                            struct.setNumOfColumnsFromFileIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 15) {
                            TList _list24 = iprot.readListBegin();
                            struct.columns_from_path = new ArrayList<String>(_list24.size);
                            for (int _i26 = 0; _i26 < _list24.size; ++_i26) {
                                String _elem25 = iprot.readString();
                                struct.columns_from_path.add(_elem25);
                            }
                            iprot.readListEnd();
                            struct.setColumnsFromPathIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 2) {
                            struct.strip_outer_array = iprot.readBool();
                            struct.setStripOuterArrayIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 11) {
                            struct.jsonpaths = iprot.readString();
                            struct.setJsonpathsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 13: {
                        if (schemeField.type == 11) {
                            struct.json_root = iprot.readString();
                            struct.setJsonRootIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 14: {
                        if (schemeField.type == 2) {
                            struct.num_as_string = iprot.readBool();
                            struct.setNumAsStringIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 15: {
                        if (schemeField.type == 2) {
                            struct.fuzzy_parse = iprot.readBool();
                            struct.setFuzzyParseIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 16: {
                        if (schemeField.type == 12) {
                            struct.hdfs_params = new THdfsParams();
                            struct.hdfs_params.read(iprot);
                            struct.setHdfsParamsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 17: {
                        if (schemeField.type == 2) {
                            struct.read_json_by_line = iprot.readBool();
                            struct.setReadJsonByLineIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 18: {
                        if (schemeField.type == 2) {
                            struct.read_by_column_def = iprot.readBool();
                            struct.setReadByColumnDefIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetSplittable()) {
                throw new TProtocolException("Required field 'splittable' was not found in serialized data! Struct: " + this.toString());
            }
            if (!struct.isSetStartOffset()) {
                throw new TProtocolException("Required field 'start_offset' was not found in serialized data! Struct: " + this.toString());
            }
            if (!struct.isSetSize()) {
                throw new TProtocolException("Required field 'size' was not found in serialized data! Struct: " + this.toString());
            }
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, TBrokerRangeDesc struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.file_type != null) {
                oprot.writeFieldBegin(FILE_TYPE_FIELD_DESC);
                oprot.writeI32(struct.file_type.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.format_type != null) {
                oprot.writeFieldBegin(FORMAT_TYPE_FIELD_DESC);
                oprot.writeI32(struct.format_type.getValue());
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(SPLITTABLE_FIELD_DESC);
            oprot.writeBool(struct.splittable);
            oprot.writeFieldEnd();
            if (struct.path != null) {
                oprot.writeFieldBegin(PATH_FIELD_DESC);
                oprot.writeString(struct.path);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(START_OFFSET_FIELD_DESC);
            oprot.writeI64(struct.start_offset);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(SIZE_FIELD_DESC);
            oprot.writeI64(struct.size);
            oprot.writeFieldEnd();
            if (struct.load_id != null && struct.isSetLoadId()) {
                oprot.writeFieldBegin(LOAD_ID_FIELD_DESC);
                struct.load_id.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.isSetFileSize()) {
                oprot.writeFieldBegin(FILE_SIZE_FIELD_DESC);
                oprot.writeI64(struct.file_size);
                oprot.writeFieldEnd();
            }
            if (struct.isSetNumOfColumnsFromFile()) {
                oprot.writeFieldBegin(NUM_OF_COLUMNS_FROM_FILE_FIELD_DESC);
                oprot.writeI32(struct.num_of_columns_from_file);
                oprot.writeFieldEnd();
            }
            if (struct.columns_from_path != null && struct.isSetColumnsFromPath()) {
                oprot.writeFieldBegin(COLUMNS_FROM_PATH_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.columns_from_path.size()));
                for (String _iter27 : struct.columns_from_path) {
                    oprot.writeString(_iter27);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.isSetStripOuterArray()) {
                oprot.writeFieldBegin(STRIP_OUTER_ARRAY_FIELD_DESC);
                oprot.writeBool(struct.strip_outer_array);
                oprot.writeFieldEnd();
            }
            if (struct.jsonpaths != null && struct.isSetJsonpaths()) {
                oprot.writeFieldBegin(JSONPATHS_FIELD_DESC);
                oprot.writeString(struct.jsonpaths);
                oprot.writeFieldEnd();
            }
            if (struct.json_root != null && struct.isSetJsonRoot()) {
                oprot.writeFieldBegin(JSON_ROOT_FIELD_DESC);
                oprot.writeString(struct.json_root);
                oprot.writeFieldEnd();
            }
            if (struct.isSetNumAsString()) {
                oprot.writeFieldBegin(NUM_AS_STRING_FIELD_DESC);
                oprot.writeBool(struct.num_as_string);
                oprot.writeFieldEnd();
            }
            if (struct.isSetFuzzyParse()) {
                oprot.writeFieldBegin(FUZZY_PARSE_FIELD_DESC);
                oprot.writeBool(struct.fuzzy_parse);
                oprot.writeFieldEnd();
            }
            if (struct.hdfs_params != null && struct.isSetHdfsParams()) {
                oprot.writeFieldBegin(HDFS_PARAMS_FIELD_DESC);
                struct.hdfs_params.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.isSetReadJsonByLine()) {
                oprot.writeFieldBegin(READ_JSON_BY_LINE_FIELD_DESC);
                oprot.writeBool(struct.read_json_by_line);
                oprot.writeFieldEnd();
            }
            if (struct.isSetReadByColumnDef()) {
                oprot.writeFieldBegin(READ_BY_COLUMN_DEF_FIELD_DESC);
                oprot.writeBool(struct.read_by_column_def);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TBrokerRangeDescStandardSchemeFactory
    implements SchemeFactory {
        private TBrokerRangeDescStandardSchemeFactory() {
        }

        public TBrokerRangeDescStandardScheme getScheme() {
            return new TBrokerRangeDescStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        FILE_TYPE(1, "file_type"),
        FORMAT_TYPE(2, "format_type"),
        SPLITTABLE(3, "splittable"),
        PATH(4, "path"),
        START_OFFSET(5, "start_offset"),
        SIZE(6, "size"),
        LOAD_ID(7, "load_id"),
        FILE_SIZE(8, "file_size"),
        NUM_OF_COLUMNS_FROM_FILE(9, "num_of_columns_from_file"),
        COLUMNS_FROM_PATH(10, "columns_from_path"),
        STRIP_OUTER_ARRAY(11, "strip_outer_array"),
        JSONPATHS(12, "jsonpaths"),
        JSON_ROOT(13, "json_root"),
        NUM_AS_STRING(14, "num_as_string"),
        FUZZY_PARSE(15, "fuzzy_parse"),
        HDFS_PARAMS(16, "hdfs_params"),
        READ_JSON_BY_LINE(17, "read_json_by_line"),
        READ_BY_COLUMN_DEF(18, "read_by_column_def");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return FILE_TYPE;
                }
                case 2: {
                    return FORMAT_TYPE;
                }
                case 3: {
                    return SPLITTABLE;
                }
                case 4: {
                    return PATH;
                }
                case 5: {
                    return START_OFFSET;
                }
                case 6: {
                    return SIZE;
                }
                case 7: {
                    return LOAD_ID;
                }
                case 8: {
                    return FILE_SIZE;
                }
                case 9: {
                    return NUM_OF_COLUMNS_FROM_FILE;
                }
                case 10: {
                    return COLUMNS_FROM_PATH;
                }
                case 11: {
                    return STRIP_OUTER_ARRAY;
                }
                case 12: {
                    return JSONPATHS;
                }
                case 13: {
                    return JSON_ROOT;
                }
                case 14: {
                    return NUM_AS_STRING;
                }
                case 15: {
                    return FUZZY_PARSE;
                }
                case 16: {
                    return HDFS_PARAMS;
                }
                case 17: {
                    return READ_JSON_BY_LINE;
                }
                case 18: {
                    return READ_BY_COLUMN_DEF;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

