/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2.dpp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.doris.load.loadv2.dpp.RollupTreeBuilder;
import org.apache.doris.load.loadv2.dpp.RollupTreeNode;
import org.apache.doris.load.loadv2.etl.EtlJobConfig;

public class MinimumCoverageRollupTreeBuilder
implements RollupTreeBuilder {
    @Override
    public RollupTreeNode build(EtlJobConfig.EtlTable tableMeta) {
        List<EtlJobConfig.EtlIndex> indexes = tableMeta.indexes;
        ArrayList<EtlJobConfig.EtlIndex> indexMetas = new ArrayList<EtlJobConfig.EtlIndex>();
        EtlJobConfig.EtlIndex baseIndex = null;
        for (EtlJobConfig.EtlIndex indexMeta : indexes) {
            if (indexMeta.isBaseIndex) {
                baseIndex = indexMeta;
                continue;
            }
            indexMetas.add(indexMeta);
        }
        List<EtlJobConfig.EtlColumn> baseIndexColumns = baseIndex.columns;
        ArrayList<String> baseKeyColumns = new ArrayList<String>();
        ArrayList<String> baseValueColumns = new ArrayList<String>();
        for (EtlJobConfig.EtlColumn columnMeta : baseIndexColumns) {
            if (columnMeta.isKey) {
                baseKeyColumns.add(columnMeta.columnName);
                continue;
            }
            baseValueColumns.add(columnMeta.columnName);
        }
        RollupTreeNode root = new RollupTreeNode();
        root.parent = null;
        root.keyColumnNames = baseKeyColumns;
        root.valueColumnNames = baseValueColumns;
        root.indexId = baseIndex.indexId;
        root.indexMeta = baseIndex;
        Collections.sort(indexMetas, new EtlJobConfig.EtlIndexComparator().reversed());
        for (int i = 0; i < indexMetas.size(); ++i) {
            ArrayList<String> keyColumns = new ArrayList<String>();
            ArrayList<String> valueColumns = new ArrayList<String>();
            for (EtlJobConfig.EtlColumn column : ((EtlJobConfig.EtlIndex)indexMetas.get((int)i)).columns) {
                if (column.isKey) {
                    keyColumns.add(column.columnName);
                    continue;
                }
                valueColumns.add(column.columnName);
            }
            if (this.insertIndex(root, (EtlJobConfig.EtlIndex)indexMetas.get(i), keyColumns, valueColumns)) continue;
            throw new RuntimeException(String.format("can't find a parent rollup for rollup %s, rollup tree is %s", ((EtlJobConfig.EtlIndex)indexMetas.get(i)).toString(), root.toString()));
        }
        return root;
    }

    private boolean insertIndex(RollupTreeNode root, EtlJobConfig.EtlIndex indexMeta, List<String> keyColumns, List<String> valueColumns) {
        if (root.children != null) {
            for (int i = root.children.size() - 1; i >= 0; --i) {
                if (!this.insertIndex(root.children.get(i), indexMeta, keyColumns, valueColumns)) continue;
                return true;
            }
        }
        if (root.keyColumnNames.containsAll(keyColumns) && root.valueColumnNames.containsAll(valueColumns)) {
            if (root.children == null) {
                root.children = new ArrayList<RollupTreeNode>();
            }
            RollupTreeNode newChild = new RollupTreeNode();
            newChild.keyColumnNames = keyColumns;
            newChild.valueColumnNames = valueColumns;
            newChild.indexMeta = indexMeta;
            newChild.indexId = indexMeta.indexId;
            newChild.parent = root;
            newChild.level = root.level + 1;
            root.children.add(newChild);
            return true;
        }
        return false;
    }
}

