/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.io;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.doris.common.io.IOUtils;

public class OutputBuffer
extends FilterOutputStream {
    private Buffer buffer;

    public OutputBuffer() {
        this(new Buffer());
    }

    private OutputBuffer(Buffer buffer) {
        super(buffer);
        this.buffer = buffer;
    }

    public byte[] getData() {
        return this.buffer.getData();
    }

    public int getLength() {
        return this.buffer.getLength();
    }

    public OutputBuffer reset() {
        this.buffer.reset();
        return this;
    }

    public void write(InputStream in, int length) throws IOException {
        this.buffer.write(in, length);
    }

    private static class Buffer
    extends ByteArrayOutputStream {
        private Buffer() {
        }

        public byte[] getData() {
            return this.buf;
        }

        public int getLength() {
            return this.count;
        }

        @Override
        public void reset() {
            this.count = 0;
        }

        public void write(InputStream in, int len) throws IOException {
            int newcount = this.count + len;
            if (newcount > this.buf.length) {
                byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
                System.arraycopy(this.buf, 0, newbuf, 0, this.count);
                this.buf = newbuf;
            }
            IOUtils.readFully(in, this.buf, this.count, len);
            this.count = newcount;
        }
    }
}

