/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.codec.binary.StringUtils;

public class Hll {
    public static final byte HLL_DATA_EMPTY = 0;
    public static final byte HLL_DATA_EXPLICIT = 1;
    public static final byte HLL_DATA_SPARSE = 2;
    public static final byte HLL_DATA_FULL = 3;
    public static final int HLL_COLUMN_PRECISION = 14;
    public static final int HLL_ZERO_COUNT_BITS = 50;
    public static final int HLL_EXPLICLIT_INT64_NUM = 160;
    public static final int HLL_SPARSE_THRESHOLD = 4096;
    public static final int HLL_REGISTERS_COUNT = 16384;
    private int type = 0;
    private Set<Long> hashSet = new HashSet<Long>();
    private byte[] registers;
    public static final long M64 = -4132994306676758123L;
    public static final int R64 = 47;
    public static final int SEED = -1379386599;

    private void convertExplicitToRegister() {
        assert (this.type == 1);
        this.registers = new byte[16384];
        for (Long value : this.hashSet) {
            this.updateRegisters(value);
        }
        this.hashSet.clear();
    }

    private void updateRegisters(long hashValue) {
        int idx;
        if (hashValue < 0L) {
            BigInteger unint64HashValue = new BigInteger(Long.toUnsignedString(hashValue));
            unint64HashValue = unint64HashValue.mod(new BigInteger(Long.toUnsignedString(16384L)));
            idx = unint64HashValue.intValue();
        } else {
            idx = (int)(hashValue % 16384L);
        }
        hashValue >>>= 14;
        byte firstOneBit = (byte)(Hll.getLongTailZeroNum(hashValue |= 0x4000000000000L) + 1);
        this.registers[idx] = this.registers[idx] > firstOneBit ? this.registers[idx] : firstOneBit;
    }

    private void mergeRegisters(byte[] other) {
        for (int i = 0; i < 16384; ++i) {
            this.registers[i] = this.registers[i] > other[i] ? this.registers[i] : other[i];
        }
    }

    public static byte getLongTailZeroNum(long hashValue) {
        if (hashValue == 0L) {
            return 0;
        }
        long value = 1L;
        byte idx = 0;
        while (true) {
            if ((value & hashValue) != 0L) {
                return idx;
            }
            value <<= 1;
            if (idx == 62) break;
            idx = (byte)(idx + 1);
        }
        return idx;
    }

    public void updateWithHash(Object value) {
        byte[] v = StringUtils.getBytesUtf8((String)String.valueOf(value));
        this.update(Hll.hash64(v, v.length, -1379386599));
    }

    public void update(long hashValue) {
        switch (this.type) {
            case 0: {
                this.hashSet.add(hashValue);
                this.type = 1;
                break;
            }
            case 1: {
                if (this.hashSet.size() < 160) {
                    this.hashSet.add(hashValue);
                    break;
                }
                this.convertExplicitToRegister();
                this.type = 3;
            }
            case 2: 
            case 3: {
                this.updateRegisters(hashValue);
            }
        }
    }

    public void merge(Hll other) {
        block19: {
            if (other.type == 0) {
                return;
            }
            switch (this.type) {
                case 0: {
                    this.type = other.type;
                    switch (other.type) {
                        case 1: {
                            this.hashSet.addAll(other.hashSet);
                            break;
                        }
                        case 2: 
                        case 3: {
                            this.registers = new byte[16384];
                            System.arraycopy(other.registers, 0, this.registers, 0, 16384);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (other.type) {
                        case 1: {
                            this.hashSet.addAll(other.hashSet);
                            if (this.hashSet.size() <= 160) break;
                            this.convertExplicitToRegister();
                            this.type = 3;
                            break;
                        }
                        case 2: 
                        case 3: {
                            this.convertExplicitToRegister();
                            this.mergeRegisters(other.registers);
                            this.type = 3;
                        }
                    }
                    break;
                }
                case 2: 
                case 3: {
                    switch (other.type) {
                        case 1: {
                            for (long value : other.hashSet) {
                                this.update(value);
                            }
                            break block19;
                        }
                        case 2: 
                        case 3: {
                            this.mergeRegisters(other.registers);
                        }
                    }
                }
            }
        }
    }

    public void serialize(DataOutput output) throws IOException {
        switch (this.type) {
            case 0: {
                output.writeByte(this.type);
                break;
            }
            case 1: {
                output.writeByte(this.type);
                output.writeByte(this.hashSet.size());
                for (long value : this.hashSet) {
                    output.writeLong(Long.reverseBytes(value));
                }
                break;
            }
            case 2: 
            case 3: {
                int i;
                int nonZeroRegisterNum = 0;
                for (i = 0; i < 16384; ++i) {
                    if (this.registers[i] == 0) continue;
                    ++nonZeroRegisterNum;
                }
                if (nonZeroRegisterNum > 4096) {
                    output.writeByte(3);
                    for (byte value : this.registers) {
                        output.writeByte(value);
                    }
                } else {
                    output.writeByte(2);
                    output.writeInt(Integer.reverseBytes(nonZeroRegisterNum));
                    for (i = 0; i < 16384; ++i) {
                        if (this.registers[i] == 0) continue;
                        output.writeShort(Short.reverseBytes((short)i));
                        output.writeByte(this.registers[i]);
                    }
                }
                break;
            }
        }
    }

    public boolean deserialize(DataInput input) throws IOException {
        assert (this.type == 0);
        if (input == null) {
            return false;
        }
        this.type = input.readByte();
        switch (this.type) {
            case 0: {
                break;
            }
            case 1: {
                int hashSetSize = input.readUnsignedByte();
                for (int i = 0; i < hashSetSize; ++i) {
                    this.update(Long.reverseBytes(input.readLong()));
                }
                assert (this.type == 1);
                break;
            }
            case 2: {
                int sparseDataSize = Integer.reverseBytes(input.readInt());
                this.registers = new byte[16384];
                for (int i = 0; i < sparseDataSize; ++i) {
                    byte value;
                    short idx = Short.reverseBytes(input.readShort());
                    this.registers[idx] = value = input.readByte();
                }
                break;
            }
            case 3: {
                this.registers = new byte[16384];
                for (int i = 0; i < 16384; ++i) {
                    this.registers[i] = input.readByte();
                }
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public strictfp long estimateCardinality() {
        if (this.type == 0) {
            return 0L;
        }
        if (this.type == 1) {
            return this.hashSet.size();
        }
        int numStreams = 16384;
        float alpha = 0.0f;
        alpha = numStreams == 16 ? 0.673f : (numStreams == 32 ? 0.697f : (numStreams == 64 ? 0.709f : 0.7213f / (1.0f + 1.079f / (float)numStreams)));
        float harmonicMean = 0.0f;
        int numZeroRegisters = 0;
        for (int i = 0; i < 16384; ++i) {
            harmonicMean = (float)((double)harmonicMean + Math.pow(2.0, -this.registers[i]));
            if (this.registers[i] != 0) continue;
            ++numZeroRegisters;
        }
        double estimate = alpha * (float)numStreams * (float)numStreams * (harmonicMean = 1.0f / harmonicMean);
        if (estimate <= (double)numStreams * 2.5 && numZeroRegisters != 0) {
            estimate = (double)numStreams * Math.log((float)numStreams / (float)numZeroRegisters);
        } else if (numStreams == 16384 && estimate < 72000.0) {
            double bias = 5.911900000000001E-18 * (estimate * estimate * estimate * estimate) - 1.4253E-12 * (estimate * estimate * estimate) + 1.294E-7 * (estimate * estimate) - 0.0052921 * estimate + 83.3216;
            estimate -= estimate * (bias / 100.0);
        }
        return (long)(estimate + 0.5);
    }

    public int maxSerializedSize() {
        switch (this.type) {
            default: {
                return 1;
            }
            case 1: {
                return 2 + this.hashSet.size() * 8;
            }
            case 2: 
            case 3: 
        }
        return 16385;
    }

    private static long getLittleEndianLong(byte[] data, int index) {
        return (long)data[index] & 0xFFL | ((long)data[index + 1] & 0xFFL) << 8 | ((long)data[index + 2] & 0xFFL) << 16 | ((long)data[index + 3] & 0xFFL) << 24 | ((long)data[index + 4] & 0xFFL) << 32 | ((long)data[index + 5] & 0xFFL) << 40 | ((long)data[index + 6] & 0xFFL) << 48 | ((long)data[index + 7] & 0xFFL) << 56;
    }

    public static long hash64(byte[] data, int length, int seed) {
        long h2 = (long)seed & 0xFFFFFFFFL ^ (long)length * -4132994306676758123L;
        int nblocks = length >> 3;
        for (int i = 0; i < nblocks; ++i) {
            int index = i << 3;
            long k = Hll.getLittleEndianLong(data, index);
            k *= -4132994306676758123L;
            k ^= k >>> 47;
            h2 ^= (k *= -4132994306676758123L);
            h2 *= -4132994306676758123L;
        }
        int index = nblocks << 3;
        switch (length - index) {
            case 7: {
                h2 ^= ((long)data[index + 6] & 0xFFL) << 48;
            }
            case 6: {
                h2 ^= ((long)data[index + 5] & 0xFFL) << 40;
            }
            case 5: {
                h2 ^= ((long)data[index + 4] & 0xFFL) << 32;
            }
            case 4: {
                h2 ^= ((long)data[index + 3] & 0xFFL) << 24;
            }
            case 3: {
                h2 ^= ((long)data[index + 2] & 0xFFL) << 16;
            }
            case 2: {
                h2 ^= ((long)data[index + 1] & 0xFFL) << 8;
            }
            case 1: {
                h2 ^= (long)data[index] & 0xFFL;
                h2 *= -4132994306676758123L;
            }
        }
        h2 ^= h2 >>> 47;
        h2 *= -4132994306676758123L;
        h2 ^= h2 >>> 47;
        return h2;
    }

    public int getType() {
        return this.type;
    }
}

