---
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
# 
#   http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

home: true
heroImage: /images/home/banner-stats.png
heroBgImage: /images/home/hero-bg.png
heroText:
  - Welcome to 
  - Apache Doris
tagline: A fast MPP database for all modern analytics on big data.
structure: 
  title: Apache Doris 
  subTitle: 
  descriptions: 
    - Apache Doris is a modern MPP analytical database product. It can provide sub-second queries and efficient real-time data analysis. With it's distributed architecture, up to 10PB level datasets will be well supported and easy to operate.
    - Apache Doris can meet various data analysis demands, including history data reports, real-time data analysis, interactive data analysis, and exploratory data analysis. Make your data analysis easier!
  image: /images/home/structure-fresh.png
  actionText: Learn More
  actionLink: /en/getting-started/basic-usage
features:
  title: Apache Doris Core Features
  subTitle: 
  list: 
    - title: Modern MPP architecture
      icon: /images/home/struct.png
    - title: Getting result of a query within one second
      icon: /images/home/clock.png
    - title: Support standard SQL language, compatible with MySQL protocol
      icon: /images/home/sql.png
    - title: Vectorized SQL executor
      icon: /images/home/program.png
    - title: Effective data model for aggregation
      icon: /images/home/aggr.png
    - title: Rollup，novel pre-computation mechanism
      icon: /images/home/rollup.png
    - title: High performance, high availability, high reliability
      icon: /images/home/cpu.png
    - title: easy for operation，Elastic data warehouse for big data
      icon: /images/home/dev.png
cases:
  title: Apache Doris Users
  subTitle: 
  list:
    - logo: /images/home/logo-meituan.png
      alt: 美团
    - logo: /images/home/logo-xiaomi.png
      alt: 小米
    - logo: /images/home/logo-jd.png
      alt: 京东
    - logo: /images/home/logo-huawei.png
      alt: 华为
    - logo: /images/home/logo-baidu.png
      alt: 百度
    - logo: /images/home/logo-weibo.png
      alt: 新浪微博
    - logo: /images/home/logo-zuoyebang.png
      alt: 作业帮
    - logo: /images/home/logo-vipkid.png
      alt: Vipkid
    - logo: /images/home/logo-360.png
      alt: 360
    - logo: /images/home/logo-shopee.png
      alt: Shopee
    - logo: /images/home/logo-tantan.png
      alt: 探探
    - logo: /images/home/logo-kuaishou.png
      alt: 快手
    - logo: /images/home/logo-sohu.png
      alt: 搜狐
    - logo: /images/home/logo-yidian.png
      alt: 一点资讯
    - logo: /images/home/logo-dingdong.png
      alt: 叮咚买菜
    - logo: /images/home/logo-youdao.png
      alt: 有道
actionText: Quick Start →
actionLink: /en/installing/compilation
---
