/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.dolphinscheduler.common.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;

public enum StateEventType {

    PROCESS_STATE_CHANGE(0, "process state change"),
    TASK_STATE_CHANGE(1, "task state change"),
    PROCESS_TIMEOUT(2, "process timeout"),
    TASK_TIMEOUT(3, "task timeout"),
    WAKE_UP_TASK_GROUP(4, "wait task group"),
    TASK_RETRY(5, "task retry"),
    PROCESS_BLOCKED(6, "process blocked"),
    PROCESS_SUBMIT_FAILED(7, "process submit failed");

    StateEventType(int code, String descp) {
        this.code = code;
        this.descp = descp;
    }

    @EnumValue
    private final int code;
    private final String descp;

    public int getCode() {
        return code;
    }

    public String getDescp() {
        return descp;
    }
}
