# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

"""Init Side package, Side package keep object related to DolphinScheduler but not in the Core part."""

from pydolphinscheduler.models.project import Project
from pydolphinscheduler.models.queue import Queue
from pydolphinscheduler.models.tenant import Tenant
from pydolphinscheduler.models.user import User
from pydolphinscheduler.models.worker_group import WorkerGroup

__all__ = [
    "Project",
    "Tenant",
    "User",
    "Queue",
    "WorkerGroup",
]
