# Have Questions?

## StackOverflow

For usage questions, it is recommended you use the StackOverflow tag [apache-dolphinscheduler](https://stackoverflow.com/questions/tagged/apache-dolphinscheduler) as it is an active forum for DolphinScheduler users’ questions and answers.

Some quick tips when using StackOverflow:

- Prior to asking submitting questions, please:
  - Search StackOverflow’s [apache-dolphinscheduler](https://stackoverflow.com/questions/tagged/apache-dolphinscheduler) tag to see if your question has already been answered
- Please follow the StackOverflow [code of conduct](https://stackoverflow.com/help/how-to-ask)
- Always use the apache-dolphinscheduler tag when asking questions
- Please do not cross-post between [StackOverflow](https://stackoverflow.com/questions/tagged/apache-dolphinscheduler) and [GitHub issues](https://github.com/apache/dolphinscheduler/issues/new/choose)

Question template:

> **Describe the question**
>
> A clear and concise description of what the question is.
>
> **Which version of DolphinScheduler:**
>
>  -[1.3.0-preview]
>
> **Additional context**
>
> Add any other context about the problem here.
>
> **Requirement or improvement**
>
> \- Please describe about your requirements or improvement suggestions.

For broad, opinion based, ask for external resources, debug issues, bugs, contributing to the project, and scenarios, it is recommended you use the[ GitHub issues ](https://github.com/apache/dolphinscheduler/issues/new/choose)or dev@dolphinscheduler.apache.org mailing list.

## Mailing Lists

- [dev@dolphinscheduler.apache.org](https://lists.apache.org/list.html?dev@dolphinscheduler.apache.org) is for people who want to contribute code to DolphinScheduler. [(subscribe)](mailto:dev-subscribe@dolphinscheduler.apache.org?subject=(send%20this%20email%20to%20subscribe)) [(unsubscribe)](mailto:dev-unsubscribe@dolphinscheduler.apache.org?subject=(send%20this%20email%20to%20unsubscribe)) [(archives)](http://lists.apache.org/list.html?dev@dolphinscheduler.apache.org)

Some quick tips when using email:

- Prior to asking submitting questions, please:
  - Search StackOverflow at [apache-dolphinscheduler](https://stackoverflow.com/questions/tagged/apache-dolphinscheduler) to see if your question has already been answered

- Tagging the subject line of your email will help you get a faster response, e.g. [api-server]: How to get open api interface?

- Tags may help identify a topic by:
  - Component: MasterServer,ApiServer,WorkerServer,AlertServer, etc
  - Level: Beginner, Intermediate, Advanced
  - Scenario: Debug, How-to

- For error logs or long code examples, please use [GitHub gist](https://gist.github.com/) and include only a few lines of the pertinent code / log within the email.

## Chat Rooms

Chat rooms are great for quick questions or discussions on specialized topics. 

The following chat rooms are officially part of Apache DolphinScheduler:

​	The Slack workspace URL: http://asf-dolphinscheduler.slack.com/.

​	You can join through invitation url: https://s.apache.org/dolphinscheduler-slack. 

This chat room is used for questions and discussions related to using DolphinScheduler.

 