/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao;

import java.util.Objects;
import org.apache.dolphinscheduler.dao.entity.PluginDefine;
import org.apache.dolphinscheduler.dao.mapper.PluginDefineMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PluginDao {
    @Autowired
    private PluginDefineMapper pluginDefineMapper;

    public boolean checkPluginDefineTableExist() {
        return this.pluginDefineMapper.checkTableExist() > 0;
    }

    public int addPluginDefine(PluginDefine pluginDefine) {
        return this.pluginDefineMapper.insert(pluginDefine);
    }

    public int addOrUpdatePluginDefine(PluginDefine pluginDefine) {
        Objects.requireNonNull(pluginDefine, "pluginDefine is null");
        Objects.requireNonNull(pluginDefine.getPluginName(), "pluginName is null");
        Objects.requireNonNull(pluginDefine.getPluginType(), "pluginType is null");
        PluginDefine currPluginDefine = this.pluginDefineMapper.queryByNameAndType(pluginDefine.getPluginName(), pluginDefine.getPluginType());
        if (currPluginDefine == null) {
            if (this.pluginDefineMapper.insert(pluginDefine) == 1 && pluginDefine.getId() > 0) {
                return pluginDefine.getId();
            }
            throw new IllegalStateException("Failed to insert plugin definition");
        }
        if (!currPluginDefine.getPluginParams().equals(pluginDefine.getPluginParams())) {
            currPluginDefine.setUpdateTime(pluginDefine.getUpdateTime());
            currPluginDefine.setPluginParams(pluginDefine.getPluginParams());
            this.pluginDefineMapper.updateById(currPluginDefine);
        }
        return currPluginDefine.getId();
    }

    public PluginDefine getPluginDefineById(int pluginDefineId) {
        return (PluginDefine)this.pluginDefineMapper.selectById(Integer.valueOf(pluginDefineId));
    }

    public PluginDefineMapper getPluginDefineMapper() {
        return this.pluginDefineMapper;
    }

    public void setPluginDefineMapper(PluginDefineMapper pluginDefineMapper) {
        this.pluginDefineMapper = pluginDefineMapper;
    }
}

