/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Joiner;
import com.google.common.io.Files;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.api.dto.resources.filter.ResourceFilter;
import org.apache.dolphinscheduler.api.dto.resources.visitor.ResourceTreeVisitor;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.ResourcesService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.FileUtils;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.RegexUtils;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.ProgramType;
import org.apache.dolphinscheduler.common.utils.HadoopUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.dao.entity.Resource;
import org.apache.dolphinscheduler.dao.entity.ResourcesUser;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.UdfFunc;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ResourceMapper;
import org.apache.dolphinscheduler.dao.mapper.ResourceUserMapper;
import org.apache.dolphinscheduler.dao.mapper.TenantMapper;
import org.apache.dolphinscheduler.dao.mapper.UdfFuncMapper;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.apache.dolphinscheduler.dao.utils.ResourceProcessDefinitionUtils;
import org.apache.dolphinscheduler.spi.enums.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ResourcesServiceImpl
extends BaseServiceImpl
implements ResourcesService {
    private static final Logger logger = LoggerFactory.getLogger(ResourcesServiceImpl.class);
    @Autowired
    private ResourceMapper resourcesMapper;
    @Autowired
    private UdfFuncMapper udfFunctionMapper;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private ResourceUserMapper resourceUserMapper;
    @Autowired
    private ProcessDefinitionMapper processDefinitionMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<Object> createDirectory(User loginUser, String name, String description, ResourceType type, int pid, String currentDir) {
        Result<Object> result = this.checkResourceUploadStartupState();
        if (!result.getCode().equals(Status.SUCCESS.getCode())) {
            return result;
        }
        if (org.apache.dolphinscheduler.common.utils.FileUtils.directoryTraversal((String)name)) {
            this.putMsg((Result)result, Status.VERIFY_PARAMETER_NAME_FAILED, new Object[0]);
            return result;
        }
        String fullName = currentDir.equals("/") ? String.format("%s%s", currentDir, name) : String.format("%s/%s", currentDir, name);
        result = this.verifyResource(loginUser, type, fullName, pid);
        if (!result.getCode().equals(Status.SUCCESS.getCode())) {
            return result;
        }
        if (this.checkResourceExists(fullName, 0, type.ordinal())) {
            logger.error("resource directory {} has exist, can't recreate", (Object)fullName);
            this.putMsg((Result)result, Status.RESOURCE_EXIST, new Object[0]);
            return result;
        }
        Date now = new Date();
        Resource resource = new Resource(pid, name, fullName, true, description, name, loginUser.getId(), type, 0L, now, now);
        try {
            this.resourcesMapper.insert((Object)resource);
            this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
            BeanMap dataMap = new BeanMap((Object)resource);
            HashMap resultMap = new HashMap();
            for (Map.Entry entry : dataMap.entrySet()) {
                if ("class".equalsIgnoreCase(entry.getKey().toString())) continue;
                resultMap.put(entry.getKey().toString(), entry.getValue());
            }
            result.setData(resultMap);
        }
        catch (DuplicateKeyException e) {
            logger.error("resource directory {} has exist, can't recreate", (Object)fullName);
            this.putMsg((Result)result, Status.RESOURCE_EXIST, new Object[0]);
            return result;
        }
        catch (Exception e) {
            logger.error("resource already exists, can't recreate ", (Throwable)e);
            throw new ServiceException("resource already exists, can't recreate");
        }
        this.createDirectory(loginUser, fullName, type, result);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<Object> createResource(User loginUser, String name, String desc, ResourceType type, MultipartFile file, int pid, String currentDir) {
        String fullName;
        Result<Object> result = this.checkResourceUploadStartupState();
        if (!result.getCode().equals(Status.SUCCESS.getCode())) {
            return result;
        }
        result = this.verifyPid(loginUser, pid);
        if (!result.getCode().equals(Status.SUCCESS.getCode())) {
            return result;
        }
        result = this.verifyFile(name, type, file);
        if (!result.getCode().equals(Status.SUCCESS.getCode())) {
            return result;
        }
        String string = fullName = currentDir.equals("/") ? String.format("%s%s", currentDir, name) : String.format("%s/%s", currentDir, name);
        if (this.checkResourceExists(fullName, 0, type.ordinal())) {
            logger.error("resource {} has exist, can't recreate", (Object)RegexUtils.escapeNRT(name));
            this.putMsg((Result)result, Status.RESOURCE_EXIST, new Object[0]);
            return result;
        }
        Date now = new Date();
        Resource resource = new Resource(pid, name, fullName, false, desc, file.getOriginalFilename(), loginUser.getId(), type, file.getSize(), now, now);
        try {
            this.resourcesMapper.insert((Object)resource);
            this.updateParentResourceSize(resource, resource.getSize());
            this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
            BeanMap dataMap = new BeanMap((Object)resource);
            HashMap resultMap = new HashMap();
            for (Map.Entry entry : dataMap.entrySet()) {
                if ("class".equalsIgnoreCase(entry.getKey().toString())) continue;
                resultMap.put(entry.getKey().toString(), entry.getValue());
            }
            result.setData(resultMap);
        }
        catch (Exception e) {
            logger.error("resource already exists, can't recreate ", (Throwable)e);
            throw new ServiceException("resource already exists, can't recreate");
        }
        if (!this.upload(loginUser, fullName, file, type)) {
            logger.error("upload resource: {} file: {} failed.", (Object)RegexUtils.escapeNRT(name), (Object)RegexUtils.escapeNRT(file.getOriginalFilename()));
            this.putMsg((Result)result, Status.HDFS_OPERATION_ERROR, new Object[0]);
            throw new ServiceException(String.format("upload resource: %s file: %s failed.", name, file.getOriginalFilename()));
        }
        return result;
    }

    private void updateParentResourceSize(Resource resource, long size) {
        if (resource.getSize() > 0L) {
            String[] splits = resource.getFullName().split("/");
            for (int i = 1; i < splits.length; ++i) {
                List resources;
                String parentFullName = Joiner.on((String)"/").join((Object[])Arrays.copyOfRange(splits, 0, i));
                if (!StringUtils.isNotBlank((String)parentFullName) || !CollectionUtils.isNotEmpty((Collection)(resources = this.resourcesMapper.queryResource(parentFullName, resource.getType().ordinal())))) continue;
                Resource parentResource = (Resource)resources.get(0);
                if (parentResource.getSize() + size >= 0L) {
                    parentResource.setSize(parentResource.getSize() + size);
                } else {
                    parentResource.setSize(0L);
                }
                this.resourcesMapper.updateById((Object)parentResource);
            }
        }
    }

    private boolean checkResourceExists(String fullName, int userId, int type) {
        Boolean existResource = this.resourcesMapper.existResource(fullName, userId, type);
        return existResource == Boolean.TRUE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<Object> updateResource(User loginUser, int resourceId, String name, String desc, ResourceType type, MultipartFile file) {
        Result<Object> result = this.checkResourceUploadStartupState();
        if (!result.getCode().equals(Status.SUCCESS.getCode())) {
            return result;
        }
        Resource resource = (Resource)this.resourcesMapper.selectById((Serializable)Integer.valueOf(resourceId));
        if (resource == null) {
            this.putMsg((Result)result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        if (!this.hasPerm(loginUser, resource.getUserId())) {
            this.putMsg((Result)result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        if (file == null && name.equals(resource.getAlias()) && desc.equals(resource.getDescription())) {
            this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
            return result;
        }
        String originFullName = resource.getFullName();
        String originResourceName = resource.getAlias();
        String fullName = String.format("%s%s", originFullName.substring(0, originFullName.lastIndexOf("/") + 1), name);
        if (!originResourceName.equals(name) && this.checkResourceExists(fullName, 0, type.ordinal())) {
            logger.error("resource {} already exists, can't recreate", (Object)name);
            this.putMsg((Result)result, Status.RESOURCE_EXIST, new Object[0]);
            return result;
        }
        result = this.verifyFile(name, type, file);
        if (!result.getCode().equals(Status.SUCCESS.getCode())) {
            return result;
        }
        String tenantCode = this.getTenantCode(resource.getUserId(), result);
        if (StringUtils.isEmpty((String)tenantCode)) {
            return result;
        }
        String originHdfsFileName = HadoopUtils.getHdfsFileName((ResourceType)resource.getType(), (String)tenantCode, (String)originFullName);
        try {
            if (!HadoopUtils.getInstance().exists(originHdfsFileName)) {
                logger.error("{} not exist", (Object)originHdfsFileName);
                this.putMsg((Result)result, Status.RESOURCE_NOT_EXIST, new Object[0]);
                return result;
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ServiceException(Status.HDFS_OPERATION_ERROR);
        }
        if (!resource.isDirectory()) {
            String originSuffix = Files.getFileExtension((String)originFullName);
            String suffix = Files.getFileExtension((String)fullName);
            boolean suffixIsChanged = false;
            if (StringUtils.isBlank((String)suffix) && StringUtils.isNotBlank((String)originSuffix)) {
                suffixIsChanged = true;
            }
            if (StringUtils.isNotBlank((String)suffix) && !suffix.equals(originSuffix)) {
                suffixIsChanged = true;
            }
            if (suffixIsChanged) {
                HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
                columnMap.put("resources_id", resourceId);
                List resourcesUsers = this.resourceUserMapper.selectByMap(columnMap);
                if (CollectionUtils.isNotEmpty((Collection)resourcesUsers)) {
                    List userIds = resourcesUsers.stream().map(ResourcesUser::getUserId).collect(Collectors.toList());
                    List users = this.userMapper.selectBatchIds(userIds);
                    String userNames = users.stream().map(User::getUserName).collect(Collectors.toList()).toString();
                    logger.error("resource is authorized to user {},suffix not allowed to be modified", (Object)userNames);
                    this.putMsg((Result)result, Status.RESOURCE_IS_AUTHORIZED, new Object[]{userNames});
                    return result;
                }
            }
        }
        Date now = new Date();
        long originFileSize = resource.getSize();
        resource.setAlias(name);
        resource.setFileName(name);
        resource.setFullName(fullName);
        resource.setDescription(desc);
        resource.setUpdateTime(now);
        if (file != null) {
            resource.setSize(file.getSize());
        }
        try {
            List udfFuncs;
            this.resourcesMapper.updateById((Object)resource);
            if (resource.isDirectory()) {
                List<Integer> childrenResource = this.listAllChildren(resource, false);
                if (CollectionUtils.isNotEmpty(childrenResource)) {
                    List udfFuncs2;
                    String matcherFullName = Matcher.quoteReplacement(fullName);
                    Integer[] childResIdArray = childrenResource.toArray(new Integer[childrenResource.size()]);
                    List resourceList = this.resourcesMapper.listResourceByIds(childResIdArray);
                    List childResourceList = resourceList.stream().map(t -> {
                        t.setFullName(t.getFullName().replaceFirst(originFullName, matcherFullName));
                        t.setUpdateTime(now);
                        return t;
                    }).collect(Collectors.toList());
                    this.resourcesMapper.batchUpdateResource(childResourceList);
                    if (ResourceType.UDF.equals((Object)resource.getType()) && CollectionUtils.isNotEmpty((Collection)(udfFuncs2 = this.udfFunctionMapper.listUdfByResourceId(childResIdArray)))) {
                        udfFuncs2 = udfFuncs2.stream().map(t -> {
                            t.setResourceName(t.getResourceName().replaceFirst(originFullName, matcherFullName));
                            t.setUpdateTime(now);
                            return t;
                        }).collect(Collectors.toList());
                        this.udfFunctionMapper.batchUpdateUdfFunc(udfFuncs2);
                    }
                }
            } else if (ResourceType.UDF.equals((Object)resource.getType()) && CollectionUtils.isNotEmpty((Collection)(udfFuncs = this.udfFunctionMapper.listUdfByResourceId(new Integer[]{resourceId})))) {
                udfFuncs = udfFuncs.stream().map(t -> {
                    t.setResourceName(fullName);
                    t.setUpdateTime(now);
                    return t;
                }).collect(Collectors.toList());
                this.udfFunctionMapper.batchUpdateUdfFunc(udfFuncs);
            }
            this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
            BeanMap dataMap = new BeanMap((Object)resource);
            HashMap resultMap = new HashMap();
            for (Map.Entry entry : dataMap.entrySet()) {
                if ("class".equalsIgnoreCase(entry.getKey().toString())) continue;
                resultMap.put(entry.getKey().toString(), entry.getValue());
            }
            result.setData(resultMap);
        }
        catch (Exception e) {
            logger.error(Status.UPDATE_RESOURCE_ERROR.getMsg(), (Throwable)e);
            throw new ServiceException(Status.UPDATE_RESOURCE_ERROR);
        }
        if (originResourceName.equals(name) && file == null) {
            return result;
        }
        if (file != null) {
            if (!this.upload(loginUser, fullName, file, type)) {
                logger.error("upload resource: {} file: {} failed.", (Object)name, (Object)RegexUtils.escapeNRT(file.getOriginalFilename()));
                this.putMsg((Result)result, Status.HDFS_OPERATION_ERROR, new Object[0]);
                throw new ServiceException(String.format("upload resource: %s file: %s failed.", name, file.getOriginalFilename()));
            }
            if (!fullName.equals(originFullName)) {
                try {
                    HadoopUtils.getInstance().delete(originHdfsFileName, false);
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new ServiceException(String.format("delete resource: %s failed.", originFullName));
                }
            }
            this.updateParentResourceSize(resource, resource.getSize() - originFileSize);
            return result;
        }
        String destHdfsFileName = HadoopUtils.getHdfsFileName((ResourceType)resource.getType(), (String)tenantCode, (String)fullName);
        try {
            logger.info("start hdfs copy {} -> {}", (Object)originHdfsFileName, (Object)destHdfsFileName);
            HadoopUtils.getInstance().copy(originHdfsFileName, destHdfsFileName, true, true);
        }
        catch (Exception e) {
            logger.error(MessageFormat.format("hdfs copy {0} -> {1} fail", originHdfsFileName, destHdfsFileName), (Throwable)e);
            this.putMsg((Result)result, Status.HDFS_COPY_FAIL, new Object[0]);
            throw new ServiceException(Status.HDFS_COPY_FAIL);
        }
        return result;
    }

    private Result<Object> verifyFile(String name, ResourceType type, MultipartFile file) {
        Result<Object> result = new Result<Object>();
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        if (org.apache.dolphinscheduler.common.utils.FileUtils.directoryTraversal((String)name)) {
            logger.error("file alias name {} verify failed", (Object)name);
            this.putMsg((Result)result, Status.VERIFY_PARAMETER_NAME_FAILED, new Object[0]);
            return result;
        }
        if (file != null && org.apache.dolphinscheduler.common.utils.FileUtils.directoryTraversal((String)Objects.requireNonNull(file.getOriginalFilename()))) {
            logger.error("file original name {} verify failed", (Object)file.getOriginalFilename());
            this.putMsg((Result)result, Status.VERIFY_PARAMETER_NAME_FAILED, new Object[0]);
            return result;
        }
        if (file != null) {
            if (file.isEmpty()) {
                logger.error("file is empty: {}", (Object)RegexUtils.escapeNRT(file.getOriginalFilename()));
                this.putMsg((Result)result, Status.RESOURCE_FILE_IS_EMPTY, new Object[0]);
                return result;
            }
            String fileSuffix = Files.getFileExtension((String)file.getOriginalFilename());
            String nameSuffix = Files.getFileExtension((String)name);
            if (!StringUtils.isNotEmpty((String)fileSuffix) || !fileSuffix.equalsIgnoreCase(nameSuffix)) {
                logger.error("rename file suffix and original suffix must be consistent: {}", (Object)RegexUtils.escapeNRT(file.getOriginalFilename()));
                this.putMsg((Result)result, Status.RESOURCE_SUFFIX_FORBID_CHANGE, new Object[0]);
                return result;
            }
            if ("UDF".equals(type.name()) && !"jar".equalsIgnoreCase(fileSuffix)) {
                logger.error(Status.UDF_RESOURCE_SUFFIX_NOT_JAR.getMsg());
                this.putMsg((Result)result, Status.UDF_RESOURCE_SUFFIX_NOT_JAR, new Object[0]);
                return result;
            }
            if (file.getSize() > 0x40000000L) {
                logger.error("file size is too large: {}", (Object)RegexUtils.escapeNRT(file.getOriginalFilename()));
                this.putMsg((Result)result, Status.RESOURCE_SIZE_EXCEED_LIMIT, new Object[0]);
                return result;
            }
        }
        return result;
    }

    @Override
    public Result queryResourceListPaging(User loginUser, int directoryId, ResourceType type, String searchVal, Integer pageNo, Integer pageSize) {
        Resource directory;
        Result result = new Result();
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        int userId = loginUser.getId();
        if (this.isAdmin(loginUser)) {
            userId = 0;
        }
        if (directoryId != -1 && (directory = (Resource)this.resourcesMapper.selectById((Serializable)Integer.valueOf(directoryId))) == null) {
            this.putMsg(result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        List resourcesIds = this.resourceUserMapper.queryResourcesIdListByUserIdAndPerm(userId, 0);
        IPage resourceIPage = this.resourcesMapper.queryResourcePaging((IPage)page, userId, directoryId, type.ordinal(), searchVal, resourcesIds);
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        pageInfo.setTotal((int)resourceIPage.getTotal());
        pageInfo.setTotalList(resourceIPage.getRecords());
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private void createDirectory(User loginUser, String fullName, ResourceType type, Result<Object> result) {
        String tenantCode = this.tenantMapper.queryById(loginUser.getTenantId()).getTenantCode();
        String directoryName = HadoopUtils.getHdfsFileName((ResourceType)type, (String)tenantCode, (String)fullName);
        String resourceRootPath = HadoopUtils.getHdfsDir((ResourceType)type, (String)tenantCode);
        try {
            if (!HadoopUtils.getInstance().exists(resourceRootPath)) {
                this.createTenantDirIfNotExists(tenantCode);
            }
            if (!HadoopUtils.getInstance().mkdir(directoryName)) {
                logger.error("create resource directory {} of hdfs failed", (Object)directoryName);
                this.putMsg((Result)result, Status.HDFS_OPERATION_ERROR, new Object[0]);
                throw new ServiceException(String.format("create resource directory: %s failed.", directoryName));
            }
        }
        catch (Exception e) {
            logger.error("create resource directory {} of hdfs failed", (Object)directoryName);
            this.putMsg((Result)result, Status.HDFS_OPERATION_ERROR, new Object[0]);
            throw new ServiceException(String.format("create resource directory: %s failed.", directoryName));
        }
    }

    private boolean upload(User loginUser, String fullName, MultipartFile file, ResourceType type) {
        String fileSuffix = Files.getFileExtension((String)file.getOriginalFilename());
        String nameSuffix = Files.getFileExtension((String)fullName);
        if (!StringUtils.isNotEmpty((String)fileSuffix) || !fileSuffix.equalsIgnoreCase(nameSuffix)) {
            return false;
        }
        String tenantCode = this.tenantMapper.queryById(loginUser.getTenantId()).getTenantCode();
        String localFilename = org.apache.dolphinscheduler.common.utils.FileUtils.getUploadFilename((String)tenantCode, (String)UUID.randomUUID().toString());
        String hdfsFilename = HadoopUtils.getHdfsFileName((ResourceType)type, (String)tenantCode, (String)fullName);
        String resourcePath = HadoopUtils.getHdfsDir((ResourceType)type, (String)tenantCode);
        try {
            if (!HadoopUtils.getInstance().exists(resourcePath)) {
                this.createTenantDirIfNotExists(tenantCode);
            }
            FileUtils.copyInputStreamToFile(file, localFilename);
            HadoopUtils.getInstance().copyLocalToHdfs(localFilename, hdfsFilename, true, true);
        }
        catch (Exception e) {
            org.apache.dolphinscheduler.common.utils.FileUtils.deleteFile((String)localFilename);
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> queryResourceList(User loginUser, ResourceType type) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<Resource> allResourceList = this.queryAuthoredResourceList(loginUser, type);
        ResourceTreeVisitor resourceTreeVisitor = new ResourceTreeVisitor(allResourceList);
        result.put("data", resourceTreeVisitor.visit().getChildren());
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryResourceByProgramType(User loginUser, ResourceType type, ProgramType programType) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<Resource> allResourceList = this.queryAuthoredResourceList(loginUser, type);
        String suffix = ".jar";
        if (programType != null) {
            switch (programType) {
                case JAVA: 
                case SCALA: {
                    break;
                }
                case PYTHON: {
                    suffix = ".py";
                    break;
                }
            }
        }
        List<Resource> resources = new ResourceFilter(suffix, new ArrayList<Resource>(allResourceList)).filter();
        ResourceTreeVisitor resourceTreeVisitor = new ResourceTreeVisitor(resources);
        result.put("data", resourceTreeVisitor.visit().getChildren());
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<Object> delete(User loginUser, int resourceId) throws IOException {
        Object udfFuncs;
        Result<Object> result = this.checkResourceUploadStartupState();
        if (!result.getCode().equals(Status.SUCCESS.getCode())) {
            return result;
        }
        Resource resource = (Resource)this.resourcesMapper.selectById((Serializable)Integer.valueOf(resourceId));
        if (resource == null) {
            this.putMsg((Result)result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        if (!this.hasPerm(loginUser, resource.getUserId())) {
            this.putMsg((Result)result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        String tenantCode = this.getTenantCode(resource.getUserId(), result);
        if (StringUtils.isEmpty((String)tenantCode)) {
            return result;
        }
        List list = this.processDefinitionMapper.listResources();
        Map resourceProcessMap = ResourceProcessDefinitionUtils.getResourceProcessDefinitionMap((List)list);
        Set resourceIdSet = resourceProcessMap.keySet();
        List<Integer> allChildren = this.listAllChildren(resource, true);
        Integer[] needDeleteResourceIdArray = allChildren.toArray(new Integer[allChildren.size()]);
        if (resource.getType() == ResourceType.UDF && CollectionUtils.isNotEmpty((Collection)(udfFuncs = this.udfFunctionMapper.listUdfByResourceId(needDeleteResourceIdArray)))) {
            logger.error("can't be deleted,because it is bound by UDF functions:{}", udfFuncs);
            this.putMsg((Result)result, Status.UDF_RESOURCE_IS_BOUND, new Object[]{((UdfFunc)udfFuncs.get(0)).getFuncName()});
            return result;
        }
        if (resourceIdSet.contains(resource.getPid())) {
            logger.error("can't be deleted,because it is used of process definition");
            this.putMsg((Result)result, Status.RESOURCE_IS_USED, new Object[0]);
            return result;
        }
        resourceIdSet.retainAll(allChildren);
        if (CollectionUtils.isNotEmpty(resourceIdSet)) {
            logger.error("can't be deleted,because it is used of process definition");
            for (Integer resId : resourceIdSet) {
                logger.error("resource id:{} is used of process definition {}", (Object)resId, resourceProcessMap.get(resId));
            }
            this.putMsg((Result)result, Status.RESOURCE_IS_USED, new Object[0]);
            return result;
        }
        String hdfsFilename = HadoopUtils.getHdfsFileName((ResourceType)resource.getType(), (String)tenantCode, (String)resource.getFullName());
        this.resourcesMapper.selectBatchIds(Arrays.asList(needDeleteResourceIdArray)).forEach(item -> this.updateParentResourceSize((Resource)item, item.getSize() * -1L));
        this.resourcesMapper.deleteIds(needDeleteResourceIdArray);
        this.resourceUserMapper.deleteResourceUserArray(0, needDeleteResourceIdArray);
        HadoopUtils.getInstance().delete(hdfsFilename, true);
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result<Object> verifyResourceName(String fullName, ResourceType type, User loginUser) {
        Result<Object> result = new Result<Object>();
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        if (this.checkResourceExists(fullName, 0, type.ordinal())) {
            logger.error("resource type:{} name:{} has exist, can't create again.", (Object)type, (Object)RegexUtils.escapeNRT(fullName));
            this.putMsg((Result)result, Status.RESOURCE_EXIST, new Object[0]);
        } else {
            Tenant tenant = this.tenantMapper.queryById(loginUser.getTenantId());
            if (tenant != null) {
                String tenantCode = tenant.getTenantCode();
                try {
                    String hdfsFilename = HadoopUtils.getHdfsFileName((ResourceType)type, (String)tenantCode, (String)fullName);
                    if (HadoopUtils.getInstance().exists(hdfsFilename)) {
                        logger.error("resource type:{} name:{} has exist in hdfs {}, can't create again.", new Object[]{type, RegexUtils.escapeNRT(fullName), hdfsFilename});
                        this.putMsg((Result)result, Status.RESOURCE_FILE_EXIST, new Object[]{hdfsFilename});
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    this.putMsg((Result)result, Status.HDFS_OPERATION_ERROR, new Object[0]);
                }
            } else {
                this.putMsg((Result)result, Status.TENANT_NOT_EXIST, new Object[0]);
            }
        }
        return result;
    }

    @Override
    public Result<Object> queryResource(String fullName, Integer id, ResourceType type) {
        Result<Object> result = new Result<Object>();
        if (StringUtils.isBlank((String)fullName) && id == null) {
            this.putMsg((Result)result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, new Object[0]);
            return result;
        }
        if (StringUtils.isNotBlank((String)fullName)) {
            List resourceList = this.resourcesMapper.queryResource(fullName, type.ordinal());
            if (CollectionUtils.isEmpty((Collection)resourceList)) {
                this.putMsg((Result)result, Status.RESOURCE_NOT_EXIST, new Object[0]);
                return result;
            }
            this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
            result.setData(resourceList.get(0));
        } else {
            Resource resource = (Resource)this.resourcesMapper.selectById((Serializable)id);
            if (resource == null) {
                this.putMsg((Result)result, Status.RESOURCE_NOT_EXIST, new Object[0]);
                return result;
            }
            Resource parentResource = (Resource)this.resourcesMapper.selectById((Serializable)Integer.valueOf(resource.getPid()));
            if (parentResource == null) {
                this.putMsg((Result)result, Status.RESOURCE_NOT_EXIST, new Object[0]);
                return result;
            }
            this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
            result.setData(parentResource);
        }
        return result;
    }

    @Override
    public Result<Object> readResource(int resourceId, int skipLineNum, int limit) {
        List<String> strList;
        Result<Object> result = this.checkResourceUploadStartupState();
        if (!result.getCode().equals(Status.SUCCESS.getCode())) {
            return result;
        }
        Resource resource = (Resource)this.resourcesMapper.selectById((Serializable)Integer.valueOf(resourceId));
        if (resource == null) {
            this.putMsg((Result)result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        String nameSuffix = Files.getFileExtension((String)resource.getAlias());
        String resourceViewSuffixs = org.apache.dolphinscheduler.common.utils.FileUtils.getResourceViewSuffixs();
        if (StringUtils.isNotEmpty((String)resourceViewSuffixs) && !(strList = Arrays.asList(resourceViewSuffixs.split(","))).contains(nameSuffix)) {
            logger.error("resource suffix {} not support view,  resource id {}", (Object)nameSuffix, (Object)resourceId);
            this.putMsg((Result)result, Status.RESOURCE_SUFFIX_NOT_SUPPORT_VIEW, new Object[0]);
            return result;
        }
        String tenantCode = this.getTenantCode(resource.getUserId(), result);
        if (StringUtils.isEmpty((String)tenantCode)) {
            return result;
        }
        String hdfsFileName = HadoopUtils.getHdfsResourceFileName((String)tenantCode, (String)resource.getFullName());
        logger.info("resource hdfs path is {}", (Object)hdfsFileName);
        try {
            if (HadoopUtils.getInstance().exists(hdfsFileName)) {
                List content = HadoopUtils.getInstance().catFile(hdfsFileName, skipLineNum, limit);
                this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("alias", resource.getAlias());
                map.put("content", String.join((CharSequence)"\n", content));
                result.setData(map);
            } else {
                logger.error("read file {} not exist in hdfs", (Object)hdfsFileName);
                this.putMsg((Result)result, Status.RESOURCE_FILE_NOT_EXIST, new Object[]{hdfsFileName});
            }
        }
        catch (Exception e) {
            logger.error("Resource {} read failed", (Object)hdfsFileName, (Object)e);
            this.putMsg((Result)result, Status.HDFS_OPERATION_ERROR, new Object[0]);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<Object> onlineCreateResource(User loginUser, ResourceType type, String fileName, String fileSuffix, String desc, String content, int pid, String currentDir) {
        List<String> strList;
        Result<Object> result = this.checkResourceUploadStartupState();
        if (!result.getCode().equals(Status.SUCCESS.getCode())) {
            return result;
        }
        if (org.apache.dolphinscheduler.common.utils.FileUtils.directoryTraversal((String)fileName)) {
            this.putMsg((Result)result, Status.VERIFY_PARAMETER_NAME_FAILED, new Object[0]);
            return result;
        }
        String nameSuffix = fileSuffix.trim();
        String resourceViewSuffixs = org.apache.dolphinscheduler.common.utils.FileUtils.getResourceViewSuffixs();
        if (StringUtils.isNotEmpty((String)resourceViewSuffixs) && !(strList = Arrays.asList(resourceViewSuffixs.split(","))).contains(nameSuffix)) {
            logger.error("resource suffix {} not support create", (Object)nameSuffix);
            this.putMsg((Result)result, Status.RESOURCE_SUFFIX_NOT_SUPPORT_VIEW, new Object[0]);
            return result;
        }
        String name = fileName.trim() + "." + nameSuffix;
        String fullName = currentDir.equals("/") ? String.format("%s%s", currentDir, name) : String.format("%s/%s", currentDir, name);
        result = this.verifyResource(loginUser, type, fullName, pid);
        if (!result.getCode().equals(Status.SUCCESS.getCode())) {
            return result;
        }
        Date now = new Date();
        Resource resource = new Resource(pid, name, fullName, false, desc, name, loginUser.getId(), type, (long)content.getBytes().length, now, now);
        this.resourcesMapper.insert((Object)resource);
        this.updateParentResourceSize(resource, resource.getSize());
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        BeanMap dataMap = new BeanMap((Object)resource);
        HashMap resultMap = new HashMap();
        for (Map.Entry entry : dataMap.entrySet()) {
            if ("class".equalsIgnoreCase(entry.getKey().toString())) continue;
            resultMap.put(entry.getKey().toString(), entry.getValue());
        }
        result.setData(resultMap);
        String tenantCode = this.tenantMapper.queryById(loginUser.getTenantId()).getTenantCode();
        result = this.uploadContentToHdfs(fullName, tenantCode, content);
        if (!result.getCode().equals(Status.SUCCESS.getCode())) {
            throw new ServiceException(result.getMsg());
        }
        return result;
    }

    private Result<Object> checkResourceUploadStartupState() {
        Result<Object> result = new Result<Object>();
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        if (!PropertyUtils.getResUploadStartupState()) {
            logger.error("resource upload startup state: {}", (Object)PropertyUtils.getResUploadStartupState());
            this.putMsg((Result)result, Status.HDFS_NOT_STARTUP, new Object[0]);
            return result;
        }
        return result;
    }

    private Result<Object> verifyResource(User loginUser, ResourceType type, String fullName, int pid) {
        Result<Object> result = this.verifyResourceName(fullName, type, loginUser);
        if (!result.getCode().equals(Status.SUCCESS.getCode())) {
            return result;
        }
        return this.verifyPid(loginUser, pid);
    }

    private Result<Object> verifyPid(User loginUser, int pid) {
        Result<Object> result = new Result<Object>();
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        if (pid != -1) {
            Resource parentResource = (Resource)this.resourcesMapper.selectById((Serializable)Integer.valueOf(pid));
            if (parentResource == null) {
                this.putMsg((Result)result, Status.PARENT_RESOURCE_NOT_EXIST, new Object[0]);
                return result;
            }
            if (!this.hasPerm(loginUser, parentResource.getUserId())) {
                this.putMsg((Result)result, Status.USER_NO_OPERATION_PERM, new Object[0]);
                return result;
            }
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<Object> updateResourceContent(int resourceId, String content) {
        List<String> strList;
        Result<Object> result = this.checkResourceUploadStartupState();
        if (!result.getCode().equals(Status.SUCCESS.getCode())) {
            return result;
        }
        Resource resource = (Resource)this.resourcesMapper.selectById((Serializable)Integer.valueOf(resourceId));
        if (resource == null) {
            logger.error("read file not exist,  resource id {}", (Object)resourceId);
            this.putMsg((Result)result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        String nameSuffix = Files.getFileExtension((String)resource.getAlias());
        String resourceViewSuffixs = org.apache.dolphinscheduler.common.utils.FileUtils.getResourceViewSuffixs();
        if (StringUtils.isNotEmpty((String)resourceViewSuffixs) && !(strList = Arrays.asList(resourceViewSuffixs.split(","))).contains(nameSuffix)) {
            logger.error("resource suffix {} not support updateProcessInstance,  resource id {}", (Object)nameSuffix, (Object)resourceId);
            this.putMsg((Result)result, Status.RESOURCE_SUFFIX_NOT_SUPPORT_VIEW, new Object[0]);
            return result;
        }
        String tenantCode = this.getTenantCode(resource.getUserId(), result);
        if (StringUtils.isEmpty((String)tenantCode)) {
            return result;
        }
        long originFileSize = resource.getSize();
        resource.setSize((long)content.getBytes().length);
        resource.setUpdateTime(new Date());
        this.resourcesMapper.updateById((Object)resource);
        this.updateParentResourceSize(resource, resource.getSize() - originFileSize);
        result = this.uploadContentToHdfs(resource.getFullName(), tenantCode, content);
        if (!result.getCode().equals(Status.SUCCESS.getCode())) {
            throw new ServiceException(result.getMsg());
        }
        return result;
    }

    private Result<Object> uploadContentToHdfs(String resourceName, String tenantCode, String content) {
        Result<Object> result = new Result<Object>();
        String localFilename = "";
        String hdfsFileName = "";
        try {
            localFilename = org.apache.dolphinscheduler.common.utils.FileUtils.getUploadFilename((String)tenantCode, (String)UUID.randomUUID().toString());
            if (!org.apache.dolphinscheduler.common.utils.FileUtils.writeContent2File((String)content, (String)localFilename)) {
                logger.error("file {} fail, content is {}", (Object)localFilename, (Object)RegexUtils.escapeNRT(content));
                this.putMsg((Result)result, Status.RESOURCE_NOT_EXIST, new Object[0]);
                return result;
            }
            hdfsFileName = HadoopUtils.getHdfsResourceFileName((String)tenantCode, (String)resourceName);
            String resourcePath = HadoopUtils.getHdfsResDir((String)tenantCode);
            logger.info("resource hdfs path is {}, resource dir is {}", (Object)hdfsFileName, (Object)resourcePath);
            HadoopUtils hadoopUtils = HadoopUtils.getInstance();
            if (!hadoopUtils.exists(resourcePath)) {
                this.createTenantDirIfNotExists(tenantCode);
            }
            if (hadoopUtils.exists(hdfsFileName)) {
                hadoopUtils.delete(hdfsFileName, false);
            }
            hadoopUtils.copyLocalToHdfs(localFilename, hdfsFileName, true, true);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            result.setCode(Status.HDFS_OPERATION_ERROR.getCode());
            result.setMsg(String.format("copy %s to hdfs %s fail", localFilename, hdfsFileName));
            return result;
        }
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public org.springframework.core.io.Resource downloadResource(int resourceId) throws IOException {
        if (!PropertyUtils.getResUploadStartupState()) {
            logger.error("resource upload startup state: {}", (Object)PropertyUtils.getResUploadStartupState());
            throw new ServiceException("hdfs not startup");
        }
        Resource resource = (Resource)this.resourcesMapper.selectById((Serializable)Integer.valueOf(resourceId));
        if (resource == null) {
            logger.error("download file not exist,  resource id {}", (Object)resourceId);
            return null;
        }
        if (resource.isDirectory()) {
            logger.error("resource id {} is directory,can't download it", (Object)resourceId);
            throw new ServiceException("can't download directory");
        }
        int userId = resource.getUserId();
        User user = this.userMapper.selectById(userId);
        if (user == null) {
            logger.error("user id {} not exists", (Object)userId);
            throw new ServiceException(String.format("resource owner id %d not exist", userId));
        }
        Tenant tenant = this.tenantMapper.queryById(user.getTenantId());
        if (tenant == null) {
            logger.error("tenant id {} not exists", (Object)user.getTenantId());
            throw new ServiceException(String.format("The tenant id %d of resource owner not exist", user.getTenantId()));
        }
        String tenantCode = tenant.getTenantCode();
        String hdfsFileName = HadoopUtils.getHdfsFileName((ResourceType)resource.getType(), (String)tenantCode, (String)resource.getFullName());
        String localFileName = org.apache.dolphinscheduler.common.utils.FileUtils.getDownloadFilename((String)resource.getAlias());
        logger.info("resource hdfs path is {}, download local filename is {}", (Object)hdfsFileName, (Object)localFileName);
        HadoopUtils.getInstance().copyHdfsToLocal(hdfsFileName, localFileName, false, true);
        return FileUtils.file2Resource(localFileName);
    }

    @Override
    public Map<String, Object> authorizeResourceTree(User loginUser, Integer userId) {
        List<Object> list;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isNotAdmin(loginUser, result)) {
            return result;
        }
        List resourceList = this.resourcesMapper.queryResourceExceptUserId(userId.intValue());
        if (CollectionUtils.isNotEmpty((Collection)resourceList)) {
            ResourceTreeVisitor visitor = new ResourceTreeVisitor(resourceList);
            list = visitor.visit().getChildren();
        } else {
            list = new ArrayList(0);
        }
        result.put("data", list);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> unauthorizedFile(User loginUser, Integer userId) {
        ArrayList<Object> list;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isNotAdmin(loginUser, result)) {
            return result;
        }
        List resourceList = this.resourcesMapper.queryResourceExceptUserId(userId.intValue());
        if (resourceList != null && !resourceList.isEmpty()) {
            HashSet resourceSet = new HashSet(resourceList);
            List<Resource> authedResourceList = this.queryResourceList(userId, 7);
            this.getAuthorizedResourceList(resourceSet, authedResourceList);
            list = new ArrayList(resourceSet);
        } else {
            list = new ArrayList<Resource>(0);
        }
        ResourceTreeVisitor visitor = new ResourceTreeVisitor(list);
        result.put("data", visitor.visit().getChildren());
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> unauthorizedUDFFunction(User loginUser, Integer userId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isNotAdmin(loginUser, result)) {
            return result;
        }
        List udfFuncList = this.udfFunctionMapper.queryUdfFuncExceptUserId(userId.intValue());
        ArrayList resultList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)udfFuncList)) {
            HashSet udfFuncSet = new HashSet(udfFuncList);
            List authedUDFFuncList = this.udfFunctionMapper.queryAuthedUdfFunc(userId.intValue());
            this.getAuthorizedResourceList(udfFuncSet, authedUDFFuncList);
            resultList = new ArrayList(udfFuncSet);
        }
        result.put("data", resultList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> authorizedUDFFunction(User loginUser, Integer userId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isNotAdmin(loginUser, result)) {
            return result;
        }
        List udfFuncs = this.udfFunctionMapper.queryAuthedUdfFunc(userId.intValue());
        result.put("data", udfFuncs);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> authorizedFile(User loginUser, Integer userId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isNotAdmin(loginUser, result)) {
            return result;
        }
        List<Resource> authedResources = this.queryResourceList(userId, 7);
        ResourceTreeVisitor visitor = new ResourceTreeVisitor(authedResources);
        String visit = JSONUtils.toJsonString((Object)visitor.visit(), (SerializationFeature)SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
        logger.info(visit);
        String jsonTreeStr = JSONUtils.toJsonString(visitor.visit().getChildren(), (SerializationFeature)SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
        logger.info(jsonTreeStr);
        result.put("data", visitor.visit().getChildren());
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private void getAuthorizedResourceList(Set<?> resourceSet, List<?> authedResourceList) {
        if (CollectionUtils.isNotEmpty(authedResourceList)) {
            HashSet authedResourceSet = new HashSet(authedResourceList);
            resourceSet.removeAll(authedResourceSet);
        }
    }

    private String getTenantCode(int userId, Result<Object> result) {
        User user = this.userMapper.selectById(userId);
        if (user == null) {
            logger.error("user {} not exists", (Object)userId);
            this.putMsg((Result)result, Status.USER_NOT_EXIST, new Object[]{userId});
            return null;
        }
        Tenant tenant = this.tenantMapper.queryById(user.getTenantId());
        if (tenant == null) {
            logger.error("tenant not exists");
            this.putMsg((Result)result, Status.TENANT_NOT_EXIST, new Object[0]);
            return null;
        }
        return tenant.getTenantCode();
    }

    List<Integer> listAllChildren(Resource resource, boolean containSelf) {
        ArrayList<Integer> childList = new ArrayList<Integer>();
        if (resource.getId() != -1 && containSelf) {
            childList.add(resource.getId());
        }
        if (resource.isDirectory()) {
            this.listAllChildren(resource.getId(), childList);
        }
        return childList;
    }

    void listAllChildren(int resourceId, List<Integer> childList) {
        List children = this.resourcesMapper.listChildren(resourceId);
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            int childId = (Integer)iterator.next();
            childList.add(childId);
            this.listAllChildren(childId, childList);
        }
    }

    private List<Resource> queryAuthoredResourceList(User loginUser, ResourceType type) {
        List<Object> relationResources;
        int userId = loginUser.getId();
        if (this.isAdmin(loginUser)) {
            userId = 0;
            relationResources = new ArrayList();
        } else {
            relationResources = this.queryResourceList(userId, 0);
        }
        List ownResourceList = this.resourcesMapper.queryResourceListAuthored(userId, type.ordinal());
        ownResourceList.addAll(relationResources);
        return ownResourceList;
    }

    private List<Resource> queryResourceList(Integer userId, int perm) {
        List resIds = this.resourceUserMapper.queryResourcesIdListByUserIdAndPerm(userId.intValue(), perm);
        return CollectionUtils.isEmpty((Collection)resIds) ? new ArrayList() : this.resourcesMapper.queryResourceListById(resIds);
    }
}

