/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.WorkFlowLineageService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkFlowLineage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"WORK_FLOW_LINEAGE_TAG"})
@RestController
@RequestMapping(value={"projects/{projectCode}/lineages"})
public class WorkFlowLineageController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(WorkFlowLineageController.class);
    @Autowired
    private WorkFlowLineageService workFlowLineageService;

    @ApiOperation(value="queryLineageByWorkFlowName", notes="QUERY_WORKFLOW_LINEAGE_BY_NAME_NOTES")
    @GetMapping(value={"/query-by-name"})
    @ResponseStatus(value=HttpStatus.OK)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result<List<WorkFlowLineage>> queryWorkFlowLineageByName(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="workFlowName", required=false) String workFlowName) {
        try {
            workFlowName = ParameterUtils.handleEscapes((String)workFlowName);
            Map<String, Object> result = this.workFlowLineageService.queryWorkFlowLineageByName(projectCode, workFlowName);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.QUERY_WORKFLOW_LINEAGE_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.QUERY_WORKFLOW_LINEAGE_ERROR.getCode(), Status.QUERY_WORKFLOW_LINEAGE_ERROR.getMsg());
        }
    }

    @ApiOperation(value="queryLineageByWorkFlowCode", notes="QUERY_WORKFLOW_LINEAGE_BY_CODES_NOTES")
    @GetMapping(value={"/{workFlowCode}"})
    @ResponseStatus(value=HttpStatus.OK)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result<Map<String, Object>> queryWorkFlowLineageByCode(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="workFlowCode", required=true) long workFlowCode) {
        try {
            Map<String, Object> result = this.workFlowLineageService.queryWorkFlowLineageByCode(projectCode, workFlowCode);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.QUERY_WORKFLOW_LINEAGE_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.QUERY_WORKFLOW_LINEAGE_ERROR.getCode(), Status.QUERY_WORKFLOW_LINEAGE_ERROR.getMsg());
        }
    }

    @ApiOperation(value="queryWorkFlowList", notes="QUERY_WORKFLOW_LINEAGE_NOTES")
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result<Map<String, Object>> queryWorkFlowLineage(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode) {
        try {
            Map<String, Object> result = this.workFlowLineageService.queryWorkFlowLineage(projectCode);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.QUERY_WORKFLOW_LINEAGE_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.QUERY_WORKFLOW_LINEAGE_ERROR.getCode(), Status.QUERY_WORKFLOW_LINEAGE_ERROR.getMsg());
        }
    }
}

