/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.task;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.enums.Direct;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.common.enums.TaskType;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.remote.command.StateEventChangeCommand;
import org.apache.dolphinscheduler.remote.processor.StateEventCallbackService;
import org.apache.dolphinscheduler.server.master.runner.task.BaseTaskProcessor;
import org.apache.dolphinscheduler.server.master.runner.task.TaskAction;
import org.apache.dolphinscheduler.server.utils.LogUtils;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;

public class SubTaskProcessor
extends BaseTaskProcessor {
    private ProcessInstance subProcessInstance = null;
    private TaskDefinition taskDefinition;
    private final Lock runLock = new ReentrantLock();
    private StateEventCallbackService stateEventCallbackService = (StateEventCallbackService)SpringApplicationContext.getBean(StateEventCallbackService.class);

    @Override
    public boolean submitTask() {
        this.taskDefinition = this.processService.findTaskDefinition(this.taskInstance.getTaskCode(), this.taskInstance.getTaskDefinitionVersion());
        this.taskInstance = this.processService.submitTask(this.taskInstance, this.maxRetryTimes, this.commitInterval);
        if (this.taskInstance == null) {
            return false;
        }
        this.setTaskExecutionLogger();
        this.taskInstance.setLogPath(LogUtils.getTaskLogPath(this.processInstance.getProcessDefinitionCode(), this.processInstance.getProcessDefinitionVersion(), this.taskInstance.getProcessInstanceId(), this.taskInstance.getId()));
        return true;
    }

    @Override
    protected boolean resubmitTask() {
        return true;
    }

    @Override
    public ExecutionStatus taskState() {
        return this.taskInstance.getState();
    }

    @Override
    public boolean runTask() {
        try {
            this.runLock.lock();
            if (this.setSubWorkFlow()) {
                this.updateTaskState();
            }
        }
        catch (Exception e) {
            this.logger.error("work flow {} sub task {} exceptions", new Object[]{this.processInstance.getId(), this.taskInstance.getId(), e});
        }
        finally {
            this.runLock.unlock();
        }
        return true;
    }

    @Override
    protected boolean taskTimeout() {
        TaskTimeoutStrategy taskTimeoutStrategy = this.taskDefinition.getTimeoutNotifyStrategy();
        if (TaskTimeoutStrategy.FAILED != taskTimeoutStrategy && TaskTimeoutStrategy.WARNFAILED != taskTimeoutStrategy) {
            return true;
        }
        this.logger.info("sub process task {} timeout, strategy {} ", (Object)this.taskInstance.getId(), (Object)taskTimeoutStrategy.getDescp());
        this.killTask();
        return true;
    }

    private void updateTaskState() {
        this.subProcessInstance = this.processService.findSubProcessInstance(Integer.valueOf(this.processInstance.getId()), Integer.valueOf(this.taskInstance.getId()));
        this.logger.info("work flow {} task {}, sub work flow: {} state: {}", new Object[]{this.processInstance.getId(), this.taskInstance.getId(), this.subProcessInstance.getId(), this.subProcessInstance.getState().getDescp()});
        if (this.subProcessInstance != null && this.subProcessInstance.getState().typeIsFinished()) {
            this.taskInstance.setState(this.subProcessInstance.getState());
            this.taskInstance.setEndTime(new Date());
            this.processService.saveTaskInstance(this.taskInstance);
        }
    }

    private Map<String, Property> mergeEndNodeTaskInstanceVarPool(Set<String> taskCodes) {
        List taskInstanceList = this.processService.findValidTaskListByProcessId(Integer.valueOf(this.subProcessInstance.getId()));
        this.logger.info("in dealFinish1, mergeEndNodeTaskInstanceVarPool, taskInstanceList.size:{}, subProcessInstance.getId:{}", (Object)taskInstanceList.size(), (Object)this.subProcessInstance.getId());
        List endTaskInstancesSortedByEndTimeReversed = taskInstanceList.stream().filter(o -> taskCodes.contains(Long.toString(o.getTaskCode()))).sorted(Comparator.comparing(TaskInstance::getEndTime).reversed()).collect(Collectors.toList());
        this.logger.info("in dealFinish1, mergeEndNodeTaskInstanceVarPool, endTaskInstancesSortedByEndTimeReversed.size:{}", (Object)endTaskInstancesSortedByEndTimeReversed.size());
        HashMap<String, Property> allProperties = new HashMap<String, Property>();
        for (TaskInstance taskInstance : endTaskInstancesSortedByEndTimeReversed) {
            String varPool = taskInstance.getVarPool();
            if (!StringUtils.isNotEmpty((String)varPool)) continue;
            List properties = JSONUtils.toList((String)varPool, Property.class);
            properties.forEach(o -> allProperties.put(o.getProp(), (Property)o));
        }
        return allProperties;
    }

    private void dealFinish1() {
        ProcessDefinition processDefinition = this.processService.findProcessDefinition(this.subProcessInstance.getProcessDefinitionCode(), this.subProcessInstance.getProcessDefinitionVersion());
        if (null == processDefinition) {
            this.logger.error("process definition not found in meta data, processDefinitionCode:{}, processDefinitionVersion:{}, processInstanceId:{}", new Object[]{this.subProcessInstance.getProcessDefinitionCode(), this.subProcessInstance.getProcessDefinitionVersion(), this.subProcessInstance.getId()});
            throw new RuntimeException(String.format("process definition  code %s, version %s does not exist", this.subProcessInstance.getProcessDefinitionCode(), this.subProcessInstance.getProcessDefinitionVersion()));
        }
        this.subProcessInstance.setProcessDefinition(processDefinition);
        DAG dag = this.processService.genDagGraph(this.subProcessInstance.getProcessDefinition());
        Set<String> endTaskCodes = dag.getEndNode().stream().collect(Collectors.toSet());
        this.logger.info("in dealFinish1, endTaskCodes:{}", endTaskCodes);
        if (endTaskCodes == null || endTaskCodes.isEmpty()) {
            return;
        }
        Map<String, Property> varPoolPropertiesMap = this.mergeEndNodeTaskInstanceVarPool(endTaskCodes);
        this.logger.debug("in dealFinish1, varPoolPropertiesMap:{}", varPoolPropertiesMap);
        String taskVarPool = this.taskInstance.getVarPool();
        Map<Object, Object> taskVarPoolProperties = new HashMap();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)taskVarPool)) {
            taskVarPoolProperties = JSONUtils.toList((String)taskVarPool, Property.class).stream().collect(Collectors.toMap(Property::getProp, p -> p));
        }
        Map taskParams = (Map)JSONUtils.parseObject((String)this.taskInstance.getTaskParams(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        Object localParams = taskParams.get("localParams");
        Map<Object, Object> outProperties = new HashMap();
        if (localParams != null) {
            List properties = JSONUtils.toList((String)JSONUtils.toJsonString(localParams), Property.class);
            outProperties = properties.stream().filter(r -> Direct.OUT == r.getDirect()).collect(Collectors.toMap(Property::getProp, p -> p));
            outProperties.putAll(taskVarPoolProperties);
            for (Map.Entry<Object, Object> o : outProperties.entrySet()) {
                if (!varPoolPropertiesMap.containsKey(o.getKey())) continue;
                ((Property)o.getValue()).setValue(varPoolPropertiesMap.get(o.getKey()).getValue());
            }
        } else {
            outProperties.putAll(taskVarPoolProperties);
            outProperties.putAll(varPoolPropertiesMap);
        }
        this.taskInstance.setVarPool(JSONUtils.toJsonString(outProperties.values()));
        this.logger.debug("in dealFinish1, varPool:{}", (Object)this.taskInstance.getVarPool());
        this.processService.changeOutParam(this.taskInstance);
    }

    @Override
    protected boolean persistTask(TaskAction taskAction) {
        switch (taskAction) {
            case STOP: {
                return true;
            }
        }
        this.logger.error("unknown task action: {}", (Object)taskAction);
        return false;
    }

    @Override
    protected boolean pauseTask() {
        this.pauseSubWorkFlow();
        return true;
    }

    private boolean pauseSubWorkFlow() {
        this.subProcessInstance = this.processService.findSubProcessInstance(Integer.valueOf(this.processInstance.getId()), Integer.valueOf(this.taskInstance.getId()));
        if (this.subProcessInstance == null || this.taskInstance.getState().typeIsFinished()) {
            return false;
        }
        this.subProcessInstance.setState(ExecutionStatus.READY_PAUSE);
        this.processService.updateProcessInstance(this.subProcessInstance);
        this.sendToSubProcess();
        return true;
    }

    private boolean setSubWorkFlow() {
        this.logger.info("set work flow {} task {} running", (Object)this.processInstance.getId(), (Object)this.taskInstance.getId());
        if (this.subProcessInstance != null) {
            return true;
        }
        this.subProcessInstance = this.processService.findSubProcessInstance(Integer.valueOf(this.processInstance.getId()), Integer.valueOf(this.taskInstance.getId()));
        if (this.subProcessInstance == null || this.taskInstance.getState().typeIsFinished()) {
            return false;
        }
        TaskInstance instance = this.processService.findTaskInstanceById(Integer.valueOf(this.taskInstance.getId()));
        if (instance.getState() == ExecutionStatus.RUNNING_EXECUTION) {
            this.taskInstance.setState(ExecutionStatus.RUNNING_EXECUTION);
            return true;
        }
        this.taskInstance.setState(ExecutionStatus.RUNNING_EXECUTION);
        this.taskInstance.setStartTime(new Date());
        this.processService.updateTaskInstance(this.taskInstance);
        this.logger.info("set sub work flow {} task {} state: {}", new Object[]{this.processInstance.getId(), this.taskInstance.getId(), this.taskInstance.getState()});
        return true;
    }

    @Override
    protected boolean killTask() {
        this.subProcessInstance = this.processService.findSubProcessInstance(Integer.valueOf(this.processInstance.getId()), Integer.valueOf(this.taskInstance.getId()));
        if (this.subProcessInstance == null || this.taskInstance.getState().typeIsFinished()) {
            return false;
        }
        this.subProcessInstance.setState(ExecutionStatus.READY_STOP);
        this.processService.updateProcessInstance(this.subProcessInstance);
        this.sendToSubProcess();
        this.taskInstance.setState(ExecutionStatus.KILL);
        this.taskInstance.setEndTime(new Date());
        this.dealFinish1();
        this.processService.saveTaskInstance(this.taskInstance);
        return true;
    }

    private void sendToSubProcess() {
        StateEventChangeCommand stateEventChangeCommand = new StateEventChangeCommand(this.processInstance.getId(), this.taskInstance.getId(), this.subProcessInstance.getState(), this.subProcessInstance.getId(), 0);
        String address = this.subProcessInstance.getHost().split(":")[0];
        int port = Integer.parseInt(this.subProcessInstance.getHost().split(":")[1]);
        this.stateEventCallbackService.sendResult(address, port, stateEventChangeCommand.convert2Command());
    }

    @Override
    public String getType() {
        return TaskType.SUB_PROCESS.getDesc();
    }
}

