/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.DataType;
import org.apache.dolphinscheduler.common.enums.DependResult;
import org.apache.dolphinscheduler.common.enums.Direct;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.StateEvent;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.common.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.common.enums.TimeoutFlag;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.model.TaskNode;
import org.apache.dolphinscheduler.common.model.TaskNodeRelation;
import org.apache.dolphinscheduler.common.process.ProcessDag;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.Environment;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.ProjectUser;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.utils.DagHelper;
import org.apache.dolphinscheduler.remote.command.HostUpdateCommand;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.dispatch.executor.NettyExecutorManager;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskResponseEvent;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskResponseService;
import org.apache.dolphinscheduler.server.master.runner.task.ITaskProcessor;
import org.apache.dolphinscheduler.server.master.runner.task.TaskAction;
import org.apache.dolphinscheduler.server.master.runner.task.TaskProcessorFactory;
import org.apache.dolphinscheduler.service.alert.ProcessAlertManager;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.service.quartz.cron.CronUtils;
import org.apache.dolphinscheduler.service.queue.PeerTaskInstancePriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowExecuteThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowExecuteThread.class);
    private final Map<Integer, ITaskProcessor> activeTaskProcessorMaps = new ConcurrentHashMap<Integer, ITaskProcessor>();
    private TaskResponseService taskResponseService;
    private ProcessInstance processInstance;
    private boolean taskFailedSubmit = false;
    private List<TaskInstance> recoverNodeIdList = new ArrayList<TaskInstance>();
    private Map<String, TaskInstance> errorTaskList = new ConcurrentHashMap<String, TaskInstance>();
    private Map<String, TaskInstance> completeTaskList = new ConcurrentHashMap<String, TaskInstance>();
    private PeerTaskInstancePriorityQueue readyToSubmitTaskQueue = new PeerTaskInstancePriorityQueue();
    private Map<String, TaskInstance> dependFailedTask = new ConcurrentHashMap<String, TaskInstance>();
    private Map<String, TaskNode> forbiddenTaskList = new ConcurrentHashMap<String, TaskNode>();
    private Map<String, TaskNode> skipTaskNodeList = new ConcurrentHashMap<String, TaskNode>();
    private List<TaskInstance> recoverToleranceFaultTaskList = new ArrayList<TaskInstance>();
    private ProcessAlertManager processAlertManager;
    private DAG<String, TaskNode, TaskNodeRelation> dag;
    private ProcessService processService;
    private MasterConfig masterConfig;
    private NettyExecutorManager nettyExecutorManager;
    private ConcurrentLinkedQueue<StateEvent> stateEvents = new ConcurrentLinkedQueue();
    private List<Date> complementListDate = Lists.newLinkedList();
    private Table<Integer, Long, TaskInstance> taskInstanceHashMap = HashBasedTable.create();
    private ProcessDefinition processDefinition;
    private String key;
    private ConcurrentHashMap<Integer, TaskInstance> taskTimeoutCheckList;
    private ConcurrentHashMap<Integer, TaskInstance> taskRetryCheckList;
    private ConcurrentHashMap<Integer, TaskInstance> depStateCheckList;
    private boolean isStart = false;

    public WorkflowExecuteThread(ProcessInstance processInstance, TaskResponseService taskResponseService, ProcessService processService, NettyExecutorManager nettyExecutorManager, ProcessAlertManager processAlertManager, MasterConfig masterConfig, ConcurrentHashMap<Integer, TaskInstance> taskTimeoutCheckList, ConcurrentHashMap<Integer, TaskInstance> taskRetryCheckList, ConcurrentHashMap<Integer, TaskInstance> depStateCheckList) {
        this.processService = processService;
        this.taskResponseService = taskResponseService;
        this.processInstance = processInstance;
        this.masterConfig = masterConfig;
        this.nettyExecutorManager = nettyExecutorManager;
        this.processAlertManager = processAlertManager;
        this.taskTimeoutCheckList = taskTimeoutCheckList;
        this.taskRetryCheckList = taskRetryCheckList;
        this.depStateCheckList = depStateCheckList;
    }

    @Override
    public void run() {
        try {
            if (!this.isStart()) {
                this.startProcess();
            } else {
                this.handleEvents();
            }
        }
        catch (Exception e) {
            logger.error("handler error:", (Throwable)e);
        }
    }

    public boolean isStart() {
        return this.isStart;
    }

    private void handleEvents() {
        while (!this.stateEvents.isEmpty()) {
            try {
                StateEvent stateEvent = this.stateEvents.peek();
                if (!this.stateEventHandler(stateEvent)) continue;
                this.stateEvents.remove(stateEvent);
            }
            catch (Exception e) {
                logger.error("state handle error:", (Throwable)e);
            }
        }
    }

    public String getKey() {
        if (StringUtils.isNotEmpty((String)this.key) || this.processDefinition == null) {
            return this.key;
        }
        this.key = String.format("%d_%d_%d", this.processDefinition.getCode(), this.processDefinition.getVersion(), this.processInstance.getId());
        return this.key;
    }

    public boolean addStateEvent(StateEvent stateEvent) {
        if (this.processInstance.getId() != stateEvent.getProcessInstanceId()) {
            logger.info("state event would be abounded :{}", (Object)stateEvent.toString());
            return false;
        }
        this.stateEvents.add(stateEvent);
        return true;
    }

    public int eventSize() {
        return this.stateEvents.size();
    }

    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    private boolean stateEventHandler(StateEvent stateEvent) {
        logger.info("process event: {}", (Object)stateEvent.toString());
        if (!this.checkStateEvent(stateEvent)) {
            return false;
        }
        boolean result = false;
        switch (stateEvent.getType()) {
            case PROCESS_STATE_CHANGE: {
                result = this.processStateChangeHandler(stateEvent);
                break;
            }
            case TASK_STATE_CHANGE: {
                result = this.taskStateChangeHandler(stateEvent);
                break;
            }
            case PROCESS_TIMEOUT: {
                result = this.processTimeout();
                break;
            }
            case TASK_TIMEOUT: {
                result = this.taskTimeout(stateEvent);
                break;
            }
        }
        if (result) {
            this.stateEvents.remove(stateEvent);
        }
        return result;
    }

    private boolean taskTimeout(StateEvent stateEvent) {
        if (!this.checkTaskInstanceByStateEvent(stateEvent)) {
            return true;
        }
        TaskInstance taskInstance = this.processService.findTaskInstanceById(Integer.valueOf(stateEvent.getTaskInstanceId()));
        TaskDefinition taskDefinition = this.processService.findTaskDefinition(taskInstance.getTaskCode(), taskInstance.getTaskDefinitionVersion());
        taskInstance.setTaskDefine(taskDefinition);
        if (TimeoutFlag.CLOSE == taskInstance.getTaskDefine().getTimeoutFlag()) {
            return true;
        }
        TaskTimeoutStrategy taskTimeoutStrategy = taskInstance.getTaskDefine().getTimeoutNotifyStrategy();
        if (!(TaskTimeoutStrategy.FAILED != taskTimeoutStrategy && TaskTimeoutStrategy.WARNFAILED != taskTimeoutStrategy || taskInstance.getState().typeIsFinished())) {
            ITaskProcessor taskProcessor = this.activeTaskProcessorMaps.get(stateEvent.getTaskInstanceId());
            taskProcessor.action(TaskAction.TIMEOUT);
            if (taskInstance.isDependTask()) {
                TaskInstance task = this.processService.findTaskInstanceById(Integer.valueOf(taskInstance.getId()));
                this.taskFinished(task);
            }
            if (TaskTimeoutStrategy.WARNFAILED == taskTimeoutStrategy) {
                ProjectUser projectUser = this.processService.queryProjectWithUserByProcessInstanceId(this.processInstance.getId());
                this.processAlertManager.sendTaskTimeoutAlert(this.processInstance, taskInstance, projectUser);
            }
        } else {
            ProjectUser projectUser = this.processService.queryProjectWithUserByProcessInstanceId(this.processInstance.getId());
            this.processAlertManager.sendTaskTimeoutAlert(this.processInstance, taskInstance, projectUser);
        }
        return true;
    }

    private boolean processTimeout() {
        ProjectUser projectUser = this.processService.queryProjectWithUserByProcessInstanceId(this.processInstance.getId());
        this.processAlertManager.sendProcessTimeoutAlert(this.processInstance, projectUser);
        return true;
    }

    private boolean checkTaskInstanceByStateEvent(StateEvent stateEvent) {
        if (stateEvent.getTaskInstanceId() == 0) {
            logger.error("task instance id null, state event:{}", (Object)stateEvent);
            return false;
        }
        if (!this.taskInstanceHashMap.containsRow((Object)stateEvent.getTaskInstanceId())) {
            logger.error("mismatch task instance id, event:{}", (Object)stateEvent);
            return false;
        }
        return true;
    }

    private boolean taskStateChangeHandler(StateEvent stateEvent) {
        if (!this.checkTaskInstanceByStateEvent(stateEvent)) {
            return true;
        }
        TaskInstance task = this.processService.findTaskInstanceById(Integer.valueOf(stateEvent.getTaskInstanceId()));
        if (task.getState() == null) {
            logger.error("task state is null, state handler error: {}", (Object)stateEvent);
            return true;
        }
        if (task.getState().typeIsFinished()) {
            if (this.completeTaskList.containsKey(Long.toString(task.getTaskCode())) && this.completeTaskList.get(Long.toString(task.getTaskCode())).getId() == task.getId() && task.getState() != ExecutionStatus.NEED_FAULT_TOLERANCE) {
                return true;
            }
            if (task.getStartTime() == null) {
                logger.info("Maybe TASK_EXECUTE_ACK has not been received when the task finish, will wait for one second");
                ThreadUtils.sleep((long)1000L);
            }
            this.taskFinished(task);
            return true;
        }
        if (this.activeTaskProcessorMaps.containsKey(stateEvent.getTaskInstanceId())) {
            ITaskProcessor iTaskProcessor = this.activeTaskProcessorMaps.get(stateEvent.getTaskInstanceId());
            iTaskProcessor.action(TaskAction.RUN);
            if (iTaskProcessor.taskState().typeIsFinished()) {
                task = this.processService.findTaskInstanceById(Integer.valueOf(stateEvent.getTaskInstanceId()));
                this.taskFinished(task);
            }
            return true;
        }
        logger.error("state handler error: {}", (Object)stateEvent);
        return true;
    }

    private void taskFinished(TaskInstance task) {
        logger.info("work flow {} task {} state:{} ", new Object[]{this.processInstance.getId(), task.getId(), task.getState()});
        if (task.getState() == ExecutionStatus.NEED_FAULT_TOLERANCE) {
            logger.info("resubmit NEED_FAULT_TOLERANCE {} task", (Object)task.getId());
            if (task.getMaxRetryTimes() == 0) {
                task.setRetryTimes(task.getRetryTimes() + 1);
            }
            this.addTaskToStandByList(task);
            this.submitStandByTask();
            return;
        }
        if (task.taskCanRetry() && this.processInstance.getState() != ExecutionStatus.READY_STOP) {
            if (task.retryTaskIntervalOverTime()) {
                logger.info("failure task will be submitted: process id: {}, task instance id: {} state:{} retry times:{}/{}, interval:{}", new Object[]{this.processInstance.getId(), task.getId(), task.getState(), task.getRetryTimes() + 1, task.getMaxRetryTimes(), task.getRetryInterval()});
                this.submitStandByTask();
                if (task.taskCanRetry()) {
                    TaskInstance retryTask = this.processService.findTaskInstanceById(Integer.valueOf(task.getId()));
                    if (retryTask.isDependTask()) {
                        retryTask.setRetryTimes(retryTask.getRetryTimes() + 1);
                        if (retryTask.taskCanRetry()) {
                            this.addTaskToStandByList(retryTask);
                            this.taskRetryCheckList.put(retryTask.getId(), retryTask);
                        }
                    } else {
                        this.addTaskToStandByList(retryTask);
                        this.taskRetryCheckList.put(retryTask.getId(), retryTask);
                    }
                }
                return;
            }
            task.setRetryTimes(task.getRetryTimes() + 1);
            if (task.taskCanRetry()) {
                this.addTaskToStandByList(task);
                this.taskRetryCheckList.put(task.getId(), task);
                return;
            }
        }
        ProcessInstance processInstance = this.processService.findProcessInstanceById(this.processInstance.getId());
        this.completeTaskList.put(Long.toString(task.getTaskCode()), task);
        this.activeTaskProcessorMaps.remove(task.getId());
        this.taskTimeoutCheckList.remove(task.getId());
        this.taskRetryCheckList.remove(task.getId());
        this.depStateCheckList.remove(task.getId());
        if (task.getState().typeIsSuccess()) {
            this.processService.saveProcessInstance(processInstance);
            this.submitPostNode(Long.toString(task.getTaskCode()));
        } else if (task.getState().typeIsFailure()) {
            if (task.isConditionsTask() || DagHelper.haveConditionsAfterNode((String)Long.toString(task.getTaskCode()), this.dag)) {
                this.submitPostNode(Long.toString(task.getTaskCode()));
            } else {
                this.errorTaskList.put(Long.toString(task.getTaskCode()), task);
                if (processInstance.getFailureStrategy() == FailureStrategy.END) {
                    this.killAllTasks();
                }
            }
        }
        this.updateProcessInstanceState();
    }

    private boolean checkStateEvent(StateEvent stateEvent) {
        if (this.processInstance.getId() != stateEvent.getProcessInstanceId()) {
            logger.error("mismatch process instance id: {}, state event:{}, task instance id:{}", new Object[]{this.processInstance.getId(), stateEvent, stateEvent.getTaskInstanceId()});
            return false;
        }
        return true;
    }

    private boolean processStateChangeHandler(StateEvent stateEvent) {
        try {
            logger.info("process:{} state {} change to {}", new Object[]{this.processInstance.getId(), this.processInstance.getState(), stateEvent.getExecutionStatus()});
            this.processInstance = this.processService.findProcessInstanceById(this.processInstance.getId());
            if (stateEvent.getExecutionStatus().typeIsCancel()) {
                this.updateProcessInstanceState(stateEvent);
                return true;
            }
            if (this.processComplementData()) {
                return true;
            }
            if (stateEvent.getExecutionStatus().typeIsFinished()) {
                this.endProcess();
            }
            if (this.processInstance.getState() == ExecutionStatus.READY_STOP) {
                this.killAllTasks();
            }
            return true;
        }
        catch (Exception e) {
            logger.error("process state change error:", (Throwable)e);
            return true;
        }
    }

    private boolean processComplementData() {
        if (!this.needComplementProcess()) {
            return false;
        }
        if (this.processInstance.getState().typeIsReadyCancel()) {
            return false;
        }
        Date scheduleDate = this.processInstance.getScheduleTime();
        if (scheduleDate == null) {
            scheduleDate = this.complementListDate.get(0);
        } else if (this.processInstance.getState().typeIsFinished()) {
            this.endProcess();
            if (this.processInstance.getCommandType() == CommandType.REPEAT_RUNNING) {
                return true;
            }
            if (this.complementListDate.size() <= 0) {
                logger.info("process complement end. process id:{}", (Object)this.processInstance.getId());
                return true;
            }
            int index = this.complementListDate.indexOf(scheduleDate);
            if (index >= this.complementListDate.size() - 1) {
                logger.info("process complement end. process id:{}", (Object)this.processInstance.getId());
                return true;
            }
            logger.info("process complement continue. process id:{}, schedule time:{} complementListDate:{}", new Object[]{this.processInstance.getId(), this.processInstance.getScheduleTime(), this.complementListDate.toString()});
            scheduleDate = this.complementListDate.get(index + 1);
        }
        int create = this.createComplementDataCommand(scheduleDate);
        if (create > 0) {
            logger.info("create complement data command successfully. process id: {}", (Object)this.processInstance.getId());
        }
        return true;
    }

    private int createComplementDataCommand(Date scheduleDate) {
        Command command = new Command();
        command.setScheduleTime(scheduleDate);
        command.setCommandType(CommandType.COMPLEMENT_DATA);
        command.setProcessDefinitionCode(this.processInstance.getProcessDefinitionCode().longValue());
        Map cmdParam = JSONUtils.toMap((String)this.processInstance.getCommandParam());
        if (cmdParam.containsKey("StartNodeIdList")) {
            cmdParam.remove("StartNodeIdList");
        }
        cmdParam.replace("complementStartDate", DateUtils.format((Date)scheduleDate, (String)"yyyy-MM-dd HH:mm:ss"));
        command.setCommandParam(JSONUtils.toJsonString((Object)cmdParam));
        command.setTaskDependType(this.processInstance.getTaskDependType());
        command.setFailureStrategy(this.processInstance.getFailureStrategy());
        command.setWarningType(this.processInstance.getWarningType());
        command.setWarningGroupId(this.processInstance.getWarningGroupId());
        command.setStartTime(new Date());
        command.setExecutorId(this.processInstance.getExecutorId());
        command.setUpdateTime(new Date());
        command.setProcessInstancePriority(this.processInstance.getProcessInstancePriority());
        command.setWorkerGroup(this.processInstance.getWorkerGroup());
        command.setEnvironmentCode(this.processInstance.getEnvironmentCode());
        command.setDryRun(this.processInstance.getDryRun());
        command.setProcessInstanceId(0);
        command.setProcessDefinitionVersion(this.processInstance.getProcessDefinitionVersion());
        return this.processService.createCommand(command);
    }

    private boolean needComplementProcess() {
        return this.processInstance.isComplementData() && Flag.NO == this.processInstance.getIsSubProcess();
    }

    private void startProcess() throws Exception {
        if (this.taskInstanceHashMap.size() == 0) {
            this.isStart = false;
            this.buildFlowDag();
            this.initTaskQueue();
            this.submitPostNode(null);
            this.isStart = true;
        }
    }

    private void endProcess() {
        this.stateEvents.clear();
        this.processInstance.setEndTime(new Date());
        this.processService.updateProcessInstance(this.processInstance);
        if (this.processInstance.getState().typeIsWaitingThread()) {
            this.processService.createRecoveryWaitingThreadCommand(null, this.processInstance);
        }
        if (this.processAlertManager.isNeedToSendWarning(this.processInstance)) {
            List taskInstances = this.processService.findValidTaskListByProcessId(Integer.valueOf(this.processInstance.getId()));
            ProjectUser projectUser = this.processService.queryProjectWithUserByProcessInstanceId(this.processInstance.getId());
            this.processAlertManager.sendAlertProcessInstance(this.processInstance, taskInstances, projectUser);
        }
    }

    private void buildFlowDag() throws Exception {
        if (this.dag != null) {
            return;
        }
        this.processDefinition = this.processService.findProcessDefinition(this.processInstance.getProcessDefinitionCode(), this.processInstance.getProcessDefinitionVersion());
        this.recoverNodeIdList = this.getStartTaskInstanceList(this.processInstance.getCommandParam());
        List processTaskRelationList = this.processService.findRelationByCode(this.processDefinition.getCode(), this.processDefinition.getVersion());
        List taskDefinitionLogList = this.processService.getTaskDefineLogListByRelation(processTaskRelationList);
        List taskNodeList = this.processService.transformTask(processTaskRelationList, taskDefinitionLogList);
        this.forbiddenTaskList.clear();
        taskNodeList.forEach(taskNode -> {
            if (taskNode.isForbidden().booleanValue()) {
                this.forbiddenTaskList.put(Long.toString(taskNode.getCode()), (TaskNode)taskNode);
            }
        });
        List<String> recoveryNodeCodeList = this.getRecoveryNodeCodeList();
        List<String> startNodeNameList = this.parseStartNodeName(this.processInstance.getCommandParam());
        ProcessDag processDag = this.generateFlowDag(taskNodeList, startNodeNameList, recoveryNodeCodeList, this.processInstance.getTaskDependType());
        if (processDag == null) {
            logger.error("processDag is null");
            return;
        }
        this.dag = DagHelper.buildDagGraph((ProcessDag)processDag);
    }

    private void initTaskQueue() {
        Map cmdParam;
        this.taskFailedSubmit = false;
        this.activeTaskProcessorMaps.clear();
        this.dependFailedTask.clear();
        this.completeTaskList.clear();
        this.errorTaskList.clear();
        List taskInstanceList = this.processService.findValidTaskListByProcessId(Integer.valueOf(this.processInstance.getId()));
        for (TaskInstance task : taskInstanceList) {
            if (task.isTaskComplete()) {
                this.completeTaskList.put(Long.toString(task.getTaskCode()), task);
            }
            if (task.isConditionsTask() || DagHelper.haveConditionsAfterNode((String)Long.toString(task.getTaskCode()), this.dag) || !task.getState().typeIsFailure() || task.taskCanRetry()) continue;
            this.errorTaskList.put(Long.toString(task.getTaskCode()), task);
        }
        if (this.processInstance.isComplementData() && this.complementListDate.size() == 0 && (cmdParam = JSONUtils.toMap((String)this.processInstance.getCommandParam())) != null && cmdParam.containsKey("complementStartDate")) {
            this.setGlobalParamIfCommanded(this.processDefinition, cmdParam);
            Date start = DateUtils.stringToDate((String)((String)cmdParam.get("complementStartDate")));
            Date end = DateUtils.stringToDate((String)((String)cmdParam.get("complementEndDate")));
            List schedules = this.processService.queryReleaseSchedulerListByProcessDefinitionCode(this.processInstance.getProcessDefinitionCode().longValue());
            if (this.complementListDate.size() == 0 && this.needComplementProcess()) {
                this.complementListDate = CronUtils.getSelfFireDateList((Date)start, (Date)end, (List)schedules);
                logger.info(" process definition code:{} complement data: {}", (Object)this.processInstance.getProcessDefinitionCode(), (Object)this.complementListDate.toString());
                if (this.complementListDate.size() > 0 && Flag.NO == this.processInstance.getIsSubProcess()) {
                    this.processInstance.setScheduleTime(this.complementListDate.get(0));
                    this.processInstance.setGlobalParams(ParameterUtils.curingGlobalParams((Map)this.processDefinition.getGlobalParamMap(), (List)this.processDefinition.getGlobalParamList(), (CommandType)CommandType.COMPLEMENT_DATA, (Date)this.processInstance.getScheduleTime()));
                    this.processService.updateProcessInstance(this.processInstance);
                }
            }
        }
    }

    private TaskInstance submitTaskExec(TaskInstance taskInstance) {
        try {
            ITaskProcessor taskProcessor = TaskProcessorFactory.getTaskProcessor(taskInstance.getTaskType());
            if (taskInstance.getState() == ExecutionStatus.RUNNING_EXECUTION && taskProcessor.getType().equalsIgnoreCase("common")) {
                this.notifyProcessHostUpdate(taskInstance);
            }
            taskProcessor.init(taskInstance, this.processInstance);
            boolean submit = taskProcessor.action(TaskAction.SUBMIT);
            if (submit) {
                this.taskInstanceHashMap.put((Object)taskInstance.getId(), (Object)taskInstance.getTaskCode(), (Object)taskInstance);
                this.activeTaskProcessorMaps.put(taskInstance.getId(), taskProcessor);
                taskProcessor.action(TaskAction.RUN);
                this.addTimeoutCheck(taskInstance);
                this.addDepTaskCheck(taskInstance);
                TaskDefinition taskDefinition = this.processService.findTaskDefinition(taskInstance.getTaskCode(), taskInstance.getTaskDefinitionVersion());
                taskInstance.setTaskDefine(taskDefinition);
                if (taskProcessor.taskState().typeIsFinished()) {
                    StateEvent stateEvent = new StateEvent();
                    stateEvent.setProcessInstanceId(this.processInstance.getId());
                    stateEvent.setTaskInstanceId(taskInstance.getId());
                    stateEvent.setExecutionStatus(taskProcessor.taskState());
                    stateEvent.setType(StateEventType.TASK_STATE_CHANGE);
                    this.stateEvents.add(stateEvent);
                }
                return taskInstance;
            }
            logger.error("process id:{} name:{} submit standby task id:{} name:{} failed!", new Object[]{this.processInstance.getId(), this.processInstance.getName(), taskInstance.getId(), taskInstance.getName()});
            return null;
        }
        catch (Exception e) {
            logger.error("submit standby task error", (Throwable)e);
            return null;
        }
    }

    private void notifyProcessHostUpdate(TaskInstance taskInstance) {
        if (StringUtils.isEmpty((String)taskInstance.getHost())) {
            return;
        }
        try {
            HostUpdateCommand hostUpdateCommand = new HostUpdateCommand();
            hostUpdateCommand.setProcessHost(NetUtils.getAddr((int)this.masterConfig.getListenPort()));
            hostUpdateCommand.setTaskInstanceId(taskInstance.getId());
            Host host = new Host(taskInstance.getHost());
            this.nettyExecutorManager.doExecute(host, hostUpdateCommand.convert2Command());
        }
        catch (Exception e) {
            logger.error("notify process host update", (Throwable)e);
        }
    }

    private void addTimeoutCheck(TaskInstance taskInstance) {
        if (this.taskTimeoutCheckList.containsKey(taskInstance.getId())) {
            return;
        }
        if (taskInstance.getTaskDefine() == null) {
            TaskDefinition taskDefinition = this.processService.findTaskDefinition(taskInstance.getTaskCode(), taskInstance.getTaskDefinitionVersion());
            taskInstance.setTaskDefine(taskDefinition);
        }
        if (TimeoutFlag.OPEN == taskInstance.getTaskDefine().getTimeoutFlag()) {
            this.taskTimeoutCheckList.put(taskInstance.getId(), taskInstance);
        }
        if (taskInstance.isDependTask() || taskInstance.isSubProcess()) {
            this.taskTimeoutCheckList.put(taskInstance.getId(), taskInstance);
        }
    }

    private void addDepTaskCheck(TaskInstance taskInstance) {
        if (taskInstance.isDependTask()) {
            if (this.depStateCheckList.containsKey(taskInstance.getId())) {
                return;
            }
            this.depStateCheckList.put(taskInstance.getId(), taskInstance);
        }
    }

    private void addRetryCheck(TaskInstance taskInstance) {
        if (this.taskRetryCheckList.containsKey(taskInstance.getId())) {
            return;
        }
        if (taskInstance.getTaskDefine() == null) {
            TaskDefinition taskDefinition = this.processService.findTaskDefinition(taskInstance.getTaskCode(), taskInstance.getTaskDefinitionVersion());
            taskInstance.setTaskDefine(taskDefinition);
        }
        if (taskInstance.getRetryTimes() <= taskInstance.getMaxRetryTimes() && taskInstance.isDependTask()) {
            this.taskRetryCheckList.put(taskInstance.getId(), taskInstance);
        }
    }

    private TaskInstance findTaskIfExists(Long taskCode, int taskVersion) {
        List taskInstanceList = this.processService.findValidTaskListByProcessId(Integer.valueOf(this.processInstance.getId()));
        for (TaskInstance taskInstance : taskInstanceList) {
            if (taskInstance.getTaskCode() != taskCode.longValue() || taskInstance.getTaskDefinitionVersion() != taskVersion) continue;
            return taskInstance;
        }
        return null;
    }

    private TaskInstance createTaskInstance(ProcessInstance processInstance, TaskNode taskNode) {
        TaskInstance taskInstance = this.findTaskIfExists(taskNode.getCode(), taskNode.getVersion());
        if (taskInstance == null) {
            Environment environment;
            Long taskEnvironmentCode;
            taskInstance = new TaskInstance();
            taskInstance.setTaskCode(taskNode.getCode());
            taskInstance.setTaskDefinitionVersion(taskNode.getVersion());
            taskInstance.setName(taskNode.getName());
            taskInstance.setState(ExecutionStatus.SUBMITTED_SUCCESS);
            taskInstance.setProcessInstanceId(processInstance.getId());
            taskInstance.setTaskType(taskNode.getType().toUpperCase());
            taskInstance.setAlertFlag(Flag.NO);
            taskInstance.setStartTime(null);
            taskInstance.setFlag(Flag.YES);
            taskInstance.setDryRun(processInstance.getDryRun());
            taskInstance.setRetryTimes(0);
            taskInstance.setMaxRetryTimes(taskNode.getMaxRetryTimes());
            taskInstance.setRetryInterval(taskNode.getRetryInterval());
            taskInstance.setTaskParams(taskNode.getTaskParams());
            if (taskNode.getTaskInstancePriority() == null) {
                taskInstance.setTaskInstancePriority(Priority.MEDIUM);
            } else {
                taskInstance.setTaskInstancePriority(taskNode.getTaskInstancePriority());
            }
            String processWorkerGroup = processInstance.getWorkerGroup();
            processWorkerGroup = StringUtils.isBlank((String)processWorkerGroup) ? "default" : processWorkerGroup;
            String taskWorkerGroup = StringUtils.isBlank((String)taskNode.getWorkerGroup()) ? processWorkerGroup : taskNode.getWorkerGroup();
            Long processEnvironmentCode = Objects.isNull(processInstance.getEnvironmentCode()) ? -1L : processInstance.getEnvironmentCode();
            Long l = taskEnvironmentCode = Objects.isNull(taskNode.getEnvironmentCode()) ? processEnvironmentCode : taskNode.getEnvironmentCode();
            if (!processWorkerGroup.equals("default") && taskWorkerGroup.equals("default")) {
                taskInstance.setWorkerGroup(processWorkerGroup);
                taskInstance.setEnvironmentCode(processEnvironmentCode);
            } else {
                taskInstance.setWorkerGroup(taskWorkerGroup);
                taskInstance.setEnvironmentCode(taskEnvironmentCode);
            }
            if (!taskInstance.getEnvironmentCode().equals(-1L) && Objects.nonNull(environment = this.processService.findEnvironmentByCode(taskInstance.getEnvironmentCode())) && StringUtils.isNotEmpty((String)environment.getConfig())) {
                taskInstance.setEnvironmentConfig(environment.getConfig());
            }
            taskInstance.setDelayTime(taskNode.getDelayTime());
        }
        return taskInstance;
    }

    public void getPreVarPool(TaskInstance taskInstance, Set<String> preTask) {
        HashMap<String, Property> allProperty = new HashMap<String, Property>();
        HashMap<String, TaskInstance> allTaskInstance = new HashMap<String, TaskInstance>();
        if (CollectionUtils.isNotEmpty(preTask)) {
            for (String preTaskCode : preTask) {
                String preVarPool;
                TaskInstance preTaskInstance = this.completeTaskList.get(preTaskCode);
                if (preTaskInstance == null || !StringUtils.isNotEmpty((String)(preVarPool = preTaskInstance.getVarPool()))) continue;
                List properties = JSONUtils.toList((String)preVarPool, Property.class);
                for (Property info : properties) {
                    this.setVarPoolValue(allProperty, allTaskInstance, preTaskInstance, info);
                }
            }
            if (allProperty.size() > 0) {
                taskInstance.setVarPool(JSONUtils.toJsonString(allProperty.values()));
            }
        }
    }

    private void setVarPoolValue(Map<String, Property> allProperty, Map<String, TaskInstance> allTaskInstance, TaskInstance preTaskInstance, Property thisProperty) {
        thisProperty.setDirect(Direct.IN);
        String proName = thisProperty.getProp();
        if (allProperty.containsKey(proName)) {
            Property otherPro = allProperty.get(proName);
            if (StringUtils.isEmpty((String)thisProperty.getValue())) {
                allProperty.put(proName, otherPro);
            } else if (StringUtils.isNotEmpty((String)otherPro.getValue())) {
                TaskInstance otherTask = allTaskInstance.get(proName);
                if (otherTask.getEndTime().getTime() > preTaskInstance.getEndTime().getTime()) {
                    allProperty.put(proName, thisProperty);
                    allTaskInstance.put(proName, preTaskInstance);
                } else {
                    allProperty.put(proName, otherPro);
                }
            } else {
                allProperty.put(proName, thisProperty);
                allTaskInstance.put(proName, preTaskInstance);
            }
        } else {
            allProperty.put(proName, thisProperty);
            allTaskInstance.put(proName, preTaskInstance);
        }
    }

    private void submitPostNode(String parentNodeCode) {
        Set submitTaskNodeList = DagHelper.parsePostNodes((String)parentNodeCode, this.skipTaskNodeList, this.dag, this.completeTaskList);
        ArrayList<TaskInstance> taskInstances = new ArrayList<TaskInstance>();
        for (String taskNode : submitTaskNodeList) {
            TaskNode taskNodeObject = (TaskNode)this.dag.getNode((Object)taskNode);
            if (this.taskInstanceHashMap.containsColumn((Object)taskNodeObject.getCode())) continue;
            TaskInstance task = this.createTaskInstance(this.processInstance, taskNodeObject);
            if (!(!this.processInstance.getState().typeIsReadyPause() || this.activeTaskProcessorMaps.isEmpty() && this.completeTaskList.isEmpty())) {
                task.setState(ExecutionStatus.PAUSE);
                this.completeTaskList.put(String.valueOf(task.getTaskCode()), task);
                continue;
            }
            taskInstances.add(task);
        }
        for (TaskInstance task : taskInstances) {
            if (this.readyToSubmitTaskQueue.contains(task)) continue;
            if (this.completeTaskList.containsKey(Long.toString(task.getTaskCode()))) {
                logger.info("task {} has already run success, task id:{}", (Object)task.getName(), (Object)task.getId());
                continue;
            }
            if (task.getState().typeIsCancel()) {
                logger.info("task {} stopped, the state is {}, task id:{}", new Object[]{task.getName(), task.getState(), task.getId()});
                continue;
            }
            this.addTaskToStandByList(task);
        }
        this.submitStandByTask();
        this.updateProcessInstanceState();
    }

    private DependResult isTaskDepsComplete(String taskCode) {
        Collection startNodes = this.dag.getBeginNode();
        if (startNodes.contains(taskCode)) {
            return DependResult.SUCCESS;
        }
        TaskNode taskNode = (TaskNode)this.dag.getNode((Object)taskCode);
        ArrayList<String> indirectDepCodeList = new ArrayList<String>();
        this.setIndirectDepList(taskCode, indirectDepCodeList);
        for (String depsNode : indirectDepCodeList) {
            if (!this.dag.containsNode((Object)depsNode) || this.skipTaskNodeList.containsKey(depsNode)) continue;
            if (!this.completeTaskList.containsKey(depsNode)) {
                return DependResult.WAITING;
            }
            ExecutionStatus depTaskState = this.completeTaskList.get(depsNode).getState();
            if (depTaskState.typeIsCancel()) {
                return DependResult.NON_EXEC;
            }
            if (taskNode.isConditionsTask() || this.dependTaskSuccess(depsNode, taskCode)) continue;
            return DependResult.FAILED;
        }
        logger.info("taskCode: {} completeDependTaskList: {}", (Object)taskCode, (Object)Arrays.toString(this.completeTaskList.keySet().toArray()));
        return DependResult.SUCCESS;
    }

    private void setIndirectDepList(String taskCode, List<String> indirectDepCodeList) {
        TaskNode taskNode = (TaskNode)this.dag.getNode((Object)taskCode);
        List depCodeList = taskNode.getDepList();
        for (String depsNode : depCodeList) {
            if (this.forbiddenTaskList.containsKey(depsNode)) {
                this.setIndirectDepList(depsNode, indirectDepCodeList);
                continue;
            }
            indirectDepCodeList.add(depsNode);
        }
    }

    private boolean dependTaskSuccess(String dependNodeName, String nextNodeName) {
        ExecutionStatus depTaskState;
        List nextTaskList;
        return !(((TaskNode)this.dag.getNode((Object)dependNodeName)).isConditionsTask() ? !(nextTaskList = DagHelper.parseConditionTask((String)dependNodeName, this.skipTaskNodeList, this.dag, this.completeTaskList)).contains(nextNodeName) : (depTaskState = this.completeTaskList.get(dependNodeName).getState()).typeIsFailure());
    }

    private List<TaskInstance> getCompleteTaskByState(ExecutionStatus state) {
        ArrayList<TaskInstance> resultList = new ArrayList<TaskInstance>();
        for (Map.Entry<String, TaskInstance> entry : this.completeTaskList.entrySet()) {
            if (entry.getValue().getState() != state) continue;
            resultList.add(entry.getValue());
        }
        return resultList;
    }

    private ExecutionStatus runningState(ExecutionStatus state) {
        if (state == ExecutionStatus.READY_STOP || state == ExecutionStatus.READY_PAUSE || state == ExecutionStatus.WAITING_THREAD || state == ExecutionStatus.DELAY_EXECUTION) {
            return state;
        }
        return ExecutionStatus.RUNNING_EXECUTION;
    }

    private boolean hasFailedTask() {
        List failureTaskIds;
        if (this.taskFailedSubmit) {
            return true;
        }
        if (this.errorTaskList.size() > 0) {
            for (Map.Entry<String, TaskInstance> errorTaskMap : this.errorTaskList.entrySet()) {
                TaskInstance taskInstance = this.processService.findTaskInstanceById(Integer.valueOf(errorTaskMap.getValue().getId()));
                if (taskInstance != null && !taskInstance.getState().typeIsSuccess()) continue;
                this.errorTaskList.remove(errorTaskMap.getKey());
            }
            if (this.errorTaskList.size() > 0) {
                return true;
            }
        } else if (!(this.processInstance.getCommandType() != CommandType.RECOVER_TOLERANCE_FAULT_PROCESS && this.processInstance.getCommandType() != CommandType.RECOVER_SUSPENDED_PROCESS || (failureTaskIds = this.processService.findLastTaskIdByStateList(this.processInstance.getId(), (List)Lists.newArrayList((Object[])new ExecutionStatus[]{ExecutionStatus.FAILURE, ExecutionStatus.NEED_FAULT_TOLERANCE, ExecutionStatus.KILL}))).isEmpty())) {
            return true;
        }
        return this.dependFailedTask.size() > 0;
    }

    private boolean processFailed() {
        if (this.hasFailedTask()) {
            if (this.processInstance.getFailureStrategy() == FailureStrategy.END) {
                return true;
            }
            if (this.processInstance.getFailureStrategy() == FailureStrategy.CONTINUE) {
                return this.readyToSubmitTaskQueue.size() == 0 && this.activeTaskProcessorMaps.size() == 0;
            }
        }
        return false;
    }

    private boolean hasWaitingThreadTask() {
        List<TaskInstance> waitingList = this.getCompleteTaskByState(ExecutionStatus.WAITING_THREAD);
        return CollectionUtils.isNotEmpty(waitingList);
    }

    private ExecutionStatus processReadyPause() {
        if (this.hasRetryTaskInStandBy()) {
            return ExecutionStatus.FAILURE;
        }
        List<TaskInstance> pauseList = this.getCompleteTaskByState(ExecutionStatus.PAUSE);
        if (CollectionUtils.isNotEmpty(pauseList) || !this.isComplementEnd()) {
            return ExecutionStatus.PAUSE;
        }
        return ExecutionStatus.SUCCESS;
    }

    private ExecutionStatus getProcessInstanceState(ProcessInstance instance) {
        ExecutionStatus state = instance.getState();
        if (this.activeTaskProcessorMaps.size() > 0 || this.hasRetryTaskInStandBy()) {
            return this.runningState(state);
        }
        if (this.hasWaitingThreadTask()) {
            return ExecutionStatus.WAITING_THREAD;
        }
        if (state == ExecutionStatus.READY_PAUSE) {
            return this.processReadyPause();
        }
        if (state == ExecutionStatus.READY_STOP) {
            List<TaskInstance> stopList = this.getCompleteTaskByState(ExecutionStatus.STOP);
            List<TaskInstance> killList = this.getCompleteTaskByState(ExecutionStatus.KILL);
            List<TaskInstance> failList = this.getCompleteTaskByState(ExecutionStatus.FAILURE);
            if (CollectionUtils.isNotEmpty(stopList) || CollectionUtils.isNotEmpty(killList) || CollectionUtils.isNotEmpty(failList) || !this.isComplementEnd()) {
                return ExecutionStatus.STOP;
            }
            return ExecutionStatus.SUCCESS;
        }
        if (this.processFailed()) {
            return ExecutionStatus.FAILURE;
        }
        if (state == ExecutionStatus.RUNNING_EXECUTION) {
            List<TaskInstance> killTasks = this.getCompleteTaskByState(ExecutionStatus.KILL);
            if (this.readyToSubmitTaskQueue.size() > 0) {
                return ExecutionStatus.RUNNING_EXECUTION;
            }
            if (CollectionUtils.isNotEmpty(killTasks)) {
                return ExecutionStatus.FAILURE;
            }
            return ExecutionStatus.SUCCESS;
        }
        return state;
    }

    private boolean isComplementEnd() {
        if (!this.processInstance.isComplementData()) {
            return true;
        }
        try {
            Map cmdParam = JSONUtils.toMap((String)this.processInstance.getCommandParam());
            Date endTime = DateUtils.getScheduleDate((String)((String)cmdParam.get("complementEndDate")));
            return this.processInstance.getScheduleTime().equals(endTime);
        }
        catch (Exception e) {
            logger.error("complement end failed ", (Throwable)e);
            return false;
        }
    }

    private void updateProcessInstanceState() {
        ProcessInstance instance = this.processService.findProcessInstanceById(this.processInstance.getId());
        ExecutionStatus state = this.getProcessInstanceState(instance);
        if (this.processInstance.getState() != state) {
            logger.info("work flow process instance [id: {}, name:{}], state change from {} to {}, cmd type: {}", new Object[]{this.processInstance.getId(), this.processInstance.getName(), this.processInstance.getState(), state, this.processInstance.getCommandType()});
            instance.setState(state);
            this.processService.updateProcessInstance(instance);
            this.processInstance = instance;
            StateEvent stateEvent = new StateEvent();
            stateEvent.setExecutionStatus(this.processInstance.getState());
            stateEvent.setProcessInstanceId(this.processInstance.getId());
            stateEvent.setType(StateEventType.PROCESS_STATE_CHANGE);
            this.processStateChangeHandler(stateEvent);
        }
    }

    private void updateProcessInstanceState(StateEvent stateEvent) {
        ExecutionStatus state = stateEvent.getExecutionStatus();
        if (this.processInstance.getState() != state) {
            logger.info("work flow process instance [id: {}, name:{}], state change from {} to {}, cmd type: {}", new Object[]{this.processInstance.getId(), this.processInstance.getName(), this.processInstance.getState(), state, this.processInstance.getCommandType()});
            this.processInstance.setState(state);
            if (state.typeIsFinished()) {
                this.processInstance.setEndTime(new Date());
            }
            this.processService.updateProcessInstance(this.processInstance);
        }
    }

    private DependResult getDependResultForTask(TaskInstance taskInstance) {
        return this.isTaskDepsComplete(Long.toString(taskInstance.getTaskCode()));
    }

    private void addTaskToStandByList(TaskInstance taskInstance) {
        try {
            if (this.readyToSubmitTaskQueue.contains(taskInstance)) {
                logger.warn("task was found in ready submit queue, task code:{}", (Object)taskInstance.getTaskCode());
                return;
            }
            boolean active = false;
            Map taskInstanceMap = this.taskInstanceHashMap.column((Object)taskInstance.getTaskCode());
            if (taskInstanceMap != null && taskInstanceMap.size() > 0) {
                for (Map.Entry entry : taskInstanceMap.entrySet()) {
                    TaskInstance latestTaskInstance;
                    Integer taskInstanceId = (Integer)entry.getKey();
                    if (!this.activeTaskProcessorMaps.containsKey(taskInstanceId) || (latestTaskInstance = this.processService.findTaskInstanceById(taskInstanceId)) == null || latestTaskInstance.getState().typeIsFailure()) continue;
                    active = true;
                    break;
                }
            }
            if (active) {
                logger.warn("task was found in active task list, task code:{}", (Object)taskInstance.getTaskCode());
                return;
            }
            logger.info("add task to stand by list, task name:{}, task id:{}, task code:{}", new Object[]{taskInstance.getName(), taskInstance.getId(), taskInstance.getTaskCode()});
            this.readyToSubmitTaskQueue.put(taskInstance);
        }
        catch (Exception e) {
            logger.error("add task instance to readyToSubmitTaskQueue, taskName:{}, task id:{}", new Object[]{taskInstance.getName(), taskInstance.getId(), e});
        }
    }

    private void removeTaskFromStandbyList(TaskInstance taskInstance) {
        logger.info("remove task from stand by list, id: {} name:{}", (Object)taskInstance.getId(), (Object)taskInstance.getName());
        try {
            this.readyToSubmitTaskQueue.remove(taskInstance);
        }
        catch (Exception e) {
            logger.error("remove task instance from readyToSubmitTaskQueue error, task id:{}, Name: {}", new Object[]{taskInstance.getId(), taskInstance.getName(), e});
        }
    }

    private boolean hasRetryTaskInStandBy() {
        Iterator iter = this.readyToSubmitTaskQueue.iterator();
        while (iter.hasNext()) {
            if (!((TaskInstance)iter.next()).getState().typeIsFailure()) continue;
            return true;
        }
        return false;
    }

    private void addProcessStopEvent(ProcessInstance processInstance) {
        StateEvent stateEvent = new StateEvent();
        stateEvent.setType(StateEventType.PROCESS_STATE_CHANGE);
        stateEvent.setProcessInstanceId(processInstance.getId());
        stateEvent.setExecutionStatus(ExecutionStatus.STOP);
        this.addStateEvent(stateEvent);
    }

    private void killAllTasks() {
        logger.info("kill called on process instance id: {}, num: {}", (Object)this.processInstance.getId(), (Object)this.activeTaskProcessorMaps.size());
        if (this.readyToSubmitTaskQueue.size() > 0) {
            this.readyToSubmitTaskQueue.clear();
        }
        for (int taskId : this.activeTaskProcessorMaps.keySet()) {
            TaskInstance taskInstance = this.processService.findTaskInstanceById(Integer.valueOf(taskId));
            if (taskInstance == null || taskInstance.getState().typeIsFinished()) continue;
            ITaskProcessor taskProcessor = this.activeTaskProcessorMaps.get(taskId);
            taskProcessor.action(TaskAction.STOP);
            if (taskProcessor.taskState().typeIsFinished()) {
                TaskResponseEvent taskResponseEvent = TaskResponseEvent.newActionStop(taskProcessor.taskState(), taskInstance.getId(), this.processInstance.getId());
                this.taskResponseService.addResponse(taskResponseEvent);
            }
            this.taskRetryCheckList.remove(taskId);
            this.depStateCheckList.remove(taskId);
        }
        this.addProcessStopEvent(this.processInstance);
    }

    public boolean workFlowFinish() {
        return this.processInstance.getState().typeIsFinished();
    }

    public boolean activeTaskFinish() {
        if (this.activeTaskProcessorMaps.isEmpty()) {
            return true;
        }
        List taskInstanceList = this.processService.findTaskInstanceListByIds(this.activeTaskProcessorMaps.keySet());
        for (TaskInstance taskInstance : taskInstanceList) {
            if (taskInstance.getState().typeIsFinished()) continue;
            return false;
        }
        return true;
    }

    private void submitStandByTask() {
        try {
            int length = this.readyToSubmitTaskQueue.size();
            ArrayList<TaskInstance> skipSubmitInstances = new ArrayList<TaskInstance>();
            for (int i = 0; i < length; ++i) {
                DependResult dependResult;
                TaskInstance task = this.readyToSubmitTaskQueue.peek();
                if (task == null) continue;
                if (task.taskCanRetry()) {
                    TaskInstance retryTask = this.processService.findTaskInstanceById(Integer.valueOf(task.getId()));
                    if (retryTask != null && retryTask.getState().equals((Object)ExecutionStatus.FORCED_SUCCESS)) {
                        task.setState(retryTask.getState());
                        logger.info("task name: {} has been forced success, put it into complete task list and stop retrying, task id:{}", (Object)task.getName(), (Object)task.getId());
                        this.removeTaskFromStandbyList(task);
                        this.completeTaskList.put(Long.toString(task.getTaskCode()), task);
                        this.submitPostNode(Long.toString(task.getTaskCode()));
                        continue;
                    }
                    if (retryTask != null && retryTask.getState() == ExecutionStatus.FAILURE && retryTask.getMaxRetryTimes() != 0 && retryTask.getRetryInterval() != 0) {
                        long failedTimeInterval = DateUtils.differSec((Date)new Date(), (Date)retryTask.getEndTime());
                        if ((long)retryTask.getRetryInterval() * 60L > failedTimeInterval) {
                            logger.info("task name: {} retry waiting has not exceeded the interval time, and skip submission this time, task id:{}", (Object)task.getName(), (Object)task.getId());
                            this.readyToSubmitTaskQueue.remove(task);
                            skipSubmitInstances.add(task);
                            continue;
                        }
                    }
                }
                if (task.isFirstRun()) {
                    HashSet<String> preTask = new HashSet<String>();
                    preTask.addAll(this.dag.getPreviousNodes((Object)Long.toString(task.getTaskCode())));
                    TaskNode taskNode = (TaskNode)this.dag.getNode((Object)Long.toString(task.getTaskCode()));
                    if (null != taskNode && null != taskNode.getDepList() && !taskNode.getDepList().isEmpty()) {
                        logger.debug("in submitStandByTask: taskCode:{}, taskType: {}, preTasks: {}, depList:{}", new Object[]{task.getTaskCode(), taskNode.getType(), taskNode.getPreTasks(), taskNode.getDepList()});
                        preTask.addAll(taskNode.getDepList());
                    }
                    this.getPreVarPool(task, preTask);
                }
                if (DependResult.SUCCESS == (dependResult = this.getDependResultForTask(task))) {
                    int originalId = task.getId();
                    TaskInstance taskInstance = this.submitTaskExec(task);
                    if (taskInstance == null) {
                        this.taskFailedSubmit = true;
                        continue;
                    }
                    this.removeTaskFromStandbyList(task);
                    if (taskInstance.getId() == originalId) continue;
                    this.activeTaskProcessorMaps.remove(originalId);
                    continue;
                }
                if (DependResult.FAILED == dependResult) {
                    this.dependFailedTask.put(Long.toString(task.getTaskCode()), task);
                    this.removeTaskFromStandbyList(task);
                    logger.info("task {},id:{} depend result : {}", new Object[]{task.getName(), task.getId(), dependResult});
                    continue;
                }
                if (DependResult.NON_EXEC != dependResult) continue;
                this.removeTaskFromStandbyList(task);
                logger.info("remove task {},id:{} , because depend result : {}", new Object[]{task.getName(), task.getId(), dependResult});
            }
            for (TaskInstance task : skipSubmitInstances) {
                this.readyToSubmitTaskQueue.put(task);
            }
            skipSubmitInstances.clear();
        }
        catch (Exception e) {
            logger.error("submit standby task error", (Throwable)e);
        }
    }

    private TaskInstance getRecoveryTaskInstance(String taskId) {
        if (!StringUtils.isNotEmpty((String)taskId)) {
            return null;
        }
        try {
            Integer intId = Integer.valueOf(taskId);
            TaskInstance task = this.processService.findTaskInstanceById(intId);
            if (task != null) {
                return task;
            }
            logger.error("start node id cannot be found: {}", (Object)taskId);
        }
        catch (Exception e) {
            logger.error("get recovery task instance failed ", (Throwable)e);
        }
        return null;
    }

    private List<TaskInstance> getStartTaskInstanceList(String cmdParam) {
        ArrayList<TaskInstance> instanceList = new ArrayList<TaskInstance>();
        Map paramMap = JSONUtils.toMap((String)cmdParam);
        if (paramMap != null && paramMap.containsKey("StartNodeIdList")) {
            String[] idList;
            for (String nodeId : idList = ((String)paramMap.get("StartNodeIdList")).split(",")) {
                TaskInstance task = this.getRecoveryTaskInstance(nodeId);
                if (task == null) continue;
                instanceList.add(task);
            }
        }
        return instanceList;
    }

    private List<String> parseStartNodeName(String cmdParam) {
        List<String> startNodeNameList = new ArrayList<String>();
        Map paramMap = JSONUtils.toMap((String)cmdParam);
        if (paramMap == null) {
            return startNodeNameList;
        }
        if (paramMap.containsKey("StartNodeList")) {
            startNodeNameList = Arrays.asList(((String)paramMap.get("StartNodeList")).split(","));
        }
        return startNodeNameList;
    }

    private List<String> getRecoveryNodeCodeList() {
        ArrayList<String> recoveryNodeCodeList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(this.recoverNodeIdList)) {
            for (TaskInstance task : this.recoverNodeIdList) {
                recoveryNodeCodeList.add(Long.toString(task.getTaskCode()));
            }
        }
        return recoveryNodeCodeList;
    }

    public ProcessDag generateFlowDag(List<TaskNode> totalTaskNodeList, List<String> startNodeNameList, List<String> recoveryNodeCodeList, TaskDependType depNodeType) throws Exception {
        return DagHelper.generateFlowDag(totalTaskNodeList, startNodeNameList, recoveryNodeCodeList, (TaskDependType)depNodeType);
    }

    public Map<Integer, ITaskProcessor> getActiveTaskProcessorMaps() {
        return this.activeTaskProcessorMaps;
    }

    private void setGlobalParamIfCommanded(ProcessDefinition processDefinition, Map<String, String> cmdParam) {
        Map startParamMap = new HashMap();
        if (cmdParam.containsKey("StartParams")) {
            String startParamJson = cmdParam.get("StartParams");
            startParamMap = JSONUtils.toMap((String)startParamJson);
        }
        Map fatherParamMap = new HashMap();
        if (cmdParam.containsKey("fatherParams")) {
            String fatherParamJson = cmdParam.get("fatherParams");
            fatherParamMap = JSONUtils.toMap((String)fatherParamJson);
        }
        startParamMap.putAll(fatherParamMap);
        Map globalMap = processDefinition.getGlobalParamMap();
        List globalParamList = processDefinition.getGlobalParamList();
        if (MapUtils.isNotEmpty(startParamMap) && globalMap != null) {
            HashMap tempGlobalMap = new HashMap();
            for (Map.Entry param : globalMap.entrySet()) {
                tempGlobalMap.put("global-" + (String)param.getKey(), param.getValue());
            }
            globalParamList.forEach(property -> property.setProp("global-" + property.getProp()));
            for (Map.Entry startParam : startParamMap.entrySet()) {
                String tmpStartParamKey = "startup-" + (String)startParam.getKey();
                tempGlobalMap.put(tmpStartParamKey, startParam.getValue());
                globalParamList.add(new Property(tmpStartParamKey, Direct.IN, DataType.VARCHAR, (String)startParam.getValue()));
            }
            processDefinition.setGlobalParamMap(tempGlobalMap);
        }
    }
}

