/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.sqoop.generator.sources;

import org.apache.dolphinscheduler.plugin.task.sqoop.generator.ISourceGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.SqoopParameters;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.sources.SourceHdfsParameter;
import org.apache.dolphinscheduler.spi.task.request.TaskRequest;
import org.apache.dolphinscheduler.spi.utils.JSONUtils;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsSourceGenerator
implements ISourceGenerator {
    private static final Logger logger = LoggerFactory.getLogger(HdfsSourceGenerator.class);

    @Override
    public String generate(SqoopParameters sqoopParameters, TaskRequest taskExecutionContext) {
        StringBuilder hdfsSourceSb;
        block3: {
            hdfsSourceSb = new StringBuilder();
            try {
                SourceHdfsParameter sourceHdfsParameter = (SourceHdfsParameter)JSONUtils.parseObject((String)sqoopParameters.getSourceParams(), SourceHdfsParameter.class);
                if (null == sourceHdfsParameter) break block3;
                if (StringUtils.isNotEmpty((CharSequence)sourceHdfsParameter.getExportDir())) {
                    hdfsSourceSb.append(" ").append("--export-dir").append(" ").append(sourceHdfsParameter.getExportDir());
                    break block3;
                }
                throw new IllegalArgumentException("Sqoop hdfs export dir is null");
            }
            catch (Exception e) {
                logger.error(String.format("Sqoop hdfs source parmas build failed: [%s]", e.getMessage()));
            }
        }
        return hdfsSourceSb.toString();
    }
}

