/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.rpc.remote;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.dolphinscheduler.remote.config.NettyServerConfig;
import org.apache.dolphinscheduler.remote.utils.NettyUtils;
import org.apache.dolphinscheduler.rpc.codec.NettyDecoder;
import org.apache.dolphinscheduler.rpc.codec.NettyEncoder;
import org.apache.dolphinscheduler.rpc.common.RpcRequest;
import org.apache.dolphinscheduler.rpc.remote.NettyServerHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServer {
    private static final Logger logger = LoggerFactory.getLogger(NettyServer.class);
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workGroup;
    private final NettyServerConfig serverConfig;
    private final ServerBootstrap serverBootstrap = new ServerBootstrap();
    private final AtomicBoolean isStarted = new AtomicBoolean(false);

    public NettyServer(NettyServerConfig serverConfig) {
        this.serverConfig = serverConfig;
        if (NettyUtils.useEpoll()) {
            this.bossGroup = new EpollEventLoopGroup(1, new ThreadFactory(){
                private AtomicInteger threadIndex = new AtomicInteger(0);

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, String.format("NettyServerBossThread_%d", this.threadIndex.incrementAndGet()));
                }
            });
            this.workGroup = new EpollEventLoopGroup(serverConfig.getWorkerThread(), new ThreadFactory(){
                private AtomicInteger threadIndex = new AtomicInteger(0);

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, String.format("NettyServerWorkerThread_%d", this.threadIndex.incrementAndGet()));
                }
            });
        } else {
            this.bossGroup = new NioEventLoopGroup(1, new ThreadFactory(){
                private AtomicInteger threadIndex = new AtomicInteger(0);

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, String.format("NettyServerBossThread_%d", this.threadIndex.incrementAndGet()));
                }
            });
            this.workGroup = new NioEventLoopGroup(serverConfig.getWorkerThread(), new ThreadFactory(){
                private AtomicInteger threadIndex = new AtomicInteger(0);

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, String.format("NettyServerWorkerThread_%d", this.threadIndex.incrementAndGet()));
                }
            });
        }
        this.start();
    }

    public void start() {
        if (this.isStarted.compareAndSet(false, true)) {
            ChannelFuture future;
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.serverBootstrap.group(this.bossGroup, this.workGroup).channel(NettyUtils.getServerSocketChannelClass())).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_BACKLOG, (Object)this.serverConfig.getSoBacklog())).childOption(ChannelOption.SO_KEEPALIVE, (Object)this.serverConfig.isSoKeepalive()).childOption(ChannelOption.TCP_NODELAY, (Object)this.serverConfig.isTcpNoDelay()).childOption(ChannelOption.SO_SNDBUF, (Object)this.serverConfig.getSendBufferSize()).childOption(ChannelOption.SO_RCVBUF, (Object)this.serverConfig.getReceiveBufferSize()).handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    NettyServer.this.initNettyChannel(ch);
                }
            });
            try {
                future = this.serverBootstrap.bind(this.serverConfig.getListenPort()).sync();
            }
            catch (Exception e) {
                logger.error("NettyRemotingServer bind fail {}, exit", (Object)e.getMessage(), (Object)e);
                throw new RuntimeException(String.format("NettyRemotingServer bind %s fail", this.serverConfig.getListenPort()));
            }
            if (future.isSuccess()) {
                logger.info("NettyRemotingServer bind success at port : {}", (Object)this.serverConfig.getListenPort());
            } else {
                if (future.cause() != null) {
                    throw new RuntimeException(String.format("NettyRemotingServer bind %s fail", this.serverConfig.getListenPort()), future.cause());
                }
                throw new RuntimeException(String.format("NettyRemotingServer bind %s fail", this.serverConfig.getListenPort()));
            }
        }
    }

    private void initNettyChannel(SocketChannel ch) {
        ch.pipeline().addLast(new ChannelHandler[]{new NettyDecoder(RpcRequest.class)}).addLast(new ChannelHandler[]{new NettyEncoder()}).addLast("server-idle-handle", (ChannelHandler)new IdleStateHandler(0L, 0L, 181000L, TimeUnit.MILLISECONDS)).addLast("handler", (ChannelHandler)new NettyServerHandler());
    }

    public void close() {
        if (this.isStarted.compareAndSet(true, false)) {
            try {
                if (this.bossGroup != null) {
                    this.bossGroup.shutdownGracefully();
                }
                if (this.workGroup != null) {
                    this.workGroup.shutdownGracefully();
                }
            }
            catch (Exception ex) {
                logger.error("netty server close exception", (Throwable)ex);
            }
            logger.info("netty server closed");
        }
    }
}

