/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.remote.handler;

import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.apache.dolphinscheduler.remote.NettyRemotingServer;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.remote.utils.ChannelUtils;
import org.apache.dolphinscheduler.remote.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class NettyServerHandler
extends ChannelInboundHandlerAdapter {
    private final Logger logger = LoggerFactory.getLogger(NettyServerHandler.class);
    private final NettyRemotingServer nettyRemotingServer;
    private final ConcurrentHashMap<CommandType, Pair<NettyRequestProcessor, ExecutorService>> processors = new ConcurrentHashMap();

    public NettyServerHandler(NettyRemotingServer nettyRemotingServer) {
        this.nettyRemotingServer = nettyRemotingServer;
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        ctx.channel().close();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        this.processReceived(ctx.channel(), (Command)msg);
    }

    public void registerProcessor(CommandType commandType, NettyRequestProcessor processor) {
        this.registerProcessor(commandType, processor, null);
    }

    public void registerProcessor(CommandType commandType, NettyRequestProcessor processor, ExecutorService executor) {
        ExecutorService executorRef = executor;
        if (executorRef == null) {
            executorRef = this.nettyRemotingServer.getDefaultExecutor();
        }
        this.processors.putIfAbsent(commandType, new Pair<NettyRequestProcessor, ExecutorService>(processor, executorRef));
    }

    private void processReceived(Channel channel, Command msg) {
        CommandType commandType = msg.getType();
        if (CommandType.HEART_BEAT.equals((Object)commandType)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("server receive heart beat from: host: {}", (Object)ChannelUtils.getRemoteAddress(channel));
            }
            return;
        }
        Pair<NettyRequestProcessor, ExecutorService> pair = this.processors.get((Object)commandType);
        if (pair != null) {
            Runnable r = () -> {
                try {
                    ((NettyRequestProcessor)pair.getLeft()).process(channel, msg);
                }
                catch (Exception ex) {
                    this.logger.error("process msg {} error", (Object)msg, (Object)ex);
                }
            };
            try {
                pair.getRight().submit(r);
            }
            catch (RejectedExecutionException e) {
                this.logger.warn("thread pool is full, discard msg {} from {}", (Object)msg, (Object)ChannelUtils.getRemoteAddress(channel));
            }
        } else {
            this.logger.warn("commandType {} not support", (Object)commandType);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.logger.error("exceptionCaught : {}", (Object)cause.getMessage(), (Object)cause);
        ctx.channel().close();
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        Channel ch = ctx.channel();
        ChannelConfig config = ch.config();
        if (!ch.isWritable()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("{} is not writable, over high water level : {}", (Object)ch, (Object)config.getWriteBufferHighWaterMark());
            }
            config.setAutoRead(false);
        } else {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("{} is writable, to low water : {}", (Object)ch, (Object)config.getWriteBufferLowWaterMark());
            }
            config.setAutoRead(true);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            ctx.channel().close();
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }
}

