/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.function;

import com.facebook.presto.jdbc.internal.common.CatalogSchemaName;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.function.FunctionHandle;
import com.facebook.presto.jdbc.internal.spi.function.FunctionHandleResolver;
import com.facebook.presto.jdbc.internal.spi.function.SqlFunctionId;
import java.util.Objects;

public class SqlFunctionHandle
implements FunctionHandle {
    private final SqlFunctionId functionId;
    private final long version;

    @JsonCreator
    public SqlFunctionHandle(@JsonProperty(value="functionId") SqlFunctionId functionId, @JsonProperty(value="version") long version) {
        this.functionId = Objects.requireNonNull(functionId, "functionId is null");
        this.version = version;
    }

    @JsonProperty
    public SqlFunctionId getFunctionId() {
        return this.functionId;
    }

    @JsonProperty
    public long getVersion() {
        return this.version;
    }

    @Override
    public CatalogSchemaName getFunctionNamespace() {
        return this.functionId.getFunctionName().getFunctionNamespace();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlFunctionHandle o = (SqlFunctionHandle)obj;
        return Objects.equals(this.functionId, o.functionId) && Objects.equals(this.version, o.version);
    }

    public int hashCode() {
        return Objects.hash(this.functionId, this.version);
    }

    public String toString() {
        return String.format("%s:%s", this.functionId, this.version);
    }

    public static class Resolver
    implements FunctionHandleResolver {
        @Override
        public Class<? extends FunctionHandle> getFunctionHandleClass() {
            return SqlFunctionHandle.class;
        }
    }
}

