/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc;

import com.facebook.presto.jdbc.internal.client.IntervalYearMonth;
import java.util.Objects;

public class PrestoIntervalYearMonth
implements Comparable<PrestoIntervalYearMonth> {
    private final int months;

    public PrestoIntervalYearMonth(int months) {
        this.months = months;
    }

    public PrestoIntervalYearMonth(int year, int months) {
        this.months = IntervalYearMonth.toMonths(year, months);
    }

    public int getMonths() {
        return this.months;
    }

    public int hashCode() {
        return Objects.hash(this.months);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrestoIntervalYearMonth other = (PrestoIntervalYearMonth)obj;
        return this.months == other.months;
    }

    @Override
    public int compareTo(PrestoIntervalYearMonth o) {
        return Integer.compare(this.months, o.months);
    }

    public String toString() {
        return IntervalYearMonth.formatMonths(this.months);
    }
}

