/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api;

import ch.qos.logback.classic.ClassicConstants;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.dolphinscheduler.plugin.task.api.ProcessUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskResponse;
import org.apache.dolphinscheduler.plugin.task.util.OSUtils;
import org.apache.dolphinscheduler.spi.task.TaskExecutionContextCacheManager;
import org.apache.dolphinscheduler.spi.task.request.TaskRequest;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.slf4j.Logger;

public abstract class AbstractCommandExecutor {
    protected static final Pattern APPLICATION_REGEX = Pattern.compile("application_\\d+_\\d+");
    protected StringBuilder varPool = new StringBuilder();
    private Process process;
    protected Consumer<LinkedBlockingQueue<String>> logHandler;
    protected Logger logger;
    protected LinkedBlockingQueue<String> logBuffer;
    protected boolean logOutputIsSuccess = false;
    protected String taskResultString;
    protected TaskRequest taskRequest;

    public AbstractCommandExecutor(Consumer<LinkedBlockingQueue<String>> logHandler, TaskRequest taskRequest, Logger logger) {
        this.logHandler = logHandler;
        this.taskRequest = taskRequest;
        this.logger = logger;
        this.logBuffer = new LinkedBlockingQueue();
    }

    public AbstractCommandExecutor(LinkedBlockingQueue<String> logBuffer) {
        this.logBuffer = logBuffer;
    }

    private void buildProcess(String commandFile) throws IOException {
        LinkedList<String> command = new LinkedList<String>();
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.directory(new File(this.taskRequest.getExecutePath()));
        processBuilder.redirectErrorStream(true);
        if (OSUtils.isSudoEnable()) {
            command.add("sudo");
            command.add("-u");
            command.add(this.taskRequest.getTenantCode());
        }
        command.add(this.commandInterpreter());
        command.addAll(Collections.emptyList());
        command.add(commandFile);
        processBuilder.command(command);
        this.process = processBuilder.start();
        this.printCommand(command);
    }

    public TaskResponse run(String execCommand) throws IOException, InterruptedException {
        TaskResponse result = new TaskResponse();
        int taskInstanceId = this.taskRequest.getTaskInstanceId();
        if (null == TaskExecutionContextCacheManager.getByTaskInstanceId((Integer)taskInstanceId)) {
            result.setExitStatusCode(137);
            return result;
        }
        if (StringUtils.isEmpty((CharSequence)execCommand)) {
            TaskExecutionContextCacheManager.removeByTaskInstanceId((Integer)taskInstanceId);
            return result;
        }
        String commandFilePath = this.buildCommandFilePath();
        this.createCommandFileIfNotExists(execCommand, commandFilePath);
        this.buildProcess(commandFilePath);
        this.parseProcessOutput(this.process);
        int processId = this.getProcessId(this.process);
        result.setProcessId(processId);
        this.taskRequest.setProcessId(processId);
        boolean updateTaskExecutionContextStatus = TaskExecutionContextCacheManager.updateTaskExecutionContext((TaskRequest)this.taskRequest);
        if (Boolean.FALSE.equals(updateTaskExecutionContextStatus)) {
            ProcessUtils.kill(this.taskRequest);
            result.setExitStatusCode(137);
            return result;
        }
        this.logger.info("process start, process id is: {}", (Object)processId);
        long remainTime = this.getRemainTime();
        boolean status = this.process.waitFor(remainTime, TimeUnit.SECONDS);
        if (status) {
            List<String> appIds = this.getAppIds(this.taskRequest.getLogPath());
            result.setAppIds(String.join((CharSequence)",", appIds));
            result.setExitStatusCode(this.process.exitValue());
        } else {
            this.logger.error("process has failure , exitStatusCode:{}, processExitValue:{}, ready to kill ...", (Object)result.getExitStatusCode(), (Object)this.process.exitValue());
            ProcessUtils.kill(this.taskRequest);
            result.setExitStatusCode(-1);
        }
        this.logger.info("process has exited, execute path:{}, processId:{} ,exitStatusCode:{} ,processWaitForStatus:{} ,processExitValue:{}", new Object[]{this.taskRequest.getExecutePath(), processId, result.getExitStatusCode(), status, this.process.exitValue()});
        return result;
    }

    public String getVarPool() {
        return this.varPool.toString();
    }

    public void cancelApplication() throws Exception {
        if (this.process == null) {
            return;
        }
        this.clear();
        int processId = this.getProcessId(this.process);
        this.logger.info("cancel process: {}", (Object)processId);
        boolean killed = this.softKill(processId);
        if (!killed) {
            this.hardKill(processId);
            this.process.destroy();
            this.process = null;
        }
    }

    private boolean softKill(int processId) {
        if (processId != 0 && this.process.isAlive()) {
            try {
                String cmd = String.format("kill %d", processId);
                cmd = OSUtils.getSudoCmd(this.taskRequest.getTenantCode(), cmd);
                this.logger.info("soft kill task:{}, process id:{}, cmd:{}", new Object[]{this.taskRequest.getTaskAppId(), processId, cmd});
                Runtime.getRuntime().exec(cmd);
            }
            catch (IOException e) {
                this.logger.info("kill attempt failed", (Throwable)e);
            }
        }
        return this.process.isAlive();
    }

    private void hardKill(int processId) {
        if (processId != 0 && this.process.isAlive()) {
            try {
                String cmd = String.format("kill -9 %d", processId);
                cmd = OSUtils.getSudoCmd(this.taskRequest.getTenantCode(), cmd);
                this.logger.info("hard kill task:{}, process id:{}, cmd:{}", new Object[]{this.taskRequest.getTaskAppId(), processId, cmd});
                Runtime.getRuntime().exec(cmd);
            }
            catch (IOException e) {
                this.logger.error("kill attempt failed ", (Throwable)e);
            }
        }
    }

    private void printCommand(List<String> commands) {
        this.logger.info("task run command: {}", (Object)String.join((CharSequence)" ", commands));
    }

    private void clear() {
        LinkedBlockingQueue<String> markerLog = new LinkedBlockingQueue<String>(1);
        markerLog.add(ClassicConstants.FINALIZE_SESSION_MARKER.toString());
        if (!this.logBuffer.isEmpty()) {
            this.logHandler.accept(this.logBuffer);
            this.logBuffer.clear();
        }
        this.logHandler.accept(markerLog);
    }

    private void parseProcessOutput(Process process) {
        String threadLoggerInfoName = String.format("TaskLogInfo-%s", this.taskRequest.getTaskLogName() + "-getOutputLogService");
        ExecutorService getOutputLogService = this.newDaemonSingleThreadExecutor(threadLoggerInfoName);
        getOutputLogService.submit(() -> {
            try (BufferedReader inReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                this.logBuffer.add("welcome to use bigdata scheduling system...");
                while ((line = inReader.readLine()) != null) {
                    if (line.startsWith("${setValue(")) {
                        this.varPool.append(line, "${setValue(".length(), line.length() - 2);
                        this.varPool.append("$VarPool$");
                        continue;
                    }
                    this.logBuffer.add(line);
                    this.taskResultString = line;
                }
                this.logOutputIsSuccess = true;
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                this.logOutputIsSuccess = true;
            }
        });
        getOutputLogService.shutdown();
        ExecutorService parseProcessOutputExecutorService = this.newDaemonSingleThreadExecutor(threadLoggerInfoName);
        parseProcessOutputExecutorService.submit(() -> {
            try {
                long lastFlushTime = System.currentTimeMillis();
                while (this.logBuffer.size() > 0 || !this.logOutputIsSuccess) {
                    if (this.logBuffer.size() > 0) {
                        lastFlushTime = this.flush(lastFlushTime);
                        continue;
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                Thread.currentThread().interrupt();
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                this.clear();
            }
        });
        parseProcessOutputExecutorService.shutdown();
    }

    private List<String> getAppIds(String logPath) {
        List<String> logs = this.convertFile2List(logPath);
        ArrayList<String> appIds = new ArrayList<String>();
        for (String log : logs) {
            String appId = this.findAppId(log);
            if (!StringUtils.isNotEmpty((CharSequence)appId) || appIds.contains(appId)) continue;
            this.logger.info("find app id: {}", (Object)appId);
            appIds.add(appId);
        }
        return appIds;
    }

    private List<String> convertFile2List(String filename) {
        ArrayList<String> lineList = new ArrayList<String>(100);
        File file = new File(filename);
        if (!file.exists()) {
            return lineList;
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                lineList.add(line);
            }
        }
        catch (Exception e) {
            this.logger.error(String.format("read file: %s failed : ", filename), (Throwable)e);
        }
        return lineList;
    }

    private String findAppId(String line) {
        Matcher matcher = APPLICATION_REGEX.matcher(line);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    private long getRemainTime() {
        long usedTime = (System.currentTimeMillis() - this.taskRequest.getStartTime().getTime()) / 1000L;
        long remainTime = (long)this.taskRequest.getTaskTimeout() - usedTime;
        if (remainTime < 0L) {
            throw new RuntimeException("task execution time out");
        }
        return remainTime;
    }

    private int getProcessId(Process process) {
        int processId = 0;
        try {
            Field f = process.getClass().getDeclaredField("pid");
            f.setAccessible(true);
            processId = f.getInt(process);
        }
        catch (Throwable e) {
            this.logger.error(e.getMessage(), e);
        }
        return processId;
    }

    private long flush(long lastFlushTime) {
        long now = System.currentTimeMillis();
        if (this.logBuffer.size() >= 64 || now - lastFlushTime > 1000L) {
            lastFlushTime = now;
            this.logHandler.accept(this.logBuffer);
            this.logBuffer.clear();
        }
        return lastFlushTime;
    }

    protected abstract String buildCommandFilePath();

    protected abstract void createCommandFileIfNotExists(String var1, String var2) throws IOException;

    ExecutorService newDaemonSingleThreadExecutor(String threadName) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(threadName).build();
        return Executors.newSingleThreadExecutor(threadFactory);
    }

    protected abstract String commandInterpreter();
}

